/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCurrentGroupID
extends Task {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("5500", false);

    @Override
    public boolean performTask() {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        this.checkCurrentGroupID();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        return false;
    }

    private void checkCurrentGroupID() {
        ErrorDescription errDesc;
        String errorMsg;
        String curUsr = VerificationUtil.getDefaultOracleUser();
        String curGrp = VerificationUtil.getCurrentGroup();
        String localHost = null;
        try {
            localHost = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            errorMsg = s_msgBundle.getMessage("7007", false) + LSEP + uhe.getMessage();
            ReportUtil.printError(errorMsg);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Local node not found:" + uhe.getMessage()));
            }
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(errorMsg);
            this.m_resultSet.addErrorDescription(errorDesc);
        }
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        globalExec.checkUsrInGrp(new String[]{localHost}, curUsr, curGrp, 1, usrGrpRsltSet);
        Result result = usrGrpRsltSet.getResult(localHost);
        if (result.getStatus() == 1) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else if (result.getStatus() == 3) {
            errorMsg = s_msgBundle.getMessage("5501", true, (Object[])new String[]{curUsr, curGrp});
            this.m_resultSet.addResult(this.m_nodeList, 3);
            errDesc = new ErrorDescription(errorMsg, s_msgBundle.getCause("5501", false), s_msgBundle.getAction("5501", false));
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.printError(errorMsg);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("The current group '" + curGrp + "' for the user '" + curUsr + "' is not its primary group"));
            }
        } else {
            errorMsg = s_msgBundle.getMessage("5502", true);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            errDesc = new ErrorDescription(errorMsg, s_msgBundle.getCause("5502", false), s_msgBundle.getAction("5502", false));
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.printError(errorMsg);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"The current group check could not be performed");
            }
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5503", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5504", false);
    }
}

