/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCurrentUserIsDomainUser
extends Task {
    private String m_userName = System.getProperty("user.name");

    public TaskCurrentUserIsDomainUser(String[] nodeList) {
        super(nodeList, null, 1);
    }

    @Override
    public boolean performTask() {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String domainName = "";
        String errorMsg = "";
        boolean ret = false;
        this.setSeverity(SeverityType.IGNORABLE);
        ReportUtil.blankln();
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9996", false));
        ReportUtil.println(s_msgBundle.getMessage("9999", false, (Object[])new String[]{this.m_userName}));
        UserData userData = null;
        Result nodeRslt = new Result(m_localHost);
        try {
            this.m_userName = nativeSys.getCurrentUserName();
            userData = this.initUserData(this.m_userName);
            switch (userData.getUserAccountType()) {
                case LOCAL_USER: {
                    Trace.out((String)("User '" + this.m_userName + "' is local user"));
                    nodeRslt.setStatus(4);
                    nodeRslt.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10510", true, (Object[])new String[]{this.m_userName})));
                    break;
                }
                case DOMAIN_USER: 
                case MSA_USER: {
                    domainName = userData.getUser().getDomainname();
                    nodeRslt.setStatus(1);
                    break;
                }
                case INVALID_USER: {
                    throw new WindowsSecurityException((MessageKey)PrCzMsgID.CHECK_USER_TYPE_FAILED, new Object[]{this.m_userName});
                }
            }
        }
        catch (WindowsSecurityException wse) {
            Trace.out((Exception)((Object)wse));
            errorMsg = s_msgBundle.getMessage("10000", true, (Object[])new String[]{this.m_userName, wse.getMessage()});
            nodeRslt.setStatus(2);
            ErrorDescription errorDesc = new ErrorDescription(errorMsg);
            nodeRslt.addErrorDescription(errorDesc);
        }
        catch (NativeException ne) {
            Trace.out((Exception)((Object)ne));
            errorMsg = ne.getMessage();
            nodeRslt.setStatus(2);
            ErrorDescription errorDesc = new ErrorDescription(errorMsg);
            nodeRslt.addErrorDescription(errorDesc);
        }
        if (nodeRslt.getStatus() == 2) {
            ReportUtil.printError(errorMsg);
        } else if (nodeRslt.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("9997", false, (Object[])new String[]{this.m_userName, domainName}));
            ret = true;
        } else if (nodeRslt.getStatus() == 4) {
            ReportUtil.printWarning(s_gMsgBundle.getMessage("10510", true, (Object[])new String[]{this.m_userName}));
        }
        this.m_resultSet.addResult(m_localHost, nodeRslt);
        return ret;
    }

    private UserData initUserData(String userName) throws WindowsSecurityException {
        String srcloc = VerificationUtil.getCVHome();
        String destloc = VerificationUtil.getDestLoc();
        Trace.out((String)"getting winsecurity factory and user");
        WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
        Credentials credentials = new Credentials(userName);
        User user = wsecFac.getUser(credentials, new Version());
        UserAccountType userAccountType = UserAccountType.INVALID_USER;
        if (user.isExists()) {
            if (user.isUserDomainUser()) {
                userAccountType = UserAccountType.DOMAIN_USER;
            }
            if (user.isUserMSA()) {
                userAccountType = UserAccountType.MSA_USER;
            }
            if (user.isExistsLocalAccount()) {
                userAccountType = UserAccountType.LOCAL_USER;
            }
        } else {
            Trace.out((String)("User " + userName + " was not found to be valid user"));
        }
        return new UserData(user, userAccountType);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9999", false, (Object[])new String[]{this.m_userName});
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9999", false, (Object[])new String[]{this.m_userName});
    }

    private class UserData {
        User m_userObj;
        UserAccountType m_userAccountType;

        private UserData(User user, UserAccountType userAccountType) {
            this.m_userObj = user;
            this.m_userAccountType = userAccountType;
        }

        User getUser() {
            return this.m_userObj;
        }

        UserAccountType getUserAccountType() {
            return this.m_userAccountType;
        }
    }

    private static enum UserAccountType {
        LOCAL_USER,
        DOMAIN_USER,
        MSA_USER,
        INVALID_USER;

    }
}

