/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.VersionComparator;

public class TaskDBCRSVersionCompatibility
extends Task {
    private static final String ERRTXT_4535 = "CRS-4535";
    private static final String ERRTXT_4000 = "CRS-4000";
    private static final String NAMETXT = "NAME=";
    private static final String STATETXT = "STATE=";
    private static final String ONLINETXT = "ONLINE";
    private static final String OFFLINETXT = "OFFLINE";
    private static final String RES_PREFIX = "ora.";
    public static final int RC_UNKNOWN = -1;
    public static final int RC_EXIST = 0;
    public static final int RC_ONLINE = 1;
    public static final int RC_NOTEXIST = 210;
    public static final int RC_NOCRSD = 184;
    private String m_dbVersion;

    public TaskDBCRSVersionCompatibility(String[] nodeList, String dbVersion) {
        this.m_nodeList = nodeList;
        this.m_dbVersion = dbVersion;
    }

    @Override
    public boolean performTask() {
        this.performVersionCompatibility();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("10702", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("10703", true));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void performVersionCompatibility() {
        Object releaseVer = null;
        ArrayList failNodeVer = new ArrayList();
        ArrayList sucNodeVer = new ArrayList();
        ArrayList upgNodeVer = new ArrayList();
        ArrayList curNodeVer = new ArrayList();
        Object newReleaseVer = null;
        ErrorDescription errDesc = null;
        Hashtable releaseVersionHT = new Hashtable();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        if (validNodeArr == null || validNodeArr.length == 0) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        ReportUtil.sureblankln();
        ReportUtil.println(s_gMsgBundle.getMessage("10706", false));
        ReportUtil.blankln();
        String node = validNodeArr[0];
        Result crsHomeResult = new Result(node);
        String crsHome = VerificationUtil.getCRSHome(node, crsHomeResult);
        if (crsHome == null) {
            Trace.out((String)"Failed to get CRS HOME");
            String msg = s_msgBundle.getMessage("5301", true);
            ReportUtil.sureprintln(msg);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            errDesc = new ErrorDescription("5300", s_msgBundle);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(validNodeArr, 2);
            return;
        }
        if (VerificationUtil.isVersionPost(activeCRSVer, "11.2") && !this.performASMResourceExistenceCheck(validNodeArr, crsHome, activeCRSVer)) {
            return;
        }
        if (new VersionComparator("-").compare(activeCRSVer, this.m_dbVersion) >= 0) {
            String msg = s_gMsgBundle.getMessage("10704", false, (Object[])new String[]{this.m_dbVersion, activeCRSVer});
            ReportUtil.println(msg);
            this.m_resultSet.addResult(validNodeArr, 1);
        } else {
            String msg = s_gMsgBundle.getMessage("10705", true, (Object[])new String[]{this.m_dbVersion, activeCRSVer});
            errDesc = new ErrorDescription(msg);
            ReportUtil.printError(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(validNodeArr, 3);
        }
    }

    private boolean performASMResourceExistenceCheck(String[] nodeList, String crsHome, String activeCRSVer) {
        int vRes;
        ReportUtil.sureblankln();
        ReportUtil.println(s_gMsgBundle.getMessage("1190", false));
        String asmResourceName = "ora.asm";
        String m_statCmd = crsHome + FSEP + "bin" + FSEP + "crsctl stat res " + asmResourceName;
        Object env = null;
        String output = null;
        ResultSet locRS = new ResultSet();
        GlobalExecution gex = new GlobalExecution();
        Hashtable crsCheckOutput = gex.runExeWithOutput(new String[]{nodeList[0]}, m_statCmd, locRS);
        locRS.setStatus();
        Result result = locRS.getResult(nodeList[0]);
        boolean cornerErrCondn = false;
        String etOutput = (String)crsCheckOutput.get(nodeList[0]);
        String fvr = VerificationUtil.fetchVerificationResult(etOutput);
        String valErr = VerificationUtil.fetchVerificationValue(etOutput);
        boolean asmResourceFound = false;
        if (etOutput != null && fvr != null && valErr != null && (vRes = Integer.parseInt(fvr)) == 1) {
            cornerErrCondn = true;
        }
        if (cornerErrCondn || 1 != result.getStatus()) {
            String outMsg;
            Trace.out((String)("couldn't execute 'crsctl stat res' command on node " + nodeList[0]));
            Trace.out((String)"Enter check for CRS-4535 and CRS-4000");
            String message = "";
            Trace.out((String)("exectask Output is:'" + etOutput + "'"));
            boolean crsStackError = false;
            if (valErr != null && (valErr.indexOf(ERRTXT_4535) != -1 || valErr.indexOf(ERRTXT_4000) != -1)) {
                crsStackError = true;
                message = message == "" ? valErr : message + LSEP + valErr;
            }
            if (crsStackError) {
                Trace.out((String)("CRS- error message" + message));
                outMsg = s_gMsgBundle.getMessage("1191", true) + LSEP + message;
            } else {
                outMsg = s_msgBundle.getMessage("5303", true, (Object[])new String[]{m_statCmd, nodeList[0]});
                if (message.length() > 0) {
                    outMsg = outMsg + LSEP + message;
                }
            }
            this.m_resultSet.addResult(nodeList, 2);
            this.m_resultSet.addErrorDescription(nodeList, new ErrorDescription(outMsg));
            ReportUtil.printError(outMsg);
            return false;
        }
        String execTaskOut = (String)crsCheckOutput.get(nodeList[0]);
        String cmdOut = VerificationUtil.fetchVerificationValue(execTaskOut);
        if (cmdOut != null && cmdOut.length() > 0) {
            output = (output == null ? "" : output) + cmdOut + LSEP;
        }
        if (output == null || output.length() == 0) {
            Trace.out((String)"crsctl stat res didn't produce output");
            String errMsg = s_gMsgBundle.getMessage("1191", true);
            this.m_resultSet.addResult(nodeList, 2);
            this.m_resultSet.addErrorDescription(nodeList, new ErrorDescription(errMsg));
            ReportUtil.println(errMsg);
            return false;
        }
        String[] outlist = VerificationUtil.getTokensAsArray(output, LSEP);
        for (int i = 0; i < outlist.length; ++i) {
            if (!outlist[i].startsWith(NAMETXT)) continue;
            Trace.out((String)("found NAME=" + outlist[i]));
            String resName = outlist[i].substring(NAMETXT.length());
            asmResourceFound = true;
            break;
        }
        if (asmResourceFound) {
            String msg = s_gMsgBundle.getMessage("1193", false);
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(nodeList, 1);
        } else {
            String errMsg = s_gMsgBundle.getMessage("1192", true, (Object[])new String[]{activeCRSVer});
            this.m_resultSet.addResult(nodeList, 3);
            this.m_resultSet.addErrorDescription(nodeList, new ErrorDescription(errMsg));
            ReportUtil.println(errMsg);
        }
        return true;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("10700", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("10701", false);
    }
}

