/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDBUserConsistent
extends Task {
    private String m_dbHome = null;

    public TaskDBUserConsistent(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        String errMsg = null;
        String currentUser = VerificationUtil.getDefaultOracleUser();
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("1182", false));
        String localNodeName = null;
        try {
            localNodeName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out((int)5, (String)"Exception %s occured retrieving the node list: %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Result nodeRslt = new Result(localNodeName);
        String DBUserNode = VerificationUtil.getOracleUser(this.m_dbHome, localNodeName, nodeRslt);
        if (nodeRslt.getStatus() == 1 && DBUserNode != null && DBUserNode.trim().length() > 0) {
            DBUserNode = DBUserNode.trim();
            nodeRslt.setHasResultValues(true);
            nodeRslt.setActualValue(currentUser);
            nodeRslt.setExpectedValue(DBUserNode);
            if (DBUserNode.equals(currentUser)) {
                ReportUtil.printResult(s_gMsgBundle.getMessage("1183", false));
                this.m_resultSet.addResult(localNodeName, nodeRslt);
                return true;
            }
            ReportUtil.printResult(s_gMsgBundle.getMessage("1184", true, (Object[])new String[]{this.m_dbHome}));
            errMsg = s_gMsgBundle.getMessage("1185", true, (Object[])new String[]{DBUserNode, currentUser});
            ReportUtil.printError(errMsg);
            nodeRslt.addErrorDescription(new ErrorDescription(errMsg));
            nodeRslt.setStatus(3);
            this.m_resultSet.addResult(localNodeName, nodeRslt);
            return false;
        }
        ReportUtil.printResult(s_gMsgBundle.getMessage("1184", true, (Object[])new String[]{this.m_dbHome}));
        errMsg = s_gMsgBundle.getMessage("1186", true, (Object[])new String[]{this.m_dbHome});
        ReportUtil.printError(errMsg);
        nodeRslt.addErrorDescription(new ErrorDescription(errMsg));
        this.m_resultSet.addResult(localNodeName, nodeRslt);
        return false;
    }

    public void setDBHome(String dbHome) {
        this.m_dbHome = dbHome;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1181", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1180", false);
    }
}

