/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNodeAppCreation;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDHCPChecks
extends Task
implements VerificationConstants,
HALiterals {
    boolean m_mute = false;
    private final String APPVIPTYPE = "APPVIP";
    private final String HOSTVIPTYPE = "HOSTVIP";
    private final String SCANVIPTYPE = "SCANVIP";
    private final String CRSCTL_CMD = "crsctl";
    private final String CRSCTL_LITE_CMD = "cvunetquery";
    private final String TAG_MSG_PKT_START = "<MSG_PACKET>";
    private final String TAG_MSG_PKT_END = "</MSG_PACKET>";
    private final String TAG_ARG_START = "<ARG_VALUE>";
    private final String TAG_ARG_END = "</ARG_VALUE>";
    private final String TAG_MSG_NUM_START = "<MSG_NUM>";
    private final String TAG_MSG_NUM_END = "</MSG_NUM>";
    private final String TXT_MSG_NUM_START = "CRS-";
    private final String CRSCTL_PORT_OPTION = " -port ";
    private final String CRSCTL_SUBNET_OPTION = " -subnet ";
    private final String DISCOVERCMD = " discover dhcp -clientid ";
    private final String REQUESTCMD = " request dhcp -clientid ";
    private final String RELEASECMD = " release dhcp -clientid ";
    private final String GETCLIENTIDCMD = " get clientid dhcp -cluname ";
    private String m_crsctlDiscoverCmd = "crsctl discover dhcp -clientid ";
    private String m_crsctlRequestCmd = "crsctl request dhcp -clientid ";
    private String m_crsctlReleaseCmd = "crsctl release dhcp -clientid ";
    private String m_crsctlGetCmd = "crsctl get clientid dhcp -cluname ";
    private final String ERRTXT_10007 = "CRS-10007: ";
    private final String ERRTXT_10008 = "CRS-10008: ";
    private final String ERRTXT_10009 = "CRS-10009: ";
    private final String ERRTXT_10010 = "CRS-10010: ";
    private final String ERRTXT_10011 = "CRS-10011: ";
    private final String ERRTXT_10012 = "CRS-10012: ";
    private final String ERRTXT_10013 = "CRS-10013: ";
    private final String CRS_ERR_TXT = "CRS-";
    private final int m_defaultPort = 67;
    private int m_port = 67;
    private String m_subnetStr = null;
    private String m_clusterName = null;
    private String m_vipResName = null;
    private String m_crsctlBinLocation = null;
    private long SCRIPT_TIMEOUT = 20L;
    private final String NETWORK_RESOURCE_NAME = "ora.net1.network";
    private boolean m_preCrsInst = false;
    private boolean m_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
    private String m_ldLibPath = null;

    public TaskDHCPChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskDHCPChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskDHCPChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5700", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5701", false);
    }

    @Override
    public boolean performTask() {
        int hubSize;
        block18: {
            if (!this.getCmdLineParams()) {
                return false;
            }
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5702", false));
            }
            if (VerificationUtil.isCRSConfigured()) {
                Trace.out((String)"crs is configured and running");
                if (!this.performResourceCheck()) {
                    return false;
                }
            }
            String errMsg = null;
            try {
                Trace.out((String)"Verifying if it is a IPv6 cluster");
                if (VerificationUtil.isIPv6Cluster(m_localHost, this.m_preCrsInst)) {
                    String msg = s_gMsgBundle.getMessage("11170", false);
                    this.m_resultSet.addResult(this.m_nodeList, 1);
                    ReportUtil.sureprintln(msg);
                    return true;
                }
            }
            catch (VerificationException vex) {
                Trace.out((String)("Verification Exception : " + vex.getMessage()));
                if (m_isCLImode) break block18;
                errMsg = s_gMsgBundle.getMessage("11171", true);
                errMsg = errMsg + LSEP + vex.getMessage();
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
        }
        if (!this.performExistanceCheck()) {
            if (this.m_subnetStr == null) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5704", true, (Object[])new String[]{new Integer(this.m_port).toString()}));
            } else {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("5732", true, (Object[])new String[]{new Integer(this.m_port).toString(), this.m_subnetStr}));
            }
            return false;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5703", false, (Object[])new String[]{new Integer(this.m_port).toString()}));
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5705", false));
        }
        if (this.performSufficiencyCheck()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5706", false, (Object[])new String[]{new Integer(this.m_port).toString()}));
        }
        if (this.m_nodeMgr.isBigCluster() && (hubSize = this.m_nodeMgr.getTargetHubSize()) < this.m_nodeList.length) {
            int arrayLength = this.m_nodeList.length - hubSize;
            String[] vipNodesArray = new String[arrayLength];
            Trace.out((String)("adding " + arrayLength + " nodes for node vip config check"));
            for (int i = 0; i < arrayLength; ++i) {
                vipNodesArray[i] = this.m_nodeList[hubSize + i];
            }
            if (this.performNodeVipConfigCheck(vipNodesArray)) {
                if (this.m_subnetStr == null) {
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("5728", false, (Object[])new String[]{new Integer(this.m_port).toString()}));
                } else {
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("5734", false, (Object[])new String[]{new Integer(this.m_port).toString(), this.m_subnetStr}));
                }
            }
        }
        if (!this.performTimeOutCheck()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5711", true));
            return false;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5710", false));
        return true;
    }

    private boolean performTimeOutCheck() {
        ArrayList<String> clientIDList = new ArrayList<String>();
        ArrayList<String> crsctlMsgList = new ArrayList<String>();
        Trace.out((String)"generating client id");
        ResultSet locrs = new ResultSet();
        boolean status = this.executeGetClientIDCrsctlCommand(this.m_clusterName, "SCANVIP", null, null, clientIDList, locrs);
        this.m_resultSet.uploadResultSet(locrs);
        if (!status) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        locrs.clear();
        status = this.executeDhcpCrsctlCommand(this.m_crsctlDiscoverCmd, (String)clientIDList.get(0), crsctlMsgList, locrs, false);
        this.m_resultSet.uploadResultSet(locrs);
        if (!status) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long discoveryTime = (currentTime - startTime) / 1000L;
        if (discoveryTime > this.SCRIPT_TIMEOUT) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5712", true, (Object[])new String[]{new Long(discoveryTime).toString(), new Long(this.SCRIPT_TIMEOUT).toString()}));
        }
        return true;
    }

    private boolean performExistanceCheck() {
        ArrayList<String> clientIDList = new ArrayList<String>();
        ArrayList<String> crsctlMsgList = new ArrayList<String>();
        ResultSet locrs = new ResultSet();
        boolean status = this.executeGetClientIDCrsctlCommand(this.m_clusterName, "SCANVIP", null, null, clientIDList, locrs);
        Trace.out((String)"generating client id");
        this.m_resultSet.uploadResultSet(locrs);
        if (!status) {
            return false;
        }
        locrs.clear();
        Trace.out((String)("executing discover command for " + (String)clientIDList.get(0)));
        status = this.executeDhcpCrsctlCommand(this.m_crsctlDiscoverCmd, (String)clientIDList.get(0), crsctlMsgList, locrs, false);
        this.m_resultSet.uploadResultSet(locrs);
        if (!status) {
            return false;
        }
        for (String errMsg : crsctlMsgList) {
            ReportUtil.println(errMsg);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean performSufficiencyCheck() {
        Integer n;
        ArrayList<String> clientIDList = new ArrayList<String>();
        ArrayList<String> crsctlMsgList = new ArrayList<String>();
        Integer vipRequired = new Integer(3);
        Integer vipAllocated = new Integer(0);
        Trace.out((String)"about to get SCANVIP clientid");
        ResultSet locrs = new ResultSet();
        boolean status = this.executeGetClientIDCrsctlCommand(this.m_clusterName, "SCANVIP", null, null, clientIDList, locrs);
        this.m_resultSet.uploadResultSet(locrs);
        if (!status) {
            return false;
        }
        String[] vipNodesArray = null;
        if (this.m_nodeMgr.isBigCluster()) {
            int hubSize = this.m_nodeMgr.getTargetHubSize();
            int arrayLength = hubSize < this.m_nodeList.length ? hubSize : this.m_nodeList.length;
            vipNodesArray = new String[arrayLength];
            Trace.out((String)("adding " + arrayLength + " nodes for sufficiency check"));
            for (int i = 0; i < arrayLength; ++i) {
                vipNodesArray[i] = this.m_nodeList[i];
            }
        } else {
            vipNodesArray = this.m_nodeList;
            try {
                vipNodesArray = VerificationUtil.getNodelist();
            }
            catch (NodelistNotFoundException e) {
                Trace.out((String)"nodelist couldn't be found");
            }
        }
        for (String string : vipNodesArray) {
            Trace.out((String)("getting client id for node: " + string));
            Integer n2 = vipRequired;
            n = vipRequired = Integer.valueOf(vipRequired + 1);
            locrs.clear();
            status = this.executeGetClientIDCrsctlCommand(this.m_clusterName, "HOSTVIP", null, string, clientIDList, locrs);
            this.m_resultSet.uploadResultSet(locrs);
            if (status) continue;
            return false;
        }
        if (this.m_vipResName != null) {
            void var11_21;
            String[] vipResNameArr;
            Trace.out((String)("Getting client id for vipres: " + this.m_vipResName));
            String[] arr$ = vipResNameArr = VerificationUtil.string2strArr(this.m_vipResName, ",");
            int len$ = arr$.length;
            boolean bl = false;
            while (var11_21 < len$) {
                String appVIP = arr$[var11_21];
                n = vipRequired;
                Integer n3 = vipRequired = Integer.valueOf(vipRequired + 1);
                Trace.out((String)("getting clientID for vip" + appVIP));
                locrs.clear();
                status = this.executeGetClientIDCrsctlCommand(this.m_clusterName, "APPVIP", appVIP, null, clientIDList, locrs);
                this.m_resultSet.uploadResultSet(locrs);
                if (!status) {
                    return false;
                }
                ++var11_21;
            }
        }
        Trace.out((String)("required ip address count =" + vipRequired.toString()));
        for (String clientId : clientIDList) {
            Trace.out((String)("sending discover packets for :" + clientId));
            ReportUtil.println(s_msgBundle.getMessage("5717", false, (Object[])new String[]{"DISCOVER", clientId}));
            locrs.clear();
            status = this.executeDhcpCrsctlCommand(this.m_crsctlDiscoverCmd, clientId, crsctlMsgList, locrs, true);
            this.m_resultSet.uploadResultSet(locrs);
            if (status) {
                for (String string : crsctlMsgList) {
                    ReportUtil.println(string);
                }
            } else {
                Trace.out((String)"failed while sending discover packets");
                break;
            }
            crsctlMsgList.clear();
            ReportUtil.println(s_msgBundle.getMessage("5717", false, (Object[])new String[]{"REQUEST", clientId}));
            Trace.out((String)("sending request packets for :" + clientId));
            locrs.clear();
            status = this.executeDhcpCrsctlCommand(this.m_crsctlRequestCmd, clientId, crsctlMsgList, locrs, true);
            this.m_resultSet.uploadResultSet(locrs);
            if (status) {
                Iterator i$ = vipAllocated;
                Integer n4 = vipAllocated = Integer.valueOf(vipAllocated + 1);
                for (String string : crsctlMsgList) {
                    ReportUtil.println(string);
                }
                crsctlMsgList.clear();
                continue;
            }
            Trace.out((String)"failed while executing request command");
            break;
        }
        Trace.out((String)("allocated ip=" + vipAllocated.toString()));
        if (vipAllocated < vipRequired) {
            status = false;
            String errMsg = s_msgBundle.getMessage("5707", true, (Object[])new String[]{vipAllocated.toString(), vipRequired.toString()});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ReportUtil.sureprintln(errMsg);
        }
        for (String clientId : clientIDList) {
            Trace.out((String)("sending release packets for :" + clientId));
            locrs.clear();
            boolean cleanupStatus = this.executeDhcpCrsctlCommand(this.m_crsctlReleaseCmd, clientId, crsctlMsgList, locrs, false);
            this.m_resultSet.uploadResultSet(locrs);
            if (cleanupStatus) {
                for (String errMsg : crsctlMsgList) {
                    ReportUtil.println(errMsg);
                }
                crsctlMsgList.clear();
                continue;
            }
            Trace.out((String)"failed while sending release packet");
            break;
        }
        return status;
    }

    private boolean performNodeVipConfigCheck(String[] nodeList) {
        ArrayList<String> clientIDList = new ArrayList<String>();
        ArrayList<String> crsctlMsgList = new ArrayList<String>();
        ResultSet locrs = new ResultSet();
        if (this.m_subnetStr == null) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("5729", false, (Object[])new String[]{new Integer(this.m_port).toString()}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("5735", false, (Object[])new String[]{new Integer(this.m_port).toString(), this.m_subnetStr}));
        }
        for (String node : nodeList) {
            boolean status = this.executeGetClientIDCrsctlCommand(this.m_clusterName, "HOSTVIP", null, node, clientIDList, locrs);
            Trace.out((String)"generated client id");
            this.m_resultSet.uploadResultSet(locrs);
            if (!status) {
                return false;
            }
            locrs.clear();
            Trace.out((String)("executing discover command for " + (String)clientIDList.get(0)));
            status = this.executeDhcpCrsctlCommand(this.m_crsctlDiscoverCmd, (String)clientIDList.get(0), crsctlMsgList, locrs, false);
            this.m_resultSet.uploadResultSet(locrs);
            if (!status) {
                if (this.m_subnetStr == null) {
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("5730", false, (Object[])new String[]{new Integer(this.m_port).toString(), node}));
                    continue;
                }
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("5731", false, (Object[])new String[]{new Integer(this.m_port).toString(), node, this.m_subnetStr}));
                continue;
            }
            for (String errMsg : crsctlMsgList) {
                ReportUtil.println(errMsg);
            }
            Trace.out((String)("sending release packets for :" + (String)clientIDList.get(0)));
            locrs.clear();
            status = this.executeDhcpCrsctlCommand(this.m_crsctlReleaseCmd, (String)clientIDList.get(0), crsctlMsgList, locrs, false);
            this.m_resultSet.uploadResultSet(locrs);
            if (status) {
                for (String errMsg : crsctlMsgList) {
                    ReportUtil.println(errMsg);
                }
                crsctlMsgList.clear();
                continue;
            }
            Trace.out((String)"failed while sending release packet");
            break;
        }
        return true;
    }

    private boolean performLogicalInterfaceCheck() {
        int warnAddressCount = 20;
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                int addressCount = 0;
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    ++addressCount;
                }
                if (addressCount <= warnAddressCount) continue;
                String msg = s_msgBundle.getMessage("5715", true, (Object[])new String[]{netint.getName(), new Integer(addressCount).toString(), new Integer(warnAddressCount).toString()});
                ReportUtil.sureprintln(msg);
            }
        }
        catch (SocketException e) {
            String msg = s_msgBundle.getMessage("5716", true) + LSEP + e.getMessage();
            ReportUtil.sureprintln(msg);
        }
        return true;
    }

    private boolean executeDhcpCrsctlCommand(String command, String clientId, List<String> crsctlMsgList, ResultSet locrs, boolean noDHCPMute) {
        ErrorDescription errorDesc;
        String errMsg;
        String crsctlCmd = this.m_crsctlBinLocation + command;
        int argLen = 1;
        int argPtr = 0;
        String portStr = new Integer(this.m_port).toString();
        if (this.m_port != 67) {
            argLen += 2;
        }
        if (this.m_subnetStr != null) {
            argLen += 2;
        }
        String[] cmdSplitArr = crsctlCmd.split(" ");
        int splitLen = cmdSplitArr.length - 1;
        String[] args = new String[argLen += splitLen];
        for (int i = 1; i < cmdSplitArr.length; ++i) {
            args[argPtr++] = cmdSplitArr[i];
        }
        args[argPtr++] = clientId;
        if (this.m_port != 67) {
            args[argPtr++] = " -port ";
            args[argPtr++] = portStr;
        }
        if (this.m_subnetStr != null) {
            args[argPtr++] = " -subnet ";
            args[argPtr] = this.m_subnetStr;
        }
        String crsctlCmdDisplay = crsctlCmd;
        for (int i = splitLen; i < args.length; ++i) {
            crsctlCmdDisplay = crsctlCmdDisplay + args[i] + " ";
        }
        String[] env = null;
        if (this.m_preCrsInst) {
            env = new String[]{this.m_ldLibPath};
        }
        CommandResult cmdResult = new CommandResult();
        Trace.out((String)("about to submit cmd : " + crsctlCmdDisplay));
        ResultSet rs = new ResultSet();
        String output = null;
        String node = this.m_nodeList[0];
        if (!this.m_isUnixSystem || !RootAutomationUtility.isRootExecutionConfigured()) {
            String[] ntArgs = new String[]{"-rungencmd", crsctlCmdDisplay};
            VerificationCommand[] dhcpCmdArr = new VerificationCommand[]{new VerificationCommand(m_localHost, ntArgs, env, (NativeResult)cmdResult)};
            new GlobalHandler().submit((Command[])dhcpCmdArr, 0, rs);
            Result result = dhcpCmdArr[0].getResult();
            locrs.addResult(node, result);
            if (result.getStatus() == 1) {
                output = dhcpCmdArr[0].getOutput();
            } else {
                String[] outputArr = cmdResult.getOutputString();
                String tmpStr = VerificationUtil.strArr2String(outputArr, LSEP);
                output = VerificationUtil.fetchVerificationValue(tmpStr);
            }
        } else {
            String[] nodeArr = !this.m_preCrsInst ? new String[]{this.m_nodeList[0]} : new String[]{m_localHost};
            try {
                Trace.out((String)"getting root automation configuration");
                this.m_rootCreds = RootAutomationUtility.getRootExecutionInfo();
            }
            catch (VerificationException e) {
                Trace.out((String)"root automation not configured");
                ReportUtil.sureprintln(e.getMessage());
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addResult(this.m_nodeList, 2);
                locrs.addErrorDescription(errDesc);
            }
            GlobalExecution globalExec = new GlobalExecution();
            boolean result = false;
            try {
                result = globalExec.runGenericCmdAsRoot(nodeArr, crsctlCmd.substring(0, crsctlCmd.indexOf(" ")), env, args, this.m_rootCreds, this.m_defaultTimeout, rs);
            }
            catch (RootAutomationNotConfiguredException e) {
                rs.addResult(nodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                rs.addErrorDescription(errDesc);
            }
            locrs.uploadResultSet(rs);
            if (rs.getStatus() != 1) {
                List<VerificationError> errList = rs.getResult(this.m_nodeList[0]).getErrors();
                StringBuilder sb = new StringBuilder();
                Trace.out((String)"root command execution failed");
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                ErrorDescription errDesc = new ErrorDescription(sb.toString());
                locrs.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(sb.toString());
                return false;
            }
            output = (String)rs.getResult(nodeArr[0]).getResultInfoSet().get(0);
        }
        Trace.out((String)("output =" + output));
        if (output == null || output.length() == 0) {
            Trace.out((String)("Error retreiving output of crsctl command on node " + node));
            locrs.addResult(node, 2);
            errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{crsctlCmdDisplay, node});
            ReportUtil.sureprintln(errMsg);
            errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(node, errorDesc);
        } else {
            if (output.indexOf("CRS-10010: ") != -1 || output.indexOf("CRS-10011: ") != -1 || output.indexOf("CRS-10013: ") != -1) {
                locrs.addResult(node, 3);
                if (!noDHCPMute) {
                    Trace.out((String)("crsctl output : " + output));
                    if (this.m_preCrsInst) {
                        output = VerificationUtil.strArr2String(this.parseCrsctlLiteOutput(output), LSEP);
                    }
                    errMsg = this.m_subnetStr == null ? s_gMsgBundle.getMessage("5726", true, (Object[])new String[]{portStr, crsctlCmdDisplay}) : s_gMsgBundle.getMessage("5733", true, (Object[])new String[]{portStr, crsctlCmdDisplay, this.m_subnetStr});
                    errMsg = errMsg + LSEP + output;
                    ReportUtil.sureprintln(errMsg);
                    errorDesc = new ErrorDescription(errMsg);
                    locrs.addErrorDescription(node, errorDesc);
                }
                return false;
            }
            if (output.indexOf("CRS-10009: ") != -1 || output.indexOf("CRS-10012: ") != -1) {
                if (this.m_preCrsInst) {
                    output = VerificationUtil.strArr2String(this.parseCrsctlLiteOutput(output), LSEP);
                }
                crsctlMsgList.add(output);
                locrs.addResult(node, 1);
            } else {
                String origOpt = output;
                if (this.m_preCrsInst) {
                    output = VerificationUtil.strArr2String(this.parseCrsctlLiteOutput(output), LSEP);
                }
                String errMsg2 = null;
                errMsg2 = origOpt.indexOf("CRS-") != -1 ? s_msgBundle.getMessage("5718", true, (Object[])new String[]{crsctlCmdDisplay, node, output}) : s_msgBundle.getMessage("5714", true, (Object[])new String[]{crsctlCmdDisplay, output});
                ReportUtil.sureprintln(errMsg2);
                locrs.addResult(node, 2);
                ErrorDescription errorDesc2 = new ErrorDescription(errMsg2);
                locrs.addErrorDescription(node, errorDesc2);
                return false;
            }
        }
        return true;
    }

    private boolean executeGetClientIDCrsctlCommand(String clusterName, String vipType, String vipResName, String nodeName, List<String> clientId, ResultSet locrs) {
        this.m_crsctlBinLocation = CVUAutoUpdateManager.getCRSCTLHome();
        if (this.m_crsctlBinLocation == null) {
            String msg = s_msgBundle.getMessage("5301", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(this.m_nodeList, 2);
            return false;
        }
        boolean isStackDown = false;
        if (this.m_preCrsInst) {
            if (VerificationUtil.isCVUTestEnv()) {
                this.m_crsctlBinLocation = this.m_crsctlBinLocation + "has" + FSEP;
            }
            this.m_crsctlBinLocation = this.m_crsctlBinLocation + "bin" + FSEP;
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            String liteFullName = nativeSystem.getExeName("cvunetquery");
            File liteFile = new File(this.m_crsctlBinLocation + liteFullName);
            if (!liteFile.exists()) {
                isStackDown = true;
                if (!nativeSystem.isUnixSystem()) {
                    String derivedLoc = CVUAutoUpdateManager.getDerivedCVUHome();
                    String derivedLocParent = new File(derivedLoc).getParentFile().getAbsolutePath();
                    File destCVNetQuery1 = new File(derivedLocParent + FSEP + "ext" + FSEP + "bin" + FSEP + liteFullName);
                    File destCVNetQuery2 = new File(derivedLoc + FSEP + "cv" + FSEP + "admin" + FSEP + liteFullName);
                    if (destCVNetQuery1.exists()) {
                        this.m_crsctlBinLocation = derivedLocParent + FSEP + "ext" + FSEP + "bin" + FSEP;
                    } else if (destCVNetQuery2.exists()) {
                        this.m_crsctlBinLocation = derivedLoc + FSEP + "cv" + FSEP + "admin" + FSEP;
                    } else {
                        String networkSrcLoc = VerificationUtil.getCVHome() + "cv" + FSEP + "admin" + FSEP + liteFullName;
                        this.m_crsctlBinLocation = derivedLocParent + FSEP + "ext" + FSEP + "bin" + FSEP;
                        Trace.out((String)("network src loc = " + networkSrcLoc + " dest loc = " + this.m_crsctlBinLocation + liteFullName));
                        networkSrcLoc = networkSrcLoc.replace("/", "\\");
                        String copyResult = nativeSystem.copyFile("localnode", networkSrcLoc, "localnode", this.m_crsctlBinLocation + liteFullName);
                        if (copyResult != null && copyResult.startsWith("0|")) {
                            String errStr = s_msgBundle.getMessage("7709", true, (Object[])new String[]{networkSrcLoc, this.m_crsctlBinLocation, m_localHost}) + LSEP + copyResult.substring(2);
                            this.m_resultSet.addResult(this.m_nodeList, 2);
                            this.m_resultSet.addErrorDescription(new ErrorDescription(errStr));
                            ReportUtil.sureprintln(errStr);
                            return false;
                        }
                    }
                    Trace.out((String)("Running cvunetquery.exe from " + this.m_crsctlBinLocation));
                } else {
                    this.m_crsctlBinLocation = VerificationUtil.getCVHome() + "cv" + FSEP + "admin" + FSEP;
                }
            }
        } else {
            this.m_crsctlBinLocation = this.m_crsctlBinLocation + "bin" + FSEP;
        }
        Trace.out((String)("executing crsct/cvunetquery from " + this.m_crsctlBinLocation));
        String getCmd = this.m_crsctlBinLocation + this.m_crsctlGetCmd + clusterName + " -viptype " + vipType;
        if (vipType.equals("HOSTVIP")) {
            getCmd = getCmd + " -n " + nodeName;
        } else if (vipType.equals("APPVIP")) {
            getCmd = getCmd + " -vip " + vipResName;
        }
        VerificationCommand[] getClientIdCmdArr = new VerificationCommand[1];
        String[] args = new String[]{"-rungencmd", getCmd};
        String[] env = null;
        if (this.m_preCrsInst) {
            String PSEP;
            String path;
            if (m_isAPImode) {
                if (this.m_isUnixSystem) {
                    this.m_ldLibPath = VerificationUtil.isCVUTestEnv() ? "LD_LIBRARY_PATH=" + this.m_crsctlBinLocation + ".." + FSEP + ".." + FSEP + "lib" : (isStackDown ? "LD_LIBRARY_PATH=" + VerificationUtil.getCVHome() + FSEP + "lib:" + VerificationUtil.getCVHome() + FSEP + ".." + FSEP + "ext" + FSEP + "lib" : "LD_LIBRARY_PATH=" + this.m_crsctlBinLocation + ".." + FSEP + ".." + FSEP + "ext" + FSEP + "lib");
                } else {
                    path = System.getenv("PATH");
                    PSEP = System.getProperty("path.separator");
                    this.m_ldLibPath = isStackDown ? "PATH=" + VerificationUtil.getCVHome() + FSEP + "bin" + PSEP + path : "PATH=" + this.m_crsctlBinLocation + ".." + FSEP + ".." + FSEP + "ext" + FSEP + "bin" + PSEP + path;
                }
            } else if (this.m_isUnixSystem) {
                this.m_ldLibPath = "LD_LIBRARY_PATH=" + VerificationUtil.getCVHome() + FSEP + "lib:" + VerificationUtil.getCVHome() + FSEP + ".." + FSEP + "ext" + FSEP + "lib";
            } else {
                path = System.getenv("PATH");
                PSEP = System.getProperty("path.separator");
                this.m_ldLibPath = "PATH=" + VerificationUtil.getCVHome() + FSEP + "bin" + PSEP + path;
            }
            env = new String[]{this.m_ldLibPath};
            Trace.out((String)("setting " + this.m_ldLibPath));
        }
        CommandResult cmdResult = new CommandResult();
        getClientIdCmdArr[0] = new VerificationCommand(m_localHost, args, env, (NativeResult)cmdResult);
        Trace.out((String)("about to submit get clientid cmd : " + getCmd));
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])getClientIdCmdArr, 0, rs);
        Result result = getClientIdCmdArr[0].getResult();
        String node = m_localHost;
        locrs.addResult(node, result);
        String output = null;
        if (result.getStatus() == 1) {
            output = getClientIdCmdArr[0].getOutput();
        } else {
            String[] outputArr = cmdResult.getOutputString();
            String tmpStr = VerificationUtil.strArr2String(outputArr, LSEP);
            output = VerificationUtil.fetchVerificationValue(tmpStr);
        }
        Trace.out((String)("output =" + output));
        if (output == null || output.length() == 0) {
            Trace.out((String)("Error retreiving output of crsctl command on node " + node));
            locrs.addResult(node, 2);
            String errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{getCmd, node});
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(node, errorDesc);
            return false;
        }
        String[] outlist = VerificationUtil.getTokensAsArray(output, LSEP);
        if (output.indexOf("CRS-10008: ") != -1) {
            Trace.out((String)("crsctl output : " + output));
            if (this.m_preCrsInst) {
                output = VerificationUtil.strArr2String(this.parseCrsctlLiteOutput(output), LSEP);
            }
            String errMsg = s_gMsgBundle.getMessage("5727", true, (Object[])new String[]{getCmd}) + LSEP + output;
            ReportUtil.sureprintln(errMsg);
            locrs.addResult(node, 3);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(node, errorDesc);
            return false;
        }
        for (int i = 0; i < outlist.length; ++i) {
            Trace.out((String)("id=" + outlist[i]));
            if (this.m_preCrsInst && outlist[i].indexOf("CRS-10007: ") != -1) {
                String[] liteIDArr;
                for (String liteID : liteIDArr = this.parseCrsctlLiteOutput(outlist[i])) {
                    clientId.add(liteID);
                }
                continue;
            }
            if (outlist[i].startsWith("CRS-10007: ")) {
                clientId.add(outlist[i].substring(outlist[i].indexOf(":") + 1).trim());
                continue;
            }
            if (this.m_preCrsInst) {
                output = VerificationUtil.strArr2String(this.parseCrsctlLiteOutput(output), LSEP);
            }
            String errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{getCmd, output});
            ReportUtil.sureprintln(errMsg);
            locrs.addResult(node, 2);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(node, errorDesc);
            return false;
        }
        locrs.addResult(node, 1);
        return true;
    }

    private boolean getCmdLineParams() {
        int subnetBeginIndex;
        int publicIndex;
        this.m_clusterName = VerificationUtil.getVariableValue("CLUSTER_NAME");
        this.m_vipResName = VerificationUtil.getVariableValue("APP_VIP_RESOURCE_NAMES");
        String portStr = VerificationUtil.getVariableValue("DHCP_PORT");
        if (portStr != null) {
            this.m_port = Integer.parseInt(portStr);
        }
        if (this.m_port < 1024 && this.m_isUnixSystem && !Boolean.getBoolean("CV_ROOTUSERCHECK") && !RootAutomationUtility.isRootExecutionConfigured()) {
            String errMsg = s_msgBundle.getMessage("0055", true, (Object[])new String[]{System.getProperty("user.name")});
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        String interConnectList = VerificationUtil.getVariableValue("INTERCONNECT_LIST");
        if (interConnectList != null && interConnectList.length() > 0 && (publicIndex = interConnectList.indexOf(":PUBLIC")) != -1 && (subnetBeginIndex = interConnectList.lastIndexOf("\":", publicIndex)) != -1) {
            if (subnetBeginIndex + 2 < publicIndex) {
                this.m_subnetStr = interConnectList.substring(subnetBeginIndex + 2, publicIndex);
                Trace.out((String)("setting subnet as " + this.m_subnetStr));
            } else {
                String errMsg = s_gMsgBundle.getMessage("11051", true);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
        }
        return true;
    }

    private boolean performResourceCheck() {
        ErrorDescription errDesc;
        String msg;
        if (this.m_preCrsInst) {
            return true;
        }
        boolean networkResOnline = false;
        TaskNodeAppCreation taskNAC = new TaskNodeAppCreation(this.m_nodeList);
        Trace.out((String)("\n Checking NODEAPPS for nodes: " + VerificationUtil.strArr2List(this.m_nodeList)));
        ReportUtil.println(s_gMsgBundle.getMessage("5719", false));
        boolean saveMode = ReportUtil.getMode();
        ReportUtil.setMode(false);
        taskNAC.setNodesWithCRS(this.m_nodeList);
        boolean retval = taskNAC.performCommonTask(this.m_nodeList, false);
        ReportUtil.setMode(saveMode);
        ResultSet nacRS = taskNAC.getResultSet();
        Trace.out((String)"\n Finished with NODEAPP check");
        if (nacRS.anySuccess()) {
            Object errorDesc = null;
            Hashtable t = nacRS.getResultTable();
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result result = (Result)t.get(node);
                Vector nodeappDataVect = result.getResultInfoSet();
                Trace.out((String)"Get the status for resource : ora.net1.network");
                for (TaskNodeAppCreation.TaskNACData nodeappData : nodeappDataVect) {
                    String nodeappStatus = nodeappData.getStatus() == 1 ? "ONLINE" : (nodeappData.getStatus() == 0 ? "EXIST_OFFLINE" : (nodeappData.getStatus() == 210 ? "NOTEXIST" : "UNKNOWN"));
                    Trace.out((String)("\nNodeapp: '" + nodeappData.getName() + "' Status: " + nodeappStatus));
                    if (!nodeappData.getName().equalsIgnoreCase("ora.net1.network") || nodeappData.getStatus() != 1) continue;
                    ReportUtil.println(s_gMsgBundle.getMessage("5720", false));
                    networkResOnline = true;
                }
            }
        }
        if (!networkResOnline) {
            ReportUtil.println(s_gMsgBundle.getMessage("5721", false));
            return true;
        }
        ReportUtil.println(s_gMsgBundle.getMessage("5722", false));
        Result res = new Result(m_localHost);
        String crsHome = VerificationUtil.getCRSHome(m_localHost, res);
        if (crsHome == null) {
            Trace.out((String)"Failed to get CRS HOME");
            msg = s_msgBundle.getMessage("5301", true);
            ReportUtil.sureprintln(msg);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        try {
            if (new ClusterwareInfo().isDHCPServerConfigured(crsHome)) {
                Trace.out((String)"dhcp based network resource is running");
                msg = s_gMsgBundle.getMessage("5723", true);
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                ReportUtil.sureprintln(msg);
                return false;
            }
        }
        catch (InstallException e) {
            Trace.out((String)("error while checking if network is DHCP" + e.getMessage()));
        }
        ReportUtil.println(s_gMsgBundle.getMessage("5724", false));
        return true;
    }

    public void setPreCheck(boolean isPreCheck) {
        if (!isPreCheck) {
            return;
        }
        Trace.out((String)"Running DHCP checks in lightweight mode");
        this.m_preCrsInst = isPreCheck;
        this.m_crsctlDiscoverCmd = "cvunetquery discover dhcp -clientid ";
        this.m_crsctlRequestCmd = "cvunetquery request dhcp -clientid ";
        this.m_crsctlReleaseCmd = "cvunetquery release dhcp -clientid ";
        this.m_crsctlGetCmd = "cvunetquery get clientid dhcp -cluname ";
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    private String[] parseCrsctlLiteOutput(String output) {
        String[] msgArr = VerificationUtil.fetchTextByTagsRepeat(output, "<MSG_PACKET>", "</MSG_PACKET>");
        if (msgArr == null || msgArr.length == 0) {
            return new String[]{output};
        }
        ArrayList<String> strList = new ArrayList<String>();
        for (String line : msgArr) {
            String msgNumStr;
            int beginIndex;
            String str;
            Object[] argArr = VerificationUtil.fetchTextByTagsRepeat(line, "<ARG_VALUE>", "</ARG_VALUE>");
            Trace.out((String)("looking at line " + line));
            if (line.indexOf("CRS-10007: ") != -1) {
                strList.add(argArr[0]);
                continue;
            }
            if (line.indexOf("CRS-10009: ") != -1 || line.indexOf("CRS-10012: ") != -1) {
                str = VerificationUtil.fetchTextByTags(line, "<MSG_NUM>", "</MSG_NUM>");
                beginIndex = str.indexOf("CRS-");
                msgNumStr = str.substring(beginIndex, beginIndex + 5).trim();
                strList.add(s_gMsgBundle.getMessage(msgNumStr, false, argArr));
                continue;
            }
            if (line.indexOf("CRS-10005") != -1 || line.indexOf("CRS-10006") != -1 || line.indexOf("CRS-10008") != -1 || line.indexOf("CRS-10010") != -1 || line.indexOf("CRS-10011") != -1 || line.indexOf("CRS-10013") != -1 || line.indexOf("CRS-10014") != -1 || line.indexOf("CRS-10015") != -1 || line.indexOf("CRS-10036") != -1 || line.indexOf("CRS-10039") != -1 || line.indexOf("CRS-10040") != -1 || line.indexOf("CRS-10041") != -1) {
                str = VerificationUtil.fetchTextByTags(line, "<MSG_NUM>", "</MSG_NUM>");
                beginIndex = str.indexOf("CRS-") + "CRS-".length();
                msgNumStr = str.substring(beginIndex, beginIndex + 5).trim();
                strList.add(s_gMsgBundle.getMessage(msgNumStr, true, argArr));
                continue;
            }
            str = VerificationUtil.fetchTextByTags(line, "<MSG_NUM>", "</MSG_NUM>");
            if (str != null) {
                strList.add(s_gMsgBundle.getMessage("5736", true, (Object[])new String[]{"crsctl", str}));
                continue;
            }
            strList.add(s_msgBundle.getMessage("5714", true, (Object[])new String[]{"crsctl", line}));
        }
        return strList.toArray(new String[0]);
    }
}

