/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDomainSockets
extends Task {
    List<String> m_listOfUnexpectedFiles = null;
    boolean m_checkFileAbsence = false;

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)("Performing domain sockets validation; m_checkFileAbsence=" + this.m_checkFileAbsence));
        String path = VerificationUtil.getDomainSocketsDir();
        Trace.out((String)("Domain socket directory=" + path));
        GlobalExecution globalExec = new GlobalExecution();
        for (String node : this.m_nodeList) {
            List<String> fileList = TaskDomainSockets.listDir(node, path);
            ResultSet nodeResultSet = new ResultSet();
            globalExec.getFileInfo(new String[]{node}, fileList, nodeResultSet);
            this.m_resultSet.uploadResultSet(nodeResultSet);
            Hashtable fileInforResultTable = nodeResultSet.getResultTable();
            Result result = (Result)fileInforResultTable.get(node);
            if (result == null || result.getStatus() != 1) continue;
            Hashtable nodeFileHT = (Hashtable)result.getResultInfoSet().elementAt(0);
            Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable = new Hashtable<String, Hashtable<String, FileInfo>>();
            nodeFileInfoTable.put(node, nodeFileHT);
            for (String file : nodeFileHT.keySet()) {
                if (this.m_checkFileAbsence) {
                    Trace.out((String)("Going to validate the expectation of file '" + file + "' on node '" + node + "'"));
                    if (this.isFileUnexpected(file)) {
                        ErrorDescription errDesc = new ErrorDescription("11750", new String[]{file, node}, s_gMsgBundle);
                        this.m_resultSet.addResult(node, 3);
                        ReportUtil.printError(errDesc.getErrorMessage());
                        this.m_resultSet.addErrorDescription(node, errDesc);
                    }
                }
                VerificationUtil.checkFileAttributes(new String[]{node}, file, s_gMsgBundle.getMessage("11182", false), nodeFileInfoTable, null, null, null, this.m_resultSet);
            }
        }
        return retVal;
    }

    public static List<String> listDir(String node, String dirPath) {
        Trace.out((int)2, (String)"Entry");
        ArrayList<String> fileList = new ArrayList<String>();
        List m_deviceList = new ArrayList();
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet rsltSet = new ResultSet();
        if (node == null) {
            node = VerificationUtil.getLocalHostName();
        }
        String cmd = "ls -a1 " + dirPath;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("expandDevicePaths: Command is : " + cmd));
        }
        globalExec.runGenericCmd(new String[]{node}, cmd, rsltSet);
        Result result = rsltSet.getResult(node);
        if (result.getStatus() == 1 || result.getStatus() == 4) {
            String outStr = (String)result.getResultInfoSet().firstElement();
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                m_deviceList = VerificationUtil.parseFileListOutput(cmdOut);
                for (String file : m_deviceList) {
                    fileList.add(dirPath + File.separator + file);
                }
            } else if (VerificationUtil.isStringGood(outStr)) {
                result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + LSEP + outStr));
            } else {
                result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
            }
        }
        return fileList;
    }

    boolean isFileUnexpected(String file) {
        if (this.m_listOfUnexpectedFiles == null) {
            this.getListOfUnexpectedFiles();
        }
        for (String fileStart : this.m_listOfUnexpectedFiles) {
            if (!new File(file).getName().startsWith(fileStart)) continue;
            return true;
        }
        return false;
    }

    private void getListOfUnexpectedFiles() {
        this.m_listOfUnexpectedFiles = new ArrayList<String>();
        this.m_listOfUnexpectedFiles.add("ora_gipc");
        this.m_listOfUnexpectedFiles.add("mdnsd");
        this.m_listOfUnexpectedFiles.add("npohasd");
    }

    public void setCheckFileAbsence(boolean checkFileAbsence) {
        this.m_checkFileAbsence = checkFileAbsence;
    }

    @Override
    public String getTaskID() {
        return "DOMAIN_SOCKETS";
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11180", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11181", false);
    }
}

