/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskFactoryException
extends Exception {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String LSEP = System.getProperty("line.separator");
    private Throwable m_cause;

    public TaskFactoryException(String msg) {
        super(msg);
    }

    public TaskFactoryException(String msg, Throwable cause) {
        super(msg, cause);
        this.m_cause = cause;
        Trace.stackTrace((Throwable)cause);
    }

    public TaskFactoryException(MessageBundle msgBundle, String key, Object ... args) {
        super(msgBundle.getMessage(key, true, args));
    }

    public TaskFactoryException(Throwable cause) {
        super(s_msgBundle.getMessage("7510", false), cause);
        this.m_cause = cause;
        Trace.stackTrace((Throwable)cause);
    }

    public String getCompleteMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getMessage());
        if (this.m_cause != null) {
            Throwable nextCause;
            sb.append(LSEP + this.m_cause.getMessage());
            Throwable thrw = this.m_cause;
            while ((nextCause = thrw.getCause()) != null) {
                sb.append(LSEP + nextCause.getMessage());
                thrw = nextCause;
            }
        }
        return sb.toString();
    }
}

