/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSUtils;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.GNSData;
import oracle.ops.verification.framework.engine.task.GetAllByNameThread;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskGNSIntegrity
extends Task
implements CVUHelperConstants {
    String m_localName = null;
    boolean m_preCheck = false;
    private String GNS_DATA_HELPER_ARG = "-getGNSResourceStatus";
    private String GNS_SCAN_NAME_HELPER_ARG = "-getScanName";
    private String GNS_RESPONSE_SERVER = "Oracle-GNS";

    public TaskGNSIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskGNSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskGNSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing GNS Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5202", false));
        this.performGNSIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5203", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5204", false));
        return false;
    }

    private void performGNSIntegrityChecks() {
        boolean isGNSRunningOnNode = false;
        String gnsVIP = null;
        GNSUtils gnsUtils = new GNSUtils();
        String gnsDomainName = null;
        boolean isDomainName = true;
        boolean isThereDomain = true;
        try {
            if (this.m_localName == null) {
                this.m_localName = VerificationUtil.getLocalHost();
            }
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: while getting local node" + uhe));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("0002", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return;
        }
        if (!this.m_preCheck && !CVUHelperUtil.getGNSDomainAndVIP(this.m_resultSet, this.m_localName)) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("5213", true);
            ReportUtil.sureprintln(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return;
        }
        gnsDomainName = VerificationUtil.getVariableValue("GNS_SUB_DOMAIN");
        gnsVIP = VerificationUtil.getVariableValue("GNS_VIP_ADDRESS");
        isThereDomain = VerificationUtil.isStringGood(gnsDomainName);
        Trace.out((String)("domain=" + gnsDomainName));
        Trace.out((String)("vip=" + gnsVIP));
        Trace.out((String)("is there domain=" + isThereDomain));
        Trace.out((String)("auto config value: " + VerificationUtil.getVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP")));
        if (this.m_preCheck) {
            String gnsShared;
            if ("FALSE".equalsIgnoreCase(VerificationUtil.getVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP")) || !isThereDomain) {
                isDomainName = false;
            }
            if ("TRUE".equalsIgnoreCase(gnsShared = VerificationUtil.getVariableValue("USE_SHARED_GNS"))) {
                this.m_resultSet.addResult(this.m_nodeList, 1);
                return;
            }
        } else {
            Result res = new Result(this.m_localName);
            String crsHome = VerificationUtil.getCRSHome(this.m_localName, res);
            if (crsHome == null) {
                Trace.out((String)"Failed to get CRS HOME");
                String msg = s_msgBundle.getMessage("5301", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return;
            }
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            try {
                if (!isThereDomain) {
                    isDomainName = false;
                    if (clustInfo.isDHCPServerConfigured(crsHome)) {
                        Trace.out((String)"There is DHCP but not subdomain name");
                        String msg = s_gMsgBundle.getMessage("11424", true);
                        ReportUtil.sureprintln(msg);
                        ErrorDescription errDesc = new ErrorDescription(msg);
                        this.m_resultSet.addErrorDescription(errDesc);
                        this.m_resultSet.addResult(this.m_nodeList, 3);
                        return;
                    }
                }
            }
            catch (InstallException e) {
                Trace.out((String)("error while checking if network is DHCP" + e.getMessage()));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ReportUtil.printError(e.getMessage());
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                return;
            }
        }
        Trace.out((String)("There is domain name: " + isDomainName));
        if (isDomainName) {
            try {
                ReportUtil.println(s_msgBundle.getMessage("5221", false));
                boolean isValid = GNSUtils.isDomainNameValid((String)gnsDomainName);
                ReportUtil.sureprintln(s_msgBundle.getMessage("5222", false, (Object[])new String[]{gnsDomainName}));
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
            catch (GNSException e) {
                String msg = s_msgBundle.getMessage("5223", true, (Object[])new String[]{gnsDomainName}) + LSEP + e.getMessage();
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
            }
        }
        Trace.out((String)"starting GNS-VIP subnet check");
        this.performGNSVIPSubnetCheck(gnsVIP);
        Trace.out((String)"starting VIP validity check");
        this.performGNSVIPValidityCheck(gnsVIP);
        if (!this.m_preCheck) {
            if (isDomainName) {
                Trace.out((String)"starting name resolution check");
                this.performNameResolutionCheck(gnsDomainName);
            }
            Trace.out((String)"starting post crsinst resource check");
            ArrayList<GNSData> gnsDataList = new ArrayList<GNSData>();
            if (this.getGNSDataFromHelper(gnsDataList)) {
                this.performGNSResourceCheck(gnsDataList);
                this.performGNSVIPResourceCheck(gnsDataList);
            }
        }
    }

    private void performGNSVIPSubnetCheck(String gnsVIP) {
        InetAddress gnsInetAddress = null;
        List<InterfaceInfo> ifInfoList = null;
        StringBuffer matchingSubNet = new StringBuffer();
        boolean subNetFound = true;
        if (this.m_preCheck && !VerificationUtil.isCVUTestEnv()) {
            ParamManager pm = null;
            try {
                pm = ParamManager.getInstance();
                if (pm.getMode() == ParamManager.OperationMode.MODE_CLI) {
                    return;
                }
            }
            catch (UninitializedParamManagerException e) {
                Trace.out((Exception)e);
            }
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5224", false));
        try {
            gnsInetAddress = InetAddress.getByName(gnsVIP);
            Trace.out((String)("Inet address for GNSVIP is " + gnsInetAddress.toString()));
            if (!this.m_preCheck || VerificationUtil.getVariableValue("INTERCONNECT_LIST") != null) {
                ifInfoList = VerificationUtil.getIPNetworks("localnode", gnsInetAddress, this.m_preCheck);
            }
        }
        catch (UnknownHostException e) {
            this.displayGNSFailureMessage(e);
            return;
        }
        catch (InstallException e) {
            this.displayGNSFailureMessage((Exception)((Object)e));
            return;
        }
        catch (CVUException e) {
            this.displayGNSFailureMessage(e);
            return;
        }
        if (ifInfoList == null || ifInfoList.size() == 0) {
            Trace.out((String)"oifcfg returned empty list");
            subNetFound = false;
        }
        if (subNetFound) {
            boolean firstSubNet = true;
            Trace.out((String)"matching subnets found");
            for (InterfaceInfo ifInfo : ifInfoList) {
                Trace.out((String)ifInfo.toString());
                if ((ifInfo.getNetType() & 2) == 0) continue;
                if (!firstSubNet) {
                    matchingSubNet.append(", ");
                } else {
                    firstSubNet = false;
                }
                matchingSubNet.append(ifInfo.getSubnet());
            }
            if (!firstSubNet) {
                String msg = s_msgBundle.getMessage("5234", false, (Object[])new String[]{matchingSubNet.toString(), gnsVIP});
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_nodeList, 1);
                return;
            }
            Trace.out((String)"no matching public subnet");
            subNetFound = false;
        }
        if (!subNetFound) {
            String msg = s_msgBundle.getMessage("5233", true, (Object[])new String[]{gnsVIP});
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return;
        }
    }

    private void performGNSVIPValidityCheck(String gnsVIP) {
        ErrorDescription errDesc;
        String msg;
        ReportUtil.println(s_msgBundle.getMessage("5225", false));
        try {
            boolean isValid = GNSUtils.isValidGNSVIP((String)gnsVIP);
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(s_msgBundle.getMessage("5226", false, (Object[])new String[]{gnsVIP}));
        }
        catch (GNSException e) {
            this.m_resultSet.addResult(this.m_nodeList, 3);
            String msg2 = s_msgBundle.getMessage("5227", true, (Object[])new String[]{gnsVIP}) + LSEP + e.getMessage();
            ErrorDescription errDesc2 = new ErrorDescription(msg2);
            this.m_resultSet.addErrorDescription(errDesc2);
            ReportUtil.sureprintln(msg2);
            return;
        }
        ReportUtil.println(s_msgBundle.getMessage("5228", false));
        ClusterCmd clusterCmd = new ClusterCmd();
        String[] gnsVIPArr = new String[]{gnsVIP};
        boolean nodeAlive = false;
        try {
            nodeAlive = clusterCmd.areNodesAlive(gnsVIPArr, 5, null);
        }
        catch (RemoteFileOperationException e) {
            if (!this.m_preCheck) {
                this.displayGNSFailureMessage((Exception)((Object)e));
            }
            return;
        }
        catch (ClusterException e) {
            if (!this.m_preCheck) {
                this.displayGNSFailureMessage((Exception)((Object)e));
            }
            return;
        }
        if (nodeAlive && this.m_preCheck) {
            msg = s_msgBundle.getMessage("5229", true, (Object[])new String[]{gnsVIP});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
        }
        if (!nodeAlive && !this.m_preCheck) {
            msg = s_msgBundle.getMessage("5230", true, (Object[])new String[]{gnsVIP});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ReportUtil.sureprintln(msg);
        }
    }

    private void performNameResolutionCheck(String fullyQualifiedDomainName) {
        String errMsg;
        Hashtable<String, String> addressCheckTable;
        block29: {
            addressCheckTable = new Hashtable<String, String>();
            for (String node : this.m_nodeList) {
                addressCheckTable.put(node + "-vip", node);
            }
            String[] args = new String[]{this.GNS_SCAN_NAME_HELPER_ARG};
            String[] env = null;
            CVUHelperExec helperExec = null;
            boolean continueParsing = false;
            try {
                helperExec = CVUHelperUtil.runCVUHelper(args, env);
                continueParsing = true;
            }
            catch (CVUHelperException e) {
                Trace.out((String)"cvuhelper couldn't be executed");
                errMsg = s_gMsgBundle.getMessage("1009", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                ReportUtil.printError(errMsg);
            }
            if (continueParsing) {
                if (helperExec.getExitValue() == 2) {
                    Trace.out((String)"cvuhelper failed to execute");
                    errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                    ReportUtil.printError(errMsg);
                    continueParsing = false;
                }
                if (continueParsing) {
                    String[] output = helperExec.getOutput();
                    String[] errorArray = null;
                    if (output.length != 0) {
                        String outputStr = helperExec.getOutputString();
                        Trace.out((String)outputStr);
                        int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
                        if (status == 2) {
                            Trace.out((String)"error during cvu helper execution");
                            errorArray = CVUHelperUtil.fetchError(output);
                            errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                            ErrorDescription errorDesc = new ErrorDescription(errMsg);
                            this.m_resultSet.addResult(this.m_nodeList, 2);
                            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                            ReportUtil.printError(errMsg);
                        } else {
                            Trace.out((String)"all data collected");
                            String scanName = VerificationUtil.fetchTextByTags(outputStr, null, "<SCN_NME>", "</SCN_NME>");
                            if (scanName != null && scanName.trim().length() > 0) {
                                try {
                                    if (!InetAddress.getByName(scanName).getHostAddress().equalsIgnoreCase(scanName)) {
                                        int dotIdx = scanName.indexOf(".");
                                        if (dotIdx == -1) {
                                            addressCheckTable.put(scanName, this.m_nodeList[0]);
                                        } else {
                                            addressCheckTable.put(scanName.substring(0, dotIdx), this.m_nodeList[0]);
                                        }
                                        break block29;
                                    }
                                    Trace.out((String)"skipping scanName as it is an dotted ip");
                                }
                                catch (UnknownHostException e) {
                                    Trace.out((String)("UKE while looking up " + scanName));
                                }
                            }
                        }
                    } else {
                        Trace.out((String)"cvuhelper failed to execute");
                        errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
                        ErrorDescription errorDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addResult(this.m_nodeList, 2);
                        this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                        ReportUtil.printError(errMsg);
                    }
                }
            }
        }
        ReportUtil.println(s_msgBundle.getMessage("5214", false, (Object[])new String[]{fullyQualifiedDomainName}));
        ArrayList<GetAllByNameThread> getAllByNameVect = new ArrayList<GetAllByNameThread>();
        Enumeration lookUpNodes = addressCheckTable.keys();
        while (lookUpNodes.hasMoreElements()) {
            String node = (String)lookUpNodes.nextElement();
            String fullyQualifiedMachineName = node;
            if (!fullyQualifiedMachineName.endsWith(fullyQualifiedDomainName)) {
                fullyQualifiedMachineName = fullyQualifiedMachineName + "." + fullyQualifiedDomainName;
            }
            Trace.out((String)("Trying FQMN = " + fullyQualifiedMachineName));
            GetAllByNameThread getByNameThread = new GetAllByNameThread(fullyQualifiedMachineName, (String)addressCheckTable.get(node));
            getAllByNameVect.add(getByNameThread);
            getByNameThread.start();
        }
        for (GetAllByNameThread getByNameThread : getAllByNameVect) {
            ErrorDescription errDesc;
            String msg;
            boolean skipToNextThread = false;
            errMsg = null;
            try {
                getByNameThread.join();
            }
            catch (InterruptedException e) {
                Trace.out((String)"Interrupt while looking up name");
                errMsg = e.getMessage();
                skipToNextThread = true;
            }
            long checkStartTime = getByNameThread.getCheckStartTime();
            long checkEndTime = getByNameThread.getCheckEndTime();
            String fullyQualifiedMachineName = getByNameThread.getLookupName();
            String node = getByNameThread.getErrNodeName();
            Trace.out((String)("error reporting node is : " + node));
            InetAddress[] allIPs = getByNameThread.getAllIPAddress();
            UnknownHostException uhe = getByNameThread.getUnknownHostException();
            if (errMsg != null) {
                this.m_resultSet.addResult(node, 2);
                msg = s_msgBundle.getMessage("5217", true, (Object[])new String[]{fullyQualifiedMachineName}) + LSEP + errMsg;
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(msg);
                continue;
            }
            if (uhe != null) {
                Trace.out((String)"UHE while trying to get IP's for FDQN");
                msg = s_msgBundle.getMessage("5218", true, (Object[])new String[]{fullyQualifiedMachineName});
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 4);
                ReportUtil.printWarning(LSEP + msg);
                skipToNextThread = true;
            }
            this.checkTimeIntervals(checkStartTime, checkEndTime, fullyQualifiedMachineName);
            if (skipToNextThread) continue;
            Trace.out((String)("FQMN has " + allIPs.length + "IP's"));
            if (allIPs.length == 0) {
                msg = s_msgBundle.getMessage("5218", true, (Object[])new String[]{fullyQualifiedMachineName});
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(LSEP + msg);
                continue;
            }
            String[] allIPStringArray = new String[allIPs.length];
            for (int i = 0; i < allIPs.length; ++i) {
                allIPStringArray[i] = allIPs[i].getHostAddress();
            }
            boolean[] nodeConArray = new boolean[allIPs.length];
            String[] nodeErrorArray = new String[allIPs.length];
            VerifyNetwork vfyNet = new VerifyNetwork();
            boolean reach = false;
            try {
                reach = vfyNet.checkReachFromLocalNode(allIPStringArray, nodeConArray, nodeErrorArray);
            }
            catch (NetworkException e) {
                Trace.out((String)"GNS resolved IP is unreachable");
                String msg2 = e.getMessage();
                ErrorDescription errDesc2 = new ErrorDescription(msg2);
                this.m_resultSet.addErrorDescription(errDesc2);
                ReportUtil.sureprintln(LSEP + msg2);
                return;
            }
            if (reach) {
                this.m_resultSet.addResult(this.m_nodeList, 1);
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5215", false));
                continue;
            }
            ArrayList<String> unReachableIPs = new ArrayList<String>();
            String unreachableIPReason = null;
            for (int i = 0; i < allIPs.length; ++i) {
                if (nodeConArray[i]) continue;
                unReachableIPs.add(allIPStringArray[i]);
                unreachableIPReason = unreachableIPReason == null ? nodeErrorArray[i] : unreachableIPReason + LSEP + nodeErrorArray[i];
            }
            String msg3 = s_msgBundle.getMessage("5216", true, (Object[])new String[]{fullyQualifiedMachineName, VerificationUtil.strList2List(unReachableIPs)}) + LSEP + unreachableIPReason;
            ErrorDescription errDesc3 = new ErrorDescription(msg3);
            this.m_resultSet.addErrorDescription(errDesc3);
            ReportUtil.sureprintln(LSEP + msg3);
        }
    }

    private void checkTimeIntervals(long checkStartTime, long checkEndTime, String lookupName) {
        long acceptableDNSResponseTime = 15000L;
        if (checkEndTime - checkStartTime > acceptableDNSResponseTime) {
            Trace.out((String)("currentTime=" + checkEndTime + "Start time =" + checkStartTime));
            String msg = s_msgBundle.getMessage("5827", true, (Object[])new String[]{Long.toString(acceptableDNSResponseTime / 1000L), lookupName});
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.sureprintln(msg);
        }
    }

    private void performGNSVIPResourceCheck(List<GNSData> gnsDataList) {
        ReportUtil.println(s_msgBundle.getMessage("5208", false));
        boolean isGNSVIPRunningOnSameNode = false;
        boolean gnsVIPFirstNodeFound = false;
        ArrayList<String> gnsVIPRunningNodes = new ArrayList<String>();
        ArrayList<String> gnsRunningNodes = new ArrayList<String>();
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        Trace.out((String)"starting GNS-VIP resource check");
        for (GNSData gnsData : gnsDataList) {
            String nodeName = gnsData.getNodeName();
            ArrayList vipStateList = new ArrayList();
            boolean isEnabled = gnsData.isGNSVIPEnabled();
            boolean nodeRunningState = gnsData.isGNSVIPRunning();
            if (gnsData.isGNSRunning()) {
                gnsRunningNodes.add(nodeName);
            }
            if (!gnsVIPFirstNodeFound) {
                if (nodeRunningState) {
                    Trace.out((String)("first node with running GNSVIP :" + nodeName));
                    gnsVIPFirstNodeFound = true;
                    gnsVIPRunningNodes.add(nodeName);
                    if (gnsData.isGNSRunning()) {
                        isGNSVIPRunningOnSameNode = true;
                    }
                }
            } else if (nodeRunningState) {
                Trace.out((String)("more than one node running GNS-VIP. Current:" + nodeName + "first:" + (String)gnsVIPRunningNodes.get(0)));
                gnsVIPRunningNodes.add(nodeName);
                isGNSVIPRunningOnSameNode = false;
            }
            ReportUtil.writeRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
        }
        if (!isGNSVIPRunningOnSameNode) {
            ErrorDescription errDesc;
            String msg;
            if (gnsVIPRunningNodes.size() > 0) {
                Trace.out((String)"GNS and GNS-VIP are on different machines");
                this.m_resultSet.addResult((String)gnsVIPRunningNodes.get(0), 3);
                msg = s_msgBundle.getMessage("5219", true, (Object[])new String[]{VerificationUtil.strList2List(gnsVIPRunningNodes), VerificationUtil.strList2List(gnsRunningNodes)});
                errDesc = new ErrorDescription(msg);
                this.m_resultSet.getResult((String)gnsVIPRunningNodes.get(0)).addErrorDescription(errDesc);
                return;
            }
            Trace.out((String)"No GNSVIP on any nodes");
            this.m_resultSet.addResult(this.m_nodeList, 3);
            msg = s_msgBundle.getMessage("5220", true);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return;
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5209", false));
    }

    private void performGNSResourceCheck(List<GNSData> gnsDataList) {
        String msg;
        boolean isGNSRunningOnNode = false;
        ArrayList<String> gnsRunningNodes = new ArrayList<String>();
        ReportUtil.println(s_msgBundle.getMessage("5206", false));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        for (GNSData gnsData : gnsDataList) {
            String nodeName = gnsData.getNodeName();
            boolean isEnabled = gnsData.isGNSEnabled();
            boolean nodeRunningState = gnsData.isGNSRunning();
            Trace.out((String)("results for " + nodeName));
            if (!isGNSRunningOnNode) {
                if (nodeRunningState) {
                    Trace.out((String)("first node with running GNS :" + nodeName));
                    gnsRunningNodes.add(nodeName);
                    isGNSRunningOnNode = true;
                }
            } else if (nodeRunningState) {
                Trace.out((String)("more than one node running GNS. Current:" + nodeName + "first:" + (String)gnsRunningNodes.get(0)));
                gnsRunningNodes.add(nodeName);
            }
            ReportUtil.writeRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
        }
        if (gnsRunningNodes.size() > 1) {
            Trace.out((String)"gns running on more than one node");
            this.m_resultSet.addResult(this.m_nodeList, 3);
            msg = s_msgBundle.getMessage("5210", true, (Object[])new String[]{VerificationUtil.strList2List(gnsRunningNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return;
        }
        if (gnsRunningNodes.size() == 0) {
            Trace.out((String)"No GNS on any nodes");
            this.m_resultSet.addResult(this.m_nodeList, 3);
            msg = s_msgBundle.getMessage("5211", true);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return;
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5212", false));
    }

    private boolean getGNSDataFromHelper(List<GNSData> gnsDataList) {
        String[] nodeList = null;
        String[] args = null;
        String[] env = null;
        CVUHelperExec helperExec = null;
        GNSData gnsData = null;
        try {
            nodeList = VerificationUtil.getStaticNodelist();
            args = new String[]{this.GNS_DATA_HELPER_ARG, VerificationUtil.strArr2String(nodeList, ",")};
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("Failed to get the cluster nodes: " + e.getMessage()));
            String errMsg = s_msgBundle.getMessage("9004", false);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(m_localHost, 2);
            this.m_resultSet.addErrorDescription(m_localHost, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(nodeList, 2);
            this.m_resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        String[] output = helperExec.getOutput();
        String[] gnsDetailsArr = null;
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
                String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(nodeList, 3);
                this.m_resultSet.addErrorDescription(nodeList, errorDesc);
                ReportUtil.printError(errMsg);
            } else {
                Trace.out((String)"all data collected");
                gnsDetailsArr = CVUHelperUtil.fetchOutput(output);
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            String errMsg = s_gMsgBundle.getMessage("1005", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(nodeList, 2);
            this.m_resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        Trace.out((String)("there are " + gnsDetailsArr.length + " gns info"));
        if (gnsDetailsArr != null && gnsDetailsArr.length > 0) {
            for (int i = 0; i < gnsDetailsArr.length; ++i) {
                String gnsVIPIsRunningStr;
                String gnsIsRunningStr;
                String gnsVIPIsEnabledStr;
                boolean isEnabled = false;
                boolean isRunning = false;
                boolean isGNSVIPEnabled = false;
                boolean isGNSVIPRunning = false;
                Trace.out((String)("gns detail = " + gnsDetailsArr[i]));
                String gnsLine = VerificationUtil.fetchTextByTags(gnsDetailsArr[i], null, "<GNS_DETAILS>", "</GNS_DETAILS>");
                if (gnsLine == null || gnsLine.length() == 0) {
                    Trace.out((String)"not processing as gns info");
                    continue;
                }
                String nodeName = VerificationUtil.fetchTextByTags(gnsLine, null, "<GNS_NODE>", "</GNS_NODE>");
                String gnsIsEnabledStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<GNS_ENABLE>", "</GNS_ENABLE>");
                if (gnsIsEnabledStr != null && gnsIsEnabledStr.length() != 0) {
                    isEnabled = Boolean.valueOf(gnsIsEnabledStr);
                }
                if ((gnsVIPIsEnabledStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<VIP_ENABLE>", "</VIP_ENABLE>")) != null && gnsVIPIsEnabledStr.length() != 0) {
                    isGNSVIPEnabled = Boolean.valueOf(gnsIsEnabledStr);
                }
                if ((gnsIsRunningStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<GNS_RUN>", "</GNS_RUN>")) != null && gnsIsRunningStr.length() != 0) {
                    isRunning = Boolean.valueOf(gnsIsRunningStr);
                }
                if ((gnsVIPIsRunningStr = VerificationUtil.fetchTextByTags(gnsLine, null, "<VIP_RUN>", "</VIP_RUN>")) != null && gnsVIPIsRunningStr.length() != 0) {
                    isGNSVIPRunning = Boolean.valueOf(gnsVIPIsRunningStr);
                }
                gnsData = new GNSData(nodeName, isEnabled, isRunning, isGNSVIPEnabled, isGNSVIPRunning);
                gnsDataList.add(gnsData);
            }
        }
        return gnsDataList != null && gnsDataList.size() > 0;
    }

    private void displayGNSFailureMessage(Exception e) {
        Trace.out((String)("exception : " + e.getMessage()));
        this.m_resultSet.addResult(this.m_nodeList, 3);
        String msg = s_msgBundle.getMessage("5213", true) + LSEP + e.getMessage();
        ErrorDescription errDesc = new ErrorDescription(msg);
        this.m_resultSet.addErrorDescription(errDesc);
        ReportUtil.sureprintln(msg);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4445", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5200", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }

    public void setPreCheck(boolean preCheck) {
        this.m_preCheck = preCheck;
    }

    public boolean getPreCheck() {
        return this.m_preCheck;
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

