/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGroupExistence
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1052", false);
    private String m_group;
    private Hashtable<Object, Vector<Object>> grpIdTable = new Hashtable();

    public TaskGroupExistence(String group) {
        this.m_group = group;
    }

    @Override
    public boolean performTask() {
        ErrorDescription errDesc;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet grpRsltSet = new ResultSet();
        globalExec.checkGroup(this.m_nodeList, this.m_group, grpRsltSet);
        this.m_resultSet.uploadResultSet(grpRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable ht = grpRsltSet.getResultTable();
        Enumeration<Object> e = ht.keys();
        while (e.hasMoreElements()) {
            String grpStatus;
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            result.setHasResultValues(true);
            result.setExpectedValue(Boolean.toString(true));
            if (result.getStatus() == 1) {
                comment = ReportUtil.EXIST;
                grpStatus = ReportUtil.PASSED;
                String grpID = (String)result.getResultInfoSet().elementAt(1);
                VerificationUtil.updateResultMap(this.grpIdTable, grpID, node);
                result.setExpectedValue(Boolean.toString(true));
            } else if (result.getStatus() == 3) {
                comment = ReportUtil.NOTEXIST;
                grpStatus = ReportUtil.FAILED;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7539", true, (Object[])new String[]{this.m_group, node}), s_msgBundle, "7539");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                result.setExpectedValue(Boolean.toString(false));
            } else {
                grpStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7540", true, (Object[])new String[]{node}), s_msgBundle, "7540");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, grpStatus, comment);
        }
        if (this.grpIdTable.size() > 1) {
            String errorMsg = s_msgBundle.getMessage("4020", true, (Object[])new String[]{this.m_group});
            ReportUtil.printError(errorMsg);
            errDesc = new ErrorDescription(errorMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            e = this.grpIdTable.keys();
            StringBuffer grpIdsDisplayString = new StringBuffer();
            boolean first = true;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> nodeVector = this.grpIdTable.get(key);
                String nodes = VerificationUtil.strVect2List(nodeVector);
                if (first) {
                    first = false;
                    grpIdsDisplayString.append("[");
                } else {
                    grpIdsDisplayString.append("; ");
                }
                grpIdsDisplayString.append(key + ":" + nodes);
                String errorMessage = s_msgBundle.getMessage("4021", false, (Object[])new String[]{key, nodes});
                ReportUtil.sureprintln(errorMessage);
            }
            grpIdsDisplayString.append("]");
            ErrorDescription grpIdsED = new ErrorDescription(errorMsg + " " + grpIdsDisplayString.toString(), s_msgBundle, "4020");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, grpIdsED);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0308", false, (Object[])new String[]{this.m_group}));
            return true;
        }
        if (this.isFixupReqd()) {
            this.generateFixups();
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0309", false, (Object[])new String[]{this.m_group, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void generateFixups() {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        Trace.out((String)"Generating fixups");
        FixupData fixData = null;
        String uniqueIDOfInterest = null;
        if (this.grpIdTable.size() > 0) {
            Set<Object> idSet = this.grpIdTable.keySet();
            int maxNumOfnodesWithID = 0;
            for (Object id : idSet) {
                if (this.grpIdTable.get(id).size() <= maxNumOfnodesWithID) continue;
                maxNumOfnodesWithID = this.grpIdTable.get(id).size();
                uniqueIDOfInterest = (String)id;
            }
        }
        if (null != (fixData = this.createFixupData(uniqueIDOfInterest))) {
            this.setFixupData(fixData);
        }
    }

    private FixupData createFixupData(String groupID) {
        FixupData fixGroupData = new FixupData(null);
        ArrayList<String> createGroupNodeList = new ArrayList<String>();
        ArrayList<String> updateGroupNodeList = new ArrayList<String>();
        ArrayList groupExistsNodeList = new ArrayList();
        if (VerificationUtil.isStringGood(groupID) && this.grpIdTable.size() > 0 && this.grpIdTable.containsKey(groupID)) {
            groupExistsNodeList.addAll(this.grpIdTable.get(groupID));
        }
        for (String node : this.m_nodeList) {
            if (groupExistsNodeList.contains(node)) continue;
            if (this.grpIdTable.containsValue(node)) {
                updateGroupNodeList.add(node);
                continue;
            }
            createGroupNodeList.add(node);
        }
        if (!VerificationUtil.isStringGood(groupID)) {
            GlobalExecution global = new GlobalExecution();
            ResultSet getIDResultSet = new ResultSet();
            List<String> uniqueIDList = global.getUniqueGID(createGroupNodeList.toArray(new String[0]), 1, getIDResultSet);
            if (uniqueIDList.size() > 0) {
                groupID = uniqueIDList.get(0);
            }
            if (!VerificationUtil.isStringGood(groupID)) {
                for (String node : createGroupNodeList) {
                    fixGroupData.addFixupGenerationFailedNode(node, new ErrorDescription(s_gMsgBundle.getMessage("9041", true, (Object[])new String[]{node})));
                }
                return fixGroupData;
            }
        }
        fixGroupData.addParticipatingNodes(createGroupNodeList);
        fixGroupData.addParticipatingNodes(updateGroupNodeList);
        fixGroupData.addFixupInstruction("GROUP", this.m_group);
        fixGroupData.addFixupInstruction("GID", groupID);
        String message = "Created fixup with \n Group name (" + this.m_group + ")" + "\n Group ID (" + groupID + ")" + (createGroupNodeList.size() > 0 ? "\n to create the group on nodes " + createGroupNodeList : "") + (updateGroupNodeList.size() > 0 ? "\n to update the group on nodes " + updateGroupNodeList : "");
        Trace.out((String)message);
        VerificationLogData.logInfo(message);
        return fixGroupData;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4409", false) + ": " + this.m_group;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4459", false, (Object[])new String[]{this.m_group});
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet grpRsltSet = new ResultSet();
        globalExec.checkGroup(this.m_nodeList, this.m_group, grpRsltSet);
        Hashtable ht = grpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                String grpID = (String)result.getResultInfoSet().elementAt(1);
                result.getResultInfoSet().add(0, this.m_group + "(" + grpID + ")");
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NOTEXIST);
            result.setStatus(1);
        }
        return grpRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9972", false, (Object[])new String[]{this.m_group});
    }
}

