/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.FixupData;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.sTaskGroupMembership;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGroupMembership
extends PeerCompatibleTask {
    private String m_user;
    private String m_group;
    private boolean m_primary;
    private sTaskGroupMembership s_sTaskGroupMembership;

    public TaskGroupMembership(String user, String group) {
        this(user, group, false);
    }

    public TaskGroupMembership(String user, String group, boolean primary) {
        this.m_user = user;
        this.m_group = group;
        this.m_primary = primary;
        this.s_sTaskGroupMembership = new sTaskGroupMembership();
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        boolean testFailed = false;
        globalExec.checkUsrInGrp(this.m_nodeList, this.m_user, this.m_group, this.m_primary ? 1 : 3, usrGrpRsltSet);
        this.m_resultSet.uploadResultSet(usrGrpRsltSet);
        if (!this.m_primary) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4302", false, (Object[])new String[]{this.m_user, this.m_group}));
        } else {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4022", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
        }
        if (this.m_primary) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8013", false), s_msgBundle.getMessage("8014", false), s_msgBundle.getMessage("8015", false), s_msgBundle.getMessage("8016", false), s_msgBundle.getMessage("8018", false));
        } else {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8013", false), s_msgBundle.getMessage("8014", false), s_msgBundle.getMessage("8015", false), s_msgBundle.getMessage("8018", false));
        }
        Hashtable ht = usrGrpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String nstatus;
            String primeG;
            String uInG;
            String grp;
            String usr;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                usr = ReportUtil.YES;
                grp = ReportUtil.YES;
                uInG = ReportUtil.YES;
                primeG = ReportUtil.YES;
                nstatus = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                boolean primaryGrp;
                boolean usrExists = ((String)result.getResultInfoSet().get(0)).equals(this.m_user);
                boolean usrInGrp = ((String)result.getResultInfoSet().get(1)).equals(this.m_group);
                boolean bl = primaryGrp = ((String)result.getResultInfoSet().get(2)).length() != 0;
                if (!usrExists) {
                    usr = ReportUtil.NO;
                    grp = ReportUtil.NOT_APPLICABLE;
                    uInG = ReportUtil.NOT_APPLICABLE;
                    primeG = ReportUtil.NOT_APPLICABLE;
                    nstatus = ReportUtil.FAILED;
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7537", true, (Object[])new String[]{this.m_user, node}), s_msgBundle, "7537");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                } else if (!usrInGrp) {
                    usr = ReportUtil.YES;
                    grp = ReportUtil.YES;
                    uInG = ReportUtil.NO;
                    primeG = ReportUtil.NOT_APPLICABLE;
                    nstatus = ReportUtil.FAILED;
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7566", false, (Object[])new String[]{this.m_user, this.m_group, node}), s_msgBundle, "7566");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                } else {
                    usr = ReportUtil.YES;
                    grp = ReportUtil.YES;
                    uInG = ReportUtil.YES;
                    nstatus = ReportUtil.PASSED;
                    primeG = ReportUtil.YES;
                    if (this.m_primary && !primaryGrp) {
                        primeG = ReportUtil.NO;
                        nstatus = ReportUtil.FAILED;
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7567", false, (Object[])new String[]{this.m_group, this.m_user, node}), s_msgBundle, "7567");
                        this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    } else {
                        this.m_resultSet.addResult(node, 1);
                    }
                }
            } else {
                usr = ReportUtil.UNKNOWN;
                grp = ReportUtil.UNKNOWN;
                uInG = ReportUtil.NOT_APPLICABLE;
                primeG = ReportUtil.NOT_APPLICABLE;
                nstatus = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7568", false, (Object[])new String[]{this.m_user, this.m_group, node}), s_msgBundle, "7568");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            if (this.m_primary) {
                ReportUtil.writeRecord(node, usr, grp, uInG, primeG, nstatus);
            } else {
                ReportUtil.writeRecord(node, usr, grp, uInG, nstatus);
            }
            if (nstatus.equalsIgnoreCase(ReportUtil.PASSED)) continue;
            testFailed = true;
        }
        if (testFailed) {
            if (this.isFixupReqd()) {
                this.generateFixups();
            }
            if (!this.m_primary) {
                ReportUtil.printResult(s_msgBundle.getMessage("4304", false, (Object[])new String[]{this.m_user, this.m_group}));
                this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0321", false, (Object[])new String[]{this.m_user, this.m_group, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("4024", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
                this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0323", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
            }
            ReportUtil.printErrorNodes(this.m_resultSet);
            return false;
        }
        if (!this.m_primary) {
            ReportUtil.printResult(s_msgBundle.getMessage("4303", false, (Object[])new String[]{this.m_user, this.m_group}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0320", false, (Object[])new String[]{this.m_user, this.m_group}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4023", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0322", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        }
        String strCurrentGrp = VerificationUtil.getCurrentGroup();
        if (this.m_primary && strCurrentGrp != null && !strCurrentGrp.equalsIgnoreCase(this.m_group)) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4309", false, (Object[])new String[]{strCurrentGrp, this.m_group, this.m_user}));
        }
        return true;
    }

    private void generateFixups() {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        FixupData fixGrpMemShpData = new FixupData(null);
        HashMap<String, ErrorDescription> fixupGenFailedNodeListWithError = new HashMap<String, ErrorDescription>();
        Hashtable ht = this.m_resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() != 3) continue;
            NonLocalEntity nonLocal = this.isUserAndGroupLocal(node);
            Trace.out((String)("Non locality says " + nonLocal.toString()));
            if (nonLocal == NonLocalEntity.NONE) {
                Trace.out((String)("Generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'"));
                VerificationLogData.logInfo("Generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'");
                fixGrpMemShpData.addParticipatingNode(node);
                fixGrpMemShpData.setExpectedValue(node, this.m_primary ? "PRIMARY_GROUP" : "SUPPLEMENTARY_GROUP");
                continue;
            }
            Trace.out((String)("User OR Group is not local and hence not generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'"));
            VerificationLogData.logInfo("User OR Group is not local and hence not generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'");
            ErrorDescription fixupGenFailedErrorDesc = null;
            fixupGenFailedErrorDesc = nonLocal == NonLocalEntity.USER ? new ErrorDescription(s_msgBundle.getMessage("7729", true, (Object[])new String[]{this.m_user, this.m_group, node})) : new ErrorDescription(s_msgBundle.getMessage("7730", true, (Object[])new String[]{this.m_user, this.m_group, node}));
            fixupGenFailedNodeListWithError.put(node, fixupGenFailedErrorDesc);
        }
        if (fixupGenFailedNodeListWithError.size() == 0) {
            Trace.out((String)("Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ")"));
            VerificationLogData.logInfo("Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ")");
            fixGrpMemShpData.addFixupInstruction("USER", this.m_user);
            fixGrpMemShpData.addFixupInstruction("GROUP", this.m_group);
        } else {
            fixGrpMemShpData = new FixupData(null);
            for (String node : fixupGenFailedNodeListWithError.keySet()) {
                fixGrpMemShpData.addFixupGenerationFailedNode(node, (ErrorDescription)fixupGenFailedNodeListWithError.get(node));
            }
            Trace.out((String)("Not Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") as either" + " the user or the group is not local on nodes " + VerificationUtil.strCollection2String(fixupGenFailedNodeListWithError.keySet())));
            VerificationLogData.logInfo("Not Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") as either" + " the user or the group is not local on nodes." + VerificationUtil.strCollection2String(fixupGenFailedNodeListWithError.keySet()));
        }
        this.setFixupData(fixGrpMemShpData);
    }

    private NonLocalEntity isUserAndGroupLocal(String node) {
        NonLocalEntity noLo = NonLocalEntity.USER;
        do {
            ResultSet isLocalRsltSet = new ResultSet();
            VerificationCommand[] vfyCmd = new VerificationCommand[1];
            String checkCommand = noLo == NonLocalEntity.USER ? this.s_sTaskGroupMembership.getLocalCheckCommand("user", this.m_user) : this.s_sTaskGroupMembership.getLocalCheckCommand("group", this.m_group);
            if (checkCommand == null) {
                Trace.out((String)"command is empty");
                return noLo;
            }
            String[] arg = new String[]{"-rungencmd", checkCommand};
            String[] env = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            vfyCmd[0] = new VerificationCommand(node, arg, env);
            Trace.out((String)("executing " + checkCommand));
            new GlobalHandler().submit((Command[])vfyCmd, 0, isLocalRsltSet);
            if (vfyCmd[0].getResult().getStatus() != 1) {
                Trace.out((String)("existance check failed on " + node + " with " + vfyCmd[0].getResult().getStatus()));
                return noLo;
            }
            if (vfyCmd[0].getVfyCode() != 0) {
                Trace.out((String)"User/group not found");
                return noLo;
            }
            switch (noLo) {
                case USER: {
                    noLo = NonLocalEntity.GROUP;
                    break;
                }
                default: {
                    noLo = NonLocalEntity.NONE;
                }
            }
        } while (noLo != NonLocalEntity.NONE);
        return noLo;
    }

    @Override
    public String getDefaultElementName() {
        StringBuilder elementName = new StringBuilder();
        elementName.append(s_msgBundle.getMessage("4410", false) + ": " + this.m_group);
        if (this.m_primary) {
            elementName.append("(" + s_msgBundle.getMessage("8500", false) + ")");
        }
        return elementName.toString();
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_primary) {
            return s_msgBundle.getMessage("4461", false, (Object[])new String[]{this.m_user, this.m_group});
        }
        return s_msgBundle.getMessage("4460", false, (Object[])new String[]{this.m_user, this.m_group});
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        boolean testFailed = false;
        globalExec.checkUsrInGrp(this.m_nodeList, this.m_user, this.m_group, this.m_primary ? 1 : 3, usrGrpRsltSet);
        Hashtable ht = usrGrpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                result.getResultInfoSet().add(0, ReportUtil.YES);
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NO);
            result.setStatus(1);
        }
        return usrGrpRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        String group = this.m_group;
        if (this.m_primary) {
            group = group + " (" + s_msgBundle.getMessage("8500", false) + ")";
        }
        return s_msgBundle.getMessage("9973", false, (Object[])new String[]{this.m_user, group});
    }

    private static enum NonLocalEntity {
        USER,
        GROUP,
        NONE;

    }
}

