/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.command.MulticastCommand;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskMulticastCheck
extends Task
implements VerificationAPIConstants {
    private static final String[] MULTICAST_GROUPS = new String[]{"224.0.0.251", "230.0.1.0"};
    private static final int PORT = 42414;
    private String[] m_subnetList = null;
    private int[] m_subnetTypeList = null;
    private Map<String, String> m_resultMap = new HashMap<String, String>();

    public TaskMulticastCheck(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskMulticastCheck(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskMulticastCheck(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        boolean haCheck = true;
        HashSet<String> badNodes = new HashSet<String>();
        HashSet badNodes2 = new HashSet();
        Trace.out((String)"START");
        String msg = s_gMsgBundle.getMessage("11132", false);
        ReportUtil.sureprintln(msg);
        ReportUtil.sureblankln();
        Collection<NodeInfo> nodeInfoList = this.getNodeInfoList();
        if (nodeInfoList == null) {
            return false;
        }
        Collection subnets = Subnet.classifyToSubnets(nodeInfoList);
        Vector<Subnet> privSubnets = new Vector<Subnet>();
        Vector<Subnet> nonPrivSubnets = new Vector<Subnet>();
        for (Subnet subnet : subnets) {
            boolean isPrivate = false;
            if (IPAddressUtil.isIPv6AddressString((String)subnet.getSubnet())) continue;
            if (this.m_subnetList != null) {
                int i = 0;
                for (i = 0; i < this.m_subnetList.length; ++i) {
                    if (!this.m_subnetList[i].equals(subnet.getSubnet())) continue;
                    isPrivate = this.m_subnetTypeList[i] == 1;
                    break;
                }
                if (i == this.m_subnetList.length) continue;
            }
            if (isPrivate) {
                privSubnets.add(subnet);
                continue;
            }
            nonPrivSubnets.add(subnet);
        }
        Trace.out((String)"Performing multicast connectivity on private subnets");
        for (Subnet subnet : privSubnets) {
            badNodes.clear();
            if (!this.performMulticastCheck(subnet, true, badNodes)) {
                Trace.out((String)("multicast on subnet " + subnet + " is failed. trying to perform broadcast check  on the subent"));
                badNodes2.clear();
                if (!this.performBroadcastCheck(subnet, badNodes2)) {
                    badNodes.addAll(badNodes2);
                    this.m_resultSet.addResult(badNodes.toArray(new String[0]), 3);
                    haCheck = false;
                }
            }
            if (!Utils.isDevelopmentEnv() || !"TRUE".equals(VerificationUtil.getVariableValue("_FORCE_BROADCAST_"))) continue;
            Trace.out((String)"******THIS BLOCK EXECUTES ONLY by srg and lrgs but not in shiphome lrgs and customer env*******");
            badNodes2.clear();
            if (this.performBroadcastCheck(subnet, badNodes2)) continue;
            badNodes.addAll(badNodes2);
            this.m_resultSet.addResult(badNodes.toArray(new String[0]), 3);
            haCheck = false;
        }
        if (!haCheck) {
            return false;
        }
        boolean mDNSCheck = false;
        Trace.out((String)("check if multicast check is passed on any of the private subnets on mulicast group " + MULTICAST_GROUPS[0]));
        for (String strSubnet : this.m_resultMap.keySet()) {
            if (!MULTICAST_GROUPS[0].equals(this.m_resultMap.get(strSubnet))) continue;
            Trace.out((String)("multicast check passed on private subnet " + strSubnet + " on multicast group " + MULTICAST_GROUPS[0]));
            mDNSCheck = true;
            break;
        }
        if (!mDNSCheck) {
            Trace.out((String)"Checking multicast connectivity on other networks");
            badNodes.clear();
            for (Subnet subnet : nonPrivSubnets) {
                if (!this.performMulticastCheck(subnet, false, badNodes)) continue;
                mDNSCheck = true;
                break;
            }
            if (!mDNSCheck) {
                this.m_resultSet.addResult(badNodes.toArray(new String[0]), 3);
            }
        }
        if (haCheck && mDNSCheck) {
            msg = s_gMsgBundle.getMessage("11136", false);
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        return false;
    }

    private boolean performMulticastCheck(Subnet subnet, boolean isPrivate, Set<String> badNodes) {
        boolean retVal = true;
        HashSet badNodes1 = new HashSet();
        HashSet badNodes2 = new HashSet();
        retVal = this.performMulticastCheck(subnet, MULTICAST_GROUPS[0], badNodes1);
        if (retVal) {
            this.m_resultMap.put(subnet.getSubnet(), MULTICAST_GROUPS[0]);
        } else if (isPrivate && (retVal = this.performMulticastCheck(subnet, MULTICAST_GROUPS[1], badNodes2))) {
            this.m_resultMap.put(subnet.getSubnet(), MULTICAST_GROUPS[1]);
        }
        if (!retVal) {
            badNodes.addAll(badNodes1);
            badNodes.addAll(badNodes2);
        }
        return retVal;
    }

    private boolean performMulticastCheck(Subnet subnet, String mcGroup, Set badNodes) {
        boolean retVal = true;
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11133", false, (Object[])new String[]{subnet.getSubnet(), mcGroup}));
        Trace.out((String)("Checking subnet " + subnet.getSubnet() + " for multicast communication..."));
        ResultSet mcResultSet = new ResultSet();
        MulticastServer mcServer = new MulticastServer(mcGroup, 42414, subnet, mcResultSet);
        Trace.out((String)("Trying with multicast group " + mcGroup));
        ResultSet srvRs = new ResultSet();
        Trace.out((String)"starting mcServer");
        mcServer.startServer(srvRs);
        if (srvRs.anyFailure()) {
            Trace.out((String)"mcServer.startServer() failed");
            this.printAndUploadRSErrors(srvRs);
            Trace.out((String)"stoping mcServer");
            ResultSet rs = new ResultSet();
            mcServer.stopServer(rs);
            if (rs.anyFailure()) {
                this.printAndUploadRSErrors(rs);
            }
            return false;
        }
        Trace.out((String)("multicast server started with mcGroup=" + mcGroup));
        for (Object objIfInfo : subnet.getInterfaces()) {
            InterfaceInfo ifInfo = (InterfaceInfo)objIfInfo;
            Trace.out((String)("Reachability of multicast packets via IP " + ifInfo.getIP() + "and Interface " + ifInfo.getName() + " from node " + ifInfo.getNode()));
            ResultSet rs = new ResultSet();
            Collection notReachIfInfos = mcServer.getNotReachableInterfaces(ifInfo, rs);
            if (rs.allSuccess()) {
                if (notReachIfInfos.size() == 0) {
                    Trace.out((String)("Reachability of mutlicast packetets via IP " + ifInfo.getIP() + " from node " + ifInfo.getNode() + " passed."));
                    continue;
                }
                Trace.out((String)("Reachability of mutlicast packetets via IP " + ifInfo.getIP() + " from node " + ifInfo.getNode() + " failed."));
                for (InterfaceInfo notReachIfInfo : notReachIfInfos) {
                    String node1 = ifInfo.getNode();
                    String if1 = ifInfo.getIP();
                    String node2 = notReachIfInfo.getNode();
                    String if2 = notReachIfInfo.getIP();
                    Trace.out((String)("No response for multicast packets send from (" + if1 + "," + node1 + ") to (" + if2 + "," + node2 + ")"));
                    String errMsg = s_gMsgBundle.getMessage("11138", true, (Object[])new String[]{if1, node1, if2, node2, mcGroup});
                    ReportUtil.sureprintln(errMsg);
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(node1, errDesc);
                    this.m_resultSet.addErrorDescription(node2, errDesc);
                    badNodes.add(node1);
                    badNodes.add(node2);
                    retVal = false;
                }
                continue;
            }
            String errMsg = s_gMsgBundle.getMessage("11137", true);
            for (VerificationError vfe : rs.getErrors()) {
                errMsg = errMsg + LSEP + vfe.getErrorMessage();
            }
            ReportUtil.sureprintln(errMsg);
            Trace.out((String)("Following error occured while checking multicast connectivity " + LSEP + errMsg));
            this.m_resultSet.addResult(ifInfo.getNode(), 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(ifInfo.getNode(), errDesc);
            retVal = false;
        }
        if (retVal) {
            String msg = s_gMsgBundle.getMessage("11135", false, (Object[])new String[]{subnet.getSubnet(), mcGroup});
            ReportUtil.sureprintln(msg);
            ReportUtil.sureblankln();
        }
        ResultSet rs = new ResultSet();
        Trace.out((String)"stoping mcServer");
        mcServer.stopServer(rs);
        if (rs.anyFailure()) {
            this.printAndUploadRSErrors(rs);
            retVal = false;
        }
        return retVal;
    }

    boolean performBroadcastCheck(Subnet subnet, Set badNodes) {
        String msg;
        boolean retVal = true;
        String bcAddr = "255.255.255.255";
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11351", false, (Object[])new String[]{subnet.getSubnet(), bcAddr}));
        Trace.out((String)("Checking subnet " + subnet.getSubnet() + " for broadcast communication..."));
        ResultSet mcResultSet = new ResultSet();
        MulticastServer bcServer = new MulticastServer(false, bcAddr, 42414, subnet, mcResultSet);
        ResultSet srvRs = new ResultSet();
        Trace.out((String)"starting bcServer");
        bcServer.startServer(srvRs);
        if (srvRs.anyFailure()) {
            Trace.out((String)"bcServer.startServer() failed");
            this.printAndUploadRSErrors(srvRs);
            Trace.out((String)"stoping bcServer");
            ResultSet rs = new ResultSet();
            bcServer.stopServer(rs);
            if (rs.anyFailure()) {
                this.printAndUploadRSErrors(rs);
            }
            return false;
        }
        Trace.out((String)("broadcast server started with bcAddr =" + bcAddr));
        boolean bFailedAllover = true;
        Vector<String> ifFalues = new Vector<String>();
        for (Object objIfInfo : subnet.getInterfaces()) {
            InterfaceInfo ifInfo = (InterfaceInfo)objIfInfo;
            Trace.out((String)("Reachability of broadcast packets via IP " + ifInfo.getIP() + "and Interface " + ifInfo.getName() + " from node " + ifInfo.getNode()));
            ResultSet rs = new ResultSet();
            Collection notReachIfInfos = bcServer.getNotReachableInterfaces(ifInfo, rs);
            if (rs.allSuccess()) {
                if (bFailedAllover && notReachIfInfos.size() != subnet.getInterfaces().size()) {
                    bFailedAllover = false;
                    for (String errMsg : ifFalues) {
                        ReportUtil.sureprintln(errMsg);
                    }
                    ifFalues.clear();
                }
                if (notReachIfInfos.size() == 0) {
                    Trace.out((String)("Reachability of broadcast packetets via IP " + ifInfo.getIP() + " from node " + ifInfo.getNode() + " passed."));
                    continue;
                }
                Trace.out((String)("Reachability of broadcast packetets via IP " + ifInfo.getIP() + " from node " + ifInfo.getNode() + " failed."));
                for (InterfaceInfo notReachIfInfo : notReachIfInfos) {
                    String node1 = ifInfo.getNode();
                    String if1 = ifInfo.getIP();
                    String node2 = notReachIfInfo.getNode();
                    String if2 = notReachIfInfo.getIP();
                    Trace.out((String)("No response for broadcast packets send from (" + if1 + "," + node1 + ") to (" + if2 + "," + node2 + ")"));
                    String errMsg = s_gMsgBundle.getMessage("11352", true, (Object[])new String[]{if1, node1, if2, node2, bcAddr});
                    if (bFailedAllover) {
                        ifFalues.add(errMsg);
                    } else {
                        ReportUtil.sureprintln(errMsg);
                    }
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(node1, errDesc);
                    this.m_resultSet.addErrorDescription(node2, errDesc);
                    badNodes.add(node1);
                    badNodes.add(node2);
                    retVal = false;
                }
                continue;
            }
            String errMsg = s_gMsgBundle.getMessage("11356", true);
            for (VerificationError vfe : rs.getErrors()) {
                errMsg = errMsg + LSEP + vfe.getErrorMessage();
            }
            ReportUtil.sureprintln(errMsg);
            Trace.out((String)("Following error occured while checking multicast connectivity " + LSEP + errMsg));
            this.m_resultSet.addResult(ifInfo.getNode(), 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(ifInfo.getNode(), errDesc);
            retVal = false;
        }
        if (retVal) {
            msg = s_gMsgBundle.getMessage("11354", false, (Object[])new String[]{subnet.getSubnet(), bcAddr});
            ReportUtil.sureprintln(msg);
            ReportUtil.sureblankln();
        } else if (bFailedAllover) {
            msg = s_gMsgBundle.getMessage("11353", false, (Object[])new String[]{subnet.getSubnet(), bcAddr});
            ReportUtil.sureprintln(msg);
            ReportUtil.sureblankln();
        }
        ResultSet rs = new ResultSet();
        Trace.out((String)"stoping bcServer");
        bcServer.stopServer(rs);
        if (rs.anyFailure()) {
            this.printAndUploadRSErrors(rs);
            retVal = false;
        }
        return retVal;
    }

    private void printAndUploadRSErrors(ResultSet rs) {
        String errMsg = s_gMsgBundle.getMessage("11137", true);
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        this.m_resultSet.addErrorDescription(rs.getFailureNodes(), errDesc);
        this.m_resultSet.uploadResultSet(rs);
        this.m_resultSet.addResult(rs.getFailureNodes(), 2);
        for (VerificationError vfe : rs.getErrors()) {
            errMsg = errMsg + LSEP + vfe.getErrorMessage();
        }
        ReportUtil.sureprintln(errMsg);
    }

    private Collection<NodeInfo> getNodeInfoList() {
        Vector<NodeInfo> nodeInfoList = new Vector<NodeInfo>();
        try {
            new VerifyNetwork().getInterfaceInfo(this.m_nodeList, nodeInfoList);
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            ReportUtil.printError(ne.getMessage());
            return null;
        }
        catch (MultiNodeException mne) {
            Vector okNodes = this.reportMultiNodeException(mne, this.m_nodeList);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(okNodes);
        }
        return nodeInfoList;
    }

    private Vector reportMultiNodeException(MultiNodeException mne, String[] nodeList) {
        Vector<String> goodNodes = new Vector<String>();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            Collection throwables = mne.getThrowables(this.m_nodeList[i]);
            if (null == throwables) {
                goodNodes.add(this.m_nodeList[i]);
                continue;
            }
            this.m_resultSet.addResult(this.m_nodeList[i], 2);
            String errMsg = s_msgBundle.getMessage("4087", false);
            String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{this.m_nodeList[i]});
            String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{this.m_nodeList[i]});
            this.m_resultSet.getResult(this.m_nodeList[i]).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            Trace.out((String)errMsg);
            for (Throwable t : throwables) {
                this.m_resultSet.addErrorDescription(new ErrorDescription(t.getMessage()));
                ReportUtil.printError(t.getMessage());
            }
        }
        return goodNodes;
    }

    public void setSubnetList(String[] subnetList) {
        this.m_subnetList = subnetList;
    }

    public void setSubnetTypeList(int[] subnetTypeList) {
        this.m_subnetTypeList = subnetTypeList;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11131", false);
    }

    @Override
    public String getTaskID() {
        return "MULTICAST";
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11130", false);
    }

    private class MulticastServer {
        String m_mcGroup;
        int m_port;
        Subnet m_subnet = null;
        int[] m_pids;
        boolean m_isMulticast = true;

        MulticastServer(String mcGroup, int port, Subnet subnet, ResultSet resultSet) {
            this.m_mcGroup = mcGroup;
            this.m_port = port;
            this.m_subnet = subnet;
            this.m_pids = new int[0];
        }

        MulticastServer(boolean isMulticast, String mcGroup, int port, Subnet subnet, ResultSet resultSet) {
            this.m_mcGroup = mcGroup;
            this.m_port = port;
            this.m_subnet = subnet;
            this.m_pids = new int[0];
            this.m_isMulticast = false;
        }

        private void startServer(ResultSet rs) {
            Collection ifInfos = this.m_subnet.getInterfaces();
            MulticastCommand[] mcCmds = new MulticastCommand[ifInfos.size()];
            int i = 0;
            for (InterfaceInfo ifInfo : ifInfos) {
                mcCmds[i] = this.m_isMulticast ? MulticastCommand.getListnerMulticastCommand(ifInfo.getNode(), ifInfo.getIP(), this.m_mcGroup, this.m_port) : MulticastCommand.getListnerBroadcastCommand(ifInfo.getNode(), ifInfo.getIP(), this.m_mcGroup, this.m_port);
                ++i;
            }
            new GlobalHandler().submit((Command[])mcCmds, 0, rs);
            this.m_pids = new int[mcCmds.length];
            i = 0;
            for (MulticastCommand cmd : mcCmds) {
                this.m_pids[i] = cmd.getPid();
                ++i;
            }
        }

        private void stopServer(ResultSet rs) {
            Collection ifInfos = this.m_subnet.getInterfaces();
            MulticastCommand[] mcCmds = new MulticastCommand[ifInfos.size()];
            int i = 0;
            for (InterfaceInfo ifInfo : ifInfos) {
                mcCmds[i] = MulticastCommand.getKillMulticastCommand(ifInfo.getNode(), this.m_pids[i]);
                ++i;
            }
            new GlobalHandler().submit((Command[])mcCmds, 0, rs);
        }

        private Collection<InterfaceInfo> getNotReachableInterfaces(InterfaceInfo ifInfo, ResultSet rs) {
            MulticastCommand[] mcCmds = null;
            mcCmds = this.m_isMulticast ? new MulticastCommand[]{MulticastCommand.getGroupIpMulticastCommand(ifInfo.getNode(), ifInfo.getIP(), this.m_mcGroup, this.m_port)} : new MulticastCommand[]{MulticastCommand.getGroupIpBroadcastCommand(ifInfo.getNode(), ifInfo.getIP(), this.m_mcGroup, this.m_port)};
            new GlobalHandler().submit((Command[])mcCmds, 0, rs);
            List<String> reachableIPs = Arrays.asList(mcCmds[0].getGroupIps());
            Vector<InterfaceInfo> notReachableIfInfos = new Vector<InterfaceInfo>();
            Collection ifInfos = this.m_subnet.getInterfaces();
            for (InterfaceInfo ifInfo1 : ifInfos) {
                if (reachableIPs.contains(ifInfo1.getIP())) continue;
                Trace.out((String)("adding [" + ifInfo1.getNode() + ":" + ifInfo1.getIP() + "] to not reachable notReachableIfInfos"));
                notReachableIfInfos.add(ifInfo1);
            }
            return notReachableIfInfos;
        }
    }
}

