/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskDaemonLiveliness;
import oracle.ops.verification.framework.engine.task.TimeServer;
import oracle.ops.verification.framework.engine.task.TimeServerNode;
import oracle.ops.verification.framework.engine.task.sTaskNTP;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNTP
extends Task {
    boolean m_mute = false;
    boolean m_preCheck = false;
    sTaskNTP s_sTaskNTP = new sTaskNTP(this);
    String m_requestedRelease = null;

    public TaskNTP(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNTP(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNTP(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9601", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9501", false);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing network time synchronization verification");
            Trace.out((String)("Performing TaskNTP on nodes (count = " + this.m_nodeList.length + ") = " + VerificationUtil.strArr2List(this.m_nodeList)));
        }
        this.performNTPChecks();
        if (this.m_resultSet.allSuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ResultSet shows alll Success");
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("5400", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"ResultSet shows at least one failure");
        }
        if (!this.m_mute) {
            ReportUtil.printResult(s_msgBundle.getMessage("5401", false));
        }
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        return false;
    }

    public void performNTPChecks() {
        String errMsg;
        NativeSystem nativeSystem;
        boolean isUnix;
        boolean confFileExistStatus = false;
        Vector<String> confokVec = new Vector<String>();
        Vector<String> dmnOkVec = new Vector<String>();
        ResultSet locrs = new ResultSet();
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5422", false));
        }
        if (isUnix = (nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            confFileExistStatus = this.doConfigFileCheck(locrs, this.m_nodeList, confokVec);
            Trace.out((String)("confFileExistStatus=" + confFileExistStatus + "; confokVec.size()=" + confokVec.size() + "; confokVec:: " + VerificationUtil.strVect2List(confokVec)));
            if (!confFileExistStatus) {
                if (this.m_preCheck) {
                    Trace.out((String)"PreCheck flag set. Setting overall status to SUCCESSFUL");
                    if (!this.m_mute) {
                        ReportUtil.println(s_msgBundle.getMessage("5428", false));
                    }
                    this.m_resultSet.addResult(this.m_nodeList, 1);
                } else {
                    this.m_resultSet.addResult(this.m_nodeList, 4);
                    errMsg = s_msgBundle.getMessage("5414", true);
                    if (!this.m_mute) {
                        ReportUtil.sureprintln(errMsg);
                    }
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                }
            } else {
                this.m_resultSet.uploadResultSet(locrs);
            }
            locrs.clear();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Return value from doConfigFileCheck() is " + confFileExistStatus));
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Proceeding with Daemon check...");
        }
        boolean ret = this.doDaemonCheck(locrs, this.m_nodeList, dmnOkVec);
        Trace.out((String)("ret from doDaemonCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        if (!ret) {
            if (this.m_preCheck) {
                if (!locrs.anySuccess() && !confFileExistStatus) {
                    Trace.out((String)"PreCheck flag set. No daemon is running. Setting overall status to SUCCESSFUL");
                    this.m_resultSet.addResult(this.m_nodeList, 1);
                    return;
                }
                if (!locrs.anySuccess()) {
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    errMsg = s_msgBundle.getMessage("5507", true) + LSEP + VerificationUtil.strVect2List(confokVec);
                    if (!this.m_mute) {
                        ReportUtil.sureprintln(errMsg);
                    }
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    return;
                }
                Trace.out((String)"PreCheck...At least one daemon is running. Validate the existence of configuration files");
                if (dmnOkVec.size() != confokVec.size() || !dmnOkVec.containsAll(confokVec)) {
                    Vector<String> dmnOnlyVec = new Vector<String>();
                    for (String dmnNode : dmnOkVec) {
                        if (confokVec.contains(dmnNode)) continue;
                        dmnOnlyVec.add(dmnNode);
                    }
                    if (dmnOnlyVec.size() != 0) {
                        String[] dmnOnlyArr = dmnOnlyVec.toArray(new String[0]);
                        this.m_resultSet.addResult(dmnOnlyArr, 3);
                        errMsg = s_gMsgBundle.getMessage("1018", true, (Object[])new String[]{VerificationUtil.strVect2List(dmnOnlyVec)});
                        if (!this.m_mute) {
                            ReportUtil.sureprintln(errMsg);
                        }
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    } else {
                        Trace.out((String)"all nodes on which daemon exists conf also exists");
                    }
                    Vector<String> confOnlyVec = new Vector<String>();
                    for (String confNode : confokVec) {
                        if (dmnOkVec.contains(confNode)) continue;
                        confOnlyVec.add(confNode);
                    }
                    if (confOnlyVec.size() != 0) {
                        String[] confOnlyArr = confOnlyVec.toArray(new String[0]);
                        this.m_resultSet.addResult(confOnlyArr, 3);
                        errMsg = s_gMsgBundle.getMessage("1017", true, (Object[])new String[]{VerificationUtil.strVect2List(confOnlyVec)});
                        if (!this.m_mute) {
                            ReportUtil.sureprintln(errMsg);
                        }
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    } else {
                        Trace.out((String)"all nodes on which conf exists daemon exists");
                    }
                    return;
                }
                Trace.out((String)"PreCheck...At least one daemon is running. Existence of configuration files has been validated.");
            } else {
                if (!locrs.anySuccess()) {
                    Trace.out((String)"PostCheck set. No daemon is running. Setting overall status to VERIFICATION_FAILED.");
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    errMsg = s_msgBundle.getMessage("5415", true);
                    if (!this.m_mute) {
                        ReportUtil.sureprintln(errMsg);
                    }
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    return;
                }
                Trace.out((String)"PostCheck...At least one daemon is running. Proceed with further checks.");
            }
        } else {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5491", false));
            }
            Trace.out((String)"Daemon is running on all the nodes.");
        }
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"NTP Daemon or Service is alive. Proceeding with further checks.");
        }
        if (!isUnix) {
            return;
        }
        String version = null;
        if (this.m_preCheck) {
            version = this.m_requestedRelease;
        }
        if (!VerificationUtil.isStringGood(version)) {
            String localNode = null;
            try {
                localNode = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException nlnfe) {
                Trace.out((String)"Caught NodelistNotFoundException - Failed to determine the local node name");
            }
            if (VerificationUtil.isStringGood(localNode)) {
                version = VerificationUtil.getCRSReleaseVersion(localNode);
            }
        }
        if (VerificationUtil.isStringGood(version) && !VerificationUtil.isVersionPost(version, "11.2") && !(ret = this.performSlewingCheck(locrs, dmnOkVec))) {
            return;
        }
        ret = this.doPortOpenCheck(locrs, dmnOkVec);
        Trace.out((String)("ret from doPortOpenCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5486", true));
            }
            return;
        }
        if (!this.s_sTaskNTP.isNTPQSupported()) {
            return;
        }
        Hashtable<String, TimeServer> tsTable = new Hashtable<String, TimeServer>();
        ret = this.doTimeServerCheck(locrs, tsTable, dmnOkVec);
        Trace.out((String)("ret from doTimeServerCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            errMsg = s_msgBundle.getMessage("5416", true);
            if (!this.m_mute) {
                ReportUtil.sureprintln(errMsg);
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            return;
        }
        ret = this.doOffsetCheck(tsTable, dmnOkVec);
        Trace.out((String)("ret from doOffsetCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
    }

    private boolean performSlewingCheck(ResultSet locrs, Vector<String> dmnOkVec) {
        boolean ret = this.doSlewingCheck(locrs, dmnOkVec);
        Trace.out((String)("ret from doSlewingCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            String errMsg = s_msgBundle.getMessage("5436", true, (Object[])new String[]{this.s_sTaskNTP.getNTPDSlewingOption()});
            if (!this.m_mute) {
                ReportUtil.sureprintln(errMsg);
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            return false;
        }
        ret = this.doSlewingSysConfigCheck(locrs, dmnOkVec);
        Trace.out((String)("ret from doSlewingSysConfigCheck=" + ret + "; dmnOkVec.size()=" + dmnOkVec.size() + "; dmnOkVec:: " + VerificationUtil.strVect2List(dmnOkVec)));
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5470", true, (Object[])new String[]{this.s_sTaskNTP.getNTPDBootConfigFile(), this.s_sTaskNTP.getNTPDSlewingOption()}));
            }
            return false;
        }
        return true;
    }

    private boolean doConfigFileCheck(ResultSet locrs, String[] nList, Vector<String> confokVec) {
        boolean ctssalternate;
        Vector<String> noConfMsgVec = new Vector<String>();
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5420", false));
        }
        String fileLoc = this.s_sTaskNTP.getNTPConfigFile();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Checking availability of NTP config file " + fileLoc + " on all nodes."));
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean ret = false;
        globalExec.checkFileExistence(nList, fileLoc, locrs);
        confokVec.clear();
        Hashtable cfresultHT = locrs.getResultTable();
        Enumeration e = cfresultHT.keys();
        Vector<String> noConfVec = new Vector<String>();
        Vector<String> notRunVec = new Vector<String>();
        while (e.hasMoreElements()) {
            ErrorDescription errorDesc;
            Result result;
            String curNode = (String)e.nextElement();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("==== Analyzing NTP config file chk result for node " + curNode));
            }
            if ((result = (Result)cfresultHT.get(curNode)) != null && 3 == result.getStatus()) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("==== configuration file is missing for " + curNode));
                }
                noConfVec.add(curNode);
                String errmsg = s_msgBundle.getMessage("5402", true, (Object[])new String[]{fileLoc, curNode});
                errorDesc = new ErrorDescription(errmsg);
                locrs.addErrorDescription(curNode, errorDesc);
                noConfMsgVec.add(errmsg);
                continue;
            }
            if (result == null || 1 != result.getStatus()) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("==== NTP config file chk did not run on " + curNode));
                }
                notRunVec.add(curNode);
                String errormsg = s_msgBundle.getMessage("5403", true, (Object[])new String[]{fileLoc, curNode});
                errorDesc = new ErrorDescription(errormsg);
                locrs.addErrorDescription(curNode, errorDesc);
                noConfMsgVec.add(errormsg);
                continue;
            }
            if (result == null || 1 != result.getStatus()) continue;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("==== NTP config file chk did run correctly on " + curNode));
            }
            confokVec.add(curNode);
            ret = true;
        }
        boolean bl = ctssalternate = confokVec.isEmpty() && this.m_preCheck;
        if (confokVec.isEmpty()) {
            ret = false;
        }
        if (!(confokVec.isEmpty() && this.m_preCheck || this.m_mute)) {
            for (int j = 0; j < noConfMsgVec.size(); ++j) {
                ReportUtil.sureprintln((String)noConfMsgVec.get(j));
            }
        }
        if (notRunVec.isEmpty() && noConfVec.isEmpty()) {
            if (!this.m_mute) {
                ReportUtil.println(s_msgBundle.getMessage("5404", false, (Object[])new String[]{fileLoc}));
            }
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5419", false));
            }
        } else {
            if (!(noConfVec.isEmpty() || this.m_mute || ctssalternate)) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5405", true, (Object[])new String[]{fileLoc}));
            }
            if (!notRunVec.isEmpty()) {
                if (!this.m_mute && !ctssalternate) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5421", true));
                }
                if (!this.m_mute && !ctssalternate) {
                    ReportUtil.sureprintNodelist(notRunVec);
                }
            }
        }
        return ret;
    }

    private boolean doDaemonCheck(ResultSet locrs, String[] nlist, Vector<String> dmnOkVec) {
        ErrorDescription errorDesc;
        String errmsg;
        List<String> dmnNames = this.s_sTaskNTP.getNTPDaemonNames();
        Vector noDmnMsgVec = new Vector();
        Vector<TaskDaemonLiveliness> aliveDaemonVector = new Vector<TaskDaemonLiveliness>();
        Vector<TaskDaemonLiveliness> notRunningDaemonVector = new Vector<TaskDaemonLiveliness>();
        boolean setPidCheck = false;
        if (VerificationUtil.getOperatingSystemName().contains("Linux")) {
            setPidCheck = true;
        }
        TaskDaemonLiveliness taskDaemon = null;
        for (String dmnName : dmnNames) {
            taskDaemon = new TaskDaemonLiveliness(nlist, dmnOkVec);
            taskDaemon.setDaemonName(dmnName);
            taskDaemon.setPidBasedCheck(setPidCheck);
            taskDaemon.setMute(true);
            taskDaemon.perform();
            if (taskDaemon.getResultSet().anySuccess()) {
                Trace.out((String)(dmnName + " is running on some nodes"));
                aliveDaemonVector.add(taskDaemon);
                continue;
            }
            Trace.out((String)(dmnName + " is not running on any nodes"));
            notRunningDaemonVector.add(taskDaemon);
        }
        if (aliveDaemonVector.size() > 1) {
            Trace.out((String)"more than one daemon is running");
            errmsg = s_msgBundle.getMessage("5499", true);
            for (TaskDaemonLiveliness taskDaemonIter : aliveDaemonVector) {
                String dmnName = taskDaemonIter.getDaemonName();
                Trace.out((String)(dmnName + " is running on some nodes"));
                ResultSet dmnResult = taskDaemonIter.getResultSet();
                String[] dmnRunningNodes = dmnResult.getSuccNodes();
                errmsg = errmsg + LSEP + s_msgBundle.getMessage("5469", false, (Object[])new String[]{dmnName, VerificationUtil.strArr2List(dmnRunningNodes)});
                Trace.out((String)"printing daemon check messages");
                taskDaemonIter.setMute(false);
                taskDaemonIter.displayDaemonCheckStartMessage();
                taskDaemonIter.displayDaemonLivelinessOutput(dmnResult, false);
            }
            errorDesc = new ErrorDescription(errmsg);
            locrs.addResult(this.m_nodeList, 3);
            locrs.addErrorDescription(errorDesc);
            if (!this.m_mute) {
                ReportUtil.sureprintln(errmsg);
            }
            return false;
        }
        if (aliveDaemonVector.size() == 0) {
            Trace.out((String)"no NTPD's found on any node");
            if (this.m_preCheck) {
                String errMsg = s_msgBundle.getMessage("5496", false);
                if (!this.m_mute) {
                    ReportUtil.sureprintln(errMsg);
                }
                locrs.addResult(this.m_nodeList, 3);
                return false;
            }
            for (TaskDaemonLiveliness taskDaemonIter : notRunningDaemonVector) {
                Trace.out((String)"printing daemon check messages");
                ResultSet dmnResult = taskDaemonIter.getResultSet();
                taskDaemonIter.setMute(false);
                taskDaemonIter.displayDaemonCheckStartMessage();
                taskDaemonIter.displayDaemonLivelinessOutput(dmnResult, false);
            }
            errmsg = s_msgBundle.getMessage("5494", true);
            errorDesc = new ErrorDescription(errmsg);
            locrs.addResult(this.m_nodeList, 3);
            locrs.addErrorDescription(errorDesc);
            if (!this.m_mute) {
                ReportUtil.sureprintln(errmsg);
            }
            return false;
        }
        TaskDaemonLiveliness taskDaemonIter = (TaskDaemonLiveliness)aliveDaemonVector.get(0);
        Trace.out((String)"printing daemon check messages");
        taskDaemonIter.setMute(false);
        ResultSet dmnResult = taskDaemonIter.getResultSet();
        taskDaemonIter.displayDaemonCheckStartMessage();
        taskDaemonIter.displayDaemonLivelinessOutput(dmnResult, false);
        boolean ret = false;
        String dmnName = taskDaemonIter.getDaemonName();
        Trace.out((String)(dmnName + " is running on some nodes"));
        locrs.uploadResultSet(dmnResult);
        String[] dmnRunningNodes = dmnResult.getSuccNodes();
        if (dmnResult.allSuccess()) {
            Trace.out((String)"NTPD running on all nodes");
            String errmsg2 = s_msgBundle.getMessage("5497", false);
            locrs.addResult(nlist, 1);
            ret = true;
        } else if (dmnResult.anySuccess()) {
            Trace.out((String)"NTPD running on some nodes");
            String[] dmnNotRunningNodes = dmnResult.getFailureNodes();
            String errmsg3 = s_msgBundle.getMessage("5493", true, (Object[])new String[]{VerificationUtil.strArr2List(dmnNotRunningNodes)});
            locrs.addResult(dmnRunningNodes, 1);
            locrs.addResult(dmnNotRunningNodes, 3);
            ErrorDescription errDesc = new ErrorDescription(errmsg3);
            locrs.addErrorDescription(errDesc);
            ret = false;
        }
        return ret;
    }

    private boolean doTimeServerCheck(ResultSet locrs, Hashtable<String, TimeServer> tsTable, Vector<String> confokVec) {
        ArrayList<ErrorDescription> uncommonTimeServerErrList = new ArrayList<ErrorDescription>();
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5417", false));
        }
        boolean tsOK = this.getTimeServerInfo(locrs, tsTable, confokVec);
        boolean atLeastOne = false;
        if (tsOK) {
            Enumeration<String> e = tsTable.keys();
            while (e.hasMoreElements()) {
                String tsID = e.nextElement();
                TimeServer tServer = tsTable.get(tsID);
                Trace.out((String)("tsId=" + tsID + "; tServer.getNodeTable().size()=" + tServer.getNodeTable().size()));
                if (tServer.getNodeTable().size() == confokVec.size()) {
                    atLeastOne = true;
                    if (this.m_mute) continue;
                    ReportUtil.println(s_msgBundle.getMessage("5407", false, (Object[])new String[]{tsID}));
                    continue;
                }
                String[] tsNodeList = tServer.getNodeList();
                String nodeString = VerificationUtil.strArr2List(tsNodeList);
                String errMsg = s_msgBundle.getMessage("5408", true, (Object[])new String[]{tsID, nodeString});
                uncommonTimeServerErrList.add(new ErrorDescription(errMsg));
            }
            if (atLeastOne) {
                if (!this.m_mute) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5409", false));
                }
                locrs.addResult(confokVec, 1);
            } else {
                for (ErrorDescription errDesc : uncommonTimeServerErrList) {
                    locrs.addErrorDescription(errDesc);
                    if (this.m_mute) continue;
                    ReportUtil.printError(errDesc.getErrorMessage());
                }
                locrs.addResult(confokVec, 3);
            }
        } else {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Error getting Time Server Info on all nodes");
            }
            String errMsg = s_msgBundle.getMessage("5410", true);
            if (!this.m_mute) {
                ReportUtil.sureprintln(errMsg);
            }
            locrs.addErrorDescription(new ErrorDescription(errMsg));
        }
        return atLeastOne;
    }

    private boolean getTimeServerInfo(ResultSet locrs, Hashtable<String, TimeServer> tsTable, Vector<String> confokVec) {
        VerificationCommand[] driverCmdArray = new VerificationCommand[confokVec.size()];
        String[] okNodeList = confokVec.toArray(new String[confokVec.size()]);
        String stateCmd = this.s_sTaskNTP.getNTPQueryCommand();
        for (int j = 0; j < okNodeList.length; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd};
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            String[] env = null;
            driverCmdArray[j] = new VerificationCommand(okNodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, locrs);
        if (!locrs.anySuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Global failure executing NTP query command ");
            }
            String errMsg = s_msgBundle.getMessage("5411", true, (Object[])new String[0]);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(okNodeList, errorDesc);
            if (!this.m_mute) {
                ReportUtil.printError(errMsg);
            }
            return false;
        }
        boolean validOutput = false;
        for (int nodeIndex = 0; nodeIndex < okNodeList.length; ++nodeIndex) {
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = driverCmd.getNode();
            String output = driverCmd.getOutput();
            if (output != null) {
                String[] tsLineArray;
                result.addResultInfo(output);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Output from NTP query command on node " + node + " is =" + output));
                }
                if ((tsLineArray = this.s_sTaskNTP.parseNTPQueryOutput(output)) != null) {
                    for (String tsline : tsLineArray) {
                        String serverID = this.s_sTaskNTP.getIDFromNTPOutput(tsline);
                        if (serverID != null && serverID.length() > 0 && !serverID.contains("LOCAL")) {
                            TimeServer tserv = tsTable.get(serverID);
                            if (tserv == null) {
                                tserv = new TimeServer(serverID);
                                tsTable.put(serverID, tserv);
                            }
                            tserv.addToNodeTable(okNodeList[nodeIndex], tsline);
                            validOutput = true;
                            continue;
                        }
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)("Parsing of NTP query output line FAILED. Line=" + tsline));
                    }
                } else if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Parsing of NTP query output FAILED: Output=" + output));
                }
            }
            if (validOutput) continue;
            result.setStatus(3);
            if (!Trace.isLevelEnabled((int)5)) continue;
            Trace.out((String)("NTP query on node " + okNodeList[nodeIndex] + " did NOT produce valid output."));
        }
        return validOutput;
    }

    private boolean doOffsetCheck(Hashtable<String, TimeServer> tsTable, Vector<String> okNodeVec) {
        String errMsg;
        String[] okNodeList = okNodeVec.toArray(new String[okNodeVec.size()]);
        boolean chkok = false;
        boolean nodesOK = false;
        Enumeration<String> e = tsTable.keys();
        float offsetLimit = this.s_sTaskNTP.getNTPOffsetLimit();
        Hashtable incorrectOffsetTable = new Hashtable();
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5418", false));
        }
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("5426", false, (Object[])new String[]{okNodeVec.toString()}));
        }
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("5446", false));
        }
        while (e.hasMoreElements()) {
            String srvrID = e.nextElement();
            TimeServer nextTS = tsTable.get(srvrID);
            boolean hdrPrinted = false;
            Hashtable<String, TimeServerNode> nodeHT = nextTS.getNodeTable();
            if (nodeHT.size() != okNodeVec.size()) continue;
            nodesOK = true;
            Enumeration<String> en = nodeHT.keys();
            while (en.hasMoreElements()) {
                String node;
                TimeServerNode tsNode;
                float nodeOffset;
                if (!hdrPrinted) {
                    if (!this.m_mute) {
                        ReportUtil.blankln();
                    }
                    if (!this.m_mute) {
                        ReportUtil.println(s_msgBundle.getMessage("5427", false, (Object[])new String[]{srvrID, new Float(offsetLimit).toString()}));
                    }
                    if (!this.m_mute) {
                        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("9685", false), s_msgBundle.getMessage("8018", false));
                    }
                    hdrPrinted = true;
                }
                if (Math.abs(nodeOffset = (tsNode = nodeHT.get(node = en.nextElement())).getOffset()) < offsetLimit) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Offset " + nodeOffset + " of Time Server " + srvrID + " is within limits of threshold " + offsetLimit + " on node " + node));
                    }
                    if (this.m_mute) continue;
                    ReportUtil.writeRecord(node, Float.toString(nodeOffset), ReportUtil.PASSED);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Offset " + nodeOffset + " of Time Server " + srvrID + " is NOT within limits of threshold " + offsetLimit + " on node " + node));
                }
                errMsg = s_msgBundle.getMessage("5413", true, (Object[])new String[]{node, Float.toString(nodeOffset), Float.toString(offsetLimit), srvrID});
                if (!this.m_mute) {
                    ReportUtil.sureprintln(errMsg);
                    ReportUtil.writeRecord(node, Float.toString(nodeOffset), ReportUtil.FAILED);
                }
                nodesOK = false;
                if (incorrectOffsetTable.containsKey(srvrID)) {
                    ((HashMap)incorrectOffsetTable.get(srvrID)).put(node, Float.toString(nodeOffset));
                    continue;
                }
                HashMap<String, String> nodeOffsetMap = new HashMap<String, String>();
                nodeOffsetMap.put(node, Float.toString(nodeOffset));
                incorrectOffsetTable.put(srvrID, nodeOffsetMap);
            }
            if (!nodesOK) continue;
            chkok = true;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Time Server " + srvrID + " has time offsets within limits on all nodes where NTP query succeeded."));
            }
            if (this.m_mute) continue;
            ReportUtil.println(s_msgBundle.getMessage("5425", false, (Object[])new String[]{srvrID, okNodeVec.toString()}));
        }
        if (chkok && okNodeVec.size() == this.m_nodeList.length) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5423", false));
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        Trace.out((String)"TaskNTP failed for clock offset following is detailed information:");
        Trace.out((String)("chkok = " + chkok));
        Trace.out((String)("okNodeVec (size = " + okNodeVec.size() + ") = " + VerificationUtil.strCollection2String(okNodeVec)));
        Trace.out((String)("m_nodeList (size = " + this.m_nodeList.length + ") = " + VerificationUtil.strArr2List(this.m_nodeList)));
        errMsg = s_msgBundle.getMessage("5424", true);
        if (!this.m_mute) {
            ReportUtil.sureprintln(errMsg);
        }
        this.m_resultSet.addResult(okNodeList, 3);
        Set timeServers = incorrectOffsetTable.keySet();
        for (String timeServer : timeServers) {
            HashMap nodeOffsetMap = (HashMap)incorrectOffsetTable.get(timeServer);
            Set failedNodesForTimeServer = nodeOffsetMap.keySet();
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1015", true, (Object[])new String[]{timeServer, Float.toString(offsetLimit), VerificationUtil.strCollection2String(failedNodesForTimeServer)})));
            for (String failedNode : failedNodesForTimeServer) {
                String nodeErrorMsg = s_msgBundle.getMessage("5413", true, (Object[])new String[]{failedNode, (String)nodeOffsetMap.get(failedNode), Float.toString(offsetLimit), timeServer});
                Trace.out((int)5, (String)nodeErrorMsg);
                this.m_resultSet.addResult(failedNode, 3);
                this.m_resultSet.addErrorDescription(failedNode, new ErrorDescription(nodeErrorMsg));
            }
        }
        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
        return false;
    }

    private boolean doSlewingCheck(ResultSet locrs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        VerificationCommand[] driverCmdArray = new VerificationCommand[okVectorSize];
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        String stateCmd = this.s_sTaskNTP.getNTPDCommandLine("commandline");
        String slewOption = this.s_sTaskNTP.getNTPDSlewingOption();
        for (int j = 0; j < okVectorSize; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd};
            String[] env = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            driverCmdArray[j] = new VerificationCommand(okNodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, locrs);
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5444", false, (Object[])new String[]{slewOption}));
        }
        if (!locrs.anySuccess()) {
            Trace.out((String)"Global failure executing NTP Slewing command ");
            String errMsg = s_msgBundle.getMessage("5442", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errorDesc);
            return false;
        }
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("5437", false));
        }
        if (!this.m_mute) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        }
        for (int nodeIndex = 0; nodeIndex < okVectorSize; ++nodeIndex) {
            String slewedmode = ReportUtil.UNKNOWN;
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            String node = driverCmd.getNode();
            if (result.getStatus() == 1) {
                String cmdline = driverCmd.getOutput();
                if (cmdline != null) {
                    boolean slewingPresent;
                    result.addResultInfo(cmdline);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("NTPD commandline on node " + node + " is =" + cmdline));
                    }
                    if (slewingPresent = this.s_sTaskNTP.parseNTPDCommandLine(cmdline, "commandline")) {
                        Trace.out((String)(" node:" + node + ": is slewed"));
                        locrs.addResult(node, 1);
                        slewedmode = ReportUtil.YES;
                    } else {
                        Trace.out((String)("node:" + node + ": is not slewed"));
                        locrs.addResult(node, 3);
                        ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5439", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5439");
                        locrs.addErrorDescription(node, errDesc);
                        slewedmode = ReportUtil.NO;
                    }
                }
            } else {
                locrs.addResult(node, 2);
                Trace.out((String)("NTPD commandline couldn't be obtained from node: '" + node + "'"));
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5440", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5440");
                locrs.addErrorDescription(node, errDesc);
                slewedmode = ReportUtil.UNKNOWN;
            }
            if (this.m_mute) continue;
            ReportUtil.writeRecord(node, slewedmode);
        }
        if (locrs.allSuccess()) {
            if (!this.m_mute) {
                ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5441", false, (Object[])new String[]{slewOption}));
            }
            return true;
        }
        if (!this.m_mute) {
            ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5443", false));
        }
        if (!this.m_mute) {
            ReportUtil.printErrorNodes(locrs);
        }
        return false;
    }

    private boolean doSlewingSysConfigCheck(ResultSet locrs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        VerificationCommand[] driverCmdArray = new VerificationCommand[okVectorSize];
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        String bootOptionCmd = this.s_sTaskNTP.getNTPDCommandLine("startup");
        String slewOption = this.s_sTaskNTP.getNTPDSlewingOption();
        String bootConfigFile = this.s_sTaskNTP.getNTPDBootConfigFile();
        for (int j = 0; j < okVectorSize; ++j) {
            String[] arg = new String[]{"-rungencmd", bootOptionCmd};
            String[] env = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            driverCmdArray[j] = new VerificationCommand(okNodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, locrs);
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5445", false, (Object[])new String[]{bootConfigFile, slewOption}));
        }
        if (!locrs.anySuccess()) {
            Trace.out((String)"Global failure executing NTP Boot configuration slewing command ");
            String errMsg = s_msgBundle.getMessage("5475", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errorDesc);
            return false;
        }
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5471", false));
        }
        if (!this.m_mute) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        }
        for (int nodeIndex = 0; nodeIndex < okVectorSize; ++nodeIndex) {
            String slewedmode = ReportUtil.UNKNOWN;
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            String node = driverCmd.getNode();
            if (result.getStatus() == 1) {
                String bootCmdline = driverCmd.getOutput();
                if (bootCmdline != null) {
                    boolean slewingPresent;
                    result.addResultInfo(bootCmdline);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("NTPD boot configuration on node " + node + " is =" + bootCmdline));
                    }
                    if (slewingPresent = this.s_sTaskNTP.parseNTPDCommandLine(bootCmdline, "startup")) {
                        Trace.out((String)(" node:" + node + ": is slewed"));
                        locrs.addResult(node, 1);
                        slewedmode = ReportUtil.YES;
                    } else {
                        Trace.out((String)("node:" + node + ": is not slewed"));
                        locrs.addResult(node, 3);
                        ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5472", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5472");
                        locrs.addErrorDescription(node, errDesc);
                        slewedmode = ReportUtil.NO;
                    }
                }
            } else {
                locrs.addResult(node, 2);
                Trace.out((String)("NTPD boot config couldn't be obtained from node: '" + node + "'"));
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5473", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5473");
                locrs.addErrorDescription(node, errDesc);
                slewedmode = ReportUtil.UNKNOWN;
            }
            if (this.m_mute) continue;
            ReportUtil.writeRecord(node, slewedmode);
        }
        if (locrs.allSuccess()) {
            if (!this.m_mute) {
                ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5474", false));
            }
            return true;
        }
        if (!this.m_mute) {
            ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5476", false));
        }
        if (!this.m_mute) {
            ReportUtil.printErrorNodes(locrs);
        }
        return false;
    }

    private boolean doPortOpenCheck(ResultSet rs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        GlobalExecution gex = new GlobalExecution();
        String ntpCfg = this.s_sTaskNTP.getCfgFileToSearch();
        boolean ret = false;
        ret = gex.checkNTPPort(ntpCfg, rs, okNodeList);
        Trace.out((String)("Entered doPortOpenCheck GlobalExec returns " + ret));
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5487", false));
        }
        if (!rs.anySuccess()) {
            Trace.out((String)"Global failure executing NTP Port Open Check command ");
            String errMsg = s_msgBundle.getMessage("5488", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            rs.addErrorDescription(errorDesc);
            return false;
        }
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5489", false));
        }
        if (!this.m_mute) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5490", false));
        }
        for (int nodeIndex = 0; nodeIndex < okVectorSize; ++nodeIndex) {
            String errMsg;
            String node = okNodeList[nodeIndex];
            Result r = rs.getResult(node);
            int st = r.getStatus();
            String msg = ReportUtil.UNKNOWN;
            if (st == 1) {
                msg = ReportUtil.YES;
            } else if (st == 2 || st == 3) {
                msg = ReportUtil.NO;
            }
            if (st == 2) {
                errMsg = s_msgBundle.getMessage("5506", true, (Object[])new String[]{node});
                rs.addErrorDescription(new ErrorDescription(errMsg));
            } else if (st == 3) {
                errMsg = s_msgBundle.getMessage("5505", true, (Object[])new String[]{node});
                rs.addErrorDescription(new ErrorDescription(errMsg));
            }
            if (this.m_mute) continue;
            ReportUtil.writeRecord(okNodeList[nodeIndex], msg);
        }
        Trace.out((String)("Exiting doPortOpenCheck returns " + ret));
        return ret;
    }

    public void setPreCheck(boolean preCheck) {
        this.m_preCheck = preCheck;
    }

    public boolean getPreCheck() {
        return this.m_preCheck;
    }

    public void setRequestedRelease(String reqRel) {
        this.m_requestedRelease = reqRel;
    }
}

