/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.OIFCFGUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.verification.NetworkInterfaceInfoImpl;
import oracle.cluster.impl.verification.NodeConnectivityResultSetImpl;
import oracle.cluster.impl.verification.SubnetAndInterfaceInfoImpl;
import oracle.cluster.install.InstallException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskHostsFile;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.TCPMatrix;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.ClassifierTable;
import oracle.ops.verification.util.MultiNodeException;

public class TaskNodeConnectivity
extends Task {
    public static final int NODECON = 0;
    public static final int NODEREACH = 1;
    public static final String IPCON_KEY = "IPCON";
    public static final String INFCON_KEY = "INFCON";
    public static final String NODEREACH_KEY = "NODEREACH";
    private String[] m_IPAddrList;
    private String[] m_interfaceList = null;
    private String[] m_subnetList = null;
    private int[] m_subnetTypeList = null;
    private int m_taskType = 0;
    private String m_srcNode = null;
    private VerifyNetwork m_vfyNet = new VerifyNetwork();
    private NodeConnectivityResultSetImpl m_nodeConResSetImpl = new NodeConnectivityResultSetImpl();
    private String m_localName = null;
    private Vector<NodeInfo> m_nodeInfoList = null;
    private List<String> nodeInterfaceCollection = new ArrayList<String>();

    public TaskNodeConnectivity() {
        this(null, 1);
    }

    public TaskNodeConnectivity(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskNodeConnectivity(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public TaskNodeConnectivity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNodeConnectivity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNodeConnectivity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setInterfaceList(String[] interfaceList) {
        this.m_interfaceList = interfaceList;
    }

    public void setSubnetList(String[] subnetList) {
        this.m_subnetList = subnetList;
    }

    public void setSubnetTypeList(int[] subnetTypeList) {
        this.m_subnetTypeList = subnetTypeList;
    }

    public void setIPAddrList(String[] IPAddrList) {
        this.m_IPAddrList = IPAddrList;
    }

    public void setTaskType(int type) {
        this.m_taskType = type;
    }

    public void setSourceNode(String srcNode) {
        this.m_srcNode = srcNode;
    }

    public NodeConnectivityResultSetImpl getNodeConnectivityResultSetImpl() {
        return this.m_nodeConResSetImpl;
    }

    @Override
    public void clean() {
        Trace.out((String)"Clearing cached 'm_nodeInfoList'");
        this.m_nodeInfoList = null;
    }

    @Override
    public boolean performTask() {
        boolean retVal = false;
        if (this.m_IPAddrList != null && this.m_IPAddrList.length != this.m_nodeList.length) {
            Trace.out((String)"Address node mismatch");
            ReportUtil.printError(s_msgBundle.getMessage("4079", false) + LSEP);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription("4079", s_msgBundle));
            return false;
        }
        try {
            this.m_localName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + uhe));
            String errMsg = s_msgBundle.getMessage("0002", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        if (VerificationUtil.isUpgrade() && this.isRolling()) {
            String currentCrsVer = VerificationUtil.getCRSActiveVersion();
            Trace.out((String)("It is a Rolling Upgrade scenario with an active CRS version as " + currentCrsVer));
            if (currentCrsVer != null && VerificationUtil.isVersionPre(currentCrsVer, "11.2")) {
                Trace.out((String)("Performing the Private IP and Private subnet check as it is an upgrade from pre 11.2 CRS with version " + currentCrsVer));
                retVal = this.performPrivateIPSubnetCheckForUpgrade();
            } else {
                Trace.out((String)("Not performing the Private IP and Private subnet check even though it is an upgrade scenario with rolling upgrade the CRS version " + currentCrsVer + " is found to be post 11.2"));
            }
        }
        if (this.m_taskType == 0) {
            Trace.out((String)"Performing Node Connectivity verification task... \n");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4063", false));
            if (this.m_nodeList == null) {
                Trace.out((String)"NULL 'nodelist'");
                this.m_resultSet.addResult(this.m_localName, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription("7515", s_msgBundle));
                return false;
            }
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (nativeSystem.isUnixSystem()) {
                TaskHostsFile taskNHF = new TaskHostsFile(this.m_nodeList);
                taskNHF.performTask();
                this.m_resultSet.uploadResultSet(taskNHF.getResultSet());
            }
            if (this.m_interfaceList != null) {
                Trace.out((String)("\nUsing interfaceList: '" + VerificationUtil.strArr2List(this.m_interfaceList) + "'"));
                retVal = this.verifyIfCon();
            } else {
                Trace.out((String)"interfaceList is NULL");
                retVal = this.verifyNodeCon();
            }
            if (this.m_nodeList.length > 1) {
                retVal &= this.performSubnetMaskConsistancyCheck();
            }
            retVal &= this.checkForSameIPOnMultipleNICS();
            ReportUtil.sureblankln();
            if (!this.m_resultSet.anyFailure()) {
                ReportUtil.printResult(s_msgBundle.getMessage("4086", false));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("4087", false));
            }
        } else if (this.m_taskType == 1) {
            Trace.out((String)"_nw_:Performing Node Reachability verification task... \n");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4078", false));
            boolean[] nodeConArray = new boolean[this.m_nodeList.length];
            String[] nodeErrorArray = new String[this.m_nodeList.length];
            VerifyNetwork vfyNet = new VerifyNetwork();
            if (this.m_srcNode != null) {
                if (!VerificationUtil.isUserEquivalenceOnNode(this.m_srcNode, true)) {
                    Trace.out((String)"Node Reach Equivalence check failed from source node.\n");
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_msgBundle.getMessage("4083", false, (Object[])new String[]{this.m_srcNode})));
                    return false;
                }
                Trace.out((String)"Performing Node Reachability from source node...\n");
                retVal = vfyNet.checkReachFromSrcNode(this.m_nodeList, nodeConArray, this.m_srcNode);
            } else {
                try {
                    this.m_srcNode = VerificationUtil.getLocalHost();
                    Trace.out((String)"Performing Node Reachability from local node...\n");
                    retVal = vfyNet.checkReachFromLocalNode(this.m_nodeList, nodeConArray, nodeErrorArray);
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)("UNKNOWN HOST EXCEPTION: " + uhe.getMessage()));
                    ReportUtil.sureprintln(uhe.getMessage());
                    this.m_resultSet.addErrorDescription(new ErrorDescription(uhe.getMessage()));
                    retVal = false;
                }
                catch (NetworkException ne) {
                    ReportUtil.sureprintln(ne.getMessage());
                    Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
                    this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
            }
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                String node = this.m_nodeList[i];
                if (nodeConArray[i]) {
                    this.m_resultSet.addResult(node, 1);
                    continue;
                }
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4083", false, (Object[])new String[]{this.m_srcNode}) + LSEP + nodeErrorArray[i]);
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            this.reportNodeReach(this.m_srcNode, this.m_nodeList, nodeConArray, nodeErrorArray, retVal);
        }
        ReportUtil.sureblankln();
        return retVal;
    }

    private boolean verifyNodeCon() {
        Subnet okSubnet;
        Iterator okSubnetIter;
        TCPMatrix tcpMatrix;
        ConMatrix matrix;
        Subnet subnet;
        Vector<NodeInfo> nodeInfoList = null;
        Object mne = null;
        boolean retVal = false;
        boolean foundVIPOk = false;
        boolean foundAnyValidSubnet = false;
        boolean TCPCon = false;
        boolean foundPrivate = false;
        boolean foundPrivateSameName = false;
        int numOkNodes = this.m_nodeList.length;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((nodeInfoList = this.getNodeInfoList()) == null) {
            return false;
        }
        numOkNodes = nodeInfoList.size();
        if (0 == numOkNodes) {
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                String node = this.m_nodeList[i];
                this.m_resultSet.addResult(node, 2);
                String errMsg = s_msgBundle.getMessage("4087", false);
                String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{node});
                String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{node});
                Trace.out((String)("No OK nodes: " + errMsg));
                this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            }
            ReportUtil.printError(s_msgBundle.getMessage("4080", true));
            return false;
        }
        this.reportNodeInfo(nodeInfoList);
        ReportUtil.sureblankln();
        boolean mtuRetVal = this.performMTUConsistencyCheck();
        Vector<Subnet> subnets = Subnet.classifyToSubnets(nodeInfoList);
        if (this.m_subnetList != null) {
            ArrayList<String> subnetListFromUser = new ArrayList<String>(Arrays.asList(this.m_subnetList));
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== subnetList from user: " + ((Object)subnetListFromUser).toString()));
            }
            Vector<Subnet> tmpSubnets = new Vector<Subnet>();
            for (Subnet chkSubnet : subnets) {
                String strSubnet = chkSubnet.getSubnet();
                if (!subnetListFromUser.contains(strSubnet)) continue;
                Trace.out((String)("adding subnet: '" + strSubnet + "' to tmpSubnet list."));
                tmpSubnets.add(chkSubnet);
            }
            subnets = tmpSubnets;
        }
        Vector subnetList = new Vector(subnets);
        Vector matrixList = new Vector(subnetList.size());
        Vector tcpMatrixList = new Vector(subnetList.size());
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("subnetList size: " + subnetList.size()));
        }
        if (m_isAPImode) {
            this.getNodeConnAPIData(subnetList);
        }
        try {
            foundAnyValidSubnet = this.m_vfyNet.checkSubnetCon(subnetList, matrixList);
            TCPCon = this.m_vfyNet.checkSubnetTCPCon(subnetList, tcpMatrixList);
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
            ReportUtil.printError(ne.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            retVal = false;
            return false;
        }
        Iterator subnetIter = subnetList.iterator();
        Iterator matrixIter = matrixList.iterator();
        Iterator tcpMatrixIter = tcpMatrixList.iterator();
        while (subnetIter.hasNext()) {
            subnet = (Subnet)subnetIter.next();
            matrix = (ConMatrix)matrixIter.next();
            tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
            this.reportNodeCon(matrix);
            this.reportTCPCon(subnet.getSubnet(), tcpMatrix);
        }
        subnetIter = subnetList.iterator();
        matrixIter = matrixList.iterator();
        while (subnetIter.hasNext()) {
            subnet = (Subnet)subnetIter.next();
            matrix = (ConMatrix)matrixIter.next();
            if (matrix.getStatus() != 1) continue;
            boolean warningIssued = false;
            okSubnetIter = subnet.getVIPOkSubnets(numOkNodes).iterator();
            block6: while (okSubnetIter.hasNext()) {
                foundVIPOk = true;
                warningIssued = false;
                okSubnet = (Subnet)okSubnetIter.next();
                this.reportVIPOkInterfaces(okSubnet);
                for (String node : subnet.getNodes()) {
                    for (InterfaceInfo inf : subnet.getInterfacesByNode(node)) {
                        if (!inf.getGateway().equals("0.0.0.0") || !inf.getDefGateway().equals("UNKNOWN")) continue;
                        String errMsg = s_msgBundle.getMessage("6019", false, (Object[])new String[]{okSubnet.getSubnet()});
                        this.m_resultSet.addResult(node, 4);
                        this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg));
                        Trace.out((String)("No Gateway: " + errMsg));
                        ReportUtil.printWarning(errMsg);
                        warningIssued = true;
                        break;
                    }
                    if (!warningIssued) continue;
                    continue block6;
                }
            }
        }
        subnetIter = subnetList.iterator();
        matrixIter = matrixList.iterator();
        tcpMatrixIter = tcpMatrixList.iterator();
        while (subnetIter.hasNext()) {
            subnet = (Subnet)subnetIter.next();
            matrix = (ConMatrix)matrixIter.next();
            tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
            if (matrix.getStatus() != 1 || tcpMatrix.getStatus() != 0) continue;
            okSubnetIter = subnet.getPrivateOkSubnets(numOkNodes, true).iterator();
            while (okSubnetIter.hasNext()) {
                foundPrivateSameName = true;
                okSubnet = (Subnet)okSubnetIter.next();
                this.reportPrivateOkInterfaces(okSubnet);
            }
        }
        if (!foundPrivateSameName) {
            subnetIter = subnetList.iterator();
            matrixIter = matrixList.iterator();
            tcpMatrixIter = tcpMatrixList.iterator();
            while (subnetIter.hasNext()) {
                subnet = (Subnet)subnetIter.next();
                matrix = (ConMatrix)matrixIter.next();
                tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
                if (matrix.getStatus() != 1 || tcpMatrix.getStatus() != 0) continue;
                okSubnetIter = subnet.getPrivateOkSubnets(numOkNodes, false).iterator();
                while (okSubnetIter.hasNext()) {
                    foundPrivate = true;
                    okSubnet = (Subnet)okSubnetIter.next();
                    this.reportPrivateOkInterfaces(okSubnet);
                }
            }
        }
        if (!foundVIPOk) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4101", false));
        }
        if (!foundPrivateSameName && foundPrivate) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4103", false));
        } else if (!foundPrivateSameName) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4102", false));
        }
        boolean bl = retVal = numOkNodes == this.m_nodeList.length && foundAnyValidSubnet;
        if (retVal) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 2);
        }
        retVal = retVal && mtuRetVal;
        return retVal;
    }

    private boolean verifyIfCon() {
        int i;
        int i2;
        Object mne = null;
        boolean TCPCon = false;
        boolean retVal = true;
        boolean[] ifResults = new boolean[this.m_interfaceList.length];
        String[] ifNames = new String[this.m_interfaceList.length];
        Vector<NodeInfo> nodeInfoList = null;
        Vector subnetList = new Vector();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        for (i2 = 0; i2 < ifResults.length; ++i2) {
            ifResults[i2] = true;
        }
        for (i2 = 0; i2 < this.m_interfaceList.length; ++i2) {
            int index = this.m_interfaceList[i2].indexOf(58);
            ifNames[i2] = -1 != index ? this.m_interfaceList[i2].substring(0, index) : this.m_interfaceList[i2];
        }
        nodeInfoList = this.getNodeInfoList();
        if (nodeInfoList == null) {
            return false;
        }
        int numOkNodes = nodeInfoList.size();
        if (0 == numOkNodes) {
            for (i2 = 0; i2 < this.m_nodeList.length; ++i2) {
                String node = this.m_nodeList[i2];
                this.m_resultSet.addResult(node, 2);
                String errMsg = s_msgBundle.getMessage("4087", false);
                String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{node});
                String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{node});
                Trace.out((String)("No OK nodes: " + errMsg));
                this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            }
            ReportUtil.printError(s_msgBundle.getMessage("4080", true) + LSEP);
            return false;
        }
        this.reportNodeInfo(nodeInfoList);
        ReportUtil.blankln();
        boolean mtuRetVal = this.performMTUConsistencyCheck();
        boolean subnetRetVal = this.performSubnetExistanceCheck();
        NodeInfo nodeInfo2 = null;
        Vector ifList = null;
        HashSet allInterfaces = new HashSet();
        for (i = 0; i < ifNames.length; ++i) {
            Trace.out((String)("Processing interface: '" + ifNames[i] + "'"));
            HashSet<InterfaceInfo> interfaces = new HashSet<InterfaceInfo>();
            for (NodeInfo nodeInfo2 : nodeInfoList) {
                Collection<InterfaceInfo> nodeIfList = this.m_subnetList != null ? nodeInfo2.getInterfacesBySubnetId(this.m_subnetList[i]) : nodeInfo2.getInterfacesByName(ifNames[i]);
                if (nodeIfList.size() == 0) continue;
                ifList = (Vector)nodeIfList;
                interfaces.addAll(nodeIfList);
                Trace.out((String)("Interfaces for node: " + nodeInfo2.getName()));
                for (InterfaceInfo ifEntry : ifList) {
                    Trace.out((String)("  Interface: " + ifEntry.toString()));
                }
            }
            if (interfaces.size() == 0) {
                ifResults[i] = false;
                Trace.out((String)("ifResults for '" + ifNames[i] + "' set to false!"));
                continue;
            }
            allInterfaces.addAll(interfaces);
        }
        Collection ifSubnetList = Subnet.classifyToSubnets(allInterfaces, false);
        subnetList.addAll(ifSubnetList);
        Vector matrixList = new Vector(subnetList.size());
        Vector tcpMatrixList = new Vector(subnetList.size());
        Trace.out((String)("subnetList size: " + subnetList.size()));
        if (m_isAPImode) {
            this.getNodeConnAPIData(subnetList);
        }
        try {
            this.m_vfyNet.checkSubnetCon(subnetList, matrixList);
            TCPCon = this.m_vfyNet.checkSubnetTCPCon(subnetList, tcpMatrixList);
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION: " + ne));
            ReportUtil.printError(ne.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            retVal = false;
            return false;
        }
        Iterator subnetIter = subnetList.iterator();
        Iterator matrixIter = matrixList.iterator();
        Iterator tcpMatrixIter = tcpMatrixList.iterator();
        for (i = 0; i < ifResults.length; ++i) {
            if (ifResults[i]) continue;
            retVal = false;
            Trace.out((String)("ifResults for '" + ifNames[i] + "' set to false!"));
            String errMsg = s_msgBundle.getMessage("4090", true, (Object[])new String[]{ifNames[i]});
            ReportUtil.printResult(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 3);
        }
        while (subnetIter.hasNext()) {
            Subnet subnet = (Subnet)subnetIter.next();
            ConMatrix matrix = (ConMatrix)matrixIter.next();
            TCPMatrix tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
            ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11062", false, (Object[])new String[]{subnet.getSubnet()}));
            if (matrix.getStatus() != 1 || tcpMatrix.getStatus() != 0) {
                Trace.out((String)(" Matrix status: " + matrix.getStatus() + " TCP status: " + tcpMatrix.getStatus()));
                retVal = false;
            }
            this.reportNodeCon(matrix);
            this.reportTCPCon(subnet.getSubnet(), tcpMatrix);
        }
        this.m_resultSet.traceResultSet("... verifyIfCon results ...");
        Trace.out((String)("retVal: '" + retVal + "' m_nodeList.length: '" + this.m_nodeList.length + "' numOkNodes: '" + numOkNodes + "'"));
        boolean bl = retVal = retVal && this.m_nodeList.length == numOkNodes;
        if (retVal) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 2);
        }
        return retVal && mtuRetVal && subnetRetVal;
    }

    private boolean performSubnetMaskConsistancyCheck() {
        boolean retVal = true;
        Object mne = null;
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11057", false));
        Vector<Object> nodeInfoList = new Vector();
        nodeInfoList = this.getNodeInfoList();
        if (nodeInfoList == null) {
            Trace.out((String)"getNodeInfoList() retuned null");
            return false;
        }
        Collection subnets = Subnet.classifyToSubnets(nodeInfoList);
        for (Subnet subnet : subnets) {
            if (this.m_subnetList != null) {
                boolean found = false;
                for (String strSubnet : this.m_subnetList) {
                    if (!strSubnet.equals(subnet.getSubnet())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            Trace.out((String)("trying to check subnetmask is same for subnet:" + subnet.getSubnet()));
            ClassifierTable subnetMaskTab = new ClassifierTable();
            for (Object o : subnet.getInterfaces()) {
                InterfaceInfo interfaceInfo = (InterfaceInfo)o;
                subnetMaskTab.put(interfaceInfo.getNetMask(), interfaceInfo);
            }
            if (subnetMaskTab.numSubGroups() > 1) {
                retVal = false;
                Trace.out((String)("subnet:" + subnet.getSubnet() + " has more than one subnet mask"));
                String msgMultpleSubnets = s_gMsgBundle.getMessage("11055", true, (Object[])new String[]{subnet.getSubnet()});
                ReportUtil.sureprintln(msgMultpleSubnets);
                Set subnetMasks = subnetMaskTab.keySet();
                for (Object subnetMask : subnetMasks) {
                    String nodes = this.getNodes(subnetMaskTab, subnetMask);
                    Trace.out((String)("Subnect number " + subnet.getSubnet() + " is configured using subnet mask " + subnetMask + "on nodes " + nodes));
                    String msg = s_gMsgBundle.getMessage("11056", true, (Object[])new String[]{(String)subnetMask, subnet.getSubnet(), nodes});
                    ReportUtil.sureprintln(msg);
                    msgMultpleSubnets = msgMultpleSubnets + LSEP + msg;
                }
                this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(msgMultpleSubnets));
                this.m_resultSet.addResult(this.m_nodeList, 3);
                continue;
            }
            String msg = s_gMsgBundle.getMessage("11059", false, (Object[])new String[]{subnet.getSubnet()});
            ReportUtil.sureprintln(msg);
        }
        if (retVal) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11058", false));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11060", false));
        }
        return retVal;
    }

    private boolean performSubnetExistanceCheck() {
        boolean retVal = true;
        Collection<InterfaceInfo> nodeIfList = null;
        Vector<NodeInfo> nodeInfoList = null;
        nodeInfoList = this.getNodeInfoList();
        if (nodeInfoList == null) {
            return false;
        }
        for (int i = 0; i < this.m_interfaceList.length; ++i) {
            boolean bWarn;
            String subnet;
            String ifName = this.m_interfaceList[i];
            int subnetType = this.m_subnetTypeList == null ? 4 : this.m_subnetTypeList[i];
            String string = subnet = this.m_subnetList == null ? null : this.m_subnetList[i];
            if (subnet != null && this.m_nodeMgr.isBigCluster() && subnetType == 2) {
                Trace.out((String)("This is big cluster. skipping existance check for public subnet=" + subnet));
                continue;
            }
            Vector<String> badNodeList = new Vector<String>();
            for (NodeInfo nodeInfo : nodeInfoList) {
                if (subnet != null) {
                    Trace.out((String)("getting all interfaces " + ifName + " on subnet " + subnet + " on node " + nodeInfo.getName()));
                    nodeIfList = nodeInfo.getInterfacesBySubnetAndName(subnet, ifName);
                } else {
                    Trace.out((String)("getting interface " + ifName + " on node " + nodeInfo.getName()));
                    nodeIfList = nodeInfo.getInterfacesByName(ifName);
                }
                if (nodeIfList.size() != 0) continue;
                badNodeList.add(nodeInfo.getName());
                Trace.out((String)("Node: " + nodeInfo.getName() + " has no '" + ifName + "' interfaces!"));
            }
            if (badNodeList.size() <= 0) continue;
            String msg = null;
            msg = subnet == null ? s_gMsgBundle.getMessage("11049", true, (Object[])new String[]{ifName, VerificationUtil.strVect2List(badNodeList)}) : s_gMsgBundle.getMessage("11050", true, (Object[])new String[]{ifName, subnet, VerificationUtil.strVect2List(badNodeList)});
            boolean bl = bWarn = subnetType != 1 && subnetType != 2;
            if (bWarn) {
                ReportUtil.printWarning(msg);
            } else {
                ReportUtil.printError(msg);
            }
            ErrorDescription errDesc = new ErrorDescription(msg);
            Trace.out((String)("Found Bad node(s): " + errDesc.getErrorMessage()));
            String[] nodeList = badNodeList.toArray(new String[badNodeList.size()]);
            if (bWarn) {
                this.m_resultSet.addResult(nodeList, 4);
            } else {
                this.m_resultSet.addResult(nodeList, 3);
            }
            this.m_resultSet.addErrorDescription(nodeList, errDesc);
            retVal = false;
        }
        return retVal;
    }

    private boolean checkForSameIPOnMultipleNICS() {
        boolean retVal = true;
        HashSet<InterfaceInfo> ifList = new HashSet<InterfaceInfo>();
        HashMap<String, Vector<InterfaceInfo>> ipAddrMap = new HashMap<String, Vector<InterfaceInfo>>();
        Vector<NodeInfo> nodeInfoList = this.getNodeInfoList();
        if (nodeInfoList == null) {
            Trace.out((String)"getNodeInfoList() retuned null");
            return false;
        }
        for (NodeInfo nodeInfo : nodeInfoList) {
            if (this.m_interfaceList != null) {
                for (int i = 0; i < this.m_interfaceList.length; ++i) {
                    String ifName = this.m_interfaceList[i];
                    String subnet = null;
                    String string = subnet = this.m_subnetList == null ? null : this.m_subnetList[i];
                    if (subnet != null) {
                        Trace.out((String)("get interfaces on node " + nodeInfo.getName() + " by subnet " + subnet + " and interface " + ifName));
                        ifList.addAll(nodeInfo.getInterfacesBySubnetAndName(subnet, ifName));
                        continue;
                    }
                    Trace.out((String)("get interfaces on node " + nodeInfo.getName() + " by interface " + ifName));
                    ifList.addAll(nodeInfo.getInterfacesByName(ifName));
                }
                continue;
            }
            Trace.out((String)("get all interfaces on node " + nodeInfo.getName()));
            ifList.addAll(nodeInfo.getInterfaceList());
        }
        for (InterfaceInfo ifInfo : ifList) {
            String ipAddr = ifInfo.getIP();
            Vector<InterfaceInfo> tmpIfList = (Vector<InterfaceInfo>)ipAddrMap.get(ipAddr);
            if (tmpIfList == null) {
                tmpIfList = new Vector<InterfaceInfo>();
                ipAddrMap.put(ipAddr, tmpIfList);
            }
            tmpIfList.add(ifInfo);
        }
        for (String ipAddr : ipAddrMap.keySet()) {
            Collection tmpIfList = (Collection)ipAddrMap.get(ipAddr);
            if (tmpIfList.size() <= 1) continue;
            StringBuilder nodes = new StringBuilder();
            StringBuilder ifs = new StringBuilder();
            for (InterfaceInfo ifInfo : tmpIfList) {
                if (nodes.length() > 0) {
                    nodes.append(',');
                }
                if (ifs.length() > 0) {
                    ifs.append(',');
                }
                nodes.append(ifInfo.getNode());
                ifs.append(ifInfo.getName());
            }
            String strIfs = ifs.toString();
            String strNodes = nodes.toString();
            String[] arrNodes = strNodes.split(",");
            String msg = s_gMsgBundle.getMessage("1172", true, (Object[])new String[]{ipAddr, strIfs, strNodes});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(arrNodes, 3);
            this.m_resultSet.addErrorDescription(arrNodes, errDesc);
            ReportUtil.printError(msg);
            retVal = false;
        }
        return retVal;
    }

    private boolean performMTUConsistencyCheck() {
        boolean retVal = true;
        Vector<NodeInfo> nodeInfoList = this.getNodeInfoList();
        if (nodeInfoList == null) {
            Trace.out((String)"getNodeInfoList() retuned null");
            return false;
        }
        Collection subnets = Subnet.classifyToSubnets(nodeInfoList);
        Collection privInrefaces = null;
        for (Subnet subnet : subnets) {
            if (this.m_subnetList != null) {
                boolean found = false;
                boolean isPrivate = false;
                for (int i = 0; i < this.m_subnetList.length; ++i) {
                    String strSubnet = this.m_subnetList[i];
                    if (!strSubnet.equals(subnet.getSubnet())) continue;
                    found = true;
                    isPrivate = this.m_subnetTypeList[i] == 1;
                    break;
                }
                if (!found) continue;
                if (isPrivate) {
                    if (privInrefaces == null) {
                        privInrefaces = subnet.getInterfaces();
                        continue;
                    }
                    privInrefaces.addAll(subnet.getInterfaces());
                    continue;
                }
            }
            Trace.out((String)("Performing mtu consistancy check for subnet :" + subnet.getSubnet()));
            retVal &= this.performMTUConsistencyCheck(subnet.getInterfaces(), false);
        }
        if (privInrefaces != null) {
            Trace.out((String)"Performing mtu consistancy check for all cluster interconnect interfaces");
            retVal &= this.performMTUConsistencyCheck(privInrefaces, true);
        }
        return retVal;
    }

    private boolean performMTUConsistencyCheck(Collection<InterfaceInfo> ifInfos, boolean isPrivate) {
        String mtuVal = null;
        boolean retVal = true;
        HashSet<String> mtuMismatchSubnets = new HashSet<String>();
        for (InterfaceInfo ifInfo : ifInfos) {
            String node = ifInfo.getNode();
            String ifName = ifInfo.getName();
            Result result = this.m_resultSet.getResult(node);
            if (result != null) {
                String collectionName = "MTU Size - " + ifName;
                if (!this.nodeInterfaceCollection.contains(node + collectionName)) {
                    this.nodeInterfaceCollection.add(node + collectionName);
                    CollectionElement mtuSize = new CollectionElement(collectionName, ifInfo.getMTU(), null, null, "MTU Size", 1);
                    result.addCollectionElement(mtuSize);
                }
            }
            mtuMismatchSubnets.add(ifInfo.getSubnet());
            if (mtuVal == null) {
                mtuVal = ifInfo.getMTU();
                continue;
            }
            if (!retVal || mtuVal.equals(ifInfo.getMTU())) continue;
            retVal = false;
        }
        if (!retVal) {
            String errMsg = null;
            if (isPrivate) {
                errMsg = s_gMsgBundle.getMessage("11061", true, mtuMismatchSubnets.toArray());
                this.m_resultSet.addResult(this.m_nodeList, 3);
            } else {
                errMsg = s_msgBundle.getMessage("6020", true, mtuMismatchSubnets.toArray());
                this.m_resultSet.addResult(this.m_nodeList, 4);
            }
            ReportUtil.printError(errMsg);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            Trace.out((String)("Different MTU values on subnets: " + ((Object)mtuMismatchSubnets).toString()));
            ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8052", false));
            for (InterfaceInfo ifInfo : ifInfos) {
                ReportUtil.surewriteRecord(ifInfo.getNode(), ifInfo.getName(), ifInfo.getIP(), ifInfo.getMTU());
            }
            ReportUtil.sureprintln(LSEP);
        }
        return retVal;
    }

    private String getNodes(ClassifierTable subnetMaskTab, Object subnetMask) {
        String nodes = null;
        Collection interfaceInfos = subnetMaskTab.getSubGroup(subnetMask);
        for (Object interfaceInfo : interfaceInfos) {
            if (nodes == null) {
                nodes = ((InterfaceInfo)interfaceInfo).getNode();
                continue;
            }
            nodes = nodes + "," + ((InterfaceInfo)interfaceInfo).getNode();
        }
        return nodes;
    }

    private Vector<NodeInfo> getNodeInfoList() {
        Vector<NodeInfo> nodeInfoList = new Vector<NodeInfo>();
        if (this.m_nodeInfoList == null) {
            MultiNodeException mne = null;
            try {
                this.m_vfyNet.getInterfaceInfo(this.m_nodeList, nodeInfoList);
            }
            catch (NetworkException ne) {
                Trace.out((String)("NETWORK EXCEPTION: " + ne.getMessage()));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
                ReportUtil.printError(ne.getMessage());
                return null;
            }
            catch (MultiNodeException mnException) {
                mne = mnException;
            }
            if (null != mne) {
                Vector okNodes = this.reportMultiNodeException(mne, this.m_nodeList);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(okNodes);
            }
            this.m_nodeInfoList = nodeInfoList;
        }
        return this.m_nodeInfoList;
    }

    private void reportVIPOkInterfaces(Subnet subnet) {
        ReportUtil.sureprintln("");
        ReportUtil.sureprintln(s_msgBundle.getMessage("4104", false, (Object[])new String[]{subnet.getSubnet()}));
        this.reportInterfacesInSubnet(subnet);
    }

    private void reportPrivateOkInterfaces(Subnet subnet) {
        ReportUtil.sureprintln("");
        ReportUtil.sureprintln(s_msgBundle.getMessage("4105", false, (Object[])new String[]{subnet.getSubnet()}));
        this.reportInterfacesInSubnet(subnet);
    }

    private void reportInterfacesInSubnet(Subnet subnet) {
        for (String node : subnet.getNodes()) {
            ReportUtil.sureprint(node);
            for (InterfaceInfo inf : subnet.getInterfacesByNode(node)) {
                ReportUtil.sureprint(" " + inf.getName() + ":" + inf.getIP());
            }
            ReportUtil.sureprintln("");
        }
    }

    private void reportNodeReach(String srcNode, String[] nodeList, boolean[] nodeConArray, String[] nodeErrorArray, boolean succ) {
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4081", false, (Object[])new String[]{srcNode}));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8004", false), s_msgBundle.getMessage("8005", false));
        for (int i = 0; i < nodeList.length; ++i) {
            ReportUtil.writeRecord(nodeList[i], this.bool2YesNo(nodeConArray[i]));
        }
        if (succ) {
            ReportUtil.printResult(s_msgBundle.getMessage("4082", false, (Object[])new String[]{srcNode}));
        } else {
            StringBuilder printNodeErr = new StringBuilder();
            for (int i = 0; i < nodeErrorArray.length; ++i) {
                if (nodeErrorArray[i] == null) continue;
                printNodeErr.append(nodeErrorArray[i] + LSEP);
            }
            if (printNodeErr.toString().length() > 0) {
                ReportUtil.sureprintln(printNodeErr.toString());
            }
            ReportUtil.printResult(s_msgBundle.getMessage("4083", false, (Object[])new String[]{srcNode}));
            if (printNodeErr.toString().length() == 0) {
                ReportUtil.printErrorNodes(this.m_resultSet);
            }
        }
    }

    private void reportBadIP(ConMatrix matrix) {
        String[] IPList = matrix.getIPList();
        String[] nodeList = matrix.getNodeList();
        String[] interfaceList = matrix.getInterfaceList();
        boolean[][] conTable = matrix.getMatrixForOutput();
        for (int i = 0; i < nodeList.length; ++i) {
            String msg;
            if (conTable[i][i]) continue;
            if (interfaceList != null) {
                msg = s_msgBundle.getMessage("4084", false, (Object[])new String[]{interfaceList[i] + " : " + IPList[i] + " [" + matrix.getKey() + "] ", nodeList[i]});
            } else {
                Trace.out((String)("Interface unavailable: " + matrix.toString()));
                msg = s_msgBundle.getMessage("4084", false, (Object[])new String[]{"<unavailable> : " + IPList[i] + " [" + matrix.getKey() + "] ", nodeList[i]});
            }
            ReportUtil.printWarning(msg);
            this.m_resultSet.addResult(nodeList[i], 4);
            Trace.out((String)("BadIP: " + msg));
        }
    }

    private void reportMatrix(ConMatrix matrix) {
        String[] IPList = matrix.getIPList();
        String[] nodeList = matrix.getNodeList();
        String[] interfaceList = matrix.getInterfaceList();
        boolean[][] conTable = matrix.getMatrixForOutput();
        boolean headerPrinted = false;
        ErrorDescription errDesc = null;
        this.reportBadIP(matrix);
        for (int i = 0; i < nodeList.length; ++i) {
            for (int j = i; j < nodeList.length; ++j) {
                if (i == j) continue;
                if (!headerPrinted) {
                    ReportUtil.writeColHeaders_2eq(s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8007", false), s_msgBundle.getMessage("8008", false));
                    headerPrinted = true;
                }
                String srcNode = null;
                String destNode = null;
                if (interfaceList != null) {
                    srcNode = nodeList[i] + " - " + interfaceList[i] + " : " + IPList[i];
                    destNode = nodeList[j] + " - " + interfaceList[j] + " : " + IPList[j];
                    ReportUtil.writeRecord_2eq(nodeList[i] + "[" + IPList[i] + "]", nodeList[j] + "[" + IPList[j] + "]", this.bool2YesNo(conTable[i][j]));
                } else {
                    srcNode = nodeList[i] + " - <unavailable> : " + IPList[i];
                    destNode = nodeList[j] + " - <unavailable> : " + IPList[j];
                    ReportUtil.writeRecord_2eq(nodeList[i] + ":" + interfaceList[i], nodeList[j] + ":" + interfaceList[j], this.bool2YesNo(conTable[i][j]));
                }
                if (conTable[i][j]) continue;
                String errMsg = s_msgBundle.getMessage("7616", true, (Object[])new String[]{matrix.getKey(), srcNode, destNode});
                ReportUtil.printError(errMsg);
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                this.m_resultSet.addResult(srcNode, 4);
                Trace.out((String)("Failed connectivity: " + errMsg));
            }
        }
    }

    private void reportTCPMatrix(TCPMatrix matrix) {
        String serverName = matrix.getServerName();
        String serverIP = matrix.getServerIP();
        String[] IPList = matrix.getClientIPList();
        String[] clientList = matrix.getClientList();
        int[] TCPstatus = matrix.getTCPConmatrix();
        boolean headerPrinted = false;
        matrix.setStatus();
        for (int i = 0; i < clientList.length; ++i) {
            Trace.out((String)("Processing: i: " + i + " server: " + serverName + ":" + serverIP + " client: " + clientList[i] + ":" + IPList[i] + " Status: " + TCPstatus[i]));
            if (serverIP.contentEquals(IPList[i]) && serverName.contentEquals(clientList[i])) continue;
            if (!headerPrinted) {
                ReportUtil.writeColHeaders_2eq(s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8007", false), s_msgBundle.getMessage("8008", false));
                headerPrinted = true;
            }
            String resStr = TCPstatus[i] == 0 ? ReportUtil.PASSED : (TCPstatus[i] == 1 ? ReportUtil.PARTIALLY_SUCCESSFUL : ReportUtil.FAILED);
            ReportUtil.writeRecord_2eq(serverName + ":" + serverIP, clientList[i] + ":" + IPList[i], resStr);
            if (TCPstatus[i] == 0) continue;
            String srcNode = serverName + " : " + serverIP;
            String destNode = clientList[i] + " : " + IPList[i];
            String errMsg = s_msgBundle.getMessage("7617", true, (Object[])new String[]{srcNode, destNode});
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(srcNode, 3);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            Trace.out((String)("Failed connectivity: " + errMsg));
        }
        if (!matrix.getServerExit()) {
            String errMsg = s_gMsgBundle.getMessage("5725", true, (Object[])new String[]{matrix.getServerPID(), matrix.getServerName()});
            ReportUtil.printError(errMsg);
            Trace.out((String)errMsg);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
        }
    }

    private String bool2YesNo(boolean t) {
        if (t) {
            return ReportUtil.YES;
        }
        return ReportUtil.NO;
    }

    private void reportIfCon(ConMatrix matrix, String inf, int numNodes) {
        this.reportMatrix(matrix);
        String msg = matrix.getStatus() == 1 && matrix.getNodeList().length >= numNodes ? s_msgBundle.getMessage("4089", false, (Object[])new String[]{inf}) : s_msgBundle.getMessage("4090", false, (Object[])new String[]{inf});
        ReportUtil.printResult(msg);
    }

    private void reportNodeCon(ConMatrix matrix) {
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4091", false, (Object[])new String[]{matrix.getKey()}));
        this.reportMatrix(matrix);
        String[] nodeList = matrix.getUniqueNodeList();
        if (matrix.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("4092", false, (Object[])new String[]{matrix.getKey(), VerificationUtil.strArr2List(nodeList)}));
        } else {
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4093", false, (Object[])new String[]{matrix.getKey()}));
            this.m_resultSet.addResult(this.m_localName, 4);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.printResult(errDesc.getErrorMessage());
        }
    }

    private void reportTCPCon(String subnet, TCPMatrix matrix) {
        ReportUtil.println(LSEP + LSEP + s_msgBundle.getMessage("4120", false, (Object[])new String[]{subnet}));
        Trace.out((String)("Results - " + matrix.toString()));
        this.reportTCPMatrix(matrix);
        if (matrix.getStatus() == 0) {
            ReportUtil.printResult(s_msgBundle.getMessage("4121", false, (Object[])new String[]{subnet}) + LSEP);
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4122", false, (Object[])new String[]{subnet}) + LSEP);
        }
    }

    public void reportNodeInfo(Vector nodeInfoList) {
        boolean mtuDiff = false;
        Object mtuVal = null;
        Object errMsg = null;
        String[] mtuSubnetData = null;
        Hashtable mtuDiffTable = new Hashtable();
        Enumeration nodeEnum = nodeInfoList.elements();
        while (nodeEnum.hasMoreElements()) {
            boolean headerPrinted = false;
            NodeInfo nodeInfo = (NodeInfo)nodeEnum.nextElement();
            Enumeration ifEnum = nodeInfo.getInterfaceList().elements();
            while (ifEnum.hasMoreElements()) {
                if (!headerPrinted) {
                    headerPrinted = true;
                    ReportUtil.println(LSEP + LSEP + s_msgBundle.getMessage("4094", false, (Object[])new String[]{nodeInfo.getName()}));
                    ReportUtil.writeColHeaders(s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false), s_msgBundle.getMessage("8050", false), s_msgBundle.getMessage("8051", false), s_msgBundle.getMessage("8049", false), s_msgBundle.getMessage("8052", false));
                }
                mtuSubnetData = new String[5];
                InterfaceInfo inf = (InterfaceInfo)ifEnum.nextElement();
                String infsubnet = inf.getSubnet();
                ReportUtil.writeRecord(inf.getName(), inf.getIP(), inf.getSubnet(), inf.getGateway(), inf.getDefGateway(), inf.getHWAddr(), inf.getMTU());
            }
        }
    }

    private Vector reportMultiNodeException(MultiNodeException mne, String[] nodeList) {
        Vector<String> goodNodes = new Vector<String>();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            Collection throwables = mne.getThrowables(this.m_nodeList[i]);
            if (null == throwables) {
                goodNodes.add(this.m_nodeList[i]);
                continue;
            }
            this.m_resultSet.addResult(this.m_nodeList[i], 2);
            StringBuffer errMsg = new StringBuffer();
            errMsg.append(s_msgBundle.getMessage("4087", false));
            for (Throwable t : throwables) {
                String thrwMsg = t.getMessage();
                if (thrwMsg == null || thrwMsg.length() <= 0) continue;
                errMsg.append(LSEP + thrwMsg);
            }
            String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{this.m_nodeList[i]});
            String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{this.m_nodeList[i]});
            this.m_resultSet.getResult(this.m_nodeList[i]).addErrorDescription(new ErrorDescription(errMsg.toString(), cause, action));
            Trace.out((String)("MULTINODEEXCEPTION: for node '" + this.m_nodeList[i] + "'\n" + errMsg.toString()));
            VerificationLogData.logError("MULTINODEEXCEPTION: for node '" + this.m_nodeList[i] + "'\n" + errMsg.toString());
        }
        return goodNodes;
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_taskType == 0) {
            return s_msgBundle.getMessage("4402", false);
        }
        return s_msgBundle.getMessage("4401", false);
    }

    @Override
    public String getTaskID() {
        if (this.m_taskType == 0) {
            return "NODE_CONN";
        }
        return "NODE_REACH";
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_taskType == 0) {
            if (this.m_subnetList != null) {
                return s_msgBundle.getMessage("4534", false, (Object[])new String[]{VerificationUtil.strArr2List(this.m_subnetList)});
            }
            return s_msgBundle.getMessage("4452", false);
        }
        return s_msgBundle.getMessage("4451", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    InterfaceList: " + VerificationUtil.strArr2List(this.m_interfaceList));
        sb.append("\n    IPAddressList: " + VerificationUtil.strArr2List(this.m_IPAddrList));
        sb.append("\n    TaskType: " + (this.m_taskType == 0 ? "NODECON" : NODEREACH_KEY));
        sb.append("\n    SourceNode: " + this.m_srcNode);
        return sb.toString();
    }

    public void getNodeConnAPIData(List subnetList) {
        ArrayList<SubnetAndInterfaceInfoImpl> allSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        ArrayList<SubnetAndInterfaceInfoImpl> vipSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        ArrayList<SubnetAndInterfaceInfoImpl> privateSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        Trace.out((String)("subnetList.size(): " + subnetList.size() + " \n"));
        for (int j = 0; j < subnetList.size(); ++j) {
            String action;
            String cause;
            String errMsg;
            InetAddress inetAddr = null;
            InetAddress inetAddrSubnet = null;
            InetAddress inetAddrSubnet2 = null;
            InterfaceInfo inf2 = null;
            int netType = 4;
            ArrayList<NetworkInterfaceInfoImpl> interfaceInfo = new ArrayList<NetworkInterfaceInfoImpl>();
            Subnet subnet = (Subnet)subnetList.get(j);
            String subnetName = subnet.getSubnet();
            Trace.out((String)("Subnet: #" + j + " Name: " + subnetName));
            try {
                inetAddrSubnet = InetAddress.getByName(subnetName);
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)"Subnet: Unknown Host Exception... \n");
                errMsg = s_msgBundle.getMessage("6013", false);
                cause = s_msgBundle.getMessage("6014", false, (Object[])new String[]{subnetName});
                action = s_msgBundle.getMessage("6016", false, (Object[])new String[]{subnetName});
                Trace.out((String)errMsg);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                this.m_resultSet.addResult(this.m_nodeList, 2);
            }
            for (InterfaceInfo inf2 : subnet.getInterfaces()) {
                try {
                    inetAddrSubnet2 = InetAddress.getByName(inf2.getNetMask());
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)"Mask: Unknown Host Exception... \n");
                    errMsg = s_msgBundle.getMessage("6013", false);
                    cause = s_msgBundle.getMessage("6015", false, (Object[])new String[]{inf2.getNetMask()});
                    action = s_msgBundle.getMessage("6016", false, (Object[])new String[]{subnetName});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                    Trace.out((String)errMsg);
                    this.m_resultSet.addResult(this.m_localName, 4);
                }
                Trace.out((String)("Interface Name: " + inf2.getName() + " Type: " + inf2.getNetType()));
                netType = inf2.getNetType();
                try {
                    inetAddr = InetAddress.getByName(inf2.getIP());
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)"IP: Unknown Host Exception... \n");
                    errMsg = s_msgBundle.getMessage("6013", false);
                    cause = s_msgBundle.getMessage("6017", false, (Object[])new String[]{inf2.getIP()});
                    action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{inf2.getNode()});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                    Trace.out((String)errMsg);
                    this.m_resultSet.addResult(this.m_localName, 4);
                }
                NetworkInterfaceInfoImpl newInterface = new NetworkInterfaceInfoImpl(inf2.getName(), inetAddr, inf2.getNode());
                interfaceInfo.add(newInterface);
            }
            Trace.out((String)("Number of Interface's: " + interfaceInfo.size()));
            SubnetAndInterfaceInfoImpl newSubnet = new SubnetAndInterfaceInfoImpl(inetAddrSubnet.getAddress(), inetAddrSubnet2.getAddress(), netType, interfaceInfo);
            allSubAndInterfaceInfo.add(newSubnet);
            if (newSubnet.getSubnetType() == 1) {
                privateSubAndInterfaceInfo.add(newSubnet);
                continue;
            }
            vipSubAndInterfaceInfo.add(newSubnet);
        }
        this.m_nodeConResSetImpl.setVIPInterfaces(vipSubAndInterfaceInfo);
        this.m_nodeConResSetImpl.setPrivateInterfaces(privateSubAndInterfaceInfo);
        this.m_nodeConResSetImpl.setAvailableSubnets(allSubAndInterfaceInfo);
        if (allSubAndInterfaceInfo == null) {
            ErrorDescription errDesc = new ErrorDescription("6005", s_msgBundle);
            Trace.out((String)("No subnet or interface info. \n" + errDesc.getErrorMessage()));
            this.m_resultSet.addResult(this.m_localName, 4);
            this.m_resultSet.addErrorDescription(errDesc);
        } else if (vipSubAndInterfaceInfo == null) {
            ErrorDescription errDesc = new ErrorDescription("4101", s_msgBundle);
            Trace.out((String)("No VIP subnet or interface info. \n" + errDesc.getErrorMessage()));
            this.m_resultSet.addResult(this.m_localName, 4);
            this.m_resultSet.addErrorDescription(errDesc);
        } else if (privateSubAndInterfaceInfo == null) {
            ErrorDescription errDesc = new ErrorDescription("4102", s_msgBundle);
            Trace.out((String)("No private subnet or interface info. \n" + errDesc.getErrorMessage()));
            this.m_resultSet.addResult(this.m_localName, 4);
            this.m_resultSet.addErrorDescription(errDesc);
        }
    }

    private boolean isRolling() {
        String isROLLING_value = VerificationUtil.getVariableValue("ISROLLING");
        return isROLLING_value != null && isROLLING_value.equalsIgnoreCase("true");
    }

    private boolean performPrivateIPSubnetCheckForUpgrade() {
        Trace.out((String)"Performing check to verify if private IP addresses retrieved using OLSNODES fall into the same private subnet of an existing configuration");
        boolean result = true;
        List<OIFCFGResult> cluIfs = null;
        HashMap nodePrivateHostMap = null;
        ClusterwareInfo cluInfo = new ClusterwareInfo();
        String crsHome = VerificationUtil.getCRSHome();
        String oifcfgLoc = crsHome + FSEP + "bin";
        try {
            OIFCFGUtil oifcfgUtil = new OIFCFGUtil(oifcfgLoc);
            List oifcfgInterfaceList = cluInfo.listInterfaces(this.m_nodeList[0], oifcfgLoc, false);
            String strCrsVer = VerificationUtil.getCRSReleaseVersion(crsHome, false);
            Version crsVer = VerificationUtil.getVersionObject(strCrsVer);
            List tmpOifcfgResultList = cluInfo.listClusterInterfaces(oifcfgLoc, crsVer);
            cluIfs = VerificationUtil.resolveSubNetMask(tmpOifcfgResultList, oifcfgInterfaceList, oifcfgUtil);
            nodePrivateHostMap = cluInfo.getClusterPrivateHostnames(crsHome);
        }
        catch (InstallException ie) {
            Trace.out((String)("Caught InstallException, Could not run command tool. Error is " + ie.getMessage()));
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true) + VerificationConstants.LINE_SEPARATOR + ie.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("Caught InstallException, Could not run command tool. Error is " + e.getMessage()));
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true) + VerificationUtil.LINE_SEPARATOR + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Caught ConfigurationException while getting crsVer. Error is " + ce.getMessage()));
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1512", true) + VerificationConstants.LINE_SEPARATOR + ce.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Hashtable<InetAddress, InetAddress> privateSubnetAndMasktable = new Hashtable<InetAddress, InetAddress>();
        Trace.out((String)("Retrieved total " + cluIfs.size() + " if objects"));
        for (OIFCFGResult ifObj : cluIfs) {
            boolean isPrivate = ifObj.getInterfaceType().toLowerCase().contains("cluster_interconnect");
            boolean isGlobal = ifObj.getNodeScope().equalsIgnoreCase("global");
            if (!isPrivate || !isGlobal) continue;
            Trace.out((String)("adding subnet:" + ifObj.getSubnet() + ", mask:" + ifObj.getSubnetMask() + " to privateSubnetAndMasktable"));
            privateSubnetAndMasktable.put(ifObj.getSubnet(), ifObj.getSubnetMask());
        }
        block7: for (String node : this.m_nodeList) {
            String privateHostForNode = null;
            if (nodePrivateHostMap.containsKey(node)) {
                privateHostForNode = (String)nodePrivateHostMap.get(node);
            }
            InetAddress[] nodePrivateIpArray = null;
            if (privateHostForNode != null && privateHostForNode.trim().length() > 0) {
                try {
                    nodePrivateIpArray = InetAddress.getAllByName(privateHostForNode);
                }
                catch (UnknownHostException e) {
                    Trace.out((String)("Failed to retrieve the IP address for node " + node + " with private host name " + privateHostForNode));
                    String errMsg = s_gMsgBundle.getMessage("1171", true, (Object[])new String[]{privateHostForNode, node});
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    this.m_resultSet.addResult(node, 3);
                    ReportUtil.sureprintln(errMsg);
                    result = false;
                    continue;
                }
            }
            if (privateSubnetAndMasktable.isEmpty() || nodePrivateIpArray == null || nodePrivateIpArray.length == 0 || privateHostForNode == null) {
                Trace.out((String)"Either the private IP, private subnet or private subnet mask is found to be null or empty");
                String errMsg = s_gMsgBundle.getMessage("1513", true, (Object[])new String[]{node});
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(node, 3);
                ReportUtil.sureprintln(errMsg);
                result = false;
                continue;
            }
            for (InetAddress nodePrivateIp : nodePrivateIpArray) {
                if (!this.checkPrivateIPWithSubnet(nodePrivateIp, privateSubnetAndMasktable)) {
                    Trace.out((String)("The private hostname " + privateHostForNode + " with IP " + nodePrivateIp.toString() + " is not part of any private subnets currently configured "));
                    this.m_resultSet.addResult(node, 3);
                    String errMsg = s_gMsgBundle.getMessage("1170", true, (Object[])new String[]{privateHostForNode, nodePrivateIp.toString(), node});
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    ReportUtil.sureprintln(errMsg);
                    result = false;
                    continue block7;
                }
                Trace.out((String)("The private hostname " + privateHostForNode + " with IP " + nodePrivateIp.toString() + " is part of one of the configured private subnet "));
            }
        }
        return result;
    }

    private boolean checkPrivateIPWithSubnet(InetAddress privateIP, Hashtable<InetAddress, InetAddress> privateSubnetAndMaskTable) {
        int i = 0;
        boolean result = false;
        Set<InetAddress> privateSubnetSet = privateSubnetAndMaskTable.keySet();
        for (InetAddress subnet : privateSubnetSet) {
            byte[] netmaskBytes;
            InetAddress subnetMask = privateSubnetAndMaskTable.get(subnet);
            byte[] privateIpBytes = privateIP.getAddress();
            if (privateIpBytes.length != (netmaskBytes = subnetMask.getAddress()).length) {
                Trace.out((String)("privateIP(name=" + privateIP.getHostName() + ",IP=" + privateIP.getHostAddress() + ") and subnet=" + subnet + ",netmask=" + subnetMask + " are not same type of address family"));
                result = false;
            }
            byte[] privateIpSubnet = new byte[privateIpBytes.length];
            for (i = 0; i < privateIpBytes.length; ++i) {
                privateIpSubnet[i] = (byte)(privateIpBytes[i] & netmaskBytes[i]);
            }
            byte[] ifSubnet = subnet.getAddress();
            for (i = 0; i < privateIpSubnet.length && privateIpSubnet[i] == ifSubnet[i]; ++i) {
            }
            if (i != privateIpSubnet.length) continue;
            Trace.out((String)("privateIP(name=" + privateIP.getHostName() + ",IP=" + privateIP.getHostAddress() + ") and subnet=" + subnet + ",netmask=" + subnetMask + " are same type of address family and hence returning true"));
            return true;
        }
        return result;
    }
}

