/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.GetSpaceCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;
import oracle.ops.verification.util.MultiNodeException;

public class TaskOCRIntegrity
extends Task
implements CVUHelperConstants {
    public static final String OCR_VERSION = "Version";
    public static final String OCR_TOTAL_SPACE = "TotalSpace";
    public static final String OCR_ID = "ID";
    public static final String OCR_INTEGRITY = "Integrity";
    public static final String OCR_DEVICESTATUS = "DeviceStatus";
    public static final String OCR_INTEGRITY_TRUE = "True";
    public static final String OCR_INTEGRITY_FALSE = "False";
    private static boolean s_unix = new SystemFactory().CreateSystem().isUnixSystem();
    private static final String FILE_STATUS_FAILED = "1";
    private final int VERIFICATION_FAIL = 2;
    private final int OPERATION_FAIL = 1;
    private final int OPERATION_SUCC = 0;
    private boolean isPreReq = false;
    String[] ocrLocArr = null;
    private String OCR_VALID_STORAGE_HELPER = "-isValidOCRStorage";
    private boolean m_rolling;
    private boolean m_upgrade;
    private String m_destinationVersion;
    private static final String s_ExecutableNotFoundException = "oracle.ops.verification.util.ExecutableNotFoundException";

    public TaskOCRIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOCRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOCRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setPreReq(boolean isPreReq) {
        this.isPreReq = isPreReq;
    }

    public void setOcrLocArr(String[] ocrLoc) {
        this.ocrLocArr = ocrLoc;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing OCR Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4039", false));
        if (this.m_nodeList != null && this.m_nodeList.length > 0 && this.ocrLocArr != null && this.ocrLocArr.length > 0) {
            List<String> deviceList = Arrays.asList(this.ocrLocArr);
            Result resolveDiskRes = new Result(this.m_nodeList[0]);
            deviceList = VerificationUtil.resolveASMDiskStamps(this.m_nodeList[0], deviceList, resolveDiskRes);
            if (resolveDiskRes.getStatus() != 1 || deviceList == null) {
                this.m_resultSet.addResult(this.m_nodeList[0], resolveDiskRes);
                Trace.out((String)"Failed to resolve one or more of the ASM stamps to the real device path");
                return false;
            }
            this.ocrLocArr = deviceList.toArray(new String[0]);
        }
        this.m_resultSet.setStatus(1);
        if (this.isPreReq) {
            this.performPreOCRIntegrityChecks();
        } else {
            this.performOCRIntegrityChecks();
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4207", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4208", false));
        return false;
    }

    void performPreOCRIntegrityChecks() {
        String new_ocrLoc = null;
        for (String ocrLoc : this.ocrLocArr) {
            String mesg;
            Hashtable<Object, Vector<Object>> checkPath = new Hashtable<Object, Vector<Object>>();
            Hashtable<Object, Vector<Object>> checkType = new Hashtable<Object, Vector<Object>>();
            Vector<StorageInfo> listStInfo = new Vector<StorageInfo>();
            if (!s_unix) {
                Vector<String> succNodes = new Vector<String>();
                Vector<String> failNodes = new Vector<String>();
                String drvPath = ocrLoc.substring(0, ocrLoc.indexOf(FSEP) + 1);
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                boolean pExist = VerificationUtil.pathExists(this.m_nodeList, drvPath, 0, succNodes, failNodes);
                if (succNodes.size() == 0) continue;
            }
            if (VerificationUtil.isASMPath(ocrLoc)) {
                Trace.out((String)("Found ocr location '" + ocrLoc + "' on ASM"));
                continue;
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("10030", false, (Object[])new String[]{ocrLoc}) + LSEP);
            for (String nodeName : this.m_nodeList) {
                try {
                    StorageInfo sInfo = new TypeFinder().getStorageInstance(ocrLoc, nodeName);
                    listStInfo.add(sInfo);
                }
                catch (StorageException e1) {
                    Trace.out((String)("StorageException encountered: " + e1));
                    Trace.out((String)("Path does not exist " + ocrLoc + " on node " + nodeName));
                    mesg = s_msgBundle.getMessage("10037", true, (Object[])new String[]{ocrLoc, nodeName});
                    mesg = mesg + LSEP + e1.getMessage();
                    ErrorDescription errorDesc = new ErrorDescription(mesg);
                    this.m_resultSet.addErrorDescription(errorDesc);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    ReportUtil.printError(mesg + LSEP);
                }
            }
            for (int i = 0; i < listStInfo.size(); ++i) {
                StorageInfo sInfo = (StorageInfo)listStInfo.get(i);
                if (sInfo.getType() != 1) {
                    new_ocrLoc = sInfo.getPath();
                    if (null != sInfo.getPath()) {
                        VerificationUtil.updateResultMap(checkPath, sInfo.getPath(), sInfo.getNode());
                    }
                } else {
                    new_ocrLoc = sInfo.getOrigPath();
                    if (null != sInfo.getOrigPath()) {
                        VerificationUtil.updateResultMap(checkPath, sInfo.getOrigPath(), sInfo.getNode());
                    }
                }
                VerificationUtil.updateResultMap(checkType, sInfo.getType(), sInfo.getNode());
            }
            if (checkPath.size() > 1) {
                Trace.out((String)"OCR Path is not same on all the nodes.");
                Enumeration e = checkPath.keys();
                StringBuffer detailMsg = new StringBuffer();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String nodeLst = ((Object)checkPath.get(key)).toString();
                    Trace.out((String)("OCR Path is " + key + "on nodes " + nodeLst));
                    detailMsg = detailMsg.append(s_gMsgBundle.getMessage("1014", false, (Object[])new String[]{key, nodeLst}) + LSEP);
                }
                mesg = s_msgBundle.getMessage("10035", true, (Object[])new String[]{ocrLoc}) + LSEP + detailMsg;
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                this.m_resultSet.addErrorDescription(errorDesc);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ReportUtil.printError(mesg);
                continue;
            }
            if (checkType.size() > 1) {
                Trace.out((String)"OCR storage type is not consistent across all the ndoes.");
                Enumeration e = checkType.keys();
                while (e.hasMoreElements()) {
                    int key = (Integer)e.nextElement();
                    Trace.out((String)("OCR Path is " + key + "on nodes " + ((Object)checkType.get(key)).toString()));
                }
                mesg = s_msgBundle.getMessage("10036", true, (Object[])new String[]{ocrLoc});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                this.m_resultSet.addErrorDescription(errorDesc);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ReportUtil.printError(mesg + LSEP);
                continue;
            }
            if (checkPath.size() != 1 || checkType.size() != 1) continue;
            if (new_ocrLoc != null) {
                ocrLoc = new_ocrLoc;
            }
            Enumeration e = checkType.keys();
            int storageType = (Integer)e.nextElement();
            if (VerificationUtil.isVersionPost(this.m_destinationVersion, "12") && 1 == storageType) {
                mesg = s_gMsgBundle.getMessage("6000", true, (Object[])new String[]{ocrLoc});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                this.m_resultSet.addErrorDescription(errorDesc);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ReportUtil.printError(mesg + LSEP);
                continue;
            }
            String softwareVersion = VerificationUtil.getCRSSoftwareVersion(this.m_nodeList[0]);
            if (!VerificationUtil.isVersionPre(softwareVersion, "11.2.0.2")) {
                Trace.out((String)"about to check if ocr storage type is valid storage type");
                ResultSet validRsltSet = new ResultSet();
                if (!this.isPreReq && !this.isValidStorage(this.m_nodeList, ocrLoc, validRsltSet)) {
                    Trace.out((String)"uploading resultset");
                    this.m_resultSet.uploadResultSet(validRsltSet);
                    continue;
                }
            } else {
                Trace.out((String)"skipping ocr location validity check");
            }
            boolean verifySharedness = true;
            Trace.out((String)("_st_ = " + storageType));
            switch (storageType) {
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    verifySharedness = false;
                }
            }
            if (!verifySharedness) {
                Trace.out((String)("not checking sharedness for " + ocrLoc));
                continue;
            }
            ResultSet ocrSharednessRS = new ResultSet();
            this.performOCRSharednessCheck(this.m_nodeList, ocrLoc, ocrSharednessRS, "12.1");
            Trace.out((String)"uploading resultset");
            this.m_resultSet.uploadResultSet(ocrSharednessRS);
            if (ocrSharednessRS.anyFailure()) continue;
            StorageInfo stInfo = (StorageInfo)listStInfo.get(0);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4163", false, (Object[])new String[]{ocrLoc}) + LSEP);
            ResultSet ocrSizeRS = new ResultSet();
            Trace.out((String)("\nNodes: " + VerificationUtil.strArr2List(this.m_nodeList) + "\nocrLocation: " + ocrLoc + "\nStorageType: " + storageType));
            this.performOCRSizeCheck(this.m_nodeList, ocrLoc, stInfo, ocrSizeRS, null);
            Trace.out((String)"uploading resultset");
            this.m_resultSet.uploadResultSet(ocrSizeRS);
        }
    }

    void performOCRIntegrityChecks() {
        ErrorDescription errDesc;
        ResultSet ocrCheckResultSet = new ResultSet();
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        GlobalExecution globalExec = new GlobalExecution();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        if (validNodeArr == null || validNodeArr.length == 0) {
            return;
        }
        ResultSet isLocalOnlyResultSet = new ResultSet();
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4040", false));
        succNodeVect.clear();
        failNodeVect.clear();
        boolean isLocalOnlyResult = globalExec.checkIsLocalOnly(validNodeArr, isLocalOnlyResultSet);
        Trace.out((String)"\n>>>> TaskOCRIntegrity:: Upload isLocalOnlyResultSet >>>>\n");
        this.m_resultSet.uploadResultSet(isLocalOnlyResultSet);
        Trace.out((String)"AFTER CSS multi-instance verification ... ");
        Hashtable t = isLocalOnlyResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) continue;
            boolean isLocalOnly = (Boolean)result.getResultInfoSet().firstElement();
            if (isLocalOnly) {
                failNodeVect.add(node);
                Trace.out((String)("CSS is probably configured as Local Instance Only on node: " + node));
                continue;
            }
            succNodeVect.add(node);
            Trace.out((String)("CSS correctly configured for multi Instance on node: " + node));
        }
        if (failNodeVect.size() != 0) {
            if (succNodeVect.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4041", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                this.m_resultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc2 = new ErrorDescription("4041", s_msgBundle);
                this.m_resultSet.addErrorDescription(errDesc2);
                for (int i = 0; i < validNodeArr.length; ++i) {
                    String node = validNodeArr[i];
                    errDesc2 = new ErrorDescription(s_msgBundle.getMessage("7596", true, (Object[])new String[]{node}), s_msgBundle, "7596");
                    this.m_resultSet.addErrorDescription(node, errDesc2);
                }
                return;
            }
            ReportUtil.printWarning(s_msgBundle.getMessage("4042", false));
            ReportUtil.sureprintNodelist(failNodeVect);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(succNodeVect);
            String[] invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
            if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                this.m_resultSet.addResult(invalidNodeArr, 2);
                for (int i = 0; i < invalidNodeArr.length; ++i) {
                    String node = invalidNodeArr[i];
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7596", true, (Object[])new String[]{node}), s_msgBundle, "7596");
                    this.m_resultSet.addErrorDescription(node, errDesc);
                }
            }
            validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4200", false) + LSEP);
        }
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            errDesc = new ErrorDescription("5300", s_msgBundle);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        Version activeVersion = VerificationUtil.getCRSActiveVersionObj();
        String crsHome = VerificationUtil.getCRSHome();
        if (this.m_nodeMgr.isBigCluster()) {
            String[] validHubNodes = null;
            try {
                validHubNodes = this.m_nodeMgr.getNodes(validNodeArr, NodeRoleCapability.HUB_CAPABLE);
            }
            catch (NoSuchNodesException nsnEx) {
                Trace.out((String)("No HUB nodes among " + VerificationUtil.strArr2List(validNodeArr) + ". skiping OCRIntegrityChecks. "));
                return;
            }
            catch (NodeManagerException nmEx) {
                String msg = nmEx.getMessage();
                Trace.out((String)("NodeManagerException occured. mesg" + msg));
                ReportUtil.printError(msg);
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.m_resultSet.setStatus(2);
                return;
            }
            validNodeArr = validHubNodes;
            Trace.out((String)("validHubNodes=" + VerificationUtil.strArr2List(validHubNodes)));
        }
        String ocrConfigLocation = nativeSystem.getConfigLocation(activeVersion);
        boolean ocrOnASM = false;
        ResultSet resultSet = new ResultSet();
        String[] ocrLocations = VerificationUtil.getOCRLocations(activeVersion, resultSet);
        if (resultSet.getStatus() != 1 || ocrLocations == null || ocrLocations.length == 0) {
            String msg = s_msgBundle.getMessage("5196", true);
            ReportUtil.printError(msg);
            this.m_resultSet.addErrorDescription(new ErrorDescription("5196", s_msgBundle));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        CollectionElement ocrlocationElement = new CollectionElement(s_gMsgBundle.getMessage("11607", false), VerificationUtil.strArr2List(ocrLocations), null, null, "", 1);
        resultSet.addCollectionElement(ocrlocationElement);
        for (String ocrLocation : ocrLocations) {
            if (ocrLocation == null || !VerificationUtil.isASMPath(ocrLocation)) continue;
            ocrOnASM = true;
            break;
        }
        Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT = new Hashtable<String, List<ASMDiskGroup>>();
        if (ocrOnASM) {
            ASMDiskGroupsUtil dgutil = new ASMDiskGroupsUtil();
            try {
                dgutil.getDiskGroups(validNodeArr, this.m_resultSet, asmDiskGroupHT);
            }
            catch (ASMDiskGroupsUtilException e2) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5131", true) + LSEP + e2.getMessage());
                this.m_resultSet.setStatus();
                return;
            }
        }
        if (s_unix) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4173", false, (Object[])new String[]{ocrConfigLocation}));
            ResultSet ocrConfigLocRS = new ResultSet();
            this.performOCRLocCheck(validNodeArr, ocrConfigLocation, ocrConfigLocRS);
            Trace.out((String)"uploading resultset");
            this.m_resultSet.uploadResultSet(ocrConfigLocRS);
        }
        ResultSet ocrConfigRS = new ResultSet();
        this.performOCRConfigurationChecks(validNodeArr, ocrConfigLocation, ocrLocations, ocrConfigRS, asmDiskGroupHT);
        Trace.out((String)"uploading resultset");
        this.m_resultSet.uploadResultSet(ocrConfigRS);
        String softwareVersion = VerificationUtil.getCRSSoftwareVersion(this.m_nodeList[0]);
        for (String ocrLocation : ocrLocations) {
            if (ocrLocation == null) continue;
            if (VerificationUtil.isASMPath(ocrLocation)) {
                Trace.out((String)("OCR Location is on ASM: '" + ocrLocation + "'"));
                continue;
            }
            Trace.out((String)("Checking storage/sharedness for OCR Location: '" + ocrLocation + "'"));
            boolean verifySharedness = true;
            StorageInfo stInfo = null;
            try {
                stInfo = new TypeFinder().getStorageInstance(ocrLocation);
            }
            catch (StorageException e1) {
                Trace.out((String)("StorageException encountered: \n" + e1.getMessage()));
                String mesg = s_msgBundle.getMessage("4125", true, (Object[])new String[]{ocrLocation});
                mesg = mesg + LSEP + e1.getMessage();
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                this.m_resultSet.addErrorDescription(errorDesc);
                this.m_resultSet.addResult(validNodeArr, 2);
                ReportUtil.printError(mesg + LSEP);
                continue;
            }
            if (stInfo.isPolicySet() || stInfo.isLockSet()) {
                String msgID = stInfo.isPolicySet() ? "7037" : "7038";
                String policyErrMsg = LSEP + s_msgBundle.getMessage(msgID, true, (Object[])new String[]{ocrLocation}) + stInfo.getNode();
                ReportUtil.printError(policyErrMsg);
                errDesc = new ErrorDescription(policyErrMsg);
                this.m_resultSet.addErrorDescription(errDesc);
            }
            if (!VerificationUtil.isVersionPre(softwareVersion, "11.2.0.2")) {
                ResultSet validRsltSet = new ResultSet();
                ReportUtil.sureprintln(s_msgBundle.getMessage("10030", false, (Object[])new String[]{ocrLocation}) + LSEP);
                Trace.out((String)"checking if ocr storage location is valid");
                if (!this.isValidStorage(validNodeArr, ocrLocation, validRsltSet)) {
                    Trace.out((String)"uploading resultset");
                    this.m_resultSet.uploadResultSet(validRsltSet);
                    continue;
                }
                Trace.out((String)"uploading resultset");
                this.m_resultSet.uploadResultSet(validRsltSet);
            } else {
                Trace.out((String)"skipping ocr storage location check");
            }
            int storageType = stInfo.getType();
            Trace.out((String)("_st_ = " + stInfo.getType()));
            switch (storageType) {
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 13: {
                    break;
                }
                default: {
                    verifySharedness = false;
                }
            }
            if (!verifySharedness) {
                Trace.out((String)("not checking sharedness for " + ocrLocation));
                continue;
            }
            ResultSet ocrSharednessRS = new ResultSet();
            this.performOCRSharednessCheck(validNodeArr, ocrLocation, ocrSharednessRS, softwareVersion);
            Trace.out((String)"uploading resultset");
            this.m_resultSet.uploadResultSet(ocrSharednessRS);
            if (ocrSharednessRS.anyFailure()) continue;
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4163", false, (Object[])new String[]{ocrLocation}) + LSEP);
            ResultSet ocrSizeRS = new ResultSet();
            Trace.out((String)("\nNodes: " + VerificationUtil.strArr2List(validNodeArr) + "\nocrLocation: " + ocrLocation + "\nStorageType: " + storageType + "\nasmDiskGroupHT: " + asmDiskGroupHT.toString() + "\n"));
            this.performOCRSizeCheck(validNodeArr, ocrLocation, stInfo, ocrSizeRS, asmDiskGroupHT);
            Trace.out((String)"uploading resultset");
            this.m_resultSet.uploadResultSet(ocrSizeRS);
        }
        String ocrBackupLocation = this.getOCRBackupLocation(crsHome, validNodeArr[0]);
        if (ocrBackupLocation != null) {
            ResultSet ocrBackupCheckResultSet = new ResultSet();
            this.performOCRBackupLocationCheck(validNodeArr, ocrBackupLocation, ocrBackupCheckResultSet, asmDiskGroupHT);
            Trace.out((String)"uploading resultset");
            this.m_resultSet.uploadResultSet(ocrBackupCheckResultSet);
        }
        ResultSet ocrDumpResultSet = new ResultSet();
        ArrayList<String> ocrDumpNodeList = new ArrayList<String>();
        ocrDumpNodeList.addAll(Arrays.asList(validNodeArr));
        this.performOCRDumpCheck(crsHome, ocrDumpNodeList.toArray(new String[0]), ocrDumpResultSet);
        Trace.out((String)"uploading resultset");
        this.m_resultSet.uploadResultSet(ocrDumpResultSet);
        if (!s_unix || VerificationUtil.isVersionPre(activeCRSVer, "11.2") || RootAutomationUtility.isRootExecutionConfigured()) {
            Trace.out((String)("performing ocr check based checks. Unix " + s_unix + " active version " + activeCRSVer + " root configured " + RootAutomationUtility.isRootExecutionConfigured()));
            this.performOcrcheckBasedChecks(validNodeArr, activeCRSVer, ocrCheckResultSet);
            Trace.out((String)"uploading resultset");
            this.m_resultSet.uploadResultSet(ocrCheckResultSet);
        } else if (this.m_resultSet.allSuccess()) {
            ReportUtil.printNote(s_msgBundle.getMessage("4197", false));
        }
    }

    private void performOCRSizeCheck(String[] nodeList, String ocrLocation, StorageInfo stInfo, ResultSet resultSet, Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT) {
        int nodeCount = 1;
        Command[] cmdArray = new Command[nodeCount];
        String version = this.m_destinationVersion;
        StorageSize totalSpace = new StorageSize(0.0, StorageUnit.BYTE);
        if (version == null) {
            version = new Version().toString();
        }
        StorageSize requiredOCRSize = new StorageSize(Long.parseLong(VDMUtil.getDefaultOcrSize(version)), StorageUnit.KBYTE);
        if (stInfo.getSize() != null) {
            Trace.out((String)("Size in stInfo: " + stInfo.getSize().sizeIn(null)));
        } else {
            Trace.out((String)"stInfo does NOT contain size information.");
        }
        if (stInfo.getType() == 13 || stInfo.getSize() == null || stInfo.getSize().sizeIn(null) == 0.0) {
            if (stInfo.getType() == 13) {
                for (String node : nodeList) {
                    List<ASMDiskGroup> dgl = asmDiskGroupHT.get(node);
                    boolean founddg = false;
                    if (dgl != null && dgl.size() > 0) {
                        for (ASMDiskGroup dg1 : dgl) {
                            String mesg;
                            if (!ocrLocation.equalsIgnoreCase("+" + dg1.getName())) continue;
                            founddg = true;
                            totalSpace = dg1.getSize();
                            Trace.out((String)("OCR size required=" + requiredOCRSize + " available=" + totalSpace));
                            if (totalSpace.compareTo(requiredOCRSize) >= 0) {
                                mesg = s_msgBundle.getMessage("4161", false, (Object[])new String[]{ocrLocation});
                                ReportUtil.sureprintln(node + ":" + mesg);
                                resultSet.addResult(nodeList, 1);
                                String sizeDesc = s_gMsgBundle.getMessage("11604", false);
                                CollectionElement sizeElement = new CollectionElement(sizeDesc + " [" + ocrLocation + "]", null, ReportUtil.unitizeSize(requiredOCRSize, 1), null, "OCR Size", 1);
                                resultSet.addCollectionElement(node, sizeElement);
                                continue;
                            }
                            mesg = s_msgBundle.getMessage("4164", true, (Object[])new String[]{ocrLocation, ReportUtil.unitizeSize(requiredOCRSize, 1), ReportUtil.unitizeSize(totalSpace, 1)});
                            ErrorDescription errorDesc = new ErrorDescription(mesg);
                            resultSet.addErrorDescription(errorDesc);
                            resultSet.addResult(nodeList, 3);
                            ReportUtil.printError(node + ":" + mesg + LSEP);
                        }
                    }
                    if (founddg) continue;
                    String mesg = s_msgBundle.getMessage("4162", true, (Object[])new String[]{ocrLocation});
                    ErrorDescription errorDesc = new ErrorDescription(mesg);
                    resultSet.addErrorDescription(errorDesc);
                    resultSet.addResult(nodeList, 2);
                    ReportUtil.printError(mesg + LSEP);
                }
            } else {
                String locationTocheck = ocrLocation;
                File ocrFile = new File(locationTocheck);
                int storageType = stInfo.getType();
                if (!(s_unix || storageType != 5 && storageType != 7 || ocrFile.isDirectory())) {
                    try {
                        stInfo = new TypeFinder().getStorageInstance(ocrFile.getParent());
                        locationTocheck = ocrFile.getParent();
                    }
                    catch (StorageException e1) {
                        Trace.out((String)("StorageException encountered: " + e1));
                        String mesg = s_msgBundle.getMessage("4125", true, (Object[])new String[]{ocrLocation}) + LSEP + e1.getMessage();
                        ErrorDescription errorDesc = new ErrorDescription(mesg);
                        this.m_resultSet.addErrorDescription(errorDesc);
                        this.m_resultSet.addResult(nodeList, 2);
                        ReportUtil.printError(mesg + LSEP);
                        return;
                    }
                }
                for (int i = 0; i < nodeCount; ++i) {
                    if (!s_unix && stInfo.getType() == 1) {
                        Trace.out((String)("stInfo.getSignature()=" + stInfo.getSignature()));
                        cmdArray[i] = new GetSpaceCommand(stInfo.getNode(), stInfo.getSignature(), stInfo.getType(), stInfo);
                        continue;
                    }
                    Trace.out((String)("stInfo.getPath()=" + stInfo.getPath()));
                    cmdArray[i] = new GetSpaceCommand(stInfo.getNode(), stInfo.getPath(), stInfo.getPath(), stInfo.getType(), stInfo);
                }
                boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
                if (!cmdResult) {
                    String mesg = s_msgBundle.getMessage("4162", true, (Object[])new String[]{ocrLocation});
                    ErrorDescription errorDesc = new ErrorDescription(mesg);
                    resultSet.addErrorDescription(errorDesc);
                    resultSet.addResult(nodeList, 2);
                    ReportUtil.printError(mesg + LSEP);
                    return;
                }
                Hashtable t = resultSet.getResultTable();
                Enumeration nodeKeys = t.keys();
                while (nodeKeys.hasMoreElements()) {
                    ErrorDescription errorDesc;
                    String mesg;
                    String node = (String)nodeKeys.nextElement();
                    Result result = (Result)t.get(node);
                    if (result.getStatus() != 1) {
                        String mesg2 = s_msgBundle.getMessage("4162", true, (Object[])new String[]{ocrLocation});
                        ErrorDescription errorDesc2 = new ErrorDescription(mesg2);
                        resultSet.addErrorDescription(errorDesc2);
                        resultSet.addResult(nodeList, 2);
                        ReportUtil.printError(mesg2 + LSEP);
                        continue;
                    }
                    totalSpace = new StorageSize(0.0, StorageUnit.BYTE);
                    try {
                        String mesg3;
                        StorageInfo st = (StorageInfo)result.getResultInfoSet().get(1);
                        totalSpace = st.getSize();
                        Trace.out((String)("StorageInfoType.getTypeStr() = " + st.getTypeStr() + "StorageInfoType.getType() = " + st.getType()));
                        Trace.out((String)("OCR size required=" + requiredOCRSize + " available=" + totalSpace));
                        String sizeDesc = s_gMsgBundle.getMessage("11604", false);
                        CollectionElement sizeElement = new CollectionElement(sizeDesc + " [" + ocrLocation + "]", ReportUtil.unitizeSize(totalSpace, 1), ReportUtil.unitizeSize(requiredOCRSize, 1), null, "OCR Size", 1);
                        resultSet.addCollectionElement(node, sizeElement);
                        if (totalSpace.compareTo(requiredOCRSize) >= 0) {
                            mesg3 = s_msgBundle.getMessage("4161", false, (Object[])new String[]{ocrLocation});
                            ReportUtil.sureprintln(mesg3);
                            continue;
                        }
                        mesg3 = s_msgBundle.getMessage("4164", true, (Object[])new String[]{ocrLocation, ReportUtil.unitizeSize(requiredOCRSize, 1), ReportUtil.unitizeSize(totalSpace, 1)});
                        ErrorDescription errorDesc3 = new ErrorDescription(mesg3);
                        resultSet.addResult(nodeList, 3);
                        resultSet.addErrorDescription(errorDesc3);
                        sizeElement.setStatus(3);
                        if (this.m_upgrade && st.getType() == 1) {
                            resultSet.addResult(nodeList, 4);
                            ReportUtil.printWarning(mesg3 + LSEP);
                            continue;
                        }
                        resultSet.addResult(nodeList, 3);
                        ReportUtil.printError(mesg3 + LSEP);
                    }
                    catch (NoSuchElementException e) {
                        Trace.out((String)e.getMessage());
                        mesg = s_msgBundle.getMessage("4165", true, (Object[])new String[]{ocrLocation});
                        errorDesc = new ErrorDescription(mesg);
                        resultSet.addErrorDescription(errorDesc);
                        resultSet.addResult(nodeList, 2);
                        ReportUtil.printError(mesg + LSEP);
                    }
                    catch (NumberFormatException e) {
                        Trace.out((String)e.getMessage());
                        mesg = s_msgBundle.getMessage("4165", true, (Object[])new String[]{ocrLocation});
                        errorDesc = new ErrorDescription(mesg);
                        resultSet.addErrorDescription(errorDesc);
                        resultSet.addResult(nodeList, 2);
                        ReportUtil.printError(mesg + LSEP);
                    }
                }
            }
        } else {
            Trace.out((String)"Using 'stInfo' object passed into check size.");
            totalSpace = stInfo.getSize();
            Trace.out((String)("StorageInfoType.getTypeStr() = " + stInfo.getTypeStr() + "StorageInfoType.getType() = " + stInfo.getType()));
            Trace.out((String)("OCR size required=" + requiredOCRSize + " available=" + totalSpace));
            if (totalSpace.compareTo(requiredOCRSize) >= 0) {
                String mesg = s_msgBundle.getMessage("4161", false, (Object[])new String[]{ocrLocation});
                ReportUtil.sureprintln(mesg);
                resultSet.addResult(nodeList, 1);
            } else {
                String mesg = s_msgBundle.getMessage("4164", true, (Object[])new String[]{ocrLocation, ReportUtil.unitizeSize(requiredOCRSize, 1), ReportUtil.unitizeSize(totalSpace, 1)});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                resultSet.addResult(nodeList, 3);
                resultSet.addErrorDescription(errorDesc);
                if (this.m_upgrade && stInfo.getType() == 1) {
                    resultSet.addResult(nodeList, 4);
                    ReportUtil.printWarning(mesg + LSEP);
                } else {
                    resultSet.addResult(nodeList, 3);
                    ReportUtil.printError(mesg + LSEP);
                }
            }
        }
    }

    private void performOCRBackupLocationCheck(String[] validNodeArr, String ocrBackupLocation, ResultSet resultSet, Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT) {
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6002", false, (Object[])new String[]{ocrBackupLocation}));
        StorageInfo stInfo = null;
        try {
            stInfo = new TypeFinder().getStorageInstance(ocrBackupLocation);
        }
        catch (StorageException e1) {
            Trace.out((String)("StorageException encountered: \n" + e1.getMessage()));
            String mesg = s_msgBundle.getMessage("4125", true, (Object[])new String[]{ocrBackupLocation});
            mesg = mesg + LSEP + e1.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(mesg);
            this.m_resultSet.addErrorDescription(errorDesc);
            this.m_resultSet.addResult(validNodeArr, 2);
            ReportUtil.printError(mesg + LSEP);
            return;
        }
        int nodeCount = validNodeArr.length;
        Command[] cmdArray = new Command[nodeCount];
        String version = this.m_destinationVersion;
        if (version == null) {
            version = new Version().toString();
        }
        StorageSize requiredOCRSize = new StorageSize(Long.parseLong(VDMUtil.getDefaultOcrSize(version)), StorageUnit.KBYTE);
        if (stInfo.getType() == 13) {
            for (String node : validNodeArr) {
                List<ASMDiskGroup> dgl = asmDiskGroupHT.get(node);
                boolean founddg = false;
                if (dgl != null && dgl.size() > 0) {
                    for (ASMDiskGroup dg1 : dgl) {
                        if (!ocrBackupLocation.equalsIgnoreCase("+" + dg1.getName())) continue;
                        founddg = true;
                        StorageSize totalSpace = dg1.getSize();
                        Trace.out((String)("OCR size required=" + requiredOCRSize + " available=" + totalSpace));
                        if (totalSpace.compareTo(requiredOCRSize) >= 0) {
                            resultSet.addResult(validNodeArr, 1);
                            continue;
                        }
                        String mesg = s_gMsgBundle.getMessage("6007", true, (Object[])new String[]{ocrBackupLocation, ReportUtil.unitizeSize(requiredOCRSize, 1), ReportUtil.unitizeSize(totalSpace, 1)});
                        ErrorDescription errorDesc = new ErrorDescription(mesg);
                        resultSet.addErrorDescription(errorDesc);
                        resultSet.addResult(validNodeArr, 3);
                        ReportUtil.printError(node + ":" + mesg + LSEP);
                    }
                }
                if (founddg) continue;
                String mesg = s_gMsgBundle.getMessage("6005", true, (Object[])new String[]{ocrBackupLocation});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                resultSet.addErrorDescription(errorDesc);
                resultSet.addResult(validNodeArr, 2);
                ReportUtil.printError(mesg + LSEP);
            }
        } else {
            String locationTocheck = ocrBackupLocation;
            File ocrFile = new File(locationTocheck);
            int storageType = stInfo.getType();
            if (!(s_unix || storageType != 5 && storageType != 7 || ocrFile.isDirectory())) {
                try {
                    stInfo = new TypeFinder().getStorageInstance(ocrFile.getParent());
                    locationTocheck = ocrFile.getParent();
                }
                catch (StorageException e1) {
                    Trace.out((String)("StorageException encountered: " + e1));
                    String mesg = s_msgBundle.getMessage("4125", true, (Object[])new String[]{ocrBackupLocation}) + LSEP + e1.getMessage();
                    ErrorDescription errorDesc = new ErrorDescription(mesg);
                    this.m_resultSet.addErrorDescription(errorDesc);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    ReportUtil.printError(mesg + LSEP);
                    return;
                }
            }
            for (int i = 0; i < nodeCount; ++i) {
                if (!s_unix && stInfo.getType() == 1) {
                    cmdArray[i] = new GetSpaceCommand(validNodeArr[i], stInfo.getSignature(), stInfo.getType(), stInfo);
                    continue;
                }
                Trace.out((String)("stInfo.getPath()=" + stInfo.getPath()));
                cmdArray[i] = new GetSpaceCommand(validNodeArr[i], stInfo.getPath(), stInfo.getPath(), stInfo.getType(), stInfo);
            }
            boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
            if (!cmdResult) {
                String mesg = s_gMsgBundle.getMessage("6005", true, (Object[])new String[]{ocrBackupLocation});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                resultSet.addErrorDescription(errorDesc);
                resultSet.addResult(validNodeArr, 2);
                ReportUtil.printError(mesg + LSEP);
                return;
            }
            Hashtable t = resultSet.getResultTable();
            Enumeration nodeKeys = t.keys();
            while (nodeKeys.hasMoreElements()) {
                ErrorDescription errorDesc;
                String mesg;
                String node = (String)nodeKeys.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() != 1) {
                    String mesg2 = s_gMsgBundle.getMessage("6005", true, (Object[])new String[]{ocrBackupLocation});
                    ErrorDescription errorDesc2 = new ErrorDescription(mesg2);
                    resultSet.addErrorDescription(errorDesc2);
                    resultSet.addResult(validNodeArr, 2);
                    ReportUtil.printError(mesg2 + LSEP);
                    continue;
                }
                StorageSize totalSpace = new StorageSize(0.0, StorageUnit.BYTE);
                try {
                    StorageInfo st = (StorageInfo)result.getResultInfoSet().get(1);
                    totalSpace = st.getSize();
                    Trace.out((String)("StorageInfoType.getTypeStr() = " + st.getTypeStr() + "StorageInfoType.getType() = " + st.getType()));
                    Trace.out((String)("OCR size required=" + requiredOCRSize + " available=" + totalSpace));
                    if (totalSpace.compareTo(requiredOCRSize) >= 0) continue;
                    mesg = s_gMsgBundle.getMessage("6007", true, (Object[])new String[]{ocrBackupLocation, ReportUtil.unitizeSize(requiredOCRSize, 1), ReportUtil.unitizeSize(totalSpace, 1)});
                    errorDesc = new ErrorDescription(mesg);
                    resultSet.addResult(validNodeArr, 3);
                    resultSet.addErrorDescription(errorDesc);
                    if (this.m_upgrade && st.getType() == 1) {
                        resultSet.addResult(validNodeArr, 4);
                        ReportUtil.printWarning(mesg + LSEP);
                        continue;
                    }
                    resultSet.addResult(validNodeArr, 3);
                    ReportUtil.printError(mesg + LSEP);
                }
                catch (NoSuchElementException e) {
                    Trace.out((String)e.getMessage());
                    mesg = s_gMsgBundle.getMessage("6005", true, (Object[])new String[]{ocrBackupLocation});
                    errorDesc = new ErrorDescription(mesg);
                    resultSet.addErrorDescription(errorDesc);
                    resultSet.addResult(validNodeArr, 2);
                    ReportUtil.printError(mesg + LSEP);
                }
                catch (NumberFormatException e) {
                    Trace.out((String)e.getMessage());
                    mesg = s_gMsgBundle.getMessage("6005", true, (Object[])new String[]{ocrBackupLocation});
                    errorDesc = new ErrorDescription(mesg);
                    resultSet.addErrorDescription(errorDesc);
                    resultSet.addResult(validNodeArr, 2);
                    ReportUtil.printError(mesg + LSEP);
                }
            }
        }
        if (resultSet.allSuccess()) {
            ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6003", false, (Object[])new String[]{ocrBackupLocation}));
        } else {
            ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6004", false, (Object[])new String[]{ocrBackupLocation}));
        }
    }

    private String getOCRBackupLocation(String crshome, String node) {
        Pattern p;
        Matcher m;
        String ocrBackupLocation = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        GlobalExecution globalExec = new GlobalExecution();
        String cmdSpec = crshome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + nativeSys.getExeName("ocrconfig") + " -showbackup";
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Command Syntax: " + cmdSpec));
        }
        ResultSet olrCheckResultSet = new ResultSet();
        Hashtable olrCheckOutput = globalExec.runExeWithOutput(new String[]{node}, cmdSpec, olrCheckResultSet);
        String output = (String)olrCheckOutput.get(node);
        String valText = VerificationUtil.fetchVerificationValue(output);
        String exitStat = VerificationUtil.fetchVerificationResult(output);
        if (exitStat != null && exitStat.contentEquals("0") && (m = (p = Pattern.compile("([^:]*):([\\s]+)Device/File Name([^:]+): (.*)")).matcher(valText.trim())).matches()) {
            ocrBackupLocation = m.group(4).trim();
        }
        return ocrBackupLocation;
    }

    private void performOCRDumpCheck(String crsHome, String[] nodeList, ResultSet resultSet) {
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6010", false));
        for (String node : nodeList) {
            String activeVersion = null;
            Result result = new Result(node);
            String versionKey = "SYSTEM.version.activeversion";
            StringBuffer ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHome, "SYSTEM.version.activeversion", result);
            resultSet.addResult(node, result);
            if (ocrKeyValue != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
                String[] lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR);
                Pattern p = Pattern.compile("(\\s*)ORATEXT([^:]*):(\\s*)(.*)");
                for (String outputLine : lineByLine) {
                    Matcher m = p.matcher(outputLine);
                    if (!m.matches()) continue;
                    activeVersion = m.group(4);
                    break;
                }
            }
            if (!VerificationUtil.isStringGood(activeVersion)) {
                Trace.out((String)"Failed to retrieve the CRS version using OCRDUMP");
                result.setStatus(2);
                resultSet.addResult(node, result);
                continue;
            }
            Trace.out((int)5, (String)("The CRS release version retrieved using OCR dump is " + activeVersion));
            result.setStatus(1);
            String keyDesc = s_gMsgBundle.getMessage("11603", false);
            CollectionElement activeVerElement = new CollectionElement("SYSTEM.version.activeversion", activeVersion, null, null, keyDesc, 1);
            result.addCollectionElement(activeVerElement);
            resultSet.addResult(node, result);
        }
        if (resultSet.allSuccess()) {
            ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6011", false));
        } else {
            ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6012", false));
        }
    }

    private boolean isValidStorage(String[] nodeList, String ocrLocation, ResultSet resultSet) {
        int isSupported = 2;
        String[] args = new String[]{this.OCR_VALID_STORAGE_HELPER, ocrLocation};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1003", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(nodeList, 2);
            this.m_resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg = s_gMsgBundle.getMessage("1003", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(nodeList, 2);
            this.m_resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        boolean displayError = true;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
                if ("unknown".equalsIgnoreCase(helperExec.getErrorString())) {
                    displayError = false;
                }
            } else {
                isSupported = status == 1 ? 1 : 0;
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            String errMsg = s_gMsgBundle.getMessage("1003", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(nodeList, 2);
            this.m_resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        switch (isSupported) {
            case 0: {
                resultSet.addResult(nodeList, 1);
                Trace.out((String)(" OCR location " + ocrLocation + " is on valid Storage."));
                String errMsg = s_msgBundle.getMessage("10034", false, (Object[])new String[]{ocrLocation});
                ReportUtil.sureprintln(errMsg);
                return true;
            }
            case 2: {
                resultSet.addResult(nodeList, 3);
                Trace.out((String)(" OCR location " + ocrLocation + " is on invalid Storage."));
                String errMsg = s_msgBundle.getMessage("10031", true, (Object[])new String[]{ocrLocation});
                ReportUtil.printError(errMsg);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(nodeList, errorDesc);
                return false;
            }
            case 1: {
                Trace.out((String)" Unable to check vaidity of OCR location storage type.");
                resultSet.addResult(nodeList, 2);
                String errMsg = s_msgBundle.getMessage("10031", true, (Object[])new String[]{ocrLocation});
                if (displayError) {
                    errMsg = errMsg + LSEP + helperExec.getErrorString();
                }
                ReportUtil.printError(errMsg);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(nodeList, errorDesc);
                return false;
            }
        }
        return false;
    }

    private void performOCRSharednessCheck(String[] nodeList, String ocrLocation, ResultSet resultSet, String release) {
        if (VerificationUtil.isASMPath(ocrLocation)) {
            resultSet.addResult(nodeList, 1);
            return;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4166", false, (Object[])new String[]{ocrLocation}) + LSEP);
        VerifyStorage checkPathSt = new VerifyStorage();
        try {
            if (checkPathSt.isShared(ocrLocation, nodeList, OracleFileType.RAC_OCR_VDISK, release)) {
                String mesg = s_msgBundle.getMessage("4167", false, (Object[])new String[]{ocrLocation});
                ReportUtil.sureprintln(mesg + LSEP);
                resultSet.addResult(nodeList, 1);
            } else {
                String mesg = s_msgBundle.getMessage("4168", true, (Object[])new String[]{ocrLocation});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                resultSet.addErrorDescription(errorDesc);
                resultSet.addResult(nodeList, 3);
                ReportUtil.printError(mesg + LSEP);
            }
        }
        catch (StorageException e) {
            Trace.out((Exception)e);
            String mesg = s_msgBundle.getMessage("4172", true, (Object[])new String[]{ocrLocation}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(mesg);
            resultSet.addErrorDescription(errorDesc);
            resultSet.addResult(nodeList, 2);
            ReportUtil.printError(mesg + LSEP);
            return;
        }
        catch (MultiNodeException e) {
            Trace.out((Exception)e);
            String mesg = s_msgBundle.getMessage("4172", true, (Object[])new String[]{ocrLocation}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(mesg);
            resultSet.addErrorDescription(errorDesc);
            resultSet.addResult(nodeList, 2);
            ReportUtil.printError(mesg + LSEP);
            return;
        }
    }

    private void performOCRConfigurationChecks(String[] validNodeArr, String ocrConfigLocation, String[] ocrLocations, ResultSet ocrConfigCheckResultSet, Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT) {
        ArrayList<String> fileList = new ArrayList<String>();
        ocrConfigCheckResultSet.addResult(validNodeArr, 1);
        for (String ocrLocation : ocrLocations) {
            if (ocrLocation == null || VerificationUtil.isASMPath(ocrLocation)) continue;
            fileList.add(ocrLocation);
        }
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        if (s_unix && fileList.size() > 0) {
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet fileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(validNodeArr, fileList, fileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                fileInfoResultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                fileInfoResultSet.addErrorDescription(errDesc);
                Trace.out((String)"uploading resultset");
                ocrConfigCheckResultSet.uploadResultSet(fileInfoResultSet);
                return;
            }
            Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
            for (String node : validNodeArr) {
                Result result = (Result)fileInforResultTable.get(node);
                if (result == null || result.getStatus() != 1) continue;
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                nodeFileInfo.put(node, nodeFileList);
            }
        }
        for (String ocrLocation : ocrLocations) {
            if (ocrLocation != null && !VerificationUtil.isASMPath(ocrLocation)) {
                String mesg;
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4176", false, (Object[])new String[]{ocrLocation}));
                String refPermission = null;
                String refGroup = null;
                String refOwner = null;
                if (!this.m_upgrade) {
                    refPermission = VDMUtil.getDefaultOcrPermissions();
                    refGroup = VerificationUtil.getOraInventoryGroup();
                    refOwner = VDMUtil.getDefaultOcrOwner();
                }
                boolean failed = false;
                if (s_unix) {
                    Hashtable<String, List<String>> failedOcrNodes = this.checkFileAttributes(validNodeArr, ocrLocation, nodeFileInfo, refOwner, refGroup, refPermission, ocrConfigCheckResultSet, true);
                    if (failedOcrNodes.keySet().size() != 0) {
                        failed = true;
                        mesg = s_msgBundle.getMessage("4178", true, (Object[])new String[]{ocrLocation});
                        ReportUtil.printError(mesg);
                        ReportUtil.sureprintNodelist(failedOcrNodes.keySet().toArray(new String[0]));
                        for (String node : failedOcrNodes.keySet()) {
                            List<String> failedNodeErrors = failedOcrNodes.get(node);
                            ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strCollection2String(failedNodeErrors, ";"));
                            ocrConfigCheckResultSet.addResult(node, 3);
                            for (String error : failedNodeErrors) {
                                ocrConfigCheckResultSet.addErrorDescription(node, new ErrorDescription(error));
                            }
                        }
                    }
                } else {
                    try {
                        StorageInfo stInfo = new TypeFinder().getStorageInstance(ocrLocation);
                    }
                    catch (StorageException e1) {
                        Trace.out((String)("StorageException encountered: " + e1));
                        failed = true;
                        mesg = s_msgBundle.getMessage("4178", true, (Object[])new String[]{ocrLocation}) + LSEP + e1.getMessage();
                        ReportUtil.printError(mesg);
                        ReportUtil.sureprintNodelist(validNodeArr);
                        for (String node : validNodeArr) {
                            ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strArr2List(validNodeArr, ";"));
                            ocrConfigCheckResultSet.addResult(node, 3);
                            for (String error : validNodeArr) {
                                ocrConfigCheckResultSet.addErrorDescription(node, new ErrorDescription(error));
                            }
                        }
                    }
                }
                if (failed) continue;
                String mesg2 = s_msgBundle.getMessage("4177", false, (Object[])new String[]{ocrLocation});
                ReportUtil.sureprintln(LSEP + mesg2 + LSEP);
                continue;
            }
            Vector<String> dgUnavailNodes = new Vector<String>();
            for (String node : validNodeArr) {
                CollectionElement ocrDGElement = new CollectionElement(s_gMsgBundle.getMessage("11605", false, (Object[])new String[]{ocrLocation}), "available", "available", null, s_gMsgBundle.getMessage("11606", false), 1);
                ocrConfigCheckResultSet.addCollectionElement(node, ocrDGElement);
                List<ASMDiskGroup> dgl = asmDiskGroupHT.get(node);
                boolean founddg = false;
                if (dgl != null && dgl.size() > 0) {
                    for (ASMDiskGroup dg1 : dgl) {
                        if (!ocrLocation.equalsIgnoreCase("+" + dg1.getName())) continue;
                        founddg = true;
                    }
                }
                if (founddg) continue;
                ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("2071", true, (Object[])new String[]{ocrLocation, node}));
                ocrConfigCheckResultSet.addResult(node, 3);
                ocrConfigCheckResultSet.addErrorDescription(node, errDesc);
                ocrDGElement.setValue("not available");
                ocrDGElement.setStatus(3);
                ocrDGElement.addErrorDescription(errDesc);
                dgUnavailNodes.add(node);
            }
            if (dgUnavailNodes.size() > 0) {
                ReportUtil.printError(LSEP + s_gMsgBundle.getMessage("2070", true, (Object[])new String[]{ocrLocation}) + LSEP);
                ReportUtil.sureprintNodelist(dgUnavailNodes);
                continue;
            }
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4196", false, (Object[])new String[]{ocrLocation}) + LSEP);
        }
    }

    private void performOCRLocCheck(String[] validNodeArr, String ocrConfigLocation, ResultSet ocrConfigCheckResultSet) {
        String mesg;
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(ocrConfigLocation);
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet fileInfoResultSet = new ResultSet();
        boolean fileInfoResult = globalExec.getFileInfo(validNodeArr, fileList, fileInfoResultSet);
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        Trace.out((String)"After calling globalExec.getFileInfo() ... ");
        if (!fileInfoResult) {
            ReportUtil.printError(s_msgBundle.getMessage("4160", false));
            fileInfoResultSet.addResult(validNodeArr, 2);
            ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
            fileInfoResultSet.addErrorDescription(errDesc);
            Trace.out((String)"uploading resultset");
            ocrConfigCheckResultSet.uploadResultSet(fileInfoResultSet);
            return;
        }
        Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
        for (String node : validNodeArr) {
            Result result = (Result)fileInforResultTable.get(node);
            if (result == null || result.getStatus() != 1) continue;
            Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
            nodeFileInfo.put(node, nodeFileList);
        }
        Trace.out((String)"Checking ocr.loc attributes");
        Hashtable<String, List<String>> failedOcrLocNodes = this.checkFileAttributes(validNodeArr, ocrConfigLocation, nodeFileInfo, VDMUtil.getDefaultOcrLocOwner(), VerificationUtil.getOraInventoryGroup(), VDMUtil.getDefaultOcrLocPermissions(), ocrConfigCheckResultSet, false);
        if (failedOcrLocNodes.keySet().size() != 0) {
            mesg = s_msgBundle.getMessage("4175", true, (Object[])new String[]{ocrConfigLocation});
            ReportUtil.printError(mesg);
            ReportUtil.sureprintNodelist(failedOcrLocNodes.keySet().toArray(new String[0]));
            for (String node : failedOcrLocNodes.keySet()) {
                List<String> failedNodeErrors = failedOcrLocNodes.get(node);
                ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strCollection2String(failedNodeErrors, ";"));
                ocrConfigCheckResultSet.addResult(node, 3);
                for (String error : failedNodeErrors) {
                    ocrConfigCheckResultSet.addErrorDescription(node, new ErrorDescription(error));
                }
            }
        } else {
            ocrConfigCheckResultSet.addResult(validNodeArr, 1);
            mesg = s_msgBundle.getMessage("4174", false, (Object[])new String[]{ocrConfigLocation});
            ReportUtil.sureprintln(LSEP + mesg + LSEP);
        }
    }

    private Hashtable<String, List<String>> checkFileAttributes(String[] validNodeArr, String location, Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable, String refOwner, String refGroup, String refPermissions, ResultSet resultSet, boolean isOcrLocation) {
        Hashtable<String, List<String>> failedNodes = new Hashtable<String, List<String>>();
        ArrayList<String> nodeErrors = null;
        for (String node : validNodeArr) {
            String elementName = null;
            String elementDesc = null;
            if (isOcrLocation) {
                elementName = "OCR Disk [" + location + "]";
                elementDesc = "OCR Disk";
            } else {
                elementName = "ocr.loc";
                elementDesc = "ocr.loc";
            }
            CollectionElement collectionElement = new CollectionElement(elementName, null, refPermissions, null, elementDesc, 1);
            if (s_unix) {
                resultSet.addCollectionElement(node, collectionElement);
            }
            String referenceValue = null;
            if (refOwner != null) {
                referenceValue = "Owner=" + refOwner;
            }
            if (refGroup != null) {
                referenceValue = referenceValue != null ? referenceValue + "; Group=" + refGroup : "Group=" + refGroup;
            }
            if (refPermissions != null) {
                referenceValue = referenceValue != null ? referenceValue + "; Permissions=" + refPermissions : "Permissions=" + refPermissions;
            }
            collectionElement.setExpectedValue(referenceValue);
            nodeErrors = new ArrayList<String>();
            Hashtable<String, FileInfo> nodeFileList = nodeFileInfoTable.get(node);
            if (nodeFileList != null) {
                ErrorDescription error;
                String errorMessage;
                boolean nodeFailed = false;
                FileInfo nodeFileInfo = nodeFileList.get(location);
                if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) {
                    resultSet.addResult(node, 3);
                    ErrorDescription error2 = new ErrorDescription(nodeFileInfo.getErrorString());
                    resultSet.addErrorDescription(node, error2);
                    nodeErrors.add(nodeFileInfo.getErrorString());
                    failedNodes.put(node, nodeErrors);
                    nodeFailed = true;
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(error2);
                    continue;
                }
                collectionElement.setValue("Owner=" + nodeFileInfo.getFileOwner() + "; Group=" + nodeFileInfo.getFileGroup() + "; Permissions=" + nodeFileInfo.getFilePermissions());
                if (refOwner != null && refOwner.length() > 0 && !nodeFileInfo.getFileOwner().equalsIgnoreCase(refOwner)) {
                    resultSet.addResult(node, 3);
                    errorMessage = s_gMsgBundle.getMessage("2031", false, (Object[])new String[]{nodeFileInfo.getFileName(), node, refOwner, nodeFileInfo.getFileOwner()});
                    error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(error);
                }
                if (refGroup != null && refGroup.length() > 0 && !nodeFileInfo.getFileGroup().equalsIgnoreCase(refGroup)) {
                    resultSet.addResult(node, 3);
                    errorMessage = s_gMsgBundle.getMessage("2032", false, (Object[])new String[]{nodeFileInfo.getFileName(), node, refGroup, nodeFileInfo.getFileGroup()});
                    error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(error);
                }
                if (refPermissions != null && refPermissions.length() > 0 && Integer.parseInt(refPermissions, 8) != Integer.parseInt(nodeFileInfo.getFilePermissions(), 8)) {
                    resultSet.addResult(node, 3);
                    errorMessage = s_gMsgBundle.getMessage("2033", false, (Object[])new String[]{nodeFileInfo.getFileName(), node, refPermissions, nodeFileInfo.getFilePermissions()});
                    error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(error);
                }
                if (!nodeFailed) continue;
                failedNodes.put(node, nodeErrors);
                continue;
            }
            String error = s_msgBundle.getMessage("4160", false);
            nodeErrors.add(error);
            failedNodes.put(node, nodeErrors);
            collectionElement.setStatus(2);
            collectionElement.addErrorDescription(new ErrorDescription(error));
        }
        return failedNodes;
    }

    /*
     * Unable to fully structure code
     */
    private void performOcrcheckBasedChecks(String[] nodeList, String activeCRSVer, ResultSet ocrCheckResultSet) {
        globalExec = new GlobalExecution();
        versionTable = new Hashtable<Object, Vector<Object>>();
        idTable = new Hashtable<Object, Vector<Object>>();
        totalSpaceTable = new Hashtable<Object, Vector<Object>>();
        integrityTable = new Hashtable<Object, Vector<Object>>();
        deviceTable = new Hashtable<Object, Vector<Object>>();
        failNodeVect = new Vector<String>();
        succNodeVect = new Vector<String>();
        if (TaskOCRIntegrity.s_unix && VerificationUtil.isVersionPost(activeCRSVer, "11.2")) {
            try {
                this.m_rootCreds = RootAutomationUtility.getRootExecutionInfo();
                ocrCheckResult = globalExec.checkOCRIntegrity(nodeList, this.m_rootCreds, this.m_defaultTimeout, ocrCheckResultSet);
            }
            catch (RootAutomationNotConfiguredException re) {
                ocrCheckResultSet.addResult(nodeList, 2);
                errDesc = new ErrorDescription(re.getMessage());
                ocrCheckResultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(re.getMessage());
                return;
            }
            catch (VerificationException ve) {
                ocrCheckResultSet.addResult(nodeList, 2);
                errDesc = new ErrorDescription(ve.getMessage());
                ocrCheckResultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(ve.getMessage());
                return;
            }
        } else {
            ocrCheckResult = globalExec.checkOCRIntegrity(nodeList, ocrCheckResultSet);
        }
        Trace.out((String)"\n>>>> TaskOCRIntegrity:: Upload ocrCheckResultSet >>>>\n");
        this.m_resultSet.uploadResultSet(ocrCheckResultSet);
        Trace.out((String)"TaskOCRIntegrity: After calling checkOCRIntegrity() ... ");
        if (!ocrCheckResult || !ocrCheckResultSet.anySuccess()) {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4043", false) + TaskOCRIntegrity.LSEP);
            this.m_resultSet.addResult(nodeList, 2);
            errDesc = new ErrorDescription("4043", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            for (i = 0; i < nodeList.length; ++i) {
                node = nodeList[i];
                errDesc = new ErrorDescription(TaskOCRIntegrity.s_msgBundle.getMessage("7597", true, (Object[])new String[]{node}), TaskOCRIntegrity.s_msgBundle, "7597");
                this.m_resultSet.addErrorDescription(node, errDesc);
            }
            return;
        }
        t = ocrCheckResultSet.getResultTable();
        e = t.keys();
        succNodeVect.clear();
        failNodeVect.clear();
        while (e.hasMoreElements()) {
            node = (String)e.nextElement();
            result = (Result)t.get(node);
            val = null;
            devStat = null;
            if (result.getStatus() == 1 && result.getResultInfoSet().size() > 2) {
                Trace.out((String)("Checking 'ocrcheck'output for node: '" + node + "'"));
                succNodeVect.add(node);
                rt = (Hashtable)result.getResultInfoSet().get(2);
                e_rt = rt.keys();
                while (e_rt.hasMoreElements()) {
                    key = (String)e_rt.nextElement();
                    if (key.equalsIgnoreCase("DeviceStatus")) {
                        devStat = (Vector)rt.get(key);
                        Trace.out((String)("\t" + key + "==>" + VerificationUtil.strVect2List(devStat)));
                    } else {
                        val = (String)rt.get(key);
                        Trace.out((String)("\t" + key + "==>" + val));
                    }
                    if (key.equalsIgnoreCase("Version")) {
                        VerificationUtil.updateResultMap(versionTable, val, node);
                        continue;
                    }
                    if (key.equalsIgnoreCase("TotalSpace")) {
                        VerificationUtil.updateResultMap(totalSpaceTable, val, node);
                        continue;
                    }
                    if (key.equalsIgnoreCase("ID")) {
                        VerificationUtil.updateResultMap(idTable, val, node);
                        continue;
                    }
                    if (key.equalsIgnoreCase("Integrity")) {
                        VerificationUtil.updateResultMap(integrityTable, val, node);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("DeviceStatus") || devStat.size() <= 0) continue;
                    for (i = 0; i < devStat.size(); ++i) {
                        VerificationUtil.updateResultMap(deviceTable, devStat.elementAt(i), node);
                    }
                }
                continue;
            }
            failNodeVect.add(node);
            Trace.out((String)("OCR details couldn't be obtained from node: '" + node + "'"));
        }
        if (failNodeVect.size() == 0) {
            Trace.out((String)"'ocrcheck' successfully run on all the nodes");
        } else {
            Trace.out((String)("Failure in running 'ocrcheck' on the nodes: " + VerificationUtil.strVect2List(failNodeVect)));
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4044", false));
            ReportUtil.sureprintNodelist(failNodeVect);
            invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
            if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                this.m_resultSet.addResult(invalidNodeArr, 2);
                for (i = 0; i < invalidNodeArr.length; ++i) {
                    node = invalidNodeArr[i];
                    errDesc = new ErrorDescription(TaskOCRIntegrity.s_msgBundle.getMessage("7597", true, (Object[])new String[]{node}), TaskOCRIntegrity.s_msgBundle, "7597");
                    this.m_resultSet.addErrorDescription(node, errDesc);
                }
            }
            if (succNodeVect.size() == 0) {
                this.m_resultSet.addResult(nodeList, 2);
                return;
            }
            ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(succNodeVect);
        }
        Trace.out((String)("Result of OCR Integrity check for nodes: " + VerificationUtil.strVect2List(succNodeVect) + " >>>>>>"));
        if (deviceTable.size() != 0) {
            ReportUtil.printWarning(TaskOCRIntegrity.s_msgBundle.getMessage("4213", false));
            e = deviceTable.keys();
            while (e.hasMoreElements()) {
                devMsg = (String)e.nextElement();
                ReportUtil.sureprintln(devMsg);
            }
        }
        Trace.out((String)("idTable.size() = " + idTable.size()));
        if (idTable.size() == 1) {
            Trace.out((String)("Same ID ('" + idTable.keys().nextElement() + "') obtained from all the nodes"));
            ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4204", false));
        } else if (idTable.size() != 0) {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4046", true) + TaskOCRIntegrity.LSEP);
            errDesc = new ErrorDescription("4046", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            e = idTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                nodeListStr = VerificationUtil.strVect2List((Vector)idTable.get(key));
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4047", false, (Object[])new String[]{key, nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
            return;
        }
        ReportUtil.sureprintln(TaskOCRIntegrity.LSEP + TaskOCRIntegrity.s_msgBundle.getMessage("4201", false));
        correctVersion = VDMUtil.getDefaultOCRVersion();
        if (versionTable.size() == 1) {
            versionFound = (String)versionTable.keys().nextElement();
            Trace.out((String)("Same Version ('" + versionFound + "') obtained from for all the nodes"));
            if (!versionFound.equalsIgnoreCase(correctVersion)) {
                errMsg = TaskOCRIntegrity.s_msgBundle.getMessage("4048", true, (Object[])new String[]{versionFound, correctVersion});
                Trace.out((String)("Incorrect Version of OCR found for all the nodes (versionFound=" + versionFound + " ; correctVersion=" + correctVersion));
                ReportUtil.printError(errMsg);
                this.m_resultSet.addResult(nodeList, 2);
                errDesc = new ErrorDescription(errMsg, TaskOCRIntegrity.s_msgBundle, "4048");
                this.m_resultSet.addErrorDescription(errDesc);
                return;
            }
        } else {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4049", true) + TaskOCRIntegrity.LSEP);
            errDesc = new ErrorDescription("4049", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            e = versionTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                nodeListStr = VerificationUtil.strVect2List(versionTable.get(key));
                if (key.equalsIgnoreCase(correctVersion)) {
                    ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4050", false, (Object[])new String[]{key, nodeListStr}));
                    continue;
                }
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4051", false, (Object[])new String[]{key, nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
            return;
        }
        Trace.out((String)("Correct Version of OCR ('" + versionFound + "') found for all the nodes"));
        ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4202", false, (Object[])new String[]{versionFound}));
        if (totalSpaceTable.size() != 1) {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4052", true) + TaskOCRIntegrity.LSEP);
            e = totalSpaceTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                nodeListStr = VerificationUtil.strVect2List(totalSpaceTable.get(key));
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4053", false, (Object[])new String[]{key, nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
            return;
        }
        totalSpaceFound = (String)totalSpaceTable.keys().nextElement();
        Trace.out((String)("Same total space ('" + totalSpaceFound + "') obtained from for all the nodes"));
        ReportUtil.sureprintln(TaskOCRIntegrity.LSEP + TaskOCRIntegrity.s_msgBundle.getMessage("4205", false));
        if (integrityTable.size() != 1) ** GOTO lbl184
        key = (String)integrityTable.keys().nextElement();
        validIntegrity = key.equalsIgnoreCase("True");
        if (validIntegrity) {
            ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4206", false));
        } else {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4055", true) + TaskOCRIntegrity.LSEP);
            errDesc = new ErrorDescription("4055", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(nodeList, 2);
            return;
lbl184:
            // 1 sources

            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4056", true));
            errDesc = new ErrorDescription("4056", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            e = integrityTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                keyVal = integrityTable.get(key);
                nodeListStr = VerificationUtil.strVect2List(keyVal);
                if (key.equalsIgnoreCase("True")) {
                    ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4057", false, (Object[])new String[]{nodeListStr}));
                    continue;
                }
                if (!key.equalsIgnoreCase("False")) continue;
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4058", false, (Object[])new String[]{nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4424", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4475", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }

    public void setRolling(boolean rolling) {
        this.m_rolling = rolling;
    }

    public void setUpgrade(boolean upgrade) {
        this.m_upgrade = upgrade;
    }

    public void setDestinationVersion(String destinationVersion) {
        this.m_destinationVersion = destinationVersion;
    }
}

