/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOLRIntegrity
extends Task {
    private static final String FILE_STATUS_FAILED = "1";
    public String m_homeType = new String("BOTH");

    public TaskOLRIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOLRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOLRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setHomeType(String homeType) {
        this.m_homeType = homeType;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing OLR Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4109", false));
        this.performOLRIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4198", false));
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4110", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4111", false));
        return false;
    }

    void performOLRIntegrityChecks() {
        String olrHome = null;
        ResultSet olrConfigRS = new ResultSet();
        ArrayList<String> nodeList = new ArrayList<String>();
        String[] validNodeArr = null;
        olrHome = VerificationUtil.getHAorCRSHome(this.m_nodeList, this.m_homeType, nodeList, olrConfigRS);
        if (olrHome == null) {
            Trace.out((int)5, (String)"Could not determine OLR home...");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        Trace.out((int)5, (String)("OLR home is: '" + olrHome + "'"));
        validNodeArr = nodeList.toArray(new String[nodeList.size()]);
        this.performOLRConfigurationChecks(validNodeArr, olrConfigRS, olrHome);
        this.m_resultSet.uploadResultSet(olrConfigRS);
    }

    private void performOLRConfigurationChecks(String[] nodeList, ResultSet resultSet, String haHome) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable failedOlrLocNodes = new Hashtable();
        String[] olrExistNodes = null;
        String[] olrNotExistNodes = null;
        String errMsg = null;
        ErrorDescription errDesc = null;
        if (nativeSys.isUnixSystem()) {
            Version version = null;
            version = VerificationUtil.isHAConfigured() ? VerificationUtil.getSIHAReleaseVersionObj() : VerificationUtil.getCRSSoftwareVersionObj();
            String olrLocFileName = nativeSys.getOLRConfigLocation("localnode", version);
            ResultSet olrExistResultSet = new ResultSet();
            VerificationUtil.checkFileExistence(nodeList, olrLocFileName, olrExistResultSet);
            resultSet.uploadResultSet(olrExistResultSet);
            olrExistNodes = (String[])olrExistResultSet.getSuccessfulNodes().toArray();
            Trace.out((String)("olrExistNodes:: length=" + olrExistNodes.length + "; Nodes: \"" + VerificationUtil.strArr2List(olrExistNodes) + "\""));
            olrNotExistNodes = (String[])olrExistResultSet.getFailedNodes().toArray();
            Trace.out((String)("olrNotExistNodes:: length=" + olrNotExistNodes.length + "; Nodes: \"" + VerificationUtil.strArr2List(olrNotExistNodes) + "\""));
            if (olrExistResultSet.allSuccess()) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2037", false, (Object[])new String[]{olrLocFileName}));
            }
            if (olrExistNodes.length == 0) {
                return;
            }
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(olrLocFileName);
            Trace.out((int)5, (String)("olrLocFileName: '" + olrLocFileName + "'"));
            ResultSet olrLocFileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(olrExistNodes, fileList, olrLocFileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!fileInfoResult) {
                olrLocFileInfoResultSet.addResult(olrExistNodes, 2);
                errDesc = new ErrorDescription("4160", s_msgBundle);
                olrLocFileInfoResultSet.addErrorDescription(errDesc);
                ReportUtil.printError(s_msgBundle.getMessage("4160", false) + LSEP);
                resultSet.uploadResultSet(olrLocFileInfoResultSet);
                return;
            }
            Trace.out((String)"Checking olr.loc attributes");
            String olrLocOwner = VDMUtil.getDefaultOlrLocOwner();
            String olrLocGroup = VerificationUtil.getOraInventoryGroup();
            String olrPermissions = null;
            olrPermissions = VerificationUtil.isHAConfigured() ? VDMUtil.getDefaultOlrLocSIHAPermissions() : VDMUtil.getDefaultOlrLocPermissions();
            this.checkFileAttributes(olrExistNodes, olrLocFileName, olrLocFileInfoResultSet, olrLocOwner, olrLocGroup, olrPermissions);
            resultSet.uploadResultSet(olrLocFileInfoResultSet);
            if (olrLocFileInfoResultSet.allSuccess()) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2039", false, (Object[])new String[]{olrLocFileName}));
            }
        } else {
            ArrayList<String> olrExistNodesList = new ArrayList<String>();
            ArrayList<String> olrNotExistNodesList = new ArrayList<String>();
            for (String node : nodeList) {
                NativeResult keyExistsResult;
                String olrLocFileName = nativeSys.getOLRConfigLocation(node, null);
                if (!nativeSys.regKeyExists(node, olrLocFileName, keyExistsResult = new NativeResult())) {
                    olrNotExistNodesList.add(node);
                    resultSet.addResult(node, 3);
                    if (!keyExistsResult.getStatus()) {
                        Object[] args = new String[]{olrLocFileName, node, keyExistsResult.getOSString()};
                        errMsg = s_gMsgBundle.getMessage("4001", true, args);
                    } else {
                        errMsg = s_gMsgBundle.getMessage("4000", true, (Object[])new String[]{olrLocFileName, node});
                    }
                    ReportUtil.sureprintln(errMsg);
                    resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    continue;
                }
                resultSet.addResult(node, 1);
                olrExistNodesList.add(node);
            }
            olrExistNodes = olrExistNodesList.toArray(new String[olrExistNodesList.size()]);
            if (olrNotExistNodesList.size() == 0) {
                ReportUtil.println(s_gMsgBundle.getMessage("2041", false));
            }
        }
        for (String node : olrExistNodes) {
            Pattern p;
            Matcher m;
            String olrFileName = null;
            String cmdSpec = haHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + nativeSys.getExeName("ocrcheck") + " -config -local";
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Command Syntax: " + cmdSpec));
            }
            ResultSet olrCheckResultSet = new ResultSet();
            Hashtable olrCheckOutput = globalExec.runExeWithOutput(new String[]{node}, cmdSpec, olrCheckResultSet);
            String output = (String)olrCheckOutput.get(node);
            String valText = VerificationUtil.fetchVerificationValue(output);
            String exitStat = VerificationUtil.fetchVerificationResult(output);
            if (exitStat != null && exitStat.contentEquals("0") && (m = (p = Pattern.compile("([^:]*):([\\s]+)Device/File Name([^:]+): (.*)")).matcher(valText.trim())).matches()) {
                olrFileName = m.group(4).trim();
            }
            if (olrFileName == null) {
                resultSet.addResult(node, 2);
                errMsg = s_gMsgBundle.getMessage("2042", true, (Object[])new String[]{node});
                String cmdDetailsMsg = VerificationUtil.fetchCommandDetailsMessage(node, output);
                if (VerificationUtil.isStringGood(cmdDetailsMsg)) {
                    errMsg = errMsg + LSEP + cmdDetailsMsg;
                }
                resultSet.addErrorDescription(new ErrorDescription(errMsg));
                ReportUtil.sureprintln(errMsg);
                if (!Trace.isTraceEnabled()) continue;
                Trace.out((String)("Node: " + node));
                Trace.out((String)("Output: " + output));
                Trace.out((String)("valText: '" + valText + "' "));
                Trace.out((String)("exitStat: '" + exitStat + "'"));
                continue;
            }
            Trace.out((String)("olrFileName = " + olrFileName));
            ResultSet olrResultSet = new ResultSet();
            VerificationUtil.checkFileExistence(new String[]{node}, olrFileName, olrResultSet);
            resultSet.uploadResultSet(olrResultSet);
            if (!olrResultSet.allSuccess() || !nativeSys.isUnixSystem()) continue;
            Trace.out((String)("Checking for attributes of OLR file '" + olrFileName + "'"));
            ArrayList<String> olrFileList = new ArrayList<String>();
            olrFileList.add(olrFileName);
            ResultSet olrFileInfoResultSet = new ResultSet();
            boolean olrFileInfoResult = globalExec.getFileInfo(new String[]{node}, olrFileList, olrFileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!olrFileInfoResult) {
                String message = s_msgBundle.getMessage("4160", true) + LSEP;
                resultSet.addResult(node, 2);
                errDesc = new ErrorDescription("4160", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                continue;
            }
            Trace.out((String)"Checking olr attributes");
            String olrOwner = null;
            String olrGroup = null;
            String olrPermission = null;
            olrGroup = VerificationUtil.getOraInventoryGroup();
            olrPermission = VDMUtil.getDefaultOlrPermissions();
            olrOwner = VerificationUtil.isHAConfigured() ? this.getOracleUser(haHome, nodeList) : VDMUtil.getDefaultOlrOwnerCRS();
            this.checkFileAttributes(new String[]{node}, olrFileName, olrFileInfoResultSet, olrOwner, olrGroup, olrPermission);
            resultSet.uploadResultSet(olrFileInfoResultSet);
            Trace.out((String)("Check passed for attributes of OLR file '" + olrFileName + "'"));
            if (!olrFileInfoResultSet.allSuccess()) continue;
            resultSet.addResult(nodeList, 1);
        }
    }

    private void checkFileAttributes(String[] validNodeArr, String fileName, ResultSet fileInfoResultSet, String refOwner, String refGroup, String refPermissions) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
        for (String node : validNodeArr) {
            ErrorDescription errDesc;
            String errMsg;
            Result result = (Result)fileInforResultTable.get(node);
            if (result != null && result.getStatus() == 1) {
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                FileInfo nodeFileInfo = (FileInfo)nodeFileList.get(fileName);
                if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) {
                    fileInfoResultSet.addResult(node, 2);
                    errMsg = s_gMsgBundle.getMessage("2030", true, (Object[])new String[]{fileName, node}) + LSEP + nodeFileInfo.getErrorString();
                    errDesc = new ErrorDescription(errMsg);
                    fileInfoResultSet.addErrorDescription(node, errDesc);
                    ReportUtil.sureprintln(errMsg);
                    continue;
                }
                if (refOwner != null && refOwner.length() > 0 && !nodeFileInfo.getFileOwner().equalsIgnoreCase(refOwner)) {
                    fileInfoResultSet.addResult(node, 3);
                    errMsg = s_gMsgBundle.getMessage("2031", true, (Object[])new String[]{fileName, node, refOwner, nodeFileInfo.getFileOwner()});
                    errDesc = new ErrorDescription(errMsg);
                    ReportUtil.sureprintln(errMsg);
                    fileInfoResultSet.addErrorDescription(node, errDesc);
                }
                if (refGroup != null && refGroup.length() > 0 && !nodeFileInfo.getFileGroup().equalsIgnoreCase(refGroup)) {
                    fileInfoResultSet.addResult(node, 3);
                    errMsg = s_gMsgBundle.getMessage("2032", true, (Object[])new String[]{fileName, node, refGroup, nodeFileInfo.getFileGroup()});
                    errDesc = new ErrorDescription(errMsg);
                    fileInfoResultSet.addErrorDescription(node, errDesc);
                    ReportUtil.sureprintln(errMsg);
                }
                if (refPermissions == null || refPermissions.length() <= 0 || Integer.parseInt(refPermissions, 8) == Integer.parseInt(nodeFileInfo.getFilePermissions(), 8)) continue;
                fileInfoResultSet.addResult(node, 3);
                errMsg = s_gMsgBundle.getMessage("2033", true, (Object[])new String[]{fileName, node, refPermissions, nodeFileInfo.getFilePermissions()});
                errDesc = new ErrorDescription(errMsg);
                fileInfoResultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                continue;
            }
            fileInfoResultSet.addResult(node, 2);
            errMsg = s_gMsgBundle.getMessage("2030", true, (Object[])new String[]{fileName, node});
            errDesc = new ErrorDescription(errMsg);
            fileInfoResultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
    }

    private String getOracleUser(String haHome, String[] nodeList) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        String oracleBinary = haHome + File.separator + "bin" + File.separator + new SystemFactory().CreateSystem().getExeName("oracle");
        GlobalExecution globalExec = new GlobalExecution();
        List<String> fileList = Arrays.asList(oracleBinary);
        ResultSet resultSet = new ResultSet();
        boolean fileInfoResult = globalExec.getFileInfo(nodeList, fileList, resultSet);
        Trace.out((String)"After calling globalExec.getFileInfo() ... ");
        if (!fileInfoResult) {
            return null;
        }
        for (String node : nodeList) {
            Result result = (Result)resultSet.getResultTable().get(node);
            if (result == null || result.getStatus() != 1) continue;
            Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
            boolean nodeFailed = false;
            FileInfo nodeFileInfo = (FileInfo)nodeFileList.get(oracleBinary);
            if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) continue;
            return nodeFileInfo.getFileOwner();
        }
        return null;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4436", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4487", false);
    }
}

