/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOSPatch
extends Task {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1053", false);
    private String m_reqOsPatch;
    private String m_osPatchDisplayTag;

    public TaskOSPatch(String reqdPatch) {
        this.m_reqOsPatch = reqdPatch;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.checkOSPatch(this.m_nodeList, this.m_reqOsPatch, this.m_resultSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.APPLIED, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = this.m_resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String sPatchAppl = ReportUtil.MISSING;
            if (result.getResultInfoSet().size() > 0) {
                sPatchAppl = (String)result.getResultInfoSet().elementAt(0);
                sPatchAppl = this.formatOSPatchDisplayString(sPatchAppl);
            }
            if (result.getStatus() == 1) {
                ReportUtil.writeRecord(node, sPatchAppl, this.formatOSPatchDisplayString(this.m_reqOsPatch), ReportUtil.PASSED);
                result.setHasResultValues(true);
                result.setExpectedValue(this.formatOSPatchDisplayString(this.m_reqOsPatch));
                result.setActualValue(sPatchAppl);
                continue;
            }
            if (result.getStatus() == 3) {
                ReportUtil.writeRecord(node, sPatchAppl, this.formatOSPatchDisplayString(this.m_reqOsPatch), ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("9809", true, (Object[])new String[]{node, this.m_reqOsPatch, sPatchAppl}), s_msgBundle, "9809");
                result.addErrorDescription(errDesc);
                result.setHasResultValues(true);
                result.setExpectedValue(this.formatOSPatchDisplayString(this.m_reqOsPatch));
                result.setActualValue(sPatchAppl);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.formatOSPatchDisplayString(this.m_reqOsPatch), ReportUtil.FAILED);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("9695", true, (Object[])new String[]{node}), s_msgBundle, "9809");
            result.addErrorDescription(errDesc);
        }
        if (this.m_resultSet.allSuccess()) {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0314", false, (Object[])new String[]{this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
            return true;
        }
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0315", false, (Object[])new String[]{this.formatOSPatchDisplayString(this.m_reqOsPatch), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private String formatOSPatchDisplayString(String patch) {
        if (this.m_osPatchDisplayTag == null) {
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            this.m_osPatchDisplayTag = nativeSystem.isUnixSystem() ? s_msgBundle.getMessage("9694", false) : s_msgBundle.getMessage("9693", false);
        }
        return this.m_osPatchDisplayTag + " " + patch;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4413", false) + ":" + this.m_reqOsPatch;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4464", false, (Object[])new String[]{this.m_reqOsPatch});
    }

    @Override
    public String getTaskID() {
        return "OSPatch_" + this.m_reqOsPatch;
    }
}

