/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskOhasdIntegrity;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOhasdIntegrity
extends Task {
    private boolean m_toUseHAinstall;

    public TaskOhasdIntegrity(String[] nodeList, boolean toUseHAinstall) {
        this(nodeList, toUseHAinstall, null, 1);
    }

    public TaskOhasdIntegrity(String[] nodeList, boolean toUseHAinstall, MultiTaskHandler multiTaskHandler) {
        this(nodeList, toUseHAinstall, multiTaskHandler, 1);
    }

    public TaskOhasdIntegrity(String[] nodeList, boolean toUseHAinstall, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_toUseHAinstall = toUseHAinstall;
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Performing Ohasd integrity verification task... ");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5282", false));
        this.performOHASDIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5283", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5284", false));
        return false;
    }

    void performOHASDIntegrityChecks() {
        String traceTxt = null;
        String homeType = null;
        String exeHome = null;
        ArrayList<String> nodeList = new ArrayList<String>();
        traceTxt = this.m_toUseHAinstall ? new String("Attempt to get HA home") : new String("Attempt to get CRS home");
        String string = homeType = this.m_toUseHAinstall ? "HA" : "CRS";
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)traceTxt);
        }
        if ((exeHome = VerificationUtil.getHAorCRSHome(this.m_nodeList, homeType, nodeList, this.m_resultSet)) == null) {
            return;
        }
        String[] validNodeArr = nodeList.toArray(new String[nodeList.size()]);
        String string2 = traceTxt = this.m_toUseHAinstall ? new String("HA home is: '" + exeHome + "'") : new String("CRS home is: '" + exeHome + "'");
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)traceTxt);
        }
        String cmdSpec = exeHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "crsctl check has";
        GlobalExecution globalExec = new GlobalExecution();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("validNodeArr is: '" + VerificationUtil.strArr2List(validNodeArr) + "'" + LSEP + "Attempt to run the command:'" + cmdSpec + "'"));
        }
        ResultSet ohasdResultSet = new ResultSet();
        Hashtable ohasdCheckOutput = globalExec.runExeWithOutput(validNodeArr, cmdSpec, ohasdResultSet);
        for (String node : validNodeArr) {
            ErrorDescription errDesc;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Checking the result of command execution on node: '" + node + "'"));
            }
            Result result = ohasdResultSet.getResult(node);
            String etOutput = (String)ohasdCheckOutput.get(node);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("exectask Output is:'" + etOutput + "'"));
            }
            if (result.getStatus() == 2) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Failed to execute the exectask command on node '" + node + "'"));
                }
                errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + etOutput);
                ReportUtil.printError(errDesc.getErrorMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 2);
                continue;
            }
            String cmdOutput = VerificationUtil.fetchVerificationValue(etOutput);
            String cmdExitStat = VerificationUtil.fetchVerificationResult(etOutput);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("cmdExitStat is:'" + cmdExitStat + "'" + LSEP + "cmdOutput is:'" + cmdOutput + "'"));
            }
            if (!cmdExitStat.equals("0")) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nCMD: " + cmdSpec + "\n FAILED with: " + cmdOutput));
                }
                errDesc = new ErrorDescription("5302", new String[]{node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + cmdOutput);
                ReportUtil.printError(errDesc.getErrorMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 2);
                continue;
            }
            if (cmdOutput.startsWith("CRS-4638")) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("ohasd is running on node '" + node + "'"));
                }
                ReportUtil.println(s_msgBundle.getMessage("5309", false, (Object[])new String[]{node}));
                this.m_resultSet.addResult(node, 1);
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("OHASD not running, or cannot be contacted on node '" + node + "'" + "\n CMD: " + cmdSpec + "\n FAILED with: " + cmdOutput));
            }
            errDesc = new ErrorDescription("5308", new String[]{node}, s_msgBundle);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + cmdOutput);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(node, 3);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Investigate ohasd configuaration details");
            }
            sTaskOhasdIntegrity sTask = new sTaskOhasdIntegrity(this);
            sTask.checkOhasdConfig(node, this.m_resultSet);
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5280", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5281", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

