/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskOraclePatch
extends Task
implements CVUHelperConstants {
    private String m_reqOraclePatch;
    private String m_home;
    private VerificationType m_vType = null;
    private boolean m_dummyTask = false;
    private final String OPATCH_STATUS_HELPER_ARG = "-getOPatchStatus";

    public TaskOraclePatch(VerificationType vType, String home, String reqdPatch) {
        this.m_home = home;
        this.m_reqOraclePatch = reqdPatch;
        this.m_vType = vType;
    }

    public TaskOraclePatch(VerificationType vType, String home, boolean dummyTask) {
        this.m_home = home;
        this.m_dummyTask = dummyTask;
        this.m_vType = vType;
    }

    @Override
    public boolean performTask() {
        ReportUtil.blankln();
        if (this.m_dummyTask) {
            String msg = s_gMsgBundle.getMessage("1255", false, (Object[])new String[]{this.m_home});
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        ReportUtil.println(s_gMsgBundle.getMessage("1250", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
        GlobalExecution globalExec = new GlobalExecution();
        String homeVersion = this.getHomeVersion(this.m_home);
        String cmd = this.getCommand(homeVersion, this.m_home);
        globalExec.runGenericCmd(this.m_nodeList, cmd, this.m_resultSet);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.APPLIED, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = this.m_resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String sPatchAppl = ReportUtil.MISSING;
            if (result.getStatus() == 1) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                String match = this.isPatchInstalled(homeVersion, cmdOut, this.m_reqOraclePatch);
                if (match != null) {
                    sPatchAppl = match;
                    ReportUtil.writeRecord(node, sPatchAppl, this.getDisplayString(this.m_reqOraclePatch), ReportUtil.PASSED);
                    result.setHasResultValues(true);
                    result.setExpectedValue(this.getDisplayString(this.m_reqOraclePatch));
                    result.setActualValue(sPatchAppl);
                    continue;
                }
                ReportUtil.writeRecord(node, sPatchAppl, this.getDisplayString(this.m_reqOraclePatch), ReportUtil.FAILED);
                ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1253", true, (Object[])new String[]{node, this.m_home}), s_gMsgBundle, "1253");
                this.m_resultSet.getResult(node).setExpectedValue(this.getDisplayString(this.m_reqOraclePatch));
                this.m_resultSet.getResult(node).setActualValue(sPatchAppl);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 3);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.getDisplayString(this.m_reqOraclePatch), ReportUtil.FAILED);
            ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1254", true, (Object[])new String[]{node}), s_gMsgBundle, "1254");
            result.addErrorDescription(errDesc);
        }
        if (this.m_resultSet.allSuccess()) {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("1258", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
            ReportUtil.printResult(s_gMsgBundle.getMessage("1256", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
            return true;
        }
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("1259", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printResult(s_gMsgBundle.getMessage("1257", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getHome() {
        return this.m_home;
    }

    private String getHomeVersion(String home) {
        String hostName;
        String homeVersion = null;
        try {
            hostName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out((Exception)e);
            return null;
        }
        String crsHome = this.getCRSHome(home);
        homeVersion = VerificationUtil.isCRSConfigured() ? VerificationUtil.getCRSReleaseVersion(crsHome, hostName) : String.valueOf(VerificationUtil.getSIHAReleaseVersionObj(crsHome, true));
        return homeVersion;
    }

    private String getCRSHome(String home) {
        String hostName;
        try {
            hostName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out((Exception)e);
            return null;
        }
        String crsHome = null;
        if (this.m_vType.equals((Object)VerificationType.PREREQ_CRS_INST) || this.m_vType.equals((Object)VerificationType.PREREQ_SI_HA_INST) || this.m_vType.equals((Object)VerificationType.PREREQ_SI_HA_CONFIG)) {
            crsHome = home;
        } else {
            Result result = new Result(hostName);
            crsHome = VerificationUtil.getCRSHome(hostName, result);
        }
        return crsHome;
    }

    private String getDisplayString(String requiredPatch) {
        String ORStr = s_msgBundle.getMessage("7025", false) + " ";
        return requiredPatch.replaceAll(Pattern.quote("|"), ORStr);
    }

    @Override
    public String getDefaultElementName() {
        String requiredPatch = null;
        requiredPatch = this.m_dummyTask ? "N/A" : this.getDisplayString(this.m_reqOraclePatch);
        return s_gMsgBundle.getMessage("1251", false) + ":" + requiredPatch;
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_dummyTask) {
            return s_gMsgBundle.getMessage("1255", false, (Object[])new String[]{this.m_home});
        }
        return s_gMsgBundle.getMessage("1252", false, (Object[])new String[]{this.getDisplayString(this.m_reqOraclePatch), this.m_home});
    }

    @Override
    public String getTaskID() {
        return "OraclePatch_" + this.m_reqOraclePatch;
    }

    private String getCommand(String homeVersion, String home) {
        return home + VerificationUtil.FSEP + "OPatch" + VerificationUtil.FSEP + "opatch" + " lsinv -oh " + home;
    }

    private String isPatchInstalled(String homeVersion, String[] cmdOut, String requiredPatch) {
        return this.isPatchInstalledPre11203(cmdOut, requiredPatch);
    }

    private String isPatchInstalledPost11203(String[] output) {
        String[] patchDetailsArr = null;
        String[] errorArray = null;
        String match = null;
        if (output.length != 0) {
            String outputStr = VerificationUtil.strArr2List(output);
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution");
                errorArray = CVUHelperUtil.fetchError(output);
            } else if (status == 1) {
                Trace.out((String)"partial success with data collection");
                patchDetailsArr = CVUHelperUtil.fetchOutput(output);
                errorArray = CVUHelperUtil.fetchError(output);
                if (patchDetailsArr.length == 0) {
                    Trace.out((String)"all failure");
                }
            } else {
                Trace.out((String)"all data collected");
                patchDetailsArr = CVUHelperUtil.fetchOutput(output);
                Pattern p = Pattern.compile("([^:]*):installed$");
                for (String patchDeails : patchDetailsArr) {
                    Matcher m = p.matcher(patchDeails);
                    if (!m.matches()) continue;
                    match = m.group(1);
                    break;
                }
                return match;
            }
        }
        return null;
    }

    private String isPatchInstalledPre11203(String[] cmdOut, String requiredPatch) {
        String[] requiredPatches;
        ArrayList<String> patchList = new ArrayList<String>();
        for (String cmdOutList : cmdOut) {
            Pattern p = Pattern.compile("^Patch([\\s]*)([\\d]*)([\\s]*)(.*)");
            Matcher m = p.matcher(cmdOutList);
            if (!m.matches()) continue;
            String patch = m.group(2);
            patchList.add(patch);
        }
        String match = null;
        for (String requiredPatchStr : requiredPatches = requiredPatch.split(Pattern.quote("|"))) {
            if (!patchList.contains(requiredPatchStr)) continue;
            match = requiredPatchStr;
        }
        if (match == null) {
            for (String cmdOutList : cmdOut) {
                for (String requiredPatchStr : requiredPatches) {
                    if (cmdOutList.indexOf(requiredPatchStr) < 0) continue;
                    match = requiredPatchStr;
                    return match;
                }
            }
        }
        return match;
    }
}

