/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class TaskProcessAlive
extends Task {
    private String m_name;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1066", false);

    public TaskProcessAlive(String name) {
        this.m_name = name;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet procRsltSet = new ResultSet();
        globalExec.checkProcessAlive(this.m_nodeList, this.m_name, procRsltSet);
        this.m_resultSet.uploadResultSet(procRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.PROCESS, ReportUtil.RUNNING, ReportUtil.COMMENT);
        Hashtable t = procRsltSet.getResultTable();
        boolean running = false;
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            running = false;
            if (result.getStatus() == 1) {
                running = true;
            }
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.YES);
            this.m_resultSet.getResult(node).setActualValue(running ? ReportUtil.YES : ReportUtil.NO);
            if (result.getStatus() == 1) {
                String procState = (String)result.getResultInfoSet().firstElement();
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7571", false, (Object[])new String[]{this.m_name, node}), s_msgBundle.getCause("7571", false), s_msgBundle.getAction("7571", false));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                comment = ReportUtil.FAILED;
            } else {
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7572", false, (Object[])new String[]{node}), s_msgBundle.getCause("7572", false), s_msgBundle.getAction("7572", false));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                comment = ReportUtil.FAILED;
            }
            ReportUtil.writeRecord(node, this.m_name, running ? ReportUtil.YES : ReportUtil.NO, comment);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4417", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4468", false, (Object[])new String[]{this.m_name});
    }
}

