/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskResolvConfIntegrity;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskResolvConfIntegrity
extends Task {
    boolean m_mute = false;
    sTaskResolvConfIntegrity s_sTaskResolvConfIntegrity;

    public TaskResolvConfIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskResolvConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskResolvConfIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.s_sTaskResolvConfIntegrity = new sTaskResolvConfIntegrity(this.m_nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public String getDefaultDescription() {
        return this.s_sTaskResolvConfIntegrity.getDefaultDescription();
    }

    @Override
    public String getDefaultElementName() {
        return this.s_sTaskResolvConfIntegrity.getDefaultElementName();
    }

    @Override
    public String getTaskID() {
        return "RESOLV_CONF";
    }

    @Override
    public boolean performTask() {
        String msg;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            return true;
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("2006", false, (Object[])new String[]{this.s_sTaskResolvConfIntegrity.getResolvConfLocation()}) + VerificationConstants.LSEP);
        }
        try {
            this.s_sTaskResolvConfIntegrity.verify();
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(e.getMessage()));
            ReportUtil.sureprintln(e.getMessage());
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(e.getMessage()));
            ReportUtil.sureprintln(e.getMessage());
            return false;
        }
        this.m_resultSet.uploadResultSet(this.s_sTaskResolvConfIntegrity.getResultSet());
        ResultSet ssResolvConf = this.s_sTaskResolvConfIntegrity.getResultSet();
        String[] failNodes = (String[])ssResolvConf.getFailedNodes().toArray();
        if (ssResolvConf.allSuccess() || failNodes.length == 0) {
            msg = s_gMsgBundle.getMessage("2007", false, (Object[])new String[]{this.s_sTaskResolvConfIntegrity.getResolvConfLocation()}) + VerificationConstants.LSEP;
        } else {
            msg = s_gMsgBundle.getMessage("2008", false, (Object[])new String[]{this.s_sTaskResolvConfIntegrity.getResolvConfLocation()}) + VerificationConstants.LSEP;
            Trace.out((String)("RESLOV_CONF failed on nodes: '" + VerificationUtil.strArr2List(failNodes) + "'"));
            this.m_resultSet.addResult(failNodes, 3);
            this.m_resultSet.addErrorDescription(failNodes, new ErrorDescription(msg));
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(VerificationConstants.LINE_SEPARATOR + msg);
        }
        return this.m_resultSet.allSuccess();
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

