/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskTimeZoneSetting
extends Task {
    public static final int PRE = 0;
    public static final int POST = 1;
    private int m_tasktype = 0;
    public final String filePrefix = "/crs/install/s_crsconfig_";
    public final String fileSuffix = "_env.txt";

    public TaskTimeZoneSetting(String[] nodeList) {
        super(nodeList, null, 1);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    public void setTaskType(int type) {
        this.m_tasktype = type;
    }

    @Override
    public boolean performTask() {
        String cfgPath;
        String currNode;
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{this.getDefaultElementName()}));
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet tzRsltSet = new ResultSet();
        Vector<String> noCfg = new Vector<String>();
        Vector<String> noTZCfg = new Vector<String>();
        Vector<String> noTZFile = new Vector<String>();
        Hashtable cfgPaths = new Hashtable();
        if (this.m_tasktype == 1) {
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (nativeSystem.isUnixSystem()) {
                String crsHome = VerificationUtil.getCRSHome();
                if (crsHome == null) {
                    ReportUtil.printError(s_msgBundle.getMessage("9001", true));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
                cfgPaths = this.getCfgPath(crsHome);
            }
            globalExec.timeZoneConsistency(this.m_nodeList, tzRsltSet, cfgPaths);
        } else {
            globalExec.timeZoneConsistency(this.m_nodeList, tzRsltSet);
        }
        this.m_resultSet.uploadResultSet(tzRsltSet);
        Hashtable ht = this.m_resultSet.getResultTable();
        Enumeration e = ht.keys();
        String timeZone = null;
        Hashtable<Object, Vector<Object>> timeZoneList = new Hashtable<Object, Vector<Object>>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                timeZone = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: Time Zone = " + timeZone + "on node " + node));
                VerificationUtil.updateResultMap(timeZoneList, timeZone, node);
                continue;
            }
            if (result.getStatus() != 3) continue;
            String vres = (String)result.getResultInfoSet().firstElement();
            if (vres.equals("1")) {
                noCfg.add(node);
                continue;
            }
            if (vres.equals("2")) {
                noTZCfg.add(node);
                continue;
            }
            if (!vres.equals("3")) continue;
            noTZFile.add(node);
        }
        if (timeZoneList.size() > 1) {
            int ovrAllStatus = this.m_resultSet.getStatus();
            Enumeration keys1 = timeZoneList.keys();
            String erMsg0 = s_msgBundle.getMessage("5479", true);
            ReportUtil.printError(erMsg0);
            StringBuilder totalMsg = new StringBuilder();
            totalMsg.append(erMsg0);
            totalMsg.append(LSEP);
            while (keys1.hasMoreElements()) {
                String key = (String)keys1.nextElement();
                String nodeAryStr = VerificationUtil.strVect2List(timeZoneList.get(key));
                String erMsg = s_msgBundle.getMessage("5480", false, (Object[])new String[]{key, nodeAryStr});
                ReportUtil.sureprintln(erMsg);
                this.m_resultSet.addResult(timeZoneList.get(key), 3);
                totalMsg.append(erMsg);
                totalMsg.append(LSEP);
            }
            ErrorDescription ed = new ErrorDescription(totalMsg.toString());
            this.m_resultSet.addErrorDescription(ed);
        }
        if (noCfg.size() > 0) {
            int nsz = noCfg.size();
            for (int k = 0; k < nsz; ++k) {
                currNode = (String)noCfg.elementAt(k);
                cfgPath = (String)cfgPaths.get(currNode);
                ReportUtil.sureprintln(s_msgBundle.getMessage("5485", false, (Object[])new String[]{cfgPath, currNode}));
            }
        }
        if (noTZFile.size() > 0) {
            int nsz = noTZFile.size();
            String tzFileLoc = VerificationUtil.getTZFileLoc();
            String tzFileName = System.getenv("TZ");
            tzFileLoc = tzFileLoc + tzFileName;
            for (int k = 0; k < nsz; ++k) {
                String currNode2 = (String)noTZFile.elementAt(k);
                this.m_resultSet.addResult(currNode2, 3);
                String errMsg = s_msgBundle.getMessage("5498", true);
                ErrorDescription ed = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(currNode2, ed);
                ReportUtil.sureprintln(s_msgBundle.getMessage("5498", true, (Object[])new String[]{tzFileLoc, currNode2}));
            }
        }
        if (noTZCfg.size() > 0) {
            int nsz = noTZCfg.size();
            if (nsz == this.m_nodeList.length) {
                this.m_resultSet.addResult(this.m_nodeList, 1);
            } else {
                for (int k = 0; k < nsz; ++k) {
                    currNode = (String)noTZCfg.elementAt(k);
                    cfgPath = (String)cfgPaths.get(currNode);
                    this.m_resultSet.addResult(currNode, 3);
                    String errMsg = s_msgBundle.getMessage("5478", true);
                    ErrorDescription ed = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(currNode, ed);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5478", true, (Object[])new String[]{cfgPath, currNode}));
                }
            }
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{this.getDefaultElementName()}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{this.getDefaultElementName()}));
        return false;
    }

    private Hashtable getCfgPath(String crsHome) {
        Hashtable<String, String> cfgFiles = new Hashtable<String, String>();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            String hostName = VerificationUtil.getNodeName(this.m_nodeList[i]);
            cfgFiles.put(this.m_nodeList[i], crsHome + "/crs/install/s_crsconfig_" + hostName + "_env.txt");
        }
        return cfgFiles;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5483", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5484", false);
    }
}

