/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskUSMDriverChecks;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUSMDriverChecks
extends Task {
    private static final String STR_INSTALLED = "Installed";
    private static final String STR_LOADED = "Loaded";

    public TaskUSMDriverChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUSMDriverChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUSMDriverChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((int)5, (String)"Performing USM Drivers verification task... ");
        }
        if (!VerificationUtil.isACFSSupported(true)) {
            Trace.out((String)"ACFS/USM not supported on this platform");
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5160", false));
        try {
            this.performUSMDriverChecks();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5161", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5162", false));
        return false;
    }

    private void performUSMDriverChecks() {
        Trace.out((int)2, (String)"Entry");
        ResultSet resultSet = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        Vector<String> unknownNodes = new Vector<String>();
        sTaskUSMDriverChecks sTask = new sTaskUSMDriverChecks();
        boolean ret = sTask.checkDriversInstalled(this.m_nodeList, resultSet);
        Trace.out((int)5, (String)("Return value from checkDriversInstalled is " + ret));
        this.m_resultSet.uploadResultSet(resultSet);
        if (!ret) {
            Trace.out((int)5, (String)"Complete failure checking driver installed status on all of the nodes");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5156", true));
            return;
        }
        Trace.out((int)5, (String)"Drivers installed check passed on at least one node");
        resultSet.filterResult(succNodes, failNodes, unknownNodes);
        this.reportDriversInstalledStatus(succNodes, failNodes, unknownNodes);
        Trace.out((int)5, (String)"Proceeding to check if drivers loaded");
        if (succNodes.size() > 0) {
            Trace.out((int)5, (String)"Now check if drivers loaded");
            resultSet.clear();
            ret = sTask.checkDriversLoaded(succNodes, resultSet);
            Trace.out((int)5, (String)("Return value from checkDriversLoaded is " + ret));
            this.m_resultSet.uploadResultSet(resultSet);
            if (ret) {
                Trace.out((int)5, (String)"Drivers loaded check passed on at least one node");
                succNodes.clear();
                failNodes.clear();
                unknownNodes.clear();
                resultSet.filterResult(succNodes, failNodes, unknownNodes);
                this.reportDriversLoadedStatus(succNodes, failNodes, unknownNodes);
            } else {
                Trace.out((int)5, (String)"Complete failure checking driver loaded status on all of the nodes");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5168", true));
                return;
            }
        }
    }

    private void reportDriversInstalledStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes) {
        Trace.out((int)5, (String)"Reporting Drivers Installed Status");
        this.reportDriversStatus(succNodes, failNodes, unknownNodes, "5163", "5156", "5165", "5166", STR_INSTALLED);
    }

    private void reportDriversLoadedStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes) {
        Trace.out((int)5, (String)"Reporting Drivers Loaded Status");
        this.reportDriversStatus(succNodes, failNodes, unknownNodes, "5167", "5168", "5169", "5170", STR_LOADED);
    }

    private void reportDriversStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes, String passmsg, String allfailmsg, String failmsg, String unknownmsg, String whatmsg) {
        Trace.out((int)5, (String)("Reporting " + whatmsg + " Drivers Status:"));
        if (succNodes.size() > 0) {
            Trace.out((int)5, (String)("USM Drivers " + whatmsg + " on node " + succNodes));
            ReportUtil.println(s_msgBundle.getMessage(passmsg, false) + LSEP + succNodes);
        } else {
            Trace.out((int)5, (String)("USM Drivers not " + whatmsg + " on all of the nodes"));
            ReportUtil.sureprintln(s_msgBundle.getMessage(allfailmsg, true));
        }
        if (failNodes.size() > 0) {
            Trace.out((int)5, (String)("USM Drivers not " + whatmsg + " on following nodes: " + LSEP + failNodes));
            ReportUtil.sureprintln(s_msgBundle.getMessage(failmsg, true) + LSEP + failNodes);
        }
        if (unknownNodes.size() > 0) {
            Trace.out((int)5, (String)("Unable to determine if USM Drivers " + whatmsg + " on following nodes: " + LSEP + unknownNodes));
            ReportUtil.sureprintln(s_msgBundle.getMessage(unknownmsg, true) + LSEP + failNodes);
        }
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4498", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4448", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

