/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUserNotInGroup
extends Task {
    String m_user = null;
    String m_group = null;

    public TaskUserNotInGroup(String[] nodeList, String user, String group) {
        super(nodeList, null, 1);
        this.m_user = user;
        this.m_group = VerificationUtil.getCurrentOS().toLowerCase().contentEquals("aix") && group.toLowerCase().contentEquals("root") ? "system" : group;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        Object[] msgArgs = new String[]{this.m_user, this.m_group};
        ReportUtil.sureblankln();
        ReportUtil.println(s_msgBundle.getMessage("4315", false, msgArgs));
        globalExec.checkUsrInGrp(this.m_nodeList, this.m_user, this.m_group, 3, usrGrpRsltSet);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        ResultSet rootGrpRsltSet = new ResultSet();
        Hashtable ht = usrGrpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String grpStatus;
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                comment = ReportUtil.EXIST;
                grpStatus = ReportUtil.FAILED;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("4317", true, msgArgs), s_msgBundle);
                rootGrpRsltSet.addResult(node, 3);
                rootGrpRsltSet.getResult(node).addErrorDescription(errDesc);
            } else if (result.getStatus() == 3) {
                comment = ReportUtil.NOTEXIST;
                grpStatus = ReportUtil.PASSED;
                rootGrpRsltSet.addResult(node, 1);
            } else {
                grpStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("4318", true, (Object[])new String[]{this.m_user, this.m_group, node}), s_msgBundle);
                rootGrpRsltSet.addResult(node, 2);
                rootGrpRsltSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, grpStatus, comment);
        }
        this.m_resultSet.uploadResultSet(rootGrpRsltSet);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4316", false, msgArgs));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("4317", false, msgArgs));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4558", false) + ": " + this.m_user;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4559", false, (Object[])new String[]{this.m_user, this.m_group});
    }
}

