/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskVIPSubnetCheck
extends Task
implements VerificationConstants,
VerificationAPIConstants {
    static final String TYPE_OIFCFG_PUBLIC = "PUBLIC";
    private boolean m_isPreCRS = false;
    private boolean m_isAddNode = false;
    private String[] m_newNodes = null;
    private String[] m_newVipNames = null;
    private List<NIInfo> m_newVips = null;
    private List<NIInfo> m_vips = null;

    public TaskVIPSubnetCheck(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskVIPSubnetCheck(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskVIPSubnetCheck(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setIsPreCRS(boolean isPreCRS) {
        this.m_isPreCRS = isPreCRS;
    }

    public void addNodes(String[] nodeNames, String[] vipNames) {
        this.m_isAddNode = true;
        this.m_newNodes = new String[nodeNames.length];
        System.arraycopy(nodeNames, 0, this.m_newNodes, 0, nodeNames.length);
        this.m_newVipNames = new String[vipNames.length];
        System.arraycopy(vipNames, 0, this.m_newVipNames, 0, vipNames.length);
    }

    @Override
    public boolean performTask() {
        boolean retVal = false;
        boolean bSubnetCheck = false;
        List<NIInfo> vips = null;
        Trace.out((String)"Performing VIP Configuration check...");
        ReportUtil.sureprintln(s_msgBundle.getMessage("10202", false));
        if (this.m_isAddNode) {
            Trace.out((String)"Performing VIP Subnet check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10203", false));
            bSubnetCheck = this.performVIPSubnetCheckAddNodes();
            if (bSubnetCheck) {
                Trace.out((String)"VIP Subnet check was passed");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10206", false));
            } else {
                Trace.out((String)"VIP Subnet check was failed");
                String msg = s_msgBundle.getMessage("10205", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(this.m_newNodes, errDesc);
            }
            Trace.out((String)"Performing VIP active check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10204", false));
            if (this.m_newVips != null && this.m_newVips.size() > 0) {
                vips = this.checkReachability(this.m_newVips, true);
                if (vips.size() == 0) {
                    Trace.out((String)"VIP active check passed");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("10207", false));
                } else {
                    StringBuffer nodesBuf = new StringBuffer();
                    for (int i = vips.size() - 1; i >= 0; --i) {
                        nodesBuf.append(vips.get(i).getHostName());
                        if (i == 0) continue;
                        nodesBuf.append(", ");
                    }
                    String reachableNodes = nodesBuf.toString();
                    Trace.out((String)("VIP(s) " + reachableNodes + " are active. VIPs should be configured to use unused IP address before cluster install"));
                    Object[] reachableNodesArr = new String[]{reachableNodes};
                    String msg = s_msgBundle.getMessage("10209", true, reachableNodesArr);
                    ReportUtil.sureprintln(msg);
                    ErrorDescription errDesc = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription((String[])reachableNodesArr, errDesc);
                }
            }
            if (!bSubnetCheck || vips.size() != 0) {
                retVal = false;
                this.m_resultSet.addResult(this.m_newNodes, 3);
            } else {
                retVal = true;
                this.m_resultSet.addResult(this.m_newNodes, 1);
            }
        } else if (this.m_isPreCRS) {
            Trace.out((String)"Performing VIP Subnet check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10203", false));
            bSubnetCheck = this.performVIPSubnetCheckInst();
            if (bSubnetCheck) {
                Trace.out((String)"VIP Subnet check was passed");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10206", false));
            } else {
                Trace.out((String)"VIP Subnet check was failed");
                String msg = s_msgBundle.getMessage("10205", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            }
            Trace.out((String)"Performing VIP active check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10204", false));
            if (this.m_vips != null && this.m_vips.size() > 0) {
                vips = this.checkReachability(this.m_vips, true);
                if (vips.size() == 0) {
                    Trace.out((String)"VIP active check passed");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("10207", false));
                } else {
                    StringBuffer nodesBuf = new StringBuffer();
                    for (int i = vips.size() - 1; i >= 0; --i) {
                        nodesBuf.append(vips.get(i).getHostName());
                        if (i == 0) continue;
                        nodesBuf.append(", ");
                    }
                    Trace.out((String)("VIP(s) " + nodesBuf + " are active. VIPs should be configured to use unused IP address before cluster install"));
                    String msg = s_msgBundle.getMessage("10209", false, (Object[])new String[]{nodesBuf.toString()});
                    ReportUtil.printWarning(msg);
                    ErrorDescription errDesc = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                }
            }
            if (!bSubnetCheck) {
                this.m_resultSet.addResult(this.m_nodeList, 3);
            } else {
                retVal = true;
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
        } else {
            Trace.out((String)"Performing VIP Subnet check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10203", false));
            bSubnetCheck = this.performVIPSubnetCheckPostCrsInst();
            if (bSubnetCheck) {
                Trace.out((String)"VIP Subnet check was passed");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10206", false));
            } else {
                Trace.out((String)"VIP Subnet check was failed");
                String msg = s_msgBundle.getMessage("10205", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            }
            Trace.out((String)"Performing VIP active check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10204", false));
            if (this.m_vips != null && this.m_vips.size() > 0) {
                vips = this.checkReachability(this.m_vips, false);
                if (vips.size() == 0) {
                    Trace.out((String)"VIP active check passed");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("10207", false));
                } else {
                    StringBuffer nodesBuf = new StringBuffer();
                    for (int i = vips.size() - 1; i >= 0; --i) {
                        nodesBuf.append(vips.get(i).getHostName());
                        if (i == 0) continue;
                        nodesBuf.append(", ");
                    }
                    Trace.out((String)("VIP(s) " + nodesBuf + " are not active. clusterware istall should have failed to confiure VIP(s)"));
                    String msg = s_msgBundle.getMessage("10210", true, (Object[])new String[]{nodesBuf.toString()});
                    ReportUtil.sureprintln(msg);
                    ErrorDescription errDesc = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                }
            }
            if (!bSubnetCheck || vips != null && vips.size() > 0) {
                this.m_resultSet.addResult(this.m_nodeList, 3);
            } else {
                retVal = true;
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
        }
        return retVal;
    }

    /*
     * Exception decompiling
     */
    private boolean performVIPSubnetCheckInst() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<NIInfo> resolveInterfaceType(String node) {
        ArrayList<InterfaceInfo> ifInfoList = new ArrayList<InterfaceInfo>();
        ArrayList<NIInfo> niInfoLst = new ArrayList<NIInfo>();
        String cvuVarErrMsg = null;
        String netErrMsg = null;
        try {
            ClusterNetworkInfo cnInfo = ClusterNetworkInfo.getNetworkInfoFromCVUVar();
            VerifyNetwork vfyNet = new VerifyNetwork();
            vfyNet.getInterfaceInfo(node, cnInfo, ifInfoList);
            for (InterfaceInfo ifInfo : ifInfoList) {
                InetAddress subnet = InetAddress.getByName(ifInfo.getSubnet());
                InetAddress subnetMask = InetAddress.getByName(ifInfo.getNetMask());
                String ifType = ifInfo.getNetType() == 2 ? TYPE_OIFCFG_PUBLIC : null;
                niInfoLst.add(new NIInfo(null, subnet, subnetMask, ifType));
            }
        }
        catch (CVUException cvuEx) {
            cvuVarErrMsg = cvuEx.getMessage();
            Trace.out((String)("CVUException occured. message: " + cvuVarErrMsg + ". stacktrace fallows"));
            Trace.out((Exception)cvuEx);
        }
        catch (UnknownHostException e) {
            cvuVarErrMsg = e.getMessage();
            Trace.out((String)("UnknownHostException occured. message: " + cvuVarErrMsg + ". stacktrace fallows"));
            Trace.out((Exception)e);
        }
        catch (MultiNodeException mnEx) {
            netErrMsg = mnEx.getMessage();
            Trace.out((String)("MultiNodeException occured. message: " + netErrMsg + ". stacktrace fallows"));
            Trace.out((Exception)mnEx);
        }
        catch (NetworkException nEx) {
            netErrMsg = nEx.getMessage();
            Trace.out((String)("MultiNodeException occured. message: " + netErrMsg + ". stacktrace fallows"));
            Trace.out((Exception)nEx);
        }
        if (netErrMsg != null) {
            String errMsg = netErrMsg;
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        if (cvuVarErrMsg != null) {
            Trace.out((String)"INTERCONNECT_LISTis not in valid format as expected");
            cvuVarErrMsg = s_msgBundle.getMessage("5461", true, (Object[])new String[]{"INTERCONNECT_LIST"}) + LSEP + cvuVarErrMsg;
            ReportUtil.sureprintln(cvuVarErrMsg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(cvuVarErrMsg);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        return niInfoLst;
    }

    private boolean performVIPSubnetCheckPostCrsInst() {
        List<NIInfo> vips = this.getNodeVIPs(this.m_nodeList);
        this.m_vips = vips;
        if (this.m_resultSet.anyFailure()) {
            return false;
        }
        if (vips.size() == 0) {
            Trace.out((String)"No vips found. returning true as VIP check is not required");
            return true;
        }
        List<NIInfo> cluifs = this.getClusterIfs();
        if (this.m_resultSet.anyFailure() || cluifs.size() == 0) {
            return false;
        }
        return this.performVIPSubnetCheckInternal(vips, cluifs);
    }

    private boolean performVIPSubnetCheckAddNodes() {
        List<NIInfo> vips = this.getNodeVIPs(this.m_nodeList);
        this.m_vips = vips;
        this.m_newVips = new ArrayList<NIInfo>();
        int i = 0;
        if (i < this.m_newVipNames.length) {
            Trace.out((String)("Adding new vip=" + this.m_newVipNames[i] + " to the new vips list"));
            try {
                this.m_newVips.add(new NIInfo(InetAddress.getByName(this.m_newVipNames[i]), null, null, null));
            }
            catch (UnknownHostException uex) {
                Trace.out((Object)("UnknownHostException while getting IP address for VIP name " + this.m_newVipNames[i] + ". exception="), (String)uex.getMessage());
                String errMsg = s_msgBundle.getMessage("10211", true, (Object[])new String[]{this.m_newVipNames[i]});
                Trace.out((String)errMsg);
                ReportUtil.sureprintln(errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_newNodes[i], 2);
                this.m_resultSet.addErrorDescription(this.m_newNodes[i], errDesc);
            }
        }
        vips.addAll(this.m_newVips);
        List<NIInfo> cluifs = this.getClusterIfs();
        if (this.m_resultSet.anyFailure() || cluifs.size() == 0) {
            return false;
        }
        return this.performVIPSubnetCheckInternal(vips, cluifs);
    }

    private List<NIInfo> getNodeVIPs(String[] nodeList) {
        ArrayList<NIInfo> vips = new ArrayList<NIInfo>();
        Trace.out((String)"Trying to get VIPs");
        try {
            String crsHome = VerificationUtil.getCRSHome();
            if (crsHome == null) {
                Trace.out((String)"Failed to get CRS HOME.");
                String msg = s_msgBundle.getMessage("5301", true);
                ReportUtil.printError(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return vips;
            }
            String actCRSVer = VerificationUtil.getCRSActiveVersion();
            String crsctl = null;
            crsctl = VerificationUtil.isVersionPre(actCRSVer, "11.2") ? crsHome + FSEP + "bin" + FSEP + "crs_stat" : crsHome + FSEP + "bin" + FSEP + "crsctl";
            String vipResName = null;
            String localNode = VerificationUtil.getLocalHost();
            VerificationCommand[] cmds = new VerificationCommand[nodeList.length];
            for (int i = 0; i < cmds.length; ++i) {
                String[] args = null;
                if (VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
                    args = new String[]{"-rungencmd", crsctl, "-p", "ora." + nodeList[i] + ".vip"};
                } else {
                    args = new String[]{"-rungencmd", crsctl, "stat res", null, "-p"};
                    args[3] = vipResName = "ora." + nodeList[i] + ".vip";
                }
                cmds[i] = new VerificationCommand(localNode, args, null);
            }
            ResultSet rs = new ResultSet();
            new GlobalHandler().submit((Command[])cmds, 0, rs);
            if (rs.allSuccess()) {
                block5: for (int i = 0; i < cmds.length; ++i) {
                    String cmdOutput = cmds[i].getOutput();
                    StringTokenizer tokenizer = new StringTokenizer(cmdOutput, LSEP);
                    while (tokenizer.hasMoreTokens()) {
                        String[] prop = tokenizer.nextToken().split("=");
                        if (prop.length != 2 || !prop[0].equals("USR_ORA_VIP")) continue;
                        Trace.out((String)("Adding vip=" + prop[1] + " to the vip list"));
                        try {
                            String[] tokens;
                            for (String vip : tokens = prop[1].split(",")) {
                                Trace.out((String)("Adding vip=" + vip + " to the vip list"));
                                vips.add(new NIInfo(InetAddress.getByName(vip), null, null, null));
                            }
                            continue block5;
                        }
                        catch (UnknownHostException uex) {
                            Trace.out((Object)("UnknownHostException while getting IP address for VIP name " + prop[1] + ". exception="), (String)uex.getMessage());
                            String errMsg = s_msgBundle.getMessage("10211", true, (Object[])new String[]{prop[1]});
                            Trace.out((String)errMsg);
                            ReportUtil.sureprintln(errMsg);
                            ErrorDescription errDesc = new ErrorDescription(errMsg);
                            this.m_resultSet.addResult(nodeList[i], 2);
                            this.m_resultSet.addErrorDescription(nodeList[i], errDesc);
                            continue block5;
                        }
                    }
                }
            } else {
                String message = "";
                for (VerificationError vfe : rs.getErrors()) {
                    String errMsg = vfe.getErrorMessage().replace("|", LSEP);
                    message = message + LSEP + VerificationUtil.fetchVerificationValue(errMsg);
                }
                Trace.out((String)("Error message from crsctl:" + message));
                String errMsg = s_msgBundle.getMessage("5303", true, (Object[])new String[]{crsctl, localNode});
                if (message.length() > 0) {
                    errMsg = errMsg + LSEP + message;
                }
                ReportUtil.sureprintln(errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.getResult(localNode).addErrorDescription(errDesc);
                this.m_resultSet.addResult(this.m_nodeList, 2);
            }
        }
        catch (UnknownHostException uex) {
            Trace.out((Object)"exception while getting local host name. exception=", (String)uex.getMessage());
            String errMsg = s_msgBundle.getMessage("0002", true) + uex.getMessage();
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
        }
        Trace.out((String)"Returning VIP list");
        return vips;
    }

    private List<NIInfo> getClusterIfs() {
        String[] nodes = this.m_nodeList;
        ArrayList<NIInfo> niInfoLst = new ArrayList<NIInfo>();
        Trace.out((String)"Trying to get cluster network interface info");
        try {
            String FSEP = FILE_SEPARATOR;
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            List cluIfs = null;
            ArrayList netIfs = null;
            String crsHome = VerificationUtil.getCRSHome();
            String oifcfgLoc = crsHome + FSEP + "bin";
            String strCrsVer = VerificationUtil.getCRSReleaseVersion(crsHome, false);
            try {
                Version crsVer = VerificationUtil.getVersionObject(strCrsVer);
                cluIfs = cluInfo.listClusterInterfaces(oifcfgLoc, crsVer);
            }
            catch (ConfigurationException cEx) {
                Trace.out((String)("ConfigurationException occured while getting version object. strCrsVer=" + strCrsVer + ", Msg=" + cEx.getMessage()));
                cluIfs = cluInfo.listClusterInterfaces(oifcfgLoc);
            }
            netIfs = new ArrayList();
            for (int i = 0; i < nodes.length; ++i) {
                netIfs.addAll(cluInfo.listInterfaces(nodes[i], oifcfgLoc, false));
            }
            OIFCFGResult cluIf = null;
            OIFCFGResult netIf = null;
            block5: for (int i = 0; i < cluIfs.size(); ++i) {
                cluIf = (OIFCFGResult)cluIfs.get(i);
                for (int j = 0; j < netIfs.size(); ++j) {
                    netIf = (OIFCFGResult)netIfs.get(j);
                    if (!cluIf.getSubnet().equals(netIf.getSubnet())) continue;
                    niInfoLst.add(new NIInfo(null, cluIf.getSubnet(), netIf.getSubnetMask(), cluIf.getInterfaceType()));
                    continue block5;
                }
            }
        }
        catch (InstallException iex) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + iex.getMessage()));
            String errMsg = s_msgBundle.getMessage("10208", true);
            errMsg = errMsg + LSEP + iex.getMessage();
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        Trace.out((String)"End of geting cluster network interfaces info.");
        return niInfoLst;
    }

    private List<NIInfo> checkReachability(List<NIInfo> vips, boolean bActive) {
        int i;
        VerifyNetwork vfyNet = new VerifyNetwork();
        String[] vipHosts = new String[vips.size()];
        boolean[] bActiveHosts = new boolean[vips.size()];
        ArrayList<NIInfo> retVals = new ArrayList<NIInfo>();
        for (i = 0; i < vips.size(); ++i) {
            vipHosts[i] = vips.get(i).getHostName();
        }
        Trace.out((String)("checking reachability from " + this.m_nodeList[0]));
        vfyNet.checkReachFromSrcNode(vipHosts, bActiveHosts, this.m_nodeList[0]);
        for (i = 0; i < vips.size(); ++i) {
            if (bActiveHosts[i] != bActive) continue;
            retVals.add(vips.get(i));
        }
        return retVals;
    }

    private boolean performVIPSubnetCheckInternal(List<NIInfo> vips, List<NIInfo> cluIfs) {
        int i;
        NIInfo vip = null;
        NIInfo cluIf = null;
        boolean retv6 = true;
        ArrayList<NIInfo> vips_v6 = new ArrayList<NIInfo>();
        ArrayList<NIInfo> vips_v4 = new ArrayList<NIInfo>();
        ArrayList<NIInfo> cluIfs_v6 = new ArrayList<NIInfo>();
        ArrayList<NIInfo> cluIfs_v4 = new ArrayList<NIInfo>();
        for (i = 0; i < vips.size(); ++i) {
            vip = vips.get(i);
            Trace.out((String)("VIP: " + vip.getAddressAsStr()));
            if (IPAddressUtil.isIPv6AddressString((String)vip.getAddressAsStr())) {
                vips_v6.add(vip);
                continue;
            }
            vips_v4.add(vip);
        }
        for (i = 0; i < cluIfs.size(); ++i) {
            cluIf = cluIfs.get(i);
            Trace.out((String)("CluIf: " + cluIf.getSubnetAsStr()));
            if (IPAddressUtil.isIPv6AddressString((String)cluIf.getSubnetAsStr())) {
                cluIfs_v6.add(cluIf);
                continue;
            }
            cluIfs_v4.add(cluIf);
        }
        if (vips_v6.size() > 0) {
            retv6 = this.performVIPSubnetCheck(vips_v6, cluIfs_v6);
        }
        return this.performVIPSubnetCheck(vips_v4, cluIfs_v4) && retv6;
    }

    private boolean performVIPSubnetCheck(List<NIInfo> vips, List<NIInfo> cluIfs) {
        NIInfo vip = null;
        NIInfo cluIf = null;
        ArrayList<NIInfo> tmpCluIfs = new ArrayList<NIInfo>();
        for (int i = 0; i < vips.size(); ++i) {
            vip = vips.get(i);
            tmpCluIfs.clear();
            for (int j = 0; j < cluIfs.size(); ++j) {
                cluIf = cluIfs.get(j);
                if (cluIf.isPublic && this.checkSubNetwork(vip.ip, cluIf)) {
                    tmpCluIfs.add(cluIf);
                    Trace.out((String)("ADDING to tmpCluIfs:" + vip.getHostName()));
                }
                if (!Utils.isDevelopmentEnv()) continue;
                Trace.out((String)"******THIS BLOCK EXECUTES ONLY by srg and lrgs but not in shiphome lrgs and customer env***********");
                tmpCluIfs.add(cluIf);
                Trace.out((String)("ADDING(Utils.isDevelopmentEnv()=TRUE) to tmpCluIfs:" + vip.getHostName()));
            }
            cluIfs.clear();
            cluIfs.addAll(tmpCluIfs);
            if (cluIfs.size() != 0) continue;
            while (i < vips.size()) {
                Trace.out((String)("vip:" + vips.get(i).getHostName() + " does not match with any of the public subnets that other vips match"));
                ++i;
            }
            break;
        }
        return cluIfs.size() > 0;
    }

    private boolean checkSubNetwork(InetAddress vip, NIInfo cluIf) {
        byte[] netmask;
        int i = 0;
        byte[] ip1 = vip.getAddress();
        if (ip1.length != (netmask = cluIf.subnetMask.getAddress()).length) {
            Trace.out((String)("vip(name=" + vip.getHostName() + ",ip=" + vip.getHostAddress() + ") and cluIf(subnet=" + cluIf.getSubnetAsStr() + ",netmask=" + cluIf.getSubnetMaskAsStr() + ") are not same type of address family"));
            String errMsg = MessageBundle.getMessage((MessageKey)PrCiMsgID.IPADDR_SUBNETMASK_LENGTH_MISMATCH, (boolean)true, (Object[])new Object[]{vip.getHostAddress(), cluIf.getSubnetMaskAsStr()});
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        byte[] vipSubnet = new byte[ip1.length];
        for (i = 0; i < ip1.length; ++i) {
            vipSubnet[i] = (byte)(ip1[i] & netmask[i]);
        }
        byte[] ifSubnet = cluIf.subnet.getAddress();
        for (i = 0; i < vipSubnet.length && vipSubnet[i] == ifSubnet[i]; ++i) {
        }
        return i == vipSubnet.length;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("10201", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("10200", false);
    }

    @Override
    public String getTaskID() {
        return "NODE_VIP";
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    @Override
    protected boolean setupNewNodesForBigCluster() {
        String[] appNodes = null;
        try {
            appNodes = this.m_nodeMgr.getNewNodes(this.m_newNodes, NodeRoleCapability.HUB_CAPABLE);
        }
        catch (NoSuchNodesException nsnEx) {
            Trace.out((String)"NodeSuchNodesException ccured while getting node of type HUB_CAPABLE");
            this.m_resultSet.addResult(this.m_newNodes, 6);
            this.m_newNodes = new String[0];
            this.m_newVipNames = new String[0];
            return true;
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException occured while getting node of type HUB_CAPABLE. mesg=" + nmEx.getMessage()));
            return false;
        }
        List<String> appNodesLst = Arrays.asList(appNodes);
        String[] tmpNewNodes = new String[appNodes.length];
        String[] tmpNewVipNames = new String[appNodes.length];
        int j = 0;
        for (int i = 0; i < this.m_newNodes.length; ++i) {
            if (appNodesLst.contains(this.m_newNodes[i])) {
                tmpNewNodes[j] = this.m_newNodes[i];
                tmpNewVipNames[j] = this.m_newVipNames[i];
                ++j;
                continue;
            }
            this.m_resultSet.addResult(this.m_newNodes[i], 6);
        }
        this.m_newNodes = tmpNewNodes;
        this.m_newVipNames = tmpNewVipNames;
        return true;
    }

    private class NIInfo {
        public InetAddress ip = null;
        public InetAddress subnet = null;
        public InetAddress subnetMask = null;
        public boolean isPublic = false;

        public NIInfo(InetAddress ip, InetAddress subnet, InetAddress subnetMask, String type) {
            this.ip = ip;
            this.subnet = subnet;
            this.subnetMask = subnetMask;
            if (type != null) {
                this.isPublic = type.equalsIgnoreCase(TaskVIPSubnetCheck.TYPE_OIFCFG_PUBLIC) | type.equalsIgnoreCase("PUB");
            }
        }

        public String getAddressAsStr() {
            return this.ip.getHostAddress();
        }

        public String getHostName() {
            return this.ip.getHostName();
        }

        public String getSubnetAsStr() {
            return this.subnet.getHostAddress();
        }

        public String getSubnetMaskAsStr() {
            return this.subnetMask.getHostAddress();
        }
    }
}

