/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.cluster.common.NodeRole;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskValidateNodeRoles
extends Task
implements VerificationConstants {
    boolean m_isAddNode = false;
    String[] m_newNodes = null;

    public TaskValidateNodeRoles(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskValidateNodeRoles(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskValidateNodeRoles(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void addNodes(String[] newNodes) {
        this.m_isAddNode = true;
        this.m_newNodes = newNodes;
    }

    @Override
    public boolean performTask() {
        String errMsg = s_gMsgBundle.getMessage("11518", true);
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11512", false));
        Trace.out((String)"Trying to get CRSHome");
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"Failed to get CRSHome");
            String msg = errMsg + FSEP + s_msgBundle.getMessage("9001", true);
            ReportUtil.printError(msg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(msg));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        String crsctl = crsHome + FSEP + "bin" + FSEP + "crsctl";
        VerificationCommand[] cmds = new VerificationCommand[this.m_nodeList.length];
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            String node = this.m_nodeList[i];
            String[] args = new String[]{"-rungencmd", crsctl, "get", "node", "role", "config", "-brief"};
            cmds[i] = new VerificationCommand(node, args, null);
        }
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.anyFailure()) {
            String[] badNodes;
            Trace.out((String)"error occured while running crsctl command");
            String errorStr = errMsg;
            for (String node : badNodes = rs.getFailureNodes()) {
                String msg = s_msgBundle.getMessage("5303", true, (Object[])new String[]{crsctl, node});
                Result r = rs.getResult(node);
                for (VerificationError vfe : r.getErrors()) {
                    msg = msg + FSEP + vfe.getErrorMessage();
                }
                Trace.out((String)("node specific error. node=" + node + " Error=" + msg));
                errorStr = errorStr + FSEP + msg;
            }
            for (VerificationError vfe : rs.getErrors()) {
                errorStr = errorStr + LSEP + vfe.getErrorMessage();
            }
            Trace.out((String)("Error message :" + errorStr));
            ReportUtil.printError(errorStr);
            this.m_resultSet.uploadResultSet(rs);
            this.m_resultSet.addResult(badNodes, 2);
            return false;
        }
        HashSet<String> hubNodes = new HashSet<String>();
        HashSet<String> autoNodes = new HashSet<String>();
        HashSet<String> rimNodes = new HashSet<String>();
        StringBuilder sbError = new StringBuilder();
        for (int i = 0; i < cmds.length; ++i) {
            boolean bError = false;
            String cmdOutput = cmds[i].getOutput();
            Trace.out((String)("crsctl output on node " + this.m_nodeList[i] + " is : " + cmdOutput));
            String[] values = cmdOutput.trim().split("\\:");
            if (values.length == 2) {
                String node = values[0];
                String role = values[1];
                if (role.equalsIgnoreCase(NodeRole.AUTO.getRoleStr())) {
                    autoNodes.add(node);
                } else if (role.equalsIgnoreCase(NodeRole.HUB.getRoleStr())) {
                    hubNodes.add(node);
                } else if (role.equalsIgnoreCase(NodeRole.RIM.getRoleStr())) {
                    rimNodes.add(node);
                } else {
                    bError = true;
                }
            } else {
                bError = true;
            }
            if (!bError) continue;
            Trace.out((String)("crsctl error is : " + cmdOutput));
            String msg = s_msgBundle.getMessage("5303", true, (Object[])new String[]{crsctl, this.m_nodeList[i]}) + LSEP + cmdOutput;
            this.m_resultSet.addResult(this.m_nodeList[i], 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList[i], new ErrorDescription(msg));
            if (sbError.length() != 0) {
                sbError.append(LSEP);
            }
            sbError.append(msg);
        }
        if (sbError.length() != 0) {
            String errorStr = errMsg + LSEP + sbError.toString();
            Trace.out((String)("Error message :" + errorStr));
            ReportUtil.printError(errorStr);
            return false;
        }
        if (autoNodes.size() != 0 && (hubNodes.size() != 0 || rimNodes.size() != 0)) {
            String errorStr = s_gMsgBundle.getMessage("11515", true);
            ReportUtil.printError(errorStr);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errorStr));
            this.m_resultSet.addResult(this.m_nodeList, 3);
            return false;
        }
        if (this.m_isAddNode) {
            boolean isAutoConfig;
            boolean bl = isAutoConfig = autoNodes.size() != 0;
            if (this.performTaskNewNodes(isAutoConfig)) {
                String msg = s_gMsgBundle.getMessage("11519", false);
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_newNodes, 1);
                this.m_resultSet.addResult(this.m_nodeList, 1);
                return true;
            }
            return false;
        }
        String msg = s_gMsgBundle.getMessage("11519", false);
        ReportUtil.sureprintln(msg);
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return true;
    }

    private boolean performTaskNewNodes(boolean isAutoConfig) {
        if (isAutoConfig) {
            Trace.out((String)"Cluster is auto config cluster. checking for new non auto nodes");
            String[] nonAutoNodes = this.getNewNodes(false);
            if (nonAutoNodes.length != 0) {
                String errorStr = s_gMsgBundle.getMessage("11516", true, (Object[])new String[]{VerificationUtil.strArr2List(nonAutoNodes)});
                ReportUtil.printError(errorStr);
                this.m_resultSet.addErrorDescription(nonAutoNodes, new ErrorDescription(errorStr));
                this.m_resultSet.addResult(nonAutoNodes, 3);
            }
        } else {
            Trace.out((String)"Cluster is auto config cluster. checking for new auto nodes");
            String[] autoNodes = this.getNewNodes(true);
            if (autoNodes.length != 0) {
                String errorStr = s_gMsgBundle.getMessage("11517", true, (Object[])new String[]{VerificationUtil.strArr2List(autoNodes)});
                ReportUtil.printError(errorStr);
                this.m_resultSet.addErrorDescription(autoNodes, new ErrorDescription(errorStr));
                this.m_resultSet.addResult(autoNodes, 3);
            }
        }
        return this.m_resultSet.allSuccess();
    }

    private String[] getNewNodes(boolean isAutoNodes) {
        String[] newAutoNodes = null;
        String[] newNonAutoNodes = null;
        try {
            newAutoNodes = this.m_nodeMgr.getNewNodes(this.m_newNodes, NodeRoleCapability.AUTO);
            ArrayList<String> nonAutoNodesLst = new ArrayList<String>();
            List<String> newAutoNodesLst = Arrays.asList(newAutoNodes);
            for (String node : this.m_newNodes) {
                if (newAutoNodesLst.contains(node)) continue;
                nonAutoNodesLst.add(node);
            }
            newNonAutoNodes = nonAutoNodesLst.toArray(new String[0]);
        }
        catch (NoSuchNodesException nsnEx) {
            Trace.out((String)"NoSuchNodesException occured while getting new AUTO nodes");
            newNonAutoNodes = this.m_newNodes;
            newAutoNodes = new String[]{};
        }
        catch (NodeManagerException nmEx) {
            String msg = nmEx.getMessage();
            Trace.out((String)("NodeManagerException occured while getting new AUTO nodes. msg:" + msg));
            newNonAutoNodes = new String[]{};
            newAutoNodes = new String[]{};
            this.m_resultSet.addResult(this.m_newNodes, 2);
            this.m_resultSet.addErrorDescription(this.m_newNodes, new ErrorDescription(msg));
            ReportUtil.printError(msg);
        }
        if (isAutoNodes) {
            return newAutoNodes;
        }
        return newNonAutoNodes;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11511", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11510", false);
    }
}

