/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.common.NodeRole;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskUSMUdevChecks;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskVotingDisk
extends Task {
    private VoteDiskInfo[] m_voteDiskList = null;
    private boolean m_isPreReq = false;
    private boolean m_isRolling = false;
    private boolean m_isUpgrade = false;
    private String[] m_voteDiskPaths = null;
    private boolean m_couldNotFindCRSVersion = false;
    private String m_destinationVersion;

    public TaskVotingDisk(String[] nodeList) {
        this(null, 1);
        this.m_nodeList = nodeList;
    }

    public TaskVotingDisk(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(null, 1);
        this.m_nodeList = nodeList;
    }

    public TaskVotingDisk(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskVotingDisk(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public void setPreReq(boolean isPreReq) {
        this.m_isPreReq = isPreReq;
    }

    public void setDiskPaths(String[] vdPaths) {
        this.m_voteDiskPaths = vdPaths;
    }

    public void setDiskList(VoteDiskInfo[] vdList) {
        this.m_voteDiskList = vdList;
    }

    public void setisRolling(boolean isRolling) {
        this.m_isRolling = isRolling;
    }

    public void setisUpgrade(boolean isUpgrade) {
        this.m_isUpgrade = isUpgrade;
    }

    public boolean isM_couldNotFindCRSVersion() {
        return this.m_couldNotFindCRSVersion;
    }

    @Override
    public boolean performTask() {
        String m_localName = null;
        String cause = null;
        boolean status = true;
        ErrorDescription errDesc = null;
        StorageInfo stInfo = null;
        String[] validNodes = null;
        boolean nlnfeException = false;
        String notSharedMsg = null;
        ArrayList<String> voteDskLocs = new ArrayList<String>();
        ArrayList<String> voteDskLocs_orig = new ArrayList<String>();
        ArrayList<String> asmGroups = new ArrayList<String>();
        Hashtable vdiGroups = new Hashtable();
        boolean usingASM = false;
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5429", false));
        m_localName = VerificationUtil.getLocalHostName();
        Trace.out((String)("\nm_localName set to NODE NAME of: " + m_localName));
        boolean isBigCluster = this.m_nodeMgr.isBigCluster();
        if (!this.m_isPreReq || this.m_isUpgrade) {
            VerificationUtil.isCRSInstalled(this.m_nodeList, succNodeVect, failNodeVect);
            if (succNodeVect.size() != 0) {
                validNodes = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
            if (isBigCluster) {
                String[] validHubNodes = null;
                Object var18_18 = null;
                String[] allHubNodes = CVUHelperUtil.getNodeNames(NodeRole.HUB);
                String[] allRIMNodes = CVUHelperUtil.getNodeNames(NodeRole.RIM);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(validNodes));
                arrayList.retainAll(Arrays.asList(allHubNodes));
                validHubNodes = arrayList.toArray(new String[0]);
                arrayList.clear();
                arrayList.addAll(Arrays.asList(validNodes));
                arrayList.retainAll(Arrays.asList(allRIMNodes));
                String[] stringArray = arrayList.toArray(new String[0]);
                this.m_resultSet.addResult(stringArray, 1);
                validNodes = validHubNodes;
            }
        } else {
            validNodes = this.m_nodeList;
        }
        if (validNodes == null) {
            notSharedMsg = LSEP + s_msgBundle.getMessage("4037", true) + LSEP + s_msgBundle.getMessage("5447", true);
            ReportUtil.printError(notSharedMsg);
            errDesc = new ErrorDescription(notSharedMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            Trace.out((String)"No valid nodes found.");
            return false;
        }
        errDesc = new ErrorDescription("5431", s_msgBundle);
        Version verCRSActive = VerificationUtil.getCRSActiveVersionObj();
        if (verCRSActive == null) {
            cause = s_msgBundle.getMessage("5434", true);
            ReportUtil.printError(cause);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5431", true));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cause);
            this.m_resultSet.addErrorDescription(errDesc);
            Trace.out((String)"No active CRS version found.");
            this.m_couldNotFindCRSVersion = true;
            return false;
        }
        if (!this.m_isPreReq) {
            try {
                String string = VerificationUtil.getCRSHome();
                if (string == null) {
                    String errMsg = s_msgBundle.getMessage("5301", true);
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
                    ReportUtil.printError(errMsg);
                    return false;
                }
                Trace.out((String)("crshome obtained is :" + string));
                boolean votingDiskListObtained = false;
                if (isBigCluster && this.m_nodeMgr.isActiveRimNode(m_localName)) {
                    this.m_voteDiskList = VerificationUtil.getVoteDiskListFromNode(string, this.m_nodeList[0]);
                    votingDiskListObtained = true;
                    Trace.out((String)"obtained vote disk list from hub");
                }
                if (!votingDiskListObtained) {
                    Trace.out((String)"Getting Voting Disk locations from 'ClusterInfo'");
                    ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(), verCRSActive);
                    this.m_voteDiskList = ci.getVoteDiskLocations();
                }
                for (VoteDiskInfo vdiL : this.m_voteDiskList) {
                    if (vdiL.isASMPath() == 1) {
                        Trace.out((String)("Voting Disk location on ASM: " + vdiL.toString()));
                        usingASM = true;
                        List<String> vlPaths = null;
                        if (vdiGroups.containsKey(vdiL.getGroup())) {
                            vlPaths = (List)vdiGroups.get(vdiL.getGroup());
                            vlPaths.add(vdiL.getPath());
                            vdiGroups.remove(vdiL.getGroup());
                            vdiGroups.put(vdiL.getGroup(), vlPaths);
                            continue;
                        }
                        vlPaths = new ArrayList<String>();
                        vlPaths.add(vdiL.getPath());
                        vdiGroups.put(vdiL.getGroup(), vlPaths);
                        continue;
                    }
                    voteDskLocs.add(vdiL.getPath());
                }
            }
            catch (NoSuchCRSHomeException noSuchCRSHomeException) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + noSuchCRSHomeException.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("NOSUCHCRSHOMEEXCEPTION: \n" + errDesc.getErrorMessage()));
                    Trace.stackTrace();
                }
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
            catch (NoSuchExecutableException noSuchExecutableException) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + noSuchExecutableException.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("NOSUCHEXECUTABLEEXCEPTION: \n" + errDesc.getErrorMessage()));
                    Trace.stackTrace();
                }
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
            catch (ClusterInfoException clusterInfoException) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + clusterInfoException.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("CLUSTERINFOEXCEPTION: \n" + errDesc.getErrorMessage()));
                    Trace.stackTrace();
                }
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
            catch (VerificationException verificationException) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + verificationException.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                Trace.out((String)("verificaiton failed :" + errDesc.getErrorMessage()));
                ReportUtil.printError(errDesc.getErrorMessage());
                return false;
            }
        } else if (this.m_voteDiskList != null) {
            Trace.out((String)("Processing m_voteDiskList of size: " + this.m_voteDiskList.length));
            for (VoteDiskInfo voteDiskInfo : this.m_voteDiskList) {
                if (voteDiskInfo.isASMPath() == 1) {
                    usingASM = true;
                    continue;
                }
                voteDskLocs.add(voteDiskInfo.getPath());
            }
        } else if (this.m_voteDiskPaths != null) {
            Trace.out((String)("Processing m_voteDiskPaths of size: " + this.m_voteDiskPaths.length));
            for (String string : this.m_voteDiskPaths) {
                if (VerificationUtil.isASMPath(string)) {
                    usingASM = true;
                    continue;
                }
                voteDskLocs.add(string);
            }
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5432", false));
            return true;
        }
        errDesc = !Version.isPre112((Version)verCRSActive) ? new ErrorDescription("5430", s_msgBundle) : new ErrorDescription("5435", s_msgBundle);
        Vector<String> vector = new Vector<String>();
        Object voteDILoc = null;
        Object shareLoc = null;
        if (voteDskLocs.size() == 0) {
            status = true;
        }
        Object var21_42 = null;
        voteDskLocs_orig.addAll(voteDskLocs);
        if (validNodes != null && validNodes.length > 0 && voteDskLocs != null && voteDskLocs.size() > 0) {
            List<String> deviceList = new ArrayList<String>();
            deviceList.addAll(voteDskLocs);
            Result resolveDiskRes = new Result(validNodes[0]);
            deviceList = VerificationUtil.resolveASMDiskStamps(validNodes[0], deviceList, resolveDiskRes);
            if (resolveDiskRes.getStatus() != 1 || deviceList == null) {
                this.m_resultSet.addResult(validNodes[0], resolveDiskRes);
                Trace.out((String)"Failed to resolve one or more of the ASM stamps to the real device path");
                return false;
            }
            voteDskLocs.clear();
            voteDskLocs.addAll(deviceList);
            Trace.out((String)("After resolving the voting disk locs is " + voteDskLocs));
        }
        for (int i = 0; i < voteDskLocs.size(); ++i) {
            List<StorageInfo> list;
            String voteLoc = (String)voteDskLocs.get(i);
            try {
                list = new TypeFinder().getStorageInstance(voteLoc, validNodes);
            }
            catch (StorageException e) {
                Trace.out((String)("StorageException attempting to get storage type for: " + voteLoc));
                if (vector.contains(voteLoc)) continue;
                vector.add(voteLoc);
                continue;
            }
            boolean locFail = false;
            String stInfoPath = null;
            int stInfoType = 0;
            for (StorageInfo stInfoChk : list) {
                stInfo = stInfoChk;
                if (stInfo.isPolicySet() || stInfo.isLockSet()) {
                    String msgID = stInfo.isPolicySet() ? "7037" : "7038";
                    String policyErrMsg = LSEP + s_msgBundle.getMessage(msgID, true, (Object[])new String[]{voteLoc}) + stInfo.getNode();
                    ReportUtil.printError(policyErrMsg);
                    errDesc = new ErrorDescription(policyErrMsg);
                    this.m_resultSet.addErrorDescription(errDesc);
                }
                if (stInfoPath == null) {
                    stInfoType = stInfoChk.getType();
                    if (stInfoType == 1) {
                        stInfoPath = stInfoChk.getOrigPath();
                        continue;
                    }
                    stInfoPath = stInfoChk.getPath();
                    continue;
                }
                if (stInfoType == 0) {
                    stInfoType = stInfoChk.getType();
                    continue;
                }
                if (VerificationUtil.isVersionPost(this.m_destinationVersion, "12") && 1 == stInfoChk.getType()) {
                    String msg = s_gMsgBundle.getMessage("6025", true, (Object[])new String[]{stInfoChk.getOrigPath()});
                    ErrorDescription errorDesc = new ErrorDescription(msg);
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    this.m_resultSet.addErrorDescription(errorDesc);
                    ReportUtil.printError(msg + LSEP);
                    locFail = true;
                    break;
                }
                if (stInfoPath.equals(stInfoChk.getType() == 1 ? stInfoChk.getOrigPath() : stInfoChk.getPath()) && stInfoType == stInfoChk.getType()) continue;
                notSharedMsg = LSEP + s_msgBundle.getMessage("5448", true, (Object[])new String[]{voteLoc});
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 3);
                locFail = true;
                Trace.out((String)("stInfoPath: " + stInfoPath + " stInfoChk path: " + (stInfoChk.getType() == 1 ? stInfoChk.getOrigPath() : stInfoChk.getPath()) + " stInfoType: " + stInfoType + " stInfoChk type: " + stInfoChk.getType()));
                break;
            }
            if (locFail) continue;
            if (voteLoc != stInfoPath) {
                voteLoc = stInfoPath;
                voteDskLocs.set(i, voteLoc);
            }
            if (stInfo.getType() == 1) {
                if (vector.contains(voteLoc)) continue;
                vector.add(voteLoc);
                continue;
            }
            sTaskFreeSpace sTask = new sTaskFreeSpace();
            Command[] cmdArray = new Command[1];
            ResultSet rsltSet = new ResultSet();
            boolean verifySharedness = true;
            String cmd = sTask.getCommand(voteLoc);
            cmdArray[0] = new RunGenericCommand(m_localName, cmd);
            boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, rsltSet);
            Hashtable t = rsltSet.getResultTable();
            Enumeration e = t.keys();
            String fileSystem = "UNKNOWN";
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() == 2) {
                    fileSystem = "UNKNOWN";
                    continue;
                }
                String cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                fileSystem = sTask.getData(cmdOut, 0);
            }
            if (!fileSystem.contentEquals("UNKNOWN") && !vector.contains(fileSystem)) {
                vector.add(fileSystem);
            } else {
                vector.add(voteLoc);
            }
            VerifyStorage vsVoteDisk = new VerifyStorage();
            int storageType = stInfo.getType();
            Trace.out((String)("_st_ = " + stInfo.getType()));
            switch (storageType) {
                case 1: 
                case 2: 
                case 7: 
                case 8: 
                case 13: {
                    break;
                }
                default: {
                    verifySharedness = false;
                }
            }
            if (validNodes == null || !verifySharedness) continue;
            try {
                if (vsVoteDisk.isShared(voteLoc, validNodes, OracleFileType.RAC_OCR_VDISK, verCRSActive.toString4())) continue;
                notSharedMsg = LSEP + s_msgBundle.getMessage("5448", false, (Object[])new String[]{voteLoc});
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 3);
                Trace.out((String)("Vote Disk location not shared: " + voteLoc));
                continue;
            }
            catch (StorageException se) {
                Trace.out((String)("STORAGEEXCEPTION:(could not check voting disk sharedness\n" + se));
                if (null != se.getMessage()) {
                    Trace.out((String)("StorageException message: " + se.getMessage()));
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", false, (Object[])new String[]{voteLoc}) + " " + VerificationUtil.strArr2List(validNodes) + LSEP + se.getMessage();
                } else {
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", false, (Object[])new String[]{voteLoc}) + " " + VerificationUtil.strArr2List(validNodes);
                }
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 2);
                continue;
            }
            catch (MultiNodeException mne) {
                Trace.out((String)("MULTINODEEXCEPTION:(could not check voting disk sharedness\n" + mne));
                if (null != mne.getMessage()) {
                    Trace.out((String)("MultiNodeException message: " + mne.getMessage()));
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", false, (Object[])new String[]{voteLoc}) + " " + VerificationUtil.strArr2List(validNodes) + LSEP + mne.getMessage();
                } else {
                    notSharedMsg = LSEP + s_msgBundle.getMessage("7020", false, (Object[])new String[]{voteLoc}) + " " + VerificationUtil.strArr2List(validNodes);
                }
                ReportUtil.printError(notSharedMsg);
                errDesc = new ErrorDescription(notSharedMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(validNodes, 2);
            }
        }
        if (!usingASM && (voteDskLocs.size() == 0 || voteDskLocs.size() == 2 || vector.size() < voteDskLocs.size() && vector.size() < 3)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n ** Voting disk configuration does not meet oracle recommendations. **\n ** Number of voting disk(s) found: " + voteDskLocs.size() + " ** Number of uniqueLocs found: " + vector.size()));
                Trace.out((String)"\n ** Voting disk location(s) checked: ");
                if (voteDskLocs.size() != 0) {
                    for (String vdl : voteDskLocs) {
                        Trace.out((String)vdl);
                    }
                }
                Trace.out((String)"\n ** Unique location(s) checked: ");
                if (vector.size() != 0) {
                    for (String ul : vector) {
                        Trace.out((String)ul);
                    }
                }
            }
            this.m_resultSet.addResult(this.m_nodeList, 4);
            this.m_resultSet.addErrorDescription(errDesc);
            if (!Version.isPre112((Version)verCRSActive)) {
                ReportUtil.printWarning(s_msgBundle.getMessage("5430", true));
            } else {
                ReportUtil.printWarning(s_msgBundle.getMessage("5435", true));
            }
            status = false;
        }
        if (voteDskLocs.size() > 0) {
            int k = -1;
            for (String vdLoc : voteDskLocs) {
                ResultSet fileInfoResultSet;
                Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo;
                ++k;
                if (this.m_voteDiskList != null && this.m_voteDiskList.length > 0) {
                    usingASM = false;
                    for (VoteDiskInfo vdiL : this.m_voteDiskList) {
                        Trace.out((String)("Checking VD path: '" + vdLoc + "' against VoteDiskInfo path: '" + vdiL.getPath() + "'"));
                        if (!vdiL.getPath().contentEquals(vdLoc) || vdiL.isASMPath() != 1) continue;
                        Trace.out((String)("Path: '" + vdLoc + "' is on ASM"));
                        usingASM = true;
                    }
                    if (usingASM) continue;
                }
                if ((nodeFileInfo = VerificationUtil.getFileAttributes(validNodes, vdLoc, fileInfoResultSet = new ResultSet())) == null || nodeFileInfo.isEmpty()) {
                    this.m_resultSet.uploadResultSet(fileInfoResultSet);
                    continue;
                }
                String owner = null;
                String group = null;
                String perms = null;
                if (!this.m_isPreReq && !this.m_isUpgrade) {
                    Trace.out((String)"Getting owner, group, perms");
                    owner = TaskUSMUdevChecks.getVDiskOwner();
                    group = VerificationUtil.getOraInventoryGroup();
                    perms = VDMUtil.getDefaultVDiskPermissions();
                }
                Trace.out((String)("Checking vdLoc: '" + vdLoc + "' Owner: '" + owner + "' Group: '" + group + "' Perms: '" + perms + "'"));
                ResultSet chkFileAttRes = new ResultSet();
                Hashtable<String, List<String>> failedNodes = VerificationUtil.checkFileAttributes(validNodes, vdLoc, nodeFileInfo, owner, group, perms, chkFileAttRes);
                if (failedNodes.keySet().size() == 0) continue;
                String mesg = s_msgBundle.getMessage("5449", true, (Object[])new String[]{(String)voteDskLocs_orig.get(k) + "(" + vdLoc + ")"});
                status = false;
                ReportUtil.printError(mesg);
                ReportUtil.sureprintNodelist(failedNodes.keySet().toArray(new String[0]));
                for (String node : failedNodes.keySet()) {
                    List<String> failedNodeErrors = failedNodes.get(node);
                    ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strCollection2String(failedNodeErrors, ";"));
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(mesg));
                    for (String error : failedNodeErrors) {
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(error));
                    }
                }
            }
        }
        if (usingASM && !this.m_isPreReq && !this.m_isUpgrade || usingASM && this.m_isUpgrade && this.m_isRolling) {
            String[] validNodeArr = validNodes;
            String errMsg = null;
            ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
            if (validNodeArr != null && vdiGroups.size() != 0) {
                ASMDiskGroupsUtil dgutil = new ASMDiskGroupsUtil();
                Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT = new Hashtable<String, List<ASMDiskGroup>>();
                try {
                    dgutil.getDiskGroups(validNodeArr, this.m_resultSet, asmDiskGroupHT);
                    for (String node : validNodeArr) {
                        List<ASMDiskGroup> dgl = asmDiskGroupHT.get(node);
                        if (dgl == null || dgl.size() <= 0) continue;
                        for (ASMDiskGroup dg1 : dgl) {
                            asmGroups.add(dg1.getName());
                        }
                    }
                    for (String vdGroup : vdiGroups.keySet()) {
                        if (asmGroups.contains(vdGroup)) continue;
                        List noGrpLocs = (List)vdiGroups.get(vdGroup);
                        for (String vdPathLoc : noGrpLocs) {
                            errMsg = LSEP + s_msgBundle.getMessage("5157", true, (Object[])new String[]{vdGroup, vdPathLoc}) + LSEP;
                            ReportUtil.printError(errMsg);
                            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                            status = false;
                        }
                    }
                }
                catch (ASMDiskGroupsUtilException e2) {
                    errMsg = LSEP + s_msgBundle.getMessage("5131", true) + LSEP + e2.getMessage();
                    ReportUtil.printError(errMsg);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    status = false;
                }
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        if (status) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5432", false));
            return true;
        }
        this.m_resultSet.addResult(this.m_nodeList, 3);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5431", true));
        errDesc = new ErrorDescription("5431", s_msgBundle);
        this.m_resultSet.addErrorDescription(errDesc);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9502", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9603", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    public void setDestinationVersion(String destinationVersion) {
        this.m_destinationVersion = destinationVersion;
    }
}

