/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Hashtable;
import java.util.Iterator;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskCFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskDaemonLiveliness;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCFSIntegrity {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String LSEP = System.getProperty("line.separator");
    private TaskCFSIntegrity m_genTask;
    private String m_fullOcfsDriverName;
    private static final String m_regKey_cluName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\ocfs\\ClusterName";
    private static final String m_regKey_cfsDrives = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\ocfs\\PARAMETERS\\CFSDRIVE\\CFSDRIVE";
    private static final String SYSTEM_ROOT = "SystemRoot";
    private static final String OCFS_SERVICE = "ocfs";
    private static final String OCVS_SERVICE = "OracleClusterVolumeService";
    private static final String OCFS_DRIVER = "ocfs.sys";

    public sTaskCFSIntegrity(TaskCFSIntegrity genTask) {
        this.m_genTask = genTask;
    }

    public boolean performCheck() {
        boolean bTaskFailed = false;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4500", false));
        ReportUtil.sureblankln();
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable ht = null;
        TaskDaemonLiveliness taskDaemon = new TaskDaemonLiveliness(this.m_genTask.m_nodeList);
        taskDaemon.setDaemonName(OCFS_SERVICE);
        boolean bOcfsStatus = taskDaemon.performTask();
        ResultSet ocfsResultSet = taskDaemon.getResultSet();
        this.m_genTask.m_resultSet.uploadResultSet(ocfsResultSet);
        taskDaemon = new TaskDaemonLiveliness(this.m_genTask.m_nodeList);
        taskDaemon.setDaemonName(OCVS_SERVICE);
        boolean bCvsStatus = taskDaemon.performTask();
        ResultSet cvsResultSet = taskDaemon.getResultSet();
        this.m_genTask.m_resultSet.uploadResultSet(cvsResultSet);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult nativeResult = nativeSystem.getEnvironment(SYSTEM_ROOT);
        String sysRoot = nativeResult.getStringResult();
        Trace.out((String)("==== System root is: " + sysRoot));
        this.m_fullOcfsDriverName = sysRoot + "\\system32\\drivers\\" + OCFS_DRIVER;
        Trace.out((String)("==== Absolute filename for OCFS driver: " + this.m_fullOcfsDriverName));
        ResultSet drvRSet = new ResultSet();
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4515", false, (Object[])new String[]{OCFS_DRIVER}));
        globalExec.checkFileInSysPath(this.m_genTask.m_nodeList, this.m_fullOcfsDriverName, drvRSet);
        String[] nodeArrWithDriver = this.m_genTask.m_nodeList;
        if (1 == drvRSet.getStatus()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4510", false, (Object[])new String[]{OCFS_DRIVER}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4511", false, (Object[])new String[]{OCFS_DRIVER}));
            ReportUtil.sureprintNodelist(drvRSet.getFailureNodes());
            drvRSet.addErrorDescription(drvRSet.getFailureNodes(), new ErrorDescription(s_msgBundle.getMessage("4533", false, (Object[])new String[]{OCFS_DRIVER})));
            Trace.out((String)"\n>>>> sTaskCFSIntegrity:: Upload OCFS driver ResultSet >>>>\n");
            this.m_genTask.m_resultSet.uploadResultSet(drvRSet);
            nodeArrWithDriver = VerificationUtil.diffStringArr(this.m_genTask.m_nodeList, drvRSet.getFailureNodes());
            if (nodeArrWithDriver == null || nodeArrWithDriver.length == 0) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                return false;
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(nodeArrWithDriver);
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4512", false, (Object[])new String[]{OCFS_DRIVER}));
        ResultSet fverRSet = new ResultSet();
        globalExec.checkFileVersion(nodeArrWithDriver, this.m_fullOcfsDriverName, "", fverRSet);
        String sDrvVer = null;
        String lastVer = null;
        boolean verMismatch = false;
        ht = fverRSet.getResultTable();
        Hashtable<String, String> verHt = new Hashtable<String, String>();
        for (String node : ht.keySet()) {
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 2) {
                sDrvVer = ReportUtil.UNKNOWN;
            } else {
                sDrvVer = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("==== Node: " + node + ", CFS driver ver: " + sDrvVer));
            }
            if (!verMismatch) {
                if (lastVer == null) {
                    lastVer = sDrvVer;
                } else if (!lastVer.equals(sDrvVer)) {
                    verMismatch = true;
                }
            }
            verHt.put(node, sDrvVer);
        }
        ResultSet fsizeRSet = new ResultSet();
        globalExec.checkFileExistence(nodeArrWithDriver, this.m_fullOcfsDriverName, fsizeRSet);
        String sDrvSize = null;
        String lastSize = null;
        boolean sizeMismatch = false;
        ht = fsizeRSet.getResultTable();
        Hashtable<String, String> sizeHt = new Hashtable<String, String>();
        for (String node : ht.keySet()) {
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 2) {
                sDrvSize = ReportUtil.UNKNOWN;
            } else {
                sDrvSize = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("==== Node: " + node + ", CFS driver size: " + sDrvSize));
            }
            if (!sizeMismatch) {
                if (lastSize == null) {
                    lastSize = sDrvSize;
                } else if (!lastSize.equals(sDrvSize)) {
                    sizeMismatch = true;
                }
            }
            sizeHt.put(node, sDrvSize);
        }
        if (!verMismatch && !sizeMismatch) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4513", false, (Object[])new String[]{OCFS_DRIVER, lastVer}));
        } else {
            ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.VERSION, ReportUtil.FILESIZE);
            for (String node : ht.keySet()) {
                ReportUtil.surewriteRecord(node, (String)verHt.get(node), (String)sizeHt.get(node));
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("4514", false, (Object[])new String[]{OCFS_DRIVER}));
        }
        TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(nodeArrWithDriver);
        String[] fileSystemList = new String[]{this.m_genTask.m_fileSystem};
        taskSSAccess.setStorageIDlist(fileSystemList);
        taskSSAccess.setCheckOCFS(true);
        boolean ssaStatus = taskSSAccess.performTask();
        ResultSet ssaRset = taskSSAccess.getResultSet();
        this.m_genTask.m_resultSet.uploadResultSet(ssaRset);
        ReportUtil.println(s_msgBundle.getMessage("4509", false));
        ResultSet avlDrvRset = new ResultSet();
        globalExec.getRegKeyData(nodeArrWithDriver, m_regKey_cfsDrives, avlDrvRset);
        ht = avlDrvRset.getResultTable();
        Iterator nodeIterator = ht.keySet().iterator();
        String sDrives = null;
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE);
        while (nodeIterator.hasNext()) {
            String node = (String)nodeIterator.next();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 2) {
                sDrives = ReportUtil.UNKNOWN;
            } else {
                sDrives = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("==== Node: " + node + ", CFSDRIVE: " + sDrives));
            }
            ReportUtil.writeRecord(node, sDrives);
        }
        return !bTaskFailed;
    }
}

