/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskCheckEnvVariable;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskCheckEnvVariable {
    private TaskCheckEnvVariable m_taskenv;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static ClusterWindows clusterWindows = null;

    public sTaskCheckEnvVariable(TaskCheckEnvVariable taskenv) {
        this.m_taskenv = taskenv;
    }

    public boolean checkEnvVariable(Hashtable<String, Integer> maxVarLenOnNode, Vector<String> varSetNodes, Vector<String> varNotSetNodes, Vector<String> lenExceedNodes, ResultSet evResultSet) {
        boolean isvarSet = false;
        int varLength = 0;
        String errMsg = null;
        HashMap nodeValPair = null;
        Vector<String> remOpFailedNodes = new Vector<String>();
        String m_srcLoc = VerificationUtil.getSrcLoc() + File.separator + "bin";
        Trace.out((String)("sTaskCheckEnvVariable:: The srcLoc is " + m_srcLoc));
        Trace.out((String)("sTaskCheckEnvVariable:: Performing Environment Variable verification for variable (" + this.m_taskenv.m_envVarName + ") on Windows... "));
        try {
            if (clusterWindows == null) {
                Trace.out((String)"sTaskCheckEnvVariable:: Cannot create ClusterWindows ");
                errMsg = s_msgBundle.getMessage("3919", true);
                evResultSet.addErrorDescription(this.m_taskenv.m_nodeList, new ErrorDescription(errMsg));
                evResultSet.addResult(this.m_taskenv.m_nodeList, 2);
                return false;
            }
            nodeValPair = clusterWindows.getEnvironmentVariable(this.m_taskenv.m_nodeList, this.m_taskenv.m_envVarName, m_srcLoc, this.m_taskenv.m_restartService && !Utils.isDevelopmentEnv());
            if (nodeValPair == null) {
                Trace.out((String)("sTaskCheckEnvVariable:: Cannot read Environment Variable " + this.m_taskenv.m_envVarName + " from specified nodes"));
                errMsg = s_msgBundle.getMessage("3919", true, (Object[])new String[]{this.m_taskenv.m_envVarName});
                evResultSet.addErrorDescription(this.m_taskenv.m_nodeList, new ErrorDescription(errMsg));
                evResultSet.addResult(this.m_taskenv.m_nodeList, 2);
                return false;
            }
        }
        catch (ClusterException ce) {
            Trace.out((String)("sTaskCheckEnvVariable::ClusterException - Cannot read Environment Variable " + this.m_taskenv.m_envVarName + "  Error:" + ce.getMessage()));
            errMsg = s_msgBundle.getMessage("3919", true, (Object[])new String[]{this.m_taskenv.m_envVarName});
            evResultSet.addErrorDescription(this.m_taskenv.m_nodeList, new ErrorDescription(errMsg));
            evResultSet.addResult(this.m_taskenv.m_nodeList, 2);
            return false;
        }
        catch (RemoteFileOperationException rfe) {
            Trace.out((String)("sTaskCheckEnvVariable::RemoteFileOperationException - Cannot read Environment Variable " + this.m_taskenv.m_envVarName + "  Error:" + rfe.getMessage()));
            for (int i = 0; i < this.m_taskenv.m_nodeList.length; ++i) {
                try {
                    if (rfe.getStatus(this.m_taskenv.m_nodeList[i]) == 1) {
                        errMsg = rfe.getErrorMessage(this.m_taskenv.m_nodeList[i]);
                        evResultSet.addErrorDescription(this.m_taskenv.m_nodeList[i], new ErrorDescription(errMsg));
                        evResultSet.addResult(this.m_taskenv.m_nodeList[i], 2);
                        remOpFailedNodes.add(this.m_taskenv.m_nodeList[i]);
                        continue;
                    }
                    if (rfe.getStatus(this.m_taskenv.m_nodeList[i]) != 2) continue;
                    errMsg = rfe.getException(this.m_taskenv.m_nodeList[i]).getMessage();
                    evResultSet.addErrorDescription(this.m_taskenv.m_nodeList[i], new ErrorDescription(errMsg));
                    evResultSet.addResult(this.m_taskenv.m_nodeList[i], 2);
                    remOpFailedNodes.add(this.m_taskenv.m_nodeList[i]);
                    continue;
                }
                catch (NoSuchNodeException ne) {
                    Trace.out((String)ne.getMessage());
                    Trace.out((Exception)((Object)ne));
                }
            }
        }
        this.processForLocalNode(nodeValPair);
        String nodeName = null;
        String varValue = null;
        for (int i = 0; i < this.m_taskenv.m_nodeList.length; ++i) {
            isvarSet = false;
            varLength = 0;
            varValue = null;
            if (remOpFailedNodes.size() > 0 && remOpFailedNodes.contains(this.m_taskenv.m_nodeList[i])) {
                maxVarLenOnNode.put(nodeName, varLength);
                continue;
            }
            nodeName = this.m_taskenv.m_nodeList[i];
            varValue = (String)nodeValPair.get(nodeName);
            Trace.out((String)("sTaskCheckEnvVariable::Performing Environment Variable check for variable (" + this.m_taskenv.m_envVarName + ") on Node : " + nodeName));
            if (varValue != null && varValue.length() > 0) {
                Trace.out((String)("sTaskCheckEnvVariable:: Read Variable " + this.m_taskenv.m_envVarName + " from node: " + nodeName + " with length (" + varValue.length() + ") and Value :" + varValue));
                isvarSet = true;
                varLength = varValue.length();
                maxVarLenOnNode.put(nodeName, varLength);
                varSetNodes.add(nodeName);
            } else {
                Trace.out((String)("sTaskCheckEnvVariable:: Environment Variable " + this.m_taskenv.m_envVarName + " not found to be set on node: " + nodeName));
                maxVarLenOnNode.put(nodeName, varLength);
                varNotSetNodes.add(nodeName);
            }
            if (isvarSet) {
                if (!this.m_taskenv.m_set) {
                    evResultSet.addResult(this.m_taskenv.m_nodeList[i], 3);
                    continue;
                }
                if (this.m_taskenv.m_maxLength > 0 && varLength > this.m_taskenv.m_maxLength) {
                    evResultSet.addResult(this.m_taskenv.m_nodeList[i], 3);
                    lenExceedNodes.add(nodeName);
                    continue;
                }
                evResultSet.addResult(this.m_taskenv.m_nodeList[i], 1);
                continue;
            }
            if (!this.m_taskenv.m_set) {
                evResultSet.addResult(this.m_taskenv.m_nodeList[i], 1);
                continue;
            }
            evResultSet.addResult(this.m_taskenv.m_nodeList[i], 3);
        }
        return evResultSet.allSuccess();
    }

    private void processForLocalNode(HashMap<String, String> nodeValPair) {
        String nodeName = null;
        if (nodeValPair == null || nodeValPair.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_taskenv.m_nodeList.length; ++i) {
            nodeName = this.m_taskenv.m_nodeList[i];
            if (!VerificationUtil.isLocalNode(nodeName)) continue;
            String sysVarValue = nodeValPair.get(nodeName);
            Trace.out((String)("sTaskCheckEnvVariable::processForLocalNode From System environment value retrieved is : " + sysVarValue));
            String envVarValue = System.getenv(this.m_taskenv.m_envVarName);
            Trace.out((String)("sTaskCheckEnvVariable::processForLocalNode From User environment value retrieved is : " + envVarValue));
            if (sysVarValue == null) {
                nodeValPair.remove(nodeName);
                if (envVarValue != null && envVarValue.length() > 0) {
                    nodeValPair.put(nodeName, envVarValue.trim());
                } else {
                    nodeValPair.put(nodeName, null);
                }
            } else {
                sysVarValue = sysVarValue.trim();
                if (envVarValue != null && envVarValue.length() > 0) {
                    envVarValue = envVarValue.trim();
                }
                if (envVarValue != null && envVarValue.equals(sysVarValue)) {
                    Trace.out((String)"sTaskCheckEnvVariable::processForLocalNode BOTH System and User Environment has same value");
                    return;
                }
                Trace.out((String)"sTaskCheckEnvVariable::processForLocalNode Updating the Hashmap with new value for local node");
                nodeValPair.remove(nodeName);
                nodeValPair.put(nodeName, envVarValue);
            }
            return;
        }
    }

    static {
        try {
            clusterWindows = new ClusterWindows();
        }
        catch (ClusterException e) {
            Trace.out((String)("sTaskCheckEnvVariable:: Cannot create ClusterWindows " + e.getMessage()));
        }
    }
}

