/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskVerifyServiceUser;
import oracle.ops.verification.framework.engine.task.sTaskCheckAutomount;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskFactory {
    private TaskFactory m_taskFactory = null;

    public sTaskFactory(TaskFactory taskFactory) {
        this.m_taskFactory = taskFactory;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param) throws TaskFactoryException, PreReqNotSupportedException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        TaskVerifyServiceUser taskServiceUser = null;
        switch (vfyType) {
            case PREREQ_CRS_INST: {
                Trace.out((String)"sTaskFactory:: In PRE_CRS_INST tasklist Adding the Automount feature verification task");
                taskList.add(new sTaskCheckAutomount(nodeList));
                break;
            }
            case PREREQ_DB_INST: {
                Trace.out((String)"sTaskFactory:: In PRE_DB_INST tasklist");
                taskList.add(new sTaskCheckAutomount(nodeList));
                taskServiceUser = this.verifyServiceUserCheckRequired(nodeList, false);
                if (taskServiceUser == null) break;
                taskList.add(taskServiceUser);
                break;
            }
            case PREREQ_DB_CONFIG: {
                Trace.out((String)"sTaskFactory:: In PREREQ_DB_CONFIG tasklist");
                taskServiceUser = this.verifyServiceUserCheckRequired(nodeList, true);
                if (taskServiceUser == null) break;
                taskList.add(taskServiceUser);
                break;
            }
            case PREREQ_SI_HA_INST: {
                Trace.out((String)"sTaskFactory:: In PRE_SIHA_INST tasklist Adding the Automount feature verification task");
                taskList.add(new sTaskCheckAutomount(nodeList));
                break;
            }
        }
        return taskList;
    }

    private TaskVerifyServiceUser verifyServiceUserCheckRequired(String[] nodeList, boolean isPostDbInst) {
        String reqRel = VerificationUtil.getRequestedRelease();
        if (reqRel != null && (reqRel.equalsIgnoreCase("10gR1") || reqRel.equalsIgnoreCase("10gR2") || reqRel.equalsIgnoreCase("11gR1") || reqRel.equalsIgnoreCase("11gR2"))) {
            Trace.out((String)"db version earlier than 12.1");
            return null;
        }
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        if (actCRSVer == null || actCRSVer.length() == 0) {
            Trace.out((String)"active crs version couldn't be determined");
            return null;
        }
        if (VerificationUtil.isVersionPost(actCRSVer, "12.1")) {
            String username = null;
            String password = null;
            if (isPostDbInst) {
                boolean isUserSpecifiedPwd = false;
                if (TaskFactory.m_isCLImode) {
                    if (TaskFactory.m_pm.isServicePwdSpecified()) {
                        Trace.out((String)"cmd line mode with passwd");
                        password = TaskFactory.m_pm.getServiceUserPassword();
                        isUserSpecifiedPwd = true;
                    }
                }
                if (TaskFactory.m_isAPImode && (password = VerificationUtil.getVariableValue("ORACLE_SERVICE_USER_PASSWORD")) != null) {
                    Trace.out((String)"API line mode with passwd");
                    isUserSpecifiedPwd = true;
                }
                String destloc = VerificationUtil.getDestLoc();
                String srcloc = VerificationUtil.getCVHome();
                try {
                    String oracleHome = VerificationUtil.getVariableValue("ORACLE_HOME");
                    if (oracleHome == null || oracleHome.length() == 0) {
                        return null;
                    }
                    WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
                    Home home = wsecFac.getHome(oracleHome, new Version());
                    Credentials cred = null;
                    cred = home.isServiceUserLocalService() ? new Credentials(Credentials.BuiltinUser.LOCALSERVICE) : (home.isServiceUserLocalSystem() ? new Credentials(Credentials.BuiltinUser.LOCALSYSTEM) : home.getServiceUserFromHomePath());
                    if (isUserSpecifiedPwd) {
                        cred.setPassword(password);
                    }
                    TaskVerifyServiceUser taskSvcUser = new TaskVerifyServiceUser(nodeList, cred, isPostDbInst);
                    return taskSvcUser;
                }
                catch (WindowsSecurityException e) {
                    Trace.out((String)("WSE while creating verify service user task" + e.getMessage()));
                    return null;
                }
            }
            if (TaskFactory.m_isCLImode) {
                if (!TaskFactory.m_pm.isServiceUserSpecified()) {
                    return null;
                }
                Argument svcUserArg = TaskFactory.m_pm.getArgument(Argument.ARG_SERVICE_USER);
                String[] serviceUserArr = svcUserArg.getArgList();
                username = serviceUserArr[0];
                if (TaskFactory.m_pm.isServicePwdSpecified()) {
                    password = TaskFactory.m_pm.getServiceUserPassword();
                }
            } else if (TaskFactory.m_isAPImode) {
                username = VerificationUtil.getVariableValue("WINSEC_SERVICE_USERNAME");
                password = VerificationUtil.getVariableValue("WINSEC_SERVICE_PASSWORD");
            } else {
                return null;
            }
            try {
                Credentials credentials = null;
                credentials = password == null || password.length() == 0 ? new Credentials(username) : new Credentials(username, password);
                TaskVerifyServiceUser taskSvcUser = new TaskVerifyServiceUser(nodeList, credentials, isPostDbInst);
                return taskSvcUser;
            }
            catch (WindowsSecurityException e) {
                Trace.out((String)e.getMessage());
                return null;
            }
        }
        return null;
    }
}

