/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskHostnameLength
extends Task {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvg");

    public sTaskHostnameLength(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Enter performTask method for sTaskHostnameLength ");
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("10500", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        GlobalExecution ge = new GlobalExecution();
        ResultSet rs = new ResultSet();
        boolean ret = ge.checkHostnameLength(this.m_nodeList, rs);
        this.m_resultSet.uploadResultSet(rs);
        Hashtable t = this.m_resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String avl = (String)result.getResultInfoSet().firstElement();
            if (result.getStatus() == 1) {
                Trace.out((String)("Verification Successful for node: " + node));
                ReportUtil.writeRecord(node, ReportUtil.PASSED);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setActualValue(avl);
                continue;
            }
            if (result.getStatus() == 2) {
                Trace.out((String)("Command failed and the status is =" + result.getStatus()));
                ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("10501", true, (Object[])new String[]{node}), s_msgBundle, "10501");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                continue;
            }
            if (result.getStatus() != 3) continue;
            Trace.out((String)("Hostname length check failed, retrieved hostname length=" + avl));
            ReportUtil.writeRecord(node, avl, ReportUtil.FAILED);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("10502", true, (Object[])new String[]{node, avl}), s_msgBundle, "10502");
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setActualValue(avl);
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("10503", false));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("10504", false));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("10506", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("10505", false);
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("10500", false);
    }
}

