/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskNameService;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.sCommandsUtil;

public class sTaskNameService {
    private String[] m_nodeList = null;
    private String m_scanName = null;
    private ResultSet m_resultSet = null;
    private sCommandsUtil m_cmdsUtil = null;
    private TaskNameService m_tns = null;
    private MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String LSEP = System.getProperty("line.separator");

    public sTaskNameService(String[] nodeList, String scanName, ResultSet resultSet, TaskNameService tns) {
        this.m_nodeList = nodeList;
        this.m_scanName = scanName;
        this.m_resultSet = resultSet;
        this.m_tns = tns;
    }

    public boolean performTask() {
        String status;
        String comment;
        ArrayList<String> inetIPAddrs;
        InetAddress[] addrList;
        ErrorDescription errDesc;
        String outLine;
        int i;
        String exitStat;
        String cmdOutput;
        String output;
        NativeSystem nativeSystem;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet nameSrvcRsltSet = new ResultSet();
        String nameServiceHost = null;
        boolean DNSbeforeNIS = false;
        boolean nsswitchError = false;
        ArrayList<String> nsIPAddrs = new ArrayList<String>();
        this.m_cmdsUtil = new sCommandsUtil();
        String cmdSpec = null;
        String hostsLine = null;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("ENTRY: scan name '" + this.m_scanName + "'"));
        }
        if (!(nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            return true;
        }
        ReportUtil.sureprintln(LSEP + this.s_msgBundle.getMessage("4655", false, (Object[])new String[]{this.m_scanName}));
        cmdSpec = this.m_cmdsUtil.getGrep() + " hosts: " + this.m_cmdsUtil.getNsswitch() + " | " + this.m_cmdsUtil.getAwk() + " '{print $1,$2,$3,$4,$5,$6,$7,$8,$9}'";
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Command Syntax: \n" + cmdSpec));
        }
        ResultSet switchRsltSet = new ResultSet();
        Hashtable nsswitchOutput = globalExec.runExeWithOutput(this.m_nodeList, cmdSpec, switchRsltSet);
        block4: for (String node : this.m_nodeList) {
            output = (String)nsswitchOutput.get(node);
            cmdOutput = VerificationUtil.fetchVerificationValue(output);
            exitStat = VerificationUtil.fetchVerificationResult(output);
            if (exitStat != null && exitStat.contentEquals("0")) {
                Trace.out((int)5, (String)("grep nsswitch.conf cmd succeeded on node: " + node));
                String[] nsswitchOutputLines = VerificationUtil.string2strArr(cmdOutput, VerificationUtil.LINE_SEPARATOR);
                i = 0;
                while (i < nsswitchOutputLines.length) {
                    outLine = nsswitchOutputLines[i];
                    Trace.out((int)1, (String)("nsswitch.conf line: " + outLine));
                    if (outLine.charAt(0) == '#') {
                        ++i;
                        continue;
                    }
                    if (!outLine.startsWith("hosts:")) continue;
                    if (hostsLine == null) {
                        hostsLine = outLine;
                        continue block4;
                    }
                    if (hostsLine.equalsIgnoreCase(outLine)) continue block4;
                    errDesc = new ErrorDescription("4661", new String[]{node}, this.s_msgBundle);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    this.m_resultSet.addResult(nameServiceHost, 3);
                    this.m_resultSet.addErrorDescription(errDesc);
                    nsswitchError = true;
                    continue block4;
                }
                continue;
            }
            Trace.out((int)5, (String)("grep nsswitch.conf cmd failed on node: " + node));
        }
        if (nsswitchError) {
            return false;
        }
        boolean foundDNS = false;
        boolean foundNIS = false;
        StringTokenizer st = new StringTokenizer(hostsLine);
        while (st.hasMoreTokens()) {
            String lineToken = st.nextToken();
            if (lineToken.equalsIgnoreCase("dns")) {
                foundDNS = true;
            }
            if (lineToken.equalsIgnoreCase("nis")) {
                foundNIS = true;
            }
            if (foundDNS && !foundNIS) {
                DNSbeforeNIS = true;
                break;
            }
            if (!foundNIS) continue;
            break;
        }
        Trace.out((int)5, (String)("DNSbeforeNIS is: " + DNSbeforeNIS));
        try {
            nameServiceHost = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: Local node not found: " + uhe.getMessage()));
            nameServiceHost = "localnode";
        }
        cmdSpec = this.m_cmdsUtil.getNslookup() + " " + this.m_scanName;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Running CMD: " + cmdSpec + "\n on Node: " + nameServiceHost));
        }
        Hashtable nsLookupOutput = globalExec.runExeWithOutput(new String[]{nameServiceHost}, cmdSpec, nameSrvcRsltSet);
        output = (String)nsLookupOutput.get(nameServiceHost);
        cmdOutput = VerificationUtil.fetchVerificationValue(output);
        exitStat = VerificationUtil.fetchVerificationResult(output);
        if (exitStat != null && exitStat.contentEquals("0")) {
            Trace.out((int)5, (String)"nslookup command succeeded");
            String[] nsLookupOutputLines = VerificationUtil.string2strArr(cmdOutput, VerificationUtil.LINE_SEPARATOR);
            i = 0;
            while (i < nsLookupOutputLines.length) {
                outLine = nsLookupOutputLines[i];
                Trace.out((int)5, (String)("nslookup outputLine: \n" + outLine));
                StringTokenizer st2 = new StringTokenizer(outLine);
                String lineTag = st2.nextToken();
                Trace.out((int)5, (String)("Looking for 'Name:' in '" + lineTag + "'"));
                if (lineTag.startsWith("Name:")) {
                    String name = st2.nextToken();
                    if (name.startsWith(this.m_scanName)) {
                        String outLine2 = nsLookupOutputLines[++i];
                        Trace.out((int)5, (String)("nslookup outputLine2: \n" + outLine2));
                        StringTokenizer st3 = new StringTokenizer(outLine2);
                        lineTag = st3.nextToken();
                        Trace.out((int)5, (String)("Looking for 'Address:' in '" + lineTag + "'"));
                        if (lineTag.startsWith("Address:")) {
                            String lineVal = st3.nextToken();
                            nsIPAddrs.add(lineVal);
                            Trace.out((int)5, (String)("Adding name: '" + name + "'" + " and IP addr: '" + lineVal + "' from nslookup"));
                        }
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        if (nsIPAddrs.size() == 0) {
            errDesc = new ErrorDescription("4664", new String[]{this.m_scanName}, this.s_msgBundle);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        try {
            addrList = InetAddress.getAllByName(this.m_scanName);
        }
        catch (UnknownHostException uhe2) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: InetAddress.getAllByName() failed: " + uhe2.getMessage()));
            errDesc = new ErrorDescription("4664", new String[]{this.m_scanName}, this.s_msgBundle);
            this.m_resultSet.addResult(nameServiceHost, 2);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        ArrayList<String> save_inetIPAddrs = inetIPAddrs = new ArrayList<String>();
        for (InetAddress inAddr : addrList) {
            Object inetIPAddress = null;
            StringTokenizer inetst = new StringTokenizer(inAddr.toString(), new String("/"));
            String inetAddrVal = inetst.nextToken();
            inetAddrVal = inetst.nextToken();
            Trace.out((int)5, (String)("Adding InetAddr: '" + inetAddrVal + "'"));
            inetIPAddrs.add(inetAddrVal);
        }
        ReportUtil.writeColHeaders(ReportUtil.SCANNAME, ReportUtil.IPADDR, ReportUtil.STATUS, ReportUtil.COMMENT);
        boolean diffDNSNIS = false;
        ArrayList<String> track_nsIPAddrs = new ArrayList<String>();
        track_nsIPAddrs.addAll(nsIPAddrs);
        for (String ipAddr : nsIPAddrs) {
            Trace.out((int)5, (String)("Checking ipAddr: '" + ipAddr + "'"));
            if (inetIPAddrs.size() != 0 && inetIPAddrs.contains(ipAddr)) {
                comment = new String("");
                status = ReportUtil.PASSED;
                ReportUtil.writeRecord(this.m_scanName, ipAddr, status, comment);
                track_nsIPAddrs.remove(ipAddr);
                inetIPAddrs.remove(ipAddr);
                Trace.out((int)5, (String)("Match DNS and NIS entry: '" + ipAddr + "'"));
                continue;
            }
            Trace.out((int)5, (String)("DNS and NIS do not match for: '" + ipAddr + "'"));
            comment = this.s_msgBundle.getMessage("4659", false);
            status = ReportUtil.FAILED;
            ReportUtil.writeRecord(this.m_scanName, ipAddr, status, comment);
            diffDNSNIS = true;
            track_nsIPAddrs.remove(ipAddr);
            errDesc = new ErrorDescription("4657", new String[]{this.m_scanName, ipAddr}, this.s_msgBundle);
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            if (ReportUtil.isVerbose()) continue;
            ReportUtil.printError(errDesc.getErrorMessage());
        }
        for (String nisAddr : inetIPAddrs) {
            Trace.out((int)5, (String)("No DNS entry for NIS: '" + nisAddr + "'"));
            comment = this.s_msgBundle.getMessage("4660", false);
            status = ReportUtil.FAILED;
            ReportUtil.writeRecord(this.m_scanName, nisAddr, status, comment);
            diffDNSNIS = true;
            errDesc = new ErrorDescription("4657", new String[]{this.m_scanName, nisAddr}, this.s_msgBundle);
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            if (ReportUtil.isVerbose()) continue;
            ReportUtil.printError(errDesc.getErrorMessage());
        }
        if (diffDNSNIS) {
            errDesc = !DNSbeforeNIS ? new ErrorDescription("4663", this.s_msgBundle) : new ErrorDescription("4664", new String[]{this.m_scanName}, this.s_msgBundle);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return true;
    }
}

