/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class ClusterNetworkInfo
implements NetworkConstants,
VerificationAPIConstants {
    private String[] m_ifNames = null;
    private String[] m_subnets = null;
    private int[] m_netTypes = null;
    private boolean[] m_isIfNameGlobals = null;
    private static MessageBundle m_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle m_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String FSEP = System.getProperty("file.separator");

    private ClusterNetworkInfo(String[] ifNames, String[] subnets, int[] netTypes, boolean[] isIfNameGlobals) {
        this.m_ifNames = ifNames;
        this.m_subnets = subnets;
        this.m_netTypes = netTypes;
        this.m_isIfNameGlobals = isIfNameGlobals;
    }

    public ClusterNetworkInfo(String[] subnets) {
        this.m_ifNames = new String[subnets.length];
        this.m_subnets = new String[subnets.length];
        this.m_netTypes = new int[subnets.length];
        this.m_isIfNameGlobals = new boolean[subnets.length];
        this.m_subnets = subnets;
        for (int i = 0; i < subnets.length; ++i) {
            this.m_ifNames[i] = "*";
            this.m_subnets[i] = subnets[i];
            this.m_netTypes[i] = 2;
            this.m_isIfNameGlobals[i] = true;
        }
    }

    public static ClusterNetworkInfo getNetworkInfoFromOifcfg() throws CVUException {
        String[] ifNames = null;
        String[] subnets = null;
        String[] strNetTypes = null;
        int[] netTypes = null;
        boolean[] isIfNameGlobals = null;
        Trace.out((String)"trying to get CRS Home..");
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"CRSHOME is null");
            throw new CVUException(m_prvfMsgBundle, "5301", new Object[0]);
        }
        String oifcfgLoc = crsHome + FSEP + "bin";
        Trace.out((String)("OIFCFG loc:" + oifcfgLoc));
        Version crsVer = VerificationUtil.getCRSActiveVersionObj();
        Trace.out((String)("Acrive CRS version is " + crsVer));
        List oifcfgList = null;
        try {
            oifcfgList = new ClusterwareInfo().listClusterInterfaces(oifcfgLoc, crsVer);
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION: occured while getting cluster network info. message" + ie.getMessage()));
            throw new CVUException(ie);
        }
        if (oifcfgList.size() == 0) {
            Trace.out((String)"OIFCFG list is EMPTY");
            throw new CVUException(m_prvfMsgBundle, "7615", oifcfgLoc, crsHome);
        }
        int nNetworks = oifcfgList.size();
        ifNames = new String[nNetworks];
        subnets = new String[nNetworks];
        netTypes = new int[nNetworks];
        strNetTypes = new String[nNetworks];
        isIfNameGlobals = new boolean[nNetworks];
        int i = 0;
        for (OIFCFGResult oifcfgRes : oifcfgList) {
            ifNames[i] = oifcfgRes.getInterfaceName();
            subnets[i] = oifcfgRes.getSubnet().getHostAddress();
            strNetTypes[i] = oifcfgRes.getInterfaceType();
            String scope = oifcfgRes.getNodeScope();
            scope = scope == null ? "" : scope.trim();
            isIfNameGlobals[i] = scope.equalsIgnoreCase("global");
            Trace.out((String)("ifName=" + ifNames[i] + ",subnet=" + subnets[i] + ",netType=" + strNetTypes[i] + ",isIfNameGlobals=" + isIfNameGlobals[i]));
            if ("PUBLIC".equalsIgnoreCase(strNetTypes[i]) || "PUB".equalsIgnoreCase(strNetTypes[i])) {
                netTypes[i] = 2;
            } else {
                netTypes[i] = 0;
                for (String netType : strNetTypes[i].split(",")) {
                    netTypes[i] = Utils.isDevelopmentEnv() && ("PUBLIC".equalsIgnoreCase(netType) || "PUB".equalsIgnoreCase(netType)) ? netTypes[i] | 2 : ("PVT".equalsIgnoreCase(netType) || "PRIVATE".equalsIgnoreCase(netType) || "CLUSTER_INTERCONNECT".equalsIgnoreCase(netType) ? netTypes[i] | 1 : ("ASM".equalsIgnoreCase(netType) ? netTypes[i] | 0x80 : 4));
                }
            }
            ++i;
        }
        Trace.out((String)("Interfaces(from OIFCFG): '" + VerificationUtil.strArr2List(ifNames) + "'"));
        Trace.out((String)("Subnets(from OIFCFG): '" + VerificationUtil.strArr2List(subnets) + "'"));
        Trace.out((String)("Net Types (from OIFCFG): '" + VerificationUtil.strArr2List(strNetTypes) + "'"));
        return new ClusterNetworkInfo(ifNames, subnets, netTypes, isIfNameGlobals);
    }

    public static ClusterNetworkInfo getNetworkInfoFromCVUVar() throws CVUException {
        String niList = VerificationUtil.getVariableValue("INTERCONNECT_LIST");
        if (niList == null) {
            Trace.out((String)"INTERCONNECT_LIST list is EMPTY");
            throw new CVUException(m_prvfMsgBundle, "7613", new Object[0]);
        }
        return ClusterNetworkInfo.getNetworkInfo(niList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClusterNetworkInfo getNetworkInfoFromPMArg(Argument arg, String node) throws CVUException {
        ArrayList nodeIfInfos = null;
        String[] interfaceList = arg.getArgList()[0].split("/");
        StringBuilder sbInterConnectList = new StringBuilder();
        String[] arr$ = interfaceList;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            String ifaceInfo = arr$[i$];
            Trace.out((String)("start processing ifaceInfo=" + ifaceInfo));
            String iName = null;
            String subnetId = null;
            String subnetIdType = null;
            int start = 0;
            int end = 0;
            ifaceInfo = ifaceInfo.trim();
            if (ifaceInfo.length() == 0) {
                Trace.out((String)"ifaceInfo is empty");
                throw new CVUException(m_prvgMsgBundle, "11051", arg);
            }
            boolean bSubnectId = false;
            boolean bSubnetType = false;
            if (ifaceInfo.charAt(0) == '\"') {
                start = 1;
                end = ifaceInfo.indexOf(34, 1);
                if (end == -1) {
                    Trace.out((String)("interface name is not enclosed with in double quotes properly in:" + ifaceInfo));
                    throw new CVUException(m_prvgMsgBundle, "11052", new Object[0]);
                }
                iName = ifaceInfo.substring(start, end);
                if (ifaceInfo.length() > end + 1) {
                    if (ifaceInfo.charAt(end + 1) != ':') {
                        Trace.out((String)("interface name is not seperated by a ':' in ifaceInfo:" + ifaceInfo));
                        throw new CVUException(m_prvgMsgBundle, "11051", arg);
                    }
                    bSubnectId = true;
                    ++end;
                }
            } else {
                start = 0;
                end = ifaceInfo.indexOf(58);
                if (end == -1) {
                    iName = ifaceInfo;
                } else {
                    iName = ifaceInfo.substring(start, end);
                    bSubnectId = true;
                }
            }
            Trace.out((String)("Interface name '" + iName + "' is extracted from " + ifaceInfo));
            if (bSubnectId) {
                start = end + 1;
                end = ifaceInfo.lastIndexOf(":");
                if (end + 1 == start) {
                    subnetId = ifaceInfo.substring(start);
                    Trace.out((String)("subnet id = '" + subnetId + "' is extracted from ifaceInfo:" + ifaceInfo));
                } else {
                    if (end < start) {
                        Trace.out((String)("subnet id is not specified properly. ifaceInfo:" + ifaceInfo));
                        throw new CVUException(m_prvgMsgBundle, "11051", arg);
                    }
                    bSubnetType = true;
                    subnetId = ifaceInfo.substring(start, end);
                }
                Trace.out((String)("Subnet ID '" + subnetId + "' is extracted from " + ifaceInfo));
                if (bSubnetType) {
                    subnetIdType = ifaceInfo.substring(end + 1);
                    for (String strSubnetType : subnetIdType.split(",")) {
                        if ("PUBLIC".equalsIgnoreCase(strSubnetType) || "CLUSTER_INTERCONNECT".equalsIgnoreCase(strSubnetType) || "ASM".equalsIgnoreCase(strSubnetType)) continue;
                        Trace.out((String)("got invalid subnet id type = " + subnetIdType + "form ifaceInfo=" + ifaceInfo));
                        throw new CVUException(m_prvgMsgBundle, "11053", new Object[0]);
                    }
                    subnetIdType = subnetIdType.replace(',', '-');
                } else {
                    subnetIdType = "UNKNOWN";
                }
                ClusterNetworkInfo.appendInterConnectList(sbInterConnectList, iName, subnetId, subnetIdType);
            } else {
                if (nodeIfInfos == null) {
                    try {
                        nodeIfInfos = new ArrayList();
                        ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>();
                        VerifyNetwork vfyNetwork = new VerifyNetwork();
                        vfyNetwork.getInterfaceInfo(new String[]{node}, nodeInfos);
                        for (NodeInfo nodeInfo : nodeInfos) {
                            nodeIfInfos.addAll(nodeInfo.getInterfaceList());
                        }
                    }
                    catch (NetworkException nEx) {
                        VerificationLogData.logError("NetworkException: " + nEx.getMessage() + "\n" + Trace.getStackTrace((Throwable)nEx));
                        throw new CVUException(nEx);
                    }
                    catch (MultiNodeException mEx) {
                        VerificationLogData.logError("MultiNodeException: " + mEx.getMessage() + "\n" + Trace.getStackTrace((Throwable)mEx));
                        throw new CVUException(mEx);
                    }
                }
                String regexp = iName.replaceAll("\\*", ".*");
                Pattern p = Pattern.compile(regexp);
                boolean bSubnetFound = false;
                for (InterfaceInfo nodeIfInfo : nodeIfInfos) {
                    String ifName = nodeIfInfo.getName();
                    if (!p.matcher(ifName).matches()) continue;
                    bSubnetFound = true;
                    subnetId = nodeIfInfo.getSubnet();
                    subnetIdType = "UNKNOWN";
                    ClusterNetworkInfo.appendInterConnectList(sbInterConnectList, ifName, subnetId, subnetIdType);
                }
                if (!bSubnetFound) {
                    Trace.out((String)("Failed to locate interface '" + iName + "' on node '" + node + "'"));
                    throw new CVUException(m_prvgMsgBundle, "11049", iName, node);
                }
            }
            ++i$;
        }
        return ClusterNetworkInfo.getNetworkInfo(sbInterConnectList.toString());
    }

    private static ClusterNetworkInfo getNetworkInfo(String niList) throws CVUException {
        String[] ifNames = null;
        String[] subnets = null;
        int[] netTypes = null;
        String[] strNetTypes = null;
        boolean[] isIfNameGlobals = null;
        Trace.out((String)("niList '" + niList + "'"));
        String[] interconnectLst = VerificationUtil.string2strArr(niList);
        int nNetworks = interconnectLst.length;
        ifNames = new String[nNetworks];
        subnets = new String[nNetworks];
        netTypes = new int[nNetworks];
        strNetTypes = new String[nNetworks];
        isIfNameGlobals = new boolean[nNetworks];
        for (int i = 0; i < nNetworks; ++i) {
            isIfNameGlobals[i] = true;
        }
        for (int i = 0; i < interconnectLst.length; ++i) {
            int start = interconnectLst[i].indexOf(34) + 1;
            int end = interconnectLst[i].indexOf(34, start);
            if (start == 0 || end == -1) {
                throw new CVUException(m_prvfMsgBundle, "7614", interconnectLst[i]);
            }
            ifNames[i] = interconnectLst[i].substring(start, end);
            start = interconnectLst[i].indexOf(58) + 1;
            end = interconnectLst[i].lastIndexOf(58);
            if (start == 0 || end == -1) {
                throw new CVUException(m_prvfMsgBundle, "7614", interconnectLst[i]);
            }
            subnets[i] = interconnectLst[i].substring(start, end);
            strNetTypes[i] = interconnectLst[i].substring(end + 1);
            netTypes[i] = 0;
            for (String strNetType : strNetTypes[i].split("-")) {
                if ("PUBLIC".equalsIgnoreCase(strNetType) || "PUB".equalsIgnoreCase(strNetType)) {
                    int n = i;
                    netTypes[n] = netTypes[n] | 2;
                    continue;
                }
                if ("PVT".equalsIgnoreCase(strNetType) || "PRIVATE".equalsIgnoreCase(strNetType) || "CLUSTER_INTERCONNECT".equalsIgnoreCase(strNetType)) {
                    int n = i;
                    netTypes[n] = netTypes[n] | 1;
                    continue;
                }
                if (!"ASM".equalsIgnoreCase(strNetType)) continue;
                int n = i;
                netTypes[n] = netTypes[n] | 0x80;
            }
            if (netTypes[i] != 0) continue;
            Trace.out((String)("got strNetTypes[" + i + "]=" + strNetTypes[i] + " asuming NETTYPE_UNKNOWN"));
            netTypes[i] = 4;
        }
        Trace.out((String)("Interfaces: '" + VerificationUtil.strArr2List(ifNames) + "'"));
        Trace.out((String)("Subnets: '" + VerificationUtil.strArr2List(subnets) + "'"));
        Trace.out((String)("Net Types: '" + VerificationUtil.strArr2List(strNetTypes) + "'"));
        return new ClusterNetworkInfo(ifNames, subnets, netTypes, isIfNameGlobals);
    }

    public String[] getIfNames() {
        return this.m_ifNames;
    }

    public String[] getSubnets() {
        return this.m_subnets;
    }

    public int[] getNetTypes() {
        return this.m_netTypes;
    }

    public boolean[] isIfNameGlobals() {
        return this.m_isIfNameGlobals;
    }

    public int[] getNetTypes(boolean asmAsPriv) {
        int[] netTypes = Arrays.copyOf(this.m_netTypes, this.m_netTypes.length);
        for (int i = 0; i < netTypes.length; ++i) {
            if (!asmAsPriv || (netTypes[i] & 0x80) == 0) continue;
            netTypes[i] = 1;
        }
        return netTypes;
    }

    public boolean hasNetType(int netType) {
        int i = 0;
        for (i = 0; i < this.m_netTypes.length && (this.m_netTypes[i] & netType) == 0; ++i) {
        }
        return i != this.m_netTypes.length;
    }

    public ClusterNetworkInfo getClusterNetworkInfo(int netType) {
        int nNetworks = this.m_ifNames.length;
        String[] ifNames = new String[nNetworks];
        String[] subnets = new String[nNetworks];
        int[] netTypes = new int[nNetworks];
        boolean[] isIfNameGlobals = new boolean[nNetworks];
        int j = 0;
        for (int i = 0; i < nNetworks; ++i) {
            if ((this.m_netTypes[i] & netType) == 0) continue;
            ifNames[j] = this.m_ifNames[i];
            subnets[j] = this.m_subnets[i];
            isIfNameGlobals[j] = this.m_isIfNameGlobals[i];
            netTypes[j] = netType;
            ++j;
        }
        ifNames = Arrays.copyOf(ifNames, j);
        subnets = Arrays.copyOf(subnets, j);
        netTypes = Arrays.copyOf(netTypes, j);
        isIfNameGlobals = Arrays.copyOf(isIfNameGlobals, j);
        return new ClusterNetworkInfo(ifNames, subnets, netTypes, isIfNameGlobals);
    }

    public String getInterConnectList() {
        StringBuilder sbInterConnectList = new StringBuilder();
        for (int i = 0; i < this.m_ifNames.length; ++i) {
            ClusterNetworkInfo.appendInterConnectList(sbInterConnectList, this.m_ifNames[i], this.m_subnets[i], ClusterNetworkInfo.getNetTypeStr(this.m_netTypes[i]));
        }
        return sbInterConnectList.toString();
    }

    private static void appendInterConnectList(StringBuilder sbInterConnectList, String ifName, String subnetId, String subnetIdType) {
        if (sbInterConnectList.indexOf(subnetId) != -1) {
            return;
        }
        if (sbInterConnectList.length() != 0) {
            sbInterConnectList.append(',');
        }
        sbInterConnectList.append('\"');
        sbInterConnectList.append(ifName);
        sbInterConnectList.append('\"');
        sbInterConnectList.append(':');
        sbInterConnectList.append(subnetId);
        sbInterConnectList.append(':');
        sbInterConnectList.append(subnetIdType);
    }

    private static String getNetTypeStr(int netType) {
        int asm_pri = 129;
        String netTypeStr = null;
        netTypeStr = netType == 2 ? "PUBLIC" : (netType == 1 ? "CLUSTER_INTERCONNECT" : (netType == 128 ? "ASM" : (netType == 129 ? "ASM-CLUSTER_INTERCONNECT" : (Utils.isDevelopmentEnv() && netType == 3 ? "PUBLIC-CLUSTER_INTERCONNECT" : "UNKNOWN"))));
        Trace.out((String)("netType=" + netType + ", netTypeStr=" + netTypeStr));
        return netTypeStr;
    }
}

