/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import oracle.ops.verification.framework.network.NetworkConstants;

public class InterfaceInfo
implements NetworkConstants {
    private String m_IPAddress = null;
    private String m_name = null;
    private String m_node = null;
    private String m_subnet = null;
    private String m_netmask = null;
    private String m_type = null;
    private String m_sub_gateway = null;
    private String m_def_gateway = null;
    private String m_hw_addr = null;
    private int m_netType = 4;
    private int m_status = 50;
    private String m_mtu = null;

    protected InterfaceInfo(String name, String IPAddress, String subnet, String netmask, String type, int netType, int status, String node, String def_gateway, String sub_gateway, String hw_addr, String mtu) {
        this.m_name = name;
        this.m_IPAddress = IPAddress;
        this.m_subnet = subnet;
        this.m_netmask = netmask;
        this.m_type = type;
        this.m_node = node;
        this.m_netType = netType;
        this.m_status = status;
        this.m_sub_gateway = sub_gateway;
        this.m_def_gateway = def_gateway;
        this.m_hw_addr = hw_addr;
        this.m_mtu = mtu;
    }

    boolean isOnSameSubnet(InterfaceInfo inf) {
        return this.m_subnet.equals(inf.m_subnet) && this.m_type.equals(inf.m_type);
    }

    protected int getStatus() {
        return this.m_status;
    }

    public int getNetType() {
        return this.m_netType;
    }

    public String getIP() {
        return this.m_IPAddress;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNode() {
        return this.m_node;
    }

    public String getType() {
        return this.m_type;
    }

    public String getGateway() {
        return this.m_sub_gateway;
    }

    public String getDefGateway() {
        return this.m_def_gateway;
    }

    public String getHWAddr() {
        return this.m_hw_addr;
    }

    public String getSubnet() {
        return this.m_subnet;
    }

    public String getNetMask() {
        return this.m_netmask;
    }

    public String getMTU() {
        return this.m_mtu;
    }

    public boolean isIPV6() {
        return "IPV6".equalsIgnoreCase(this.m_type);
    }

    public boolean isIPV4() {
        return "IPV4".equalsIgnoreCase(this.m_type);
    }

    public String toString() {
        return "\n<name:" + this.m_name + ", ip:" + this.m_IPAddress + ", node:" + this.m_node + "\n, subnet:" + this.m_subnet + ", netmask:" + this.m_netmask + ", type:" + this.m_type + "\n, netType:" + this.m_netType + ", status:" + this.m_status + ", MTU:" + this.m_mtu + "\n, subnet:" + this.m_sub_gateway + ", def gateway:" + this.m_def_gateway + ", hwaddr:" + this.m_hw_addr + ">";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InterfaceInfo)) {
            return false;
        }
        InterfaceInfo inf = (InterfaceInfo)obj;
        return this.m_name != null && inf.m_name != null && this.m_name.equalsIgnoreCase(inf.m_name) && this.m_IPAddress != null && inf.m_IPAddress != null && this.m_IPAddress.equalsIgnoreCase(inf.m_IPAddress) && this.m_node != null && inf.m_node != null && this.m_node.equalsIgnoreCase(inf.m_node) && this.m_subnet != null && inf.m_subnet != null && this.m_subnet.equalsIgnoreCase(inf.m_subnet) && this.m_netmask != null && inf.m_netmask != null && this.m_netmask.equalsIgnoreCase(inf.m_netmask) && this.m_hw_addr != null && inf.m_hw_addr != null && this.m_hw_addr.equalsIgnoreCase(inf.m_hw_addr);
    }
}

