/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class NetworkUtility
implements NetworkConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public static ClusterNetworkInfo getNetworkInfo(String node) throws CVUException {
        ClusterNetworkInfo clusterNetWrk = null;
        if (VerificationUtil.isCRSConfigured()) {
            clusterNetWrk = ClusterNetworkInfo.getNetworkInfoFromOifcfg();
        } else {
            ParamManager pm = null;
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                Trace.out((Exception)e);
            }
            if (null != pm && pm.getMode() == ParamManager.OperationMode.MODE_CLI) {
                if (pm.hasArgument(Argument.ARG_NETWORKLIST)) {
                    Argument argInterfaceList = pm.getArgument(Argument.ARG_NETWORKLIST);
                    clusterNetWrk = ClusterNetworkInfo.getNetworkInfoFromPMArg(argInterfaceList, node);
                }
            } else {
                clusterNetWrk = ClusterNetworkInfo.getNetworkInfoFromCVUVar();
            }
        }
        return clusterNetWrk;
    }

    public static boolean isNetworkTypeClassified(ClusterNetworkInfo clNetInfo, NetworkConstants.NetworkType netType) {
        if (clNetInfo == null || netType == null) {
            return false;
        }
        if (netType == NetworkConstants.NetworkType.PUBLIC && clNetInfo.hasNetType(2)) {
            return true;
        }
        if (netType == NetworkConstants.NetworkType.PRIVATE && clNetInfo.hasNetType(1)) {
            return true;
        }
        return netType == NetworkConstants.NetworkType.ALL;
    }

    public static List<String> getClassifiedSubnetList(String[] nodeList, ResultSet resultSet, boolean getPrivateSubnets) {
        ArrayList<String> subnetAddrList = new ArrayList<String>();
        ClusterNetworkInfo clNetInfo = null;
        try {
            clNetInfo = NetworkUtility.getNetworkInfo(nodeList[0]);
        }
        catch (CVUException cvuEx) {
            String errMsg = cvuEx.getMessage();
            Trace.out((String)("Exception occured while getting network information. msg=" + errMsg));
            resultSet.addResult(nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        if (null == clNetInfo) {
            Trace.out((String)"Failed to retrieve the list of network interfaces and subnets");
            VerificationLogData.logError("Failed to retrieve the list of network interfaces and subnets");
            resultSet.addResult(nodeList, 2);
        } else {
            String[] ifList = clNetInfo.getIfNames();
            String[] subnetList = clNetInfo.getSubnets();
            int[] netTypeList = clNetInfo.getNetTypes();
            for (int index = 0; index < ifList.length; ++index) {
                int requiredNetType;
                int n = requiredNetType = getPrivateSubnets ? 1 : 2;
                if (netTypeList[index] != requiredNetType) continue;
                Trace.out((String)("Adding Subnet Address (" + subnetList[index] + ") to the list of " + (getPrivateSubnets ? "private" : "public") + " subnets"));
                VerificationLogData.logInfo("Adding Subnet Address (" + subnetList[index] + ") to the list of" + (getPrivateSubnets ? "private" : "public") + " subnets");
                subnetAddrList.add(subnetList[index]);
            }
            if (!subnetAddrList.isEmpty()) {
                resultSet.addResult(nodeList, 1);
            }
        }
        if (subnetAddrList.isEmpty()) {
            resultSet.addResult(nodeList, 3);
        }
        return subnetAddrList;
    }

    public static Hashtable<String, List<String>> getPublicIPList(String[] nodeList, ResultSet resultSet) {
        Hashtable<String, List<String>> ipTable = new Hashtable<String, List<String>>();
        ClusterNetworkInfo clNetInfo = null;
        try {
            clNetInfo = NetworkUtility.getNetworkInfo(nodeList[0]);
        }
        catch (CVUException cvuEx) {
            String errMsg = cvuEx.getMessage();
            Trace.out((String)("Exception occured while getting network information. msg=" + errMsg));
            resultSet.addResult(nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        if (null == clNetInfo) {
            Trace.out((String)"Failed to retrieve the list of network interfaces and subnets");
            VerificationLogData.logError("Failed to retrieve the list of network interfaces and subnets");
            resultSet.addResult(nodeList, 2);
        } else {
            HashMap<String, String> publicInterfaceMap = new HashMap<String, String>();
            String[] ifList = clNetInfo.getIfNames();
            String[] subnetList = clNetInfo.getSubnets();
            int[] netTypeList = clNetInfo.getNetTypes();
            for (int index = 0; index < ifList.length; ++index) {
                if (netTypeList[index] != 2) continue;
                publicInterfaceMap.put(ifList[index], subnetList[index]);
            }
            if (publicInterfaceMap.size() == 0) {
                Trace.out((String)"Failed to retreive the interface details from install variable in pre-install scenario");
                VerificationLogData.logError("Failed to retreive the interface details from variable in pre-install scenario");
                resultSet.addResult(nodeList, 2);
            } else {
                Vector<NodeInfo> nodeInfoList = NetworkUtility.getNodeInfoList(nodeList, resultSet);
                if (nodeInfoList == null) {
                    Trace.out((String)"getNodeInfoList() retuned null");
                    Trace.out((String)"Failed to retreive the interface details from all the cluster nodes");
                    VerificationLogData.logError("Failed to retreive the interface details from all the cluster nodes");
                } else {
                    for (NodeInfo nodeInfo : nodeInfoList) {
                        String node = nodeInfo.getName();
                        for (String ifName : publicInterfaceMap.keySet()) {
                            String subnet = (String)publicInterfaceMap.get(ifName);
                            Trace.out((String)("Retrieving PUBLIC IP addresses on node " + node + " for subnet " + subnet + " and interface name " + ifName));
                            for (InterfaceInfo intInfo : nodeInfo.getInterfacesBySubnetAndName(subnet, ifName)) {
                                Trace.out((String)("Added Public IP (" + intInfo.getIP() + ") for interface '" + ifName + "' on node " + node));
                                VerificationLogData.log("Added Public IP (" + intInfo.getIP() + ") for interface '" + ifName + "' on node " + node);
                                if (ipTable.containsKey(node)) {
                                    ipTable.get(node).add(intInfo.getIP());
                                } else {
                                    ArrayList<String> ifInfoList = new ArrayList<String>();
                                    ifInfoList.add(intInfo.getIP());
                                    ipTable.put(node, ifInfoList);
                                }
                                resultSet.addResult(node, 1);
                            }
                        }
                    }
                }
            }
        }
        for (String node : nodeList) {
            if (ipTable.containsKey(node)) continue;
            Trace.out((String)("Failed to retrieve the Public IP address list from node " + node));
            ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1551", true, (Object[])new String[]{node}));
            resultSet.addErrorDescription(node, errDesc);
            resultSet.addResult(node, 2);
        }
        return ipTable;
    }

    public static Hashtable<String, List<String>> getPrivateIPList(String[] nodeList, ResultSet resultSet) {
        Hashtable<String, List<String>> ipTable = new Hashtable<String, List<String>>();
        ClusterNetworkInfo clNetInfo = null;
        try {
            clNetInfo = NetworkUtility.getNetworkInfo(nodeList[0]);
        }
        catch (CVUException cvuEx) {
            String errMsg = cvuEx.getMessage();
            Trace.out((String)("Exception occured while getting network information. msg=" + errMsg));
            resultSet.addResult(nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        if (null == clNetInfo) {
            Trace.out((String)"Failed to retrieve the list of network interfaces and subnets");
            VerificationLogData.logError("Failed to retrieve the list of network interfaces and subnets");
            resultSet.addResult(nodeList, 2);
        } else {
            HashMap<String, String> privateInterfaceMap = new HashMap<String, String>();
            String[] ifList = clNetInfo.getIfNames();
            String[] subnetList = clNetInfo.getSubnets();
            int[] netTypeList = clNetInfo.getNetTypes();
            for (int index = 0; index < ifList.length; ++index) {
                Trace.out((String)("Network information is as following :\ninterface name is = (" + ifList[index] + ")" + "\nsubnet is =(" + subnetList[index] + ")" + "\nnetwork type is =(" + netTypeList[index] + ")"));
                if (netTypeList[index] == 1) {
                    Trace.out((String)"Added this network info to the list of private networks");
                    privateInterfaceMap.put(ifList[index], subnetList[index]);
                    continue;
                }
                Trace.out((String)"Skipping this network info  network type is not private networks");
            }
            if (privateInterfaceMap.size() == 0) {
                Trace.out((String)"Failed to retreive the interface details");
                VerificationLogData.logError("Failed to retreive the interface details");
                resultSet.addResult(nodeList, 2);
            } else {
                Vector<NodeInfo> nodeInfoList = NetworkUtility.getNodeInfoList(nodeList, resultSet);
                if (nodeInfoList == null) {
                    Trace.out((String)"getNodeInfoList() retuned null");
                    Trace.out((String)"Failed to retreive the interface details from all the cluster nodes");
                    VerificationLogData.logError("Failed to retreive the interface details from all the cluster nodes");
                } else {
                    for (NodeInfo nodeInfo : nodeInfoList) {
                        String node = nodeInfo.getName();
                        for (String ifName : privateInterfaceMap.keySet()) {
                            String subnet = (String)privateInterfaceMap.get(ifName);
                            Trace.out((String)("Retrieving PRIVATE IP addresses on node " + node + " for subnet " + subnet + " and interface name " + ifName));
                            for (InterfaceInfo intInfo : nodeInfo.getInterfacesBySubnetAndName(subnet, ifName)) {
                                Trace.out((String)("Added Private IP (" + intInfo.getIP() + ") for interface '" + ifName + "' on node " + node));
                                VerificationLogData.log("Added Private IP (" + intInfo.getIP() + ") for interface '" + ifName + "' on node " + node);
                                if (ipTable.containsKey(node)) {
                                    ipTable.get(node).add(intInfo.getIP());
                                } else {
                                    ArrayList<String> ifInfoList = new ArrayList<String>();
                                    ifInfoList.add(intInfo.getIP());
                                    ipTable.put(node, ifInfoList);
                                }
                                resultSet.addResult(node, 1);
                            }
                        }
                    }
                }
            }
        }
        for (String node : nodeList) {
            if (ipTable.containsKey(node)) continue;
            Trace.out((String)("Failed to retrieve the Private IP address list from node " + node));
            ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1550", true, (Object[])new String[]{node}));
            resultSet.addErrorDescription(node, errDesc);
            resultSet.addResult(node, 2);
        }
        return ipTable;
    }

    private static Vector<NodeInfo> getNodeInfoList(String[] nodeList, ResultSet resultSet) {
        Vector<NodeInfo> nodeInfoList = new Vector<NodeInfo>();
        MultiNodeException mne = null;
        try {
            new VerifyNetwork().getInterfaceInfo(nodeList, nodeInfoList);
        }
        catch (NetworkException ne) {
            Trace.out((String)("NETWORK EXCEPTION CAUGHT: ERROR IS - " + ne.getMessage()));
            VerificationLogData.logError("NETWORK EXCEPTION CAUGHT: ERROR IS - " + ne.getMessage());
            resultSet.addResult(nodeList, 2);
            resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            ReportUtil.printError(ne.getMessage());
            return null;
        }
        catch (MultiNodeException mnException) {
            Trace.out((String)("MULTINODE EXCEPTION CAUGHT: ERROR IS - " + mnException.getMessage()));
            VerificationLogData.logError("MULTINODE EXCEPTION CAUGHT: ERROR IS - " + mnException.getMessage());
            mne = mnException;
        }
        if (null != mne) {
            Vector okNodes = NetworkUtility.reportMultiNodeException(mne, nodeList, resultSet);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(okNodes);
        }
        return nodeInfoList;
    }

    private static Vector reportMultiNodeException(MultiNodeException mne, String[] nodeList, ResultSet resultSet) {
        Vector<String> goodNodes = new Vector<String>();
        for (int i = 0; i < nodeList.length; ++i) {
            Collection throwables = mne.getThrowables(nodeList[i]);
            if (null == throwables) {
                goodNodes.add(nodeList[i]);
                continue;
            }
            resultSet.addResult(nodeList[i], 2);
            String errMsg = s_msgBundle.getMessage("4087", false);
            String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{nodeList[i]});
            String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{nodeList[i]});
            resultSet.getResult(nodeList[i]).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            Trace.out((String)errMsg);
            for (Throwable t : throwables) {
                resultSet.addErrorDescription(new ErrorDescription(t.getMessage()));
                ReportUtil.printError(t.getMessage());
            }
        }
        return goodNodes;
    }
}

