/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.util.ClassifierTable;
import oracle.ops.verification.util.DeepSortedTable;

public class Subnet
implements NetworkConstants {
    private ClassifierTable m_interfaces;
    private HashMap m_ifNameTable;
    private int m_numPrivate;
    private int m_numPublic;
    private int m_numAsm;
    private int m_numUnknown;
    private String m_subnetNumber;

    protected Subnet() {
        if (null == this.m_interfaces) {
            this.m_interfaces = new ClassifierTable();
            this.m_ifNameTable = new HashMap();
        }
    }

    protected Subnet(Collection interfaces) {
        this();
        for (InterfaceInfo inf : interfaces) {
            this.add(inf);
        }
    }

    protected void add(InterfaceInfo inf) {
        this.m_interfaces.put(inf.getNode(), inf);
        Integer numSameName = (Integer)this.m_ifNameTable.get(inf.getName());
        numSameName = null == numSameName ? new Integer(0) : new Integer(numSameName + 1);
        this.m_ifNameTable.put(inf.getName(), numSameName);
        if (null == this.m_subnetNumber) {
            this.m_subnetNumber = inf.getSubnet();
        }
        switch (inf.getNetType()) {
            case 1: {
                ++this.m_numPrivate;
                break;
            }
            case 2: {
                ++this.m_numPublic;
                break;
            }
            case 128: {
                ++this.m_numAsm;
                break;
            }
            case 4: {
                ++this.m_numUnknown;
            }
        }
    }

    private int getNumPrivates() {
        return this.m_numPrivate;
    }

    private int getNumPublic() {
        return this.m_numPublic;
    }

    private int getNumAsm() {
        return this.m_numAsm;
    }

    private int getNumUnknown() {
        return this.m_numUnknown;
    }

    public String getSubnet() {
        return this.m_subnetNumber;
    }

    public int getNumNodes() {
        return this.m_interfaces.keySet().size();
    }

    public Collection getNodes() {
        return this.m_interfaces.keySet();
    }

    public Collection getInterfaceNames() {
        return this.m_ifNameTable.keySet();
    }

    public int getNumInterfaces() {
        return this.m_interfaces.size();
    }

    public Collection getInterfaces() {
        return this.m_interfaces.values();
    }

    public Collection getInterfacesByNode(String node) {
        return this.m_interfaces.getSubGroup(node);
    }

    public boolean isPrivate() {
        boolean isPrivate = 0 == this.m_numPublic && 0 == this.m_numUnknown && this.m_numPrivate > 0;
        return isPrivate;
    }

    private Collection getSpanningInterfaces(int minNodes, boolean sameName, int typeFlags) {
        ClassifierTable ifTable = new ClassifierTable();
        DeepSortedTable nodeMap = new DeepSortedTable();
        Iterator ifIter = this.m_interfaces.values().iterator();
        Vector<Subnet> okSubnets = new Vector<Subnet>();
        if (this.getNumNodes() < minNodes) {
            return okSubnets;
        }
        while (ifIter.hasNext()) {
            InterfaceInfo inf = (InterfaceInfo)ifIter.next();
            String key = inf.getNetMask();
            if (sameName) {
                key = inf.getName() + "|" + key;
            }
            if (0 == (inf.getNetType() & typeFlags) || inf.getStatus() == 8) continue;
            nodeMap.put(key, inf.getNode());
            ifTable.put(key, inf);
        }
        for (String key : nodeMap.keySet()) {
            Collection nodeList = nodeMap.getSubGroup(key);
            if (nodeList.size() < minNodes) continue;
            Collection ifList = ifTable.getSubGroup(key);
            Subnet subnet = new Subnet(ifList);
            okSubnets.add(subnet);
        }
        return okSubnets;
    }

    public Collection getVIPOkSubnets(int minNodes) {
        Collection vipOkSubnets = this.getNumUnknown() + this.getNumPublic() < minNodes ? new Vector() : this.getSpanningInterfaces(minNodes, true, 6);
        return vipOkSubnets;
    }

    public Collection getPrivateOkSubnets(int minNodes, boolean isSameName) {
        Collection okSubnets = this.getNumPrivates() < minNodes ? new Vector() : this.getSpanningInterfaces(minNodes, isSameName, 1);
        return okSubnets;
    }

    public static Collection classifyToSubnets(Collection nodeInfoList) {
        Vector nodeInterfaceList = new Vector();
        Vector interfaceList = new Vector();
        Iterator nodeIter = nodeInfoList.iterator();
        while (nodeIter.hasNext()) {
            nodeInterfaceList = ((NodeInfo)nodeIter.next()).getInterfaceList();
            interfaceList.addAll(nodeInterfaceList);
        }
        return Subnet.classifyToSubnets(interfaceList, false);
    }

    public static Collection classifyToSubnets(Collection interfaceList, boolean byName) {
        LinkedHashMap<String, Subnet> table = new LinkedHashMap<String, Subnet>();
        for (InterfaceInfo inf : interfaceList) {
            Subnet subnet;
            String subnetNumber;
            String key = subnetNumber = inf.getSubnet();
            if (byName) {
                String name = inf.getName();
                key = key + "|" + name;
            }
            if (table.containsKey(key)) {
                subnet = (Subnet)table.get(key);
            } else {
                subnet = new Subnet();
                table.put(key, subnet);
            }
            subnet.add(inf);
        }
        return table.values();
    }
}

