/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TCPMatrix {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    public static final int SUCCESSFUL = 0;
    public static final int PARTIAL = 1;
    public static final int FAILED = -1;
    private String m_serverName = null;
    private String m_serverIP = "-1";
    private String m_serverPID = "-1";
    private String m_serverPort = "-1";
    private String[] m_IPList = null;
    private boolean m_serverExit = true;
    private String[] m_clientList = null;
    private int[] m_TCPConmatrix;
    private int m_status;

    public TCPMatrix(String serverName, String serverIP, String[] clientList, String[] IPList) {
        ArrayList<String> tmpClientList = new ArrayList<String>();
        ArrayList<String> tmpIPList = new ArrayList<String>();
        for (int i = 0; i < IPList.length; ++i) {
            if (!tmpIPList.contains(IPList[i])) {
                tmpIPList.add(IPList[i]);
                tmpClientList.add(clientList[i]);
                continue;
            }
            if (((String)tmpClientList.get(tmpIPList.indexOf(IPList[i]))).equals(clientList[i])) {
                Trace.out((String)("Removing duplicate entry for IP: " + IPList[i] + " on Node: " + clientList[i]));
                continue;
            }
            tmpIPList.add(IPList[i]);
            tmpClientList.add(clientList[i]);
            Trace.out((String)("Adding possible duplicate IP address to TCP matrix: IP: " + IPList[i] + " Node: " + clientList[i]));
        }
        this.m_serverName = serverName;
        this.m_serverIP = serverIP;
        this.m_clientList = tmpClientList.toArray(new String[tmpClientList.size()]);
        this.m_IPList = tmpIPList.toArray(new String[tmpIPList.size()]);
        this.m_TCPConmatrix = new int[this.m_clientList.length];
        this.initStatus();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nCreated - " + this.toString()));
        }
    }

    public TCPMatrix(String[] clientList, String[] IPList) {
        this(null, null, clientList, IPList);
        String localIP;
        String localNode;
        try {
            localNode = VerificationUtil.getLocalHost();
            int srvinClientLst = -1;
            for (int i = 0; i < this.m_clientList.length; ++i) {
                if (!localNode.equalsIgnoreCase(this.m_clientList[i])) continue;
                srvinClientLst = i;
                break;
            }
            localIP = srvinClientLst != -1 ? this.m_IPList[srvinClientLst] : InetAddress.getByName(localNode).getHostAddress();
        }
        catch (UnknownHostException e) {
            localNode = this.m_clientList[0];
            localIP = this.m_IPList[0];
        }
        this.setServerName(localNode);
        this.setServerIP(localIP);
        this.initStatus();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\nUpdated - " + this.toString()));
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public int getTCPStatus(int index) {
        return this.m_TCPConmatrix[index];
    }

    private void initStatus() {
        for (int i = 0; i < this.m_TCPConmatrix.length; ++i) {
            this.m_TCPConmatrix[i] = this.m_serverName != null && this.m_serverIP != null && this.m_serverName.contentEquals(this.m_clientList[i]) && this.m_serverIP.contentEquals(this.m_IPList[i]) ? 0 : -1;
        }
    }

    public void setStatus(int index, int value) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("index: " + index + " value: " + value));
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.toString();
        }
        this.m_TCPConmatrix[index] = value;
        if (Trace.isLevelEnabled((int)1)) {
            this.toString();
        }
    }

    public void setStatus() {
        boolean somePass = false;
        boolean somePartial = false;
        boolean someFail = false;
        for (int i = 0; i < this.m_TCPConmatrix.length; ++i) {
            Trace.out((String)("\n" + this.m_IPList[i] + " - TCPConmatrix[" + i + "]: " + this.m_TCPConmatrix[i]));
            if (this.m_TCPConmatrix[i] == 0) {
                somePass = true;
                continue;
            }
            if (this.m_TCPConmatrix[i] == 1) {
                somePartial = true;
                continue;
            }
            if (this.m_TCPConmatrix[i] != -1) continue;
            someFail = true;
        }
        this.m_status = somePartial || someFail ? -1 : 0;
        Trace.out((String)("Setting final status to: " + this.m_status));
    }

    public String printStatus() {
        String str = null;
        str = this.m_status == 0 ? ReportUtil.SUCCESSFUL : (this.m_status == 1 ? ReportUtil.PARTIALLY_SUCCESSFUL : (this.m_status == -1 ? ReportUtil.FAILED : "BAD TCPMATRIX STATUS"));
        return str;
    }

    public int[] getTCPConmatrix() {
        return this.m_TCPConmatrix;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public void setServerName(String serverName) {
        this.m_serverName = serverName;
    }

    public String getServerIP() {
        return this.m_serverIP;
    }

    public void setServerIP(String serverIP) {
        this.m_serverIP = serverIP;
    }

    public String[] getClientList() {
        return this.m_clientList;
    }

    public String[] getClientIPList() {
        return this.m_IPList;
    }

    public String getClientName(int index) {
        if (this.m_clientList != null) {
            return this.m_clientList[index];
        }
        return null;
    }

    public String getClientIP(int index) {
        if (this.m_IPList != null) {
            return this.m_IPList[index];
        }
        return null;
    }

    public String getServerPID() {
        return this.m_serverPID;
    }

    public void setServerPID(String serverPID) {
        this.m_serverPID = serverPID;
    }

    public String getServerPort() {
        return this.m_serverPort;
    }

    public void setServerPort(String serverPort) {
        this.m_serverPort = serverPort;
    }

    public boolean getServerExit() {
        return this.m_serverExit;
    }

    public void setServerExit(boolean serverExit) {
        this.m_serverExit = serverExit;
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer("\nTCP Connectivity Matrix for: " + this.m_serverName + "(IP:" + this.m_serverIP + " PID:" + this.m_serverPID + " PORT:" + this.m_serverPort + "): \n");
        if (this.m_IPList == null || this.m_clientList == null) {
            sBuf.append("\tError\n");
            return sBuf.toString();
        }
        for (int i = 0; i < this.m_clientList.length; ++i) {
            sBuf.append("\t" + this.m_clientList[i] + " (" + this.m_IPList[i] + "): ");
            if (this.m_TCPConmatrix[i] == 0) {
                sBuf.append("Success");
            } else if (this.m_TCPConmatrix[i] == 1) {
                sBuf.append("Partial Success");
            } else if (this.m_TCPConmatrix[i] == -1) {
                sBuf.append("Failure");
            } else {
                sBuf.append("UNKOWN");
            }
            sBuf.append("\n");
        }
        return sBuf.toString();
    }
}

