/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLOptionEnumItem;
import oracle.ops.verification.framework.param.parser.CLOptionSelection;
import oracle.ops.verification.framework.param.parser.CLSyntax2;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CLOption
extends CLCommand {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    protected String m_symbolicName = null;
    protected boolean m_processed = false;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public CLOption(CLCommand parent) {
        this.m_parent = parent;
    }

    public boolean isProcessed() {
        return this.m_processed;
    }

    public void setProcessed(boolean processed) {
        this.m_processed = processed;
    }

    public void setSymbolicName(String symbolicName) {
        this.m_symbolicName = symbolicName;
    }

    public boolean isOptionValid(List<String> clTokens, int currentTokenIndex) throws InvalidCLException {
        boolean match = true;
        if (clTokens == null || clTokens.isEmpty()) {
            return false;
        }
        boolean matches = false;
        if (this.m_fixedPosition) {
            matches = currentTokenIndex >= clTokens.size() ? false : clTokens.get(currentTokenIndex).equals(this.m_name);
        } else {
            matches = clTokens.contains(this.m_name);
            currentTokenIndex = clTokens.indexOf(this.m_name);
        }
        if (!matches) {
            return false;
        }
        clTokens.remove(currentTokenIndex);
        InvalidCLException lastCLException = null;
        if (this.m_valueRequired) {
            if (clTokens.isEmpty() || currentTokenIndex == clTokens.size()) {
                String displayText = this.m_name;
                if ("ENUM".equalsIgnoreCase(this.getValueType())) {
                    displayText = displayText + " {" + this.getValueListAsString() + "}";
                } else if (this.m_label != null) {
                    displayText = displayText + " <" + this.m_label + ">";
                }
                String msg = s_msgBundle.getMessage("3505", false, (Object[])new String[]{displayText});
                InvalidCLException ice = new InvalidCLException(msg);
                ice.setDefinitive(true);
                throw ice;
            }
            String value = clTokens.remove(currentTokenIndex);
            if (!this.validateValue(value)) {
                String displayText = this.m_name;
                if ("ENUM".equalsIgnoreCase(this.getValueType())) {
                    displayText = displayText + " {" + this.getValueListAsString() + "}";
                } else if (this.m_label != null) {
                    displayText = displayText + " <" + this.m_label + ">";
                }
                InvalidCLException ice = new InvalidCLException(s_msgBundle.getMessage("3503", false, (Object[])new String[]{value, displayText}));
                ice.setDefinitive(true);
                throw ice;
            }
            if (this.m_symbolicName != null) {
                VerificationUtil.setVariableValue(this.m_symbolicName, value);
            }
        } else if (this.m_symbolicName != null) {
            VerificationUtil.setVariableValue(this.m_symbolicName, "TRUE");
        }
        if (this.m_optionList != null) {
            for (CLOption option : this.m_optionList) {
                boolean optionMatch;
                if (option.isProcessed()) continue;
                ArrayList<String> clTokensCopy = new ArrayList<String>();
                clTokensCopy.addAll(clTokens);
                try {
                    optionMatch = option.isValid(clTokensCopy, currentTokenIndex);
                }
                catch (InvalidCLException e) {
                    if (this.getParent().isTopLevel()) {
                        e.setDefinitive(true);
                    }
                    if (lastCLException == null) {
                        lastCLException = e;
                        continue;
                    }
                    if (lastCLException.isDefinitive()) {
                        if (!e.isDefinitive()) continue;
                        lastCLException.addCause(e.getMessage());
                        continue;
                    }
                    if (e.isDefinitive()) {
                        lastCLException = e;
                        continue;
                    }
                    lastCLException.addCause(e.getMessage());
                    continue;
                }
                if (!optionMatch) continue;
                lastCLException = null;
                clTokens.clear();
                clTokens.addAll(clTokensCopy);
                option.setProcessed(true);
            }
        }
        if (lastCLException != null) {
            throw lastCLException;
        }
        if (this.m_optionList != null) {
            for (CLOption option : this.m_optionList) {
                if (option.isProcessed() || !option.isRequired()) continue;
                String displayText = option.getName();
                if ("ENUM".equalsIgnoreCase(option.getValueType())) {
                    displayText = displayText + " {" + option.getValueListAsString() + "}";
                } else if (option.getLabel() != null) {
                    displayText = displayText + " <" + option.getLabel() + ">";
                }
                if (VerificationUtil.isStringGood(displayText)) {
                    throw new InvalidCLException(s_msgBundle.getMessage("3504", false, (Object[])new String[]{displayText, this.getName(true)}));
                }
                throw new InvalidCLException(s_msgBundle.getMessage("3513", false));
            }
        }
        if (match && this.isTopLevel() && !clTokens.isEmpty()) {
            StringBuffer childToken = new StringBuffer();
            CLOption missingParent = this.getMissingParentOption(clTokens.get(0), clTokens, childToken);
            InvalidCLException icle = null;
            icle = missingParent == null || missingParent.isProcessed() ? new InvalidCLException(s_msgBundle.getMessage("3509", false, (Object[])new String[]{clTokens.get(0)})) : new InvalidCLException(s_msgBundle.getMessage("3511", false, (Object[])new String[]{childToken.toString(), missingParent.getName()}));
            icle.setDefinitive(true);
            throw icle;
        }
        return match;
    }

    public boolean isAllValid(List<String> clTokens, int currentTokenIndex) throws InvalidCLException {
        boolean match = false;
        InvalidCLException lastCLException = null;
        if (this.m_optionList == null || this.m_optionList.size() == 0) {
            return match;
        }
        int i = 0;
        while (!clTokens.isEmpty() && i < this.m_optionList.size()) {
            boolean optionMatch;
            CLOption option;
            if ((option = (CLOption)this.m_optionList.get(i++)).isProcessed()) continue;
            ArrayList<String> clTokensCopy = new ArrayList<String>();
            clTokensCopy.addAll(clTokens);
            try {
                optionMatch = option.isValid(clTokensCopy, currentTokenIndex);
                match = match || optionMatch;
            }
            catch (InvalidCLException e) {
                if (lastCLException == null) {
                    lastCLException = e;
                    continue;
                }
                if (lastCLException.isDefinitive()) {
                    if (!e.isDefinitive()) continue;
                    lastCLException.addCause(e.getMessage());
                    continue;
                }
                if (e.isDefinitive()) {
                    lastCLException = e;
                    continue;
                }
                lastCLException.addCause(e.getMessage());
                continue;
            }
            if (!optionMatch) continue;
            clTokens.clear();
            clTokens.addAll(clTokensCopy);
            option.setProcessed(true);
        }
        if (lastCLException != null) {
            throw lastCLException;
        }
        if (this.m_optionList != null) {
            for (CLOption option : this.m_optionList) {
                if (option.isProcessed() || !option.isRequired()) continue;
                String displayText = option.getName();
                if ("ENUM".equalsIgnoreCase(option.getValueType())) {
                    displayText = displayText + " {" + option.getValueListAsString() + "}";
                } else if (option.getLabel() != null) {
                    displayText = displayText + " <" + option.getLabel() + ">";
                }
                if (displayText != null) {
                    throw new InvalidCLException(s_msgBundle.getMessage("3504", false, (Object[])new String[]{displayText, this.getName(true)}));
                }
                throw new InvalidCLException(s_msgBundle.getMessage("3510", false, (Object[])new String[]{this.getName(true)}));
            }
        }
        if (match && this.isTopLevel() && !clTokens.isEmpty()) {
            StringBuffer childToken = new StringBuffer();
            CLOption missingParent = this.getMissingParentOption(clTokens.get(0), clTokens, childToken);
            InvalidCLException icle = null;
            icle = missingParent == null || missingParent.isProcessed() ? new InvalidCLException(s_msgBundle.getMessage("3509", false, (Object[])new String[]{clTokens.get(0)})) : new InvalidCLException(s_msgBundle.getMessage("3511", false, (Object[])new String[]{childToken.toString(), missingParent.getName()}));
            icle.setDefinitive(true);
            throw icle;
        }
        return match;
    }

    public boolean isChoiceValid(List<String> clTokens, int currentTokenIndex) throws InvalidCLException {
        InvalidCLException lastCLException = null;
        boolean atleastOneMatched = false;
        int i = 0;
        while (!clTokens.isEmpty() && i < this.m_optionList.size()) {
            boolean optionMatch;
            CLOption option;
            if ((option = (CLOption)this.m_optionList.get(i++)).isProcessed()) continue;
            ArrayList<String> clTokensCopy = new ArrayList<String>();
            clTokensCopy.addAll(clTokens);
            try {
                optionMatch = option.isValid(clTokensCopy, currentTokenIndex);
            }
            catch (InvalidCLException e) {
                if (lastCLException == null) {
                    lastCLException = e;
                    continue;
                }
                if (lastCLException.isDefinitive()) {
                    if (!e.isDefinitive()) continue;
                    lastCLException.addCause(e.getMessage());
                    continue;
                }
                if (e.isDefinitive()) {
                    lastCLException = e;
                    continue;
                }
                lastCLException.addCause(e.getMessage());
                continue;
            }
            if (!optionMatch) continue;
            lastCLException = null;
            clTokens.clear();
            clTokens.addAll(clTokensCopy);
            option.setProcessed(true);
        }
        if (lastCLException != null) {
            throw lastCLException;
        }
        if (this.m_optionList != null) {
            String processedOption = "";
            boolean first = true;
            int processedOptionCount = 0;
            for (CLOption option : this.m_optionList) {
                if (!option.isProcessed()) continue;
                ++processedOptionCount;
                if (first) {
                    if (VerificationUtil.isStringGood(option.getName())) {
                        processedOption = processedOption + option.getName();
                    }
                    first = false;
                } else if (VerificationUtil.isStringGood(option.getName())) {
                    processedOption = processedOption + "," + option.getName();
                }
                atleastOneMatched = true;
            }
            if (processedOptionCount > 1) {
                InvalidCLException icle = null;
                icle = processedOption.length() > 0 ? new InvalidCLException(s_msgBundle.getMessage("3512", false, (Object[])new String[]{processedOption})) : new InvalidCLException(s_msgBundle.getMessage("3513", false));
                icle.setDefinitive(true);
                throw icle;
            }
        }
        if (CLOptionSelection.CHOICE.equals((Object)this.m_selection) && !atleastOneMatched && this.isRequired()) {
            if (currentTokenIndex < clTokens.size()) {
                throw new InvalidCLException(s_msgBundle.getMessage("3509", false, (Object[])new String[]{clTokens.get(currentTokenIndex)}));
            }
            throw new InvalidCLException(s_msgBundle.getMessage("3510", false, (Object[])new String[]{this.getName(true)}));
        }
        if (atleastOneMatched && this.isTopLevel() && !clTokens.isEmpty()) {
            InvalidCLException icle = null;
            icle = new InvalidCLException(s_msgBundle.getMessage("3509", false, (Object[])new String[]{clTokens.get(0)}));
            icle.setDefinitive(true);
            throw icle;
        }
        return atleastOneMatched;
    }

    @Override
    public boolean isValid(List<String> clTokens, int currentTokenIndex) throws InvalidCLException {
        if (this.m_selection == null) {
            return this.isOptionValid(clTokens, currentTokenIndex);
        }
        if (this.m_selection.equals((Object)CLOptionSelection.ALL)) {
            return this.isAllValid(clTokens, currentTokenIndex);
        }
        if (this.m_selection.equals((Object)CLOptionSelection.CHOICE)) {
            return this.isChoiceValid(clTokens, currentTokenIndex);
        }
        return false;
    }

    private CLOption getMissingParentOption(String token, List<String> tokenList, StringBuffer childToken) {
        CLOption matchingOption = this.getMatchingOption(token);
        if (matchingOption == null) {
            return null;
        }
        if (matchingOption.isProcessed()) {
            return null;
        }
        CLOption tempOption = matchingOption;
        CLOption parentOption = null;
        do {
            if (tempOption.getParent().getSelection() != null) continue;
            parentOption = (CLOption)tempOption.getParent();
            break;
        } while (!(tempOption = (CLOption)tempOption.getParent()).getParent().equals(tempOption));
        if (parentOption == null) {
            return parentOption;
        }
        if (!parentOption.isProcessed()) {
            if (tokenList.contains(parentOption.getName())) {
                parentOption = this.getMissingParentOption(parentOption.getName(), tokenList, childToken);
            } else {
                if (childToken.length() > 0) {
                    childToken.delete(0, childToken.length());
                }
                childToken.append(token);
            }
            return parentOption;
        }
        return null;
    }

    private CLOption getMatchingOption(String token) {
        CLOption option;
        if (this.m_optionList == null) {
            return null;
        }
        CLOption matchingOption = null;
        Iterator i$ = this.m_optionList.iterator();
        while (i$.hasNext() && (matchingOption = token.equals((option = (CLOption)i$.next()).getName()) ? option : option.getMatchingOption(token)) == null) {
        }
        return matchingOption;
    }

    private boolean validateValue(String value) throws InvalidCLException {
        boolean valid = false;
        if (this.m_valueList != null) {
            for (CLOptionEnumItem item : this.m_valueList) {
                valid = !this.m_ignoreCase ? item.getText().equals(value) : item.getText().equalsIgnoreCase(value);
                if (!valid) continue;
                break;
            }
        } else if ("STORAGE_SIZE".equalsIgnoreCase(this.getValueType())) {
            valid = true;
            String token = value;
            String dskSpaceTxt = token.substring(0, token.length() - 1);
            long size = -1L;
            try {
                size = Long.parseLong(dskSpaceTxt);
                valid = size <= 0L ? false : valid;
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)("====Invalid int value '" + dskSpaceTxt + "' for space check: "));
                valid = false;
            }
            long unit = -1L;
            if (token.endsWith(CLSyntax.STR_SIZE_BYTE)) {
                unit = 1L;
            } else if (token.endsWith(CLSyntax.STR_SIZE_KILO)) {
                unit = 1024L;
            } else if (token.endsWith(CLSyntax.STR_SIZE_MEGA)) {
                unit = 0x100000L;
            } else if (token.endsWith(CLSyntax.STR_SIZE_GIGA)) {
                unit = 0x40000000L;
            }
            boolean bl = valid = unit > 0L ? valid : false;
            if (size >= Long.MAX_VALUE / unit) {
                valid = false;
            }
        } else if ("NODE".equalsIgnoreCase(this.getValueType())) {
            valid = value != null && !value.startsWith("-");
            this.assertNonMultipleValue(value);
            this.assertNonIPString(value);
        } else if ("NODE_LIST".equalsIgnoreCase(this.getValueType())) {
            String[] nodeNames;
            valid = value != null && !value.startsWith("-");
            for (String nodeName : nodeNames = value.split(",")) {
                this.assertNonIPString(nodeName);
            }
        } else if ("PATH".equalsIgnoreCase(this.getValueType())) {
            valid = value != null && !value.startsWith("-");
            this.assertNonMultipleValue(value);
        } else {
            valid = "INTEGER".equalsIgnoreCase(this.getValueType()) ? this.assertIntegerValue(value) : value != null && !value.startsWith("-");
        }
        return valid;
    }

    @Override
    protected String getDisplayString() {
        String displayText = this.m_name;
        if ("ENUM".equalsIgnoreCase(this.getValueType())) {
            String itemString = "";
            boolean first = true;
            for (CLOptionEnumItem item : this.getValueList()) {
                if (item.isHidden()) continue;
                if (first) {
                    first = false;
                } else {
                    itemString = itemString + "|";
                }
                itemString = itemString + item.getText();
            }
            displayText = displayText + " {" + itemString + "}";
        } else if (this.m_label != null) {
            displayText = displayText + " <" + this.m_label + ">";
        }
        if ("STORAGE_SIZE".equalsIgnoreCase(this.getValueType())) {
            displayText = displayText + "{B|K|M|G}";
        }
        return displayText;
    }

    @Override
    protected String getHelpText(CLOption option, int iteratorCount, String spacerString) {
        if (this.m_selection == null) {
            return this.getOptionHelpText(iteratorCount, spacerString);
        }
        if (this.m_selection.equals((Object)CLOptionSelection.ALL)) {
            return this.getAllHelpText(iteratorCount, spacerString);
        }
        if (this.m_selection.equals((Object)CLOptionSelection.CHOICE)) {
            return this.getChoiceHelpText(iteratorCount, spacerString);
        }
        return "";
    }

    private String getOptionHelpText(int iteratorCount, String spacerString) {
        if (this.isHidden() && !this.isTopLevel()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isTopLevel()) {
            String parents = "";
            CLCommand parent = this.getParent();
            do {
                if (null == parent.getName()) continue;
                parents = parent.getName() + " " + parents;
            } while (!(parent = parent.getParent()).equals(parent.getParent()));
            parents = CLSyntax2.CLUVFY_TEXT + parent.getName() + " " + parents;
            int spacerLength = parents.length();
            if (this.getOptionList() == null || this.getOptionList().size() != 1 || !CLOptionSelection.CHOICE.equals((Object)this.getOptionList().get(0).getSelection())) {
                spacerLength += this.getName().length();
            }
            spacerString = this.getPaddedString("", spacerLength);
            sb.append(parents);
        } else if (this.getParent().getSelection() == null && this.getParent().isTopLevel() && iteratorCount > 2 && iteratorCount % 2 == 0) {
            sb.append(CLSyntax2.LSEP + spacerString);
        }
        String displayText = "";
        if (this.getOptionList() == null || this.getOptionList().size() == 0) {
            displayText = this.getDisplayString();
            if (!(this.isRequired() || this.isTopLevel() || CLOptionSelection.CHOICE.equals((Object)this.getParent().getSelection()))) {
                displayText = "[" + displayText + "]";
            }
        }
        if (this.getOptionList() != null && this.getOptionList().size() > 0) {
            StringBuilder childOptionSB = new StringBuilder();
            for (int i = 0; i < this.getOptionList().size(); ++i) {
                CLOption childOption = this.getOptionList().get(i);
                String childOptionStr = childOption.getHelpText(childOption, i, spacerString);
                displayText = this.getDisplayString();
                childOptionSB.append(childOptionStr);
            }
            if (childOptionSB.length() > 0) {
                displayText = this.getOptionList() != null && this.getOptionList().size() == 1 && CLOptionSelection.CHOICE.equals((Object)this.getOptionList().get(0).getSelection()) ? childOptionSB.toString() : displayText + " " + childOptionSB.toString();
            }
            if (!(this.isRequired() || this.isTopLevel() || CLOptionSelection.CHOICE.equals((Object)this.getParent().getSelection()))) {
                displayText = "[" + displayText + "]";
            }
        }
        sb.append(displayText);
        return sb.toString();
    }

    private String getAllHelpText(int iteratorCount, String spacerString) {
        StringBuffer sb = new StringBuffer("");
        for (CLOption childOption : this.m_optionList) {
            String childOptionStr = "";
            if (!childOption.isHidden() && iteratorCount > 2 && iteratorCount % 2 == 0) {
                childOptionStr = childOptionStr + CLSyntax2.LSEP + spacerString;
            }
            if (!childOption.isHidden() && this.m_optionList.indexOf(childOption) != 0) {
                childOptionStr = childOptionStr + " ";
            }
            childOptionStr = childOptionStr + childOption.getHelpText(childOption, iteratorCount++, spacerString);
            sb.append(childOptionStr);
        }
        return sb.toString();
    }

    private String getChoiceHelpText(int iteratorCount, String spacerString) {
        StringBuffer sb = new StringBuffer("");
        boolean anyRequiredOption = false;
        for (CLOption childOption : this.m_optionList) {
            if (childOption.isRequired()) {
                anyRequiredOption = true;
            }
            if (this.getParent().getSelection() == null && (this.getParent().isRequired() || this.getParent().isTopLevel()) && iteratorCount > 2 && iteratorCount % 2 == 0) {
                sb.append(CLSyntax2.LSEP + spacerString + "  ");
            }
            int childSpacerLength = spacerString.length() + 1;
            if (this.getParent().getName(true) != null) {
                childSpacerLength += this.getParent().getName(true).length();
            }
            String childOptionStr = childOption.getHelpText(childOption, iteratorCount++, this.getPaddedString("", childSpacerLength));
            if (this.getParent().getSelection() == null && (this.getParent().isRequired() || this.getParent().isTopLevel())) {
                childOptionStr = CLSyntax2.LSEP + spacerString + " " + this.getParent().getDisplayString() + " " + childOptionStr;
            } else if (this.m_optionList.indexOf(childOption) != 0) {
                childOptionStr = "|" + childOptionStr.trim();
            }
            if (this.m_optionList.indexOf(childOption) == this.m_optionList.size() - 1 && !this.getParent().isTopLevel()) {
                childOptionStr = childOptionStr + CLSyntax2.LSEP + spacerString;
            }
            sb.append(childOptionStr);
        }
        if (!(this.isRequired() || this.isTopLevel() || anyRequiredOption)) {
            return "[" + sb.toString().trim() + "]";
        }
        return sb.toString();
    }

    private String getPaddedString(String str, int length) {
        int strLength = 0;
        if (str != null) {
            strLength = str.length();
        }
        while (strLength++ < length) {
            str = str + " ";
        }
        return str;
    }

    private String getPaddedString(String str, int length, String paddingCharacter) {
        int strLength = 0;
        if (str != null) {
            strLength = str.length();
        }
        while (strLength++ < length) {
            str = str + paddingCharacter;
        }
        return str;
    }

    private boolean assertNonMultipleValue(String value) throws InvalidCLException {
        if (value == null) {
            return true;
        }
        if (value.contains(",")) {
            throw new InvalidCLException(s_msgBundle.getMessage("3506", false, (Object[])new String[]{this.getDisplayString()}));
        }
        return true;
    }

    private boolean assertNonIPString(String value) throws InvalidCLException {
        if (!CLOption.isIPv4Address(value) && !CLOption.isIPv6Address(value)) {
            return true;
        }
        throw new InvalidCLException(s_msgBundle.getMessage("3507", false, (Object[])new String[]{this.getDisplayString()}));
    }

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    public static boolean isIPv6Address(String input) {
        return CLOption.isIPv6StdAddress(input) || CLOption.isIPv6HexCompressedAddress(input);
    }

    public boolean assertIntegerValue(String value) throws InvalidCLException {
        try {
            int number = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidCLException(s_msgBundle.getMessage("3508", false, (Object[])new String[]{value, this.getDisplayString()}));
        }
        return true;
    }

    @Override
    public String toString() {
        String str = this.getParent().toString();
        str = this.m_name != null ? str + " " + this.m_name : str + " " + (Object)((Object)this.m_selection);
        return str;
    }
}

