/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxXMLParser;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CLSyntax2 {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    public static String STR_VERBOSE = "-verbose";
    public static String STR_HELP = "-help";
    public static String STR_LIST = "-list";
    public static String STR_VERSION = "-version";
    public static String STR_COMPONENT = "comp";
    public static String STR_STAGE = "stage";
    static final String FSEP = System.getProperty("file.separator");
    static final String LSEP = System.getProperty("line.separator");
    static final String TAB = "\t";
    private static final String USAGE_TEXT = LSEP + s_msgBundle.getMessage("3000", false) + LSEP;
    static final String DESCRIPTION_TEXT = s_msgBundle.getMessage("3001", false) + LSEP;
    private static final String OPT_COMMON = " [" + STR_VERBOSE + "]";
    static String CLUVFY_TEXT = "cluvfy ";
    static final String RUN_CLUVFY_TEXT = "runcluvfy";
    public static final String FROM_RUNCLUVFY = "_FROM_RUNCLUVFY";
    public static final String FROM_RACHOME = "_FROM_RACHOME";
    private static List<CLCommand> m_commands = null;
    private static boolean m_exitOnError = true;

    private static void testValidate(String release, String command) {
        try {
            m_exitOnError = false;
            System.out.println(release + ":" + command + "=>");
            System.out.println(CLSyntax2.validate(release, command.split("\\s+")) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String release = "";
        String command = "";
        command = "stage -pre crsinst -upgade -n adc6160715 -rolling -src_crshome /tmp -dest_crshome /bar -crs_version 11.2.0.3";
        CLSyntax2.testValidate(release, command);
    }

    public static boolean validate(String release, String[] commandTokens) {
        Trace.out((int)5, (String)"Method entry. release=%s, commandStr=%s", (Object[])new Object[]{release, VerificationUtil.strArr2String(commandTokens)});
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : commandTokens) {
            tokens.add(token);
        }
        try {
            CLSyntaxXMLParser parser = new CLSyntaxXMLParser();
            m_commands = parser.getCommands(release);
        }
        catch (XmlParserException e) {
            System.out.println(LSEP + "ERROR:");
            String errorMsg = e.getMessage();
            System.out.println(errorMsg);
            System.out.println(CLSyntax2.getUsageText(commandTokens));
            if (m_exitOnError) {
                System.exit(1);
            }
            return false;
        }
        InvalidCLException exception = new InvalidCLException(s_msgBundle.getMessage("1001", false));
        boolean valid = false;
        if (tokens.contains(STR_HELP) || tokens.contains(STR_LIST) || tokens.contains(STR_VERSION)) {
            CLCommand matchedCommand = CLSyntax2.matchCommand(tokens);
            if (tokens.size() == 1 && ((String)tokens.get(0)).equals(STR_HELP)) {
                System.out.println(CLSyntax2.getUsageText(commandTokens));
                if (m_exitOnError) {
                    System.exit(0);
                }
                valid = true;
            } else if (tokens.size() == 1 && ((String)tokens.get(0)).equals(STR_VERSION)) {
                System.out.println(CLSyntax2.getVersionText());
                if (m_exitOnError) {
                    System.exit(0);
                }
                valid = true;
            } else if (matchedCommand != null) {
                if (tokens.contains(STR_LIST) && tokens.size() != 2) {
                    valid = false;
                    exception = new InvalidCLException(s_msgBundle.getMessage("1001", false));
                } else {
                    System.out.println(CLSyntax2.getUsageText(commandTokens));
                    if (m_exitOnError) {
                        System.exit(0);
                    }
                    valid = true;
                }
            } else {
                valid = false;
                exception = new InvalidCLException(s_msgBundle.getMessage("1001", false));
            }
        } else {
            try {
                for (CLCommand command : m_commands) {
                    if (!command.isValid(tokens)) continue;
                    valid = true;
                    break;
                }
            }
            catch (InvalidCLException e) {
                exception = e;
            }
        }
        if (!valid) {
            System.out.println(LSEP + "ERROR:");
            System.out.println(exception.getMessage());
            System.out.println(CLSyntax2.getUsageText(commandTokens));
            if (m_exitOnError) {
                System.exit(1);
            }
        }
        return valid;
    }

    public static String getVersionText() {
        StringBuffer sb = new StringBuffer();
        sb.append("12.1.0.1.0");
        sb.append(" Build ");
        sb.append("06_28_13_X86".replaceAll("_", ""));
        return sb.toString();
    }

    public static String getUsageText(String[] commandTokens) {
        StringBuffer sb = new StringBuffer(USAGE_TEXT);
        if (commandTokens == null || commandTokens.length == 0 || m_commands == null) {
            sb.append(CLSyntax2.getUsageText_generic());
            return sb.toString();
        }
        CLCommand matchedCommand = CLSyntax2.matchCommand(Arrays.asList(commandTokens));
        if (matchedCommand != null) {
            sb.append(matchedCommand.getUsageText(commandTokens));
        } else {
            sb.append(CLSyntax2.getUsageText_generic());
        }
        return sb.toString();
    }

    private static CLCommand matchCommand(List<String> commandTokens) {
        if (m_commands == null || commandTokens == null || commandTokens.size() == 0) {
            return null;
        }
        CLCommand matchCommand = null;
        for (CLCommand command : m_commands) {
            if (!command.getName().equals(commandTokens.get(0))) continue;
            matchCommand = command;
            break;
        }
        return matchCommand;
    }

    static String getUsageText_generic() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "[-help|-version]" + LSEP);
        sb.append(CLSyntax2.getUsageText_stage_help());
        sb.append(CLSyntax2.getUsageText_stage_usage());
        sb.append(CLSyntax2.getUsageText_comp_help());
        sb.append(CLSyntax2.getUsageText_comp_usage());
        sb.append(LSEP);
        return sb.toString();
    }

    static String getUsageText_comp_help() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "comp  {-list|-help}" + LSEP);
        return sb.toString();
    }

    static String getUsageText_comp_usage() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "comp  <component-name> ");
        sb.append("<component-specific options> " + OPT_COMMON + LSEP);
        return sb.toString();
    }

    static String getUsageText_stage_help() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "stage {-list|-help}" + LSEP);
        return sb.toString();
    }

    static String getUsageText_stage_usage() {
        StringBuffer sb = new StringBuffer();
        sb.append(CLUVFY_TEXT + "stage {-pre|-post} <stage-name> ");
        sb.append("<stage-specific options> " + OPT_COMMON + LSEP);
        return sb.toString();
    }

    public static void setRunCluvfyTxt() {
        Trace.out((String)"Method Entry.");
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        CLUVFY_TEXT = nativeSys.isUnixSystem() ? "runcluvfy.sh " : nativeSys.getScriptFileName(RUN_CLUVFY_TEXT) + " ";
    }

    public static boolean isExitOnError() {
        return m_exitOnError;
    }

    public static void setExitOnError(boolean exitOnError) {
        m_exitOnError = exitOnError;
    }
}

