/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class ReportData {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static ReportHandle m_HtmlReportHandle = null;
    private static ReportHandle m_TextReportHandle = null;
    private static ReportHandle m_XmlReportHandle = null;
    private static String m_localNodeName = null;
    private ReportHandle currentReportHandle = null;
    private long m_fileID;
    private String m_reportSubDirectory = null;

    protected ReportData(ReportTypes reportType) throws ReportToolException {
        if (!VerificationUtil.isStringGood(m_localNodeName)) {
            m_localNodeName = VerificationUtil.getLocalHostName();
        }
        this.m_fileID = 0L;
        this.initializeReportHandle(reportType);
        this.m_reportSubDirectory = this.currentReportHandle.createNewReposSubDirectory();
    }

    private void initializeReportHandle(ReportTypes reportType) throws ReportToolException {
        switch (reportType) {
            case HTML: {
                if (null == m_HtmlReportHandle) {
                    m_HtmlReportHandle = new ReportHandle(reportType);
                }
                this.currentReportHandle = m_HtmlReportHandle;
                break;
            }
            case TEXT: {
                if (null == m_TextReportHandle) {
                    m_TextReportHandle = new ReportHandle(reportType);
                }
                this.currentReportHandle = m_TextReportHandle;
                break;
            }
            case XML: {
                if (null == m_XmlReportHandle) {
                    m_XmlReportHandle = new ReportHandle(reportType);
                }
                this.currentReportHandle = m_XmlReportHandle;
            }
        }
    }

    protected String save(Object obj) throws ReportToolException {
        String objectFileName = this.getNextObjFileID();
        FileOutputStream file_for_obj = null;
        ObjectOutputStream obj_out = null;
        try {
            file_for_obj = new FileOutputStream(this.completePath(objectFileName));
            obj_out = new ObjectOutputStream(file_for_obj);
            obj_out.writeObject(obj);
        }
        catch (FileNotFoundException fnfe) {
            throw new ReportToolException(fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            throw new ReportToolException(ioe.getMessage(), ioe);
        }
        finally {
            if (file_for_obj != null) {
                try {
                    file_for_obj.close();
                }
                catch (IOException e) {}
            }
            if (obj_out != null) {
                try {
                    obj_out.close();
                }
                catch (IOException e) {}
            }
        }
        return objectFileName;
    }

    protected Object load(String fileName) throws ReportToolException {
        return this.load(fileName, false);
    }

    protected Object load(String fileName, boolean cleanUpFile) throws ReportToolException {
        Object obj;
        FileInputStream file_for_obj = null;
        ObjectInputStream obj_in = null;
        try {
            file_for_obj = new FileInputStream(this.completePath(fileName));
            obj_in = new ObjectInputStream(file_for_obj);
            obj = obj_in.readObject();
        }
        catch (FileNotFoundException fnfe) {
            throw new ReportToolException(fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            throw new ReportToolException(ioe.getMessage(), ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReportToolException(cnfe.getMessage(), cnfe);
        }
        finally {
            if (file_for_obj != null) {
                try {
                    file_for_obj.close();
                }
                catch (IOException e) {}
            }
            if (obj_in != null) {
                try {
                    obj_in.close();
                }
                catch (IOException e) {}
            }
        }
        if (cleanUpFile) {
            this.delete(fileName);
        }
        return obj;
    }

    protected String getCurrentObjectFileID() {
        return this.currentReportHandle.getReportType().toString().toLowerCase() + "_" + this.m_fileID;
    }

    private String getNextObjFileID() {
        ++this.m_fileID;
        return this.currentReportHandle.getReportType().toString().toLowerCase() + "_" + this.m_fileID;
    }

    private String completePath(String fileName) {
        return this.m_reportSubDirectory + VerificationConstants.FILE_SEPARATOR + fileName;
    }

    protected void delete(String fileName) {
        if (!VerificationUtil.isStringGood(fileName)) {
            return;
        }
        File file = new File(this.completePath(fileName));
        if (file.exists()) {
            file.delete();
        } else {
            Trace.out((String)("File (" + fileName + ") does not exist, Ignoring"));
        }
    }

    private void deleteReposDirIfExist(String dirPath) throws ReportToolException {
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            Trace.out((String)("Cleaning the directory " + dirPath + " if it exists on local node " + m_localNodeName));
            File directory = new File(dirPath);
            if (directory.exists() && directory.isDirectory()) {
                Trace.out((String)("The directory " + dirPath + " exists on local node " + m_localNodeName + " removing it"));
                boolean succ = clusterCmd.removeDirectory(new String[]{m_localNodeName}, dirPath, true);
                if (!succ) {
                    throw new ReportToolException(s_msgBundle.getMessage("7555", true, (Object[])new String[]{dirPath}));
                }
            }
        }
        catch (ClusterException ce) {
            throw new ReportToolException(ce.getMessage(), ce);
        }
    }

    private void createReportDirectory(String dirPath) throws ReportToolException {
        ClusterCmd clusterCmd = new ClusterCmd();
        this.deleteReposDirIfExist(dirPath);
        try {
            File directory = new File(dirPath);
            if (!directory.exists() && !clusterCmd.createDirInNode(m_localNodeName, dirPath)) {
                throw new ReportToolException(s_msgBundle.getMessage("7705", true, (Object[])new String[]{dirPath}));
            }
        }
        catch (ClusterException ce) {
            throw new ReportToolException(ce.getMessage(), ce);
        }
    }

    protected void cleanUpReportData() throws ReportToolException {
        this.deleteReposDirIfExist(this.m_reportSubDirectory);
    }

    private class ReportHandle {
        private ReportTypes m_reportType;
        private String m_reposDirPath;
        private long m_reportIDInstanceCnt;

        public ReportHandle(ReportTypes type) throws ReportToolException {
            this.m_reportType = type;
            this.m_reposDirPath = VerificationUtil.getCVUSubDirPath() + this.m_reportType.toString().toLowerCase();
            this.m_reportIDInstanceCnt = 0L;
            this.cleanUpReposDirIfExist();
            this.createReposDirectory();
        }

        public ReportTypes getReportType() {
            return this.m_reportType;
        }

        private long getNewReportIDInstanceNumber() {
            ++this.m_reportIDInstanceCnt;
            return this.m_reportIDInstanceCnt;
        }

        private void createReposDirectory() throws ReportToolException {
            ReportData.this.createReportDirectory(this.m_reposDirPath);
        }

        private String createNewReposSubDirectory() throws ReportToolException {
            String subDirPath = this.m_reposDirPath + VerificationConstants.FILE_SEPARATOR + this.m_reportType.toString().toLowerCase() + this.getNewReportIDInstanceNumber();
            ReportData.this.createReportDirectory(subDirPath);
            return subDirPath;
        }

        private void cleanUpReposDirIfExist() throws ReportToolException {
            ReportData.this.deleteReposDirIfExist(this.m_reposDirPath);
        }
    }

    public static enum ReportTypes {
        TEXT,
        XML,
        HTML;

    }
}

