/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.htmlreport.Table;
import oracle.ops.verification.framework.report.htmlreport.TableCell;
import oracle.ops.verification.framework.report.htmlreport.Text;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HtmlBuffer
implements HtmlConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private StringBuffer htmlBuffer = null;
    private int m_tabCount = 0;
    private boolean m_isFormattingEnabled = false;

    public HtmlBuffer(boolean formatting) {
        this.m_isFormattingEnabled = formatting;
        this.htmlBuffer = new StringBuffer();
    }

    public void addLineBreak() {
        this.beginAndClose("br /");
    }

    protected void begin(String tag) {
        this.begin(tag, null);
    }

    protected void begin(String tag, Map<String, String> attrMap) {
        this.htmlBuffer.append(this.createBegin(tag, attrMap));
    }

    protected String createBegin(String tag, Map<String, String> attrMap) {
        String buffer = "";
        if (this.m_isFormattingEnabled) {
            ++this.m_tabCount;
            buffer = VerificationConstants.LINE_SEPARATOR;
            for (int i = 0; i < this.m_tabCount; ++i) {
                buffer = buffer + "  ";
            }
        }
        buffer = buffer + "<";
        buffer = buffer + tag;
        if (attrMap != null) {
            Set<String> keySet = attrMap.keySet();
            Object[] keys = keySet.toArray();
            for (int i = 0; i < keys.length; ++i) {
                buffer = buffer + " ";
                String value = attrMap.get(keys[i]);
                if (value != null) {
                    buffer = buffer + keys[i] + "=";
                    buffer = buffer + "\"" + attrMap.get(keys[i]) + "\"";
                    continue;
                }
                buffer = buffer + keys[i];
            }
        }
        buffer = buffer + ">";
        return buffer;
    }

    protected void beginAndClose(String tag, Map<String, String> attrMap) {
        String buffer = this.createBegin(tag, attrMap);
        int index = buffer.lastIndexOf(">");
        if (index != -1) {
            buffer = buffer.substring(index) + " />";
        }
        this.htmlBuffer.append(this.createBegin(tag, attrMap));
    }

    protected void beginAndClose(String tag) {
        this.beginAndClose(tag, null);
    }

    protected void close(String tag) {
        String buffer = "";
        if (this.m_isFormattingEnabled) {
            buffer = buffer + VerificationConstants.LINE_SEPARATOR;
            for (int i = 0; i < this.m_tabCount; ++i) {
                buffer = buffer + "  ";
            }
            --this.m_tabCount;
        }
        buffer = buffer + "</";
        buffer = buffer + tag;
        buffer = buffer + ">";
        this.htmlBuffer.append(buffer);
    }

    protected void append(String text) {
        this.htmlBuffer.append(text);
    }

    protected void append(StringBuffer buffer) {
        this.htmlBuffer.append(buffer);
    }

    public String toString() {
        return this.htmlBuffer.toString();
    }

    public StringBuffer toStringBuffer() {
        return this.htmlBuffer;
    }

    public void addHeading(Text heading, int headingNumber, HtmlConstants.HorizontalAlignment align) throws HtmlReportToolException {
        if (headingNumber > 6 || headingNumber < 0) {
            headingNumber = 6;
        }
        if (align != null && align.equals((Object)HtmlConstants.HorizontalAlignment.none)) {
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            attributeMap.put("align", align.name());
            this.begin("h" + Integer.toString(headingNumber), attributeMap);
        } else {
            this.begin("h" + Integer.toString(headingNumber));
        }
        this.append(heading.toHtmlString());
        this.close("h" + Integer.toString(headingNumber));
    }

    public void addParagraph(Text data, HtmlConstants.HorizontalAlignment align) throws HtmlReportToolException {
        if (data != null) {
            if (align != null && !align.equals((Object)HtmlConstants.HorizontalAlignment.none)) {
                HashMap<String, String> attributeMap = new HashMap<String, String>();
                attributeMap.put("align", align.name());
                this.begin("p", attributeMap);
            } else {
                this.begin("p");
            }
            this.addText(data);
            this.close("p");
        }
    }

    public void addHorizontalLine() throws HtmlReportToolException {
        this.addHorizontalLineWithWidth(100);
    }

    public void addHorizontalLineWithWidth(int width) throws HtmlReportToolException {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (width <= 0) {
            width = 100;
        }
        attributeMap.put("width", Integer.toString(width) + "%");
        this.begin("hr", attributeMap);
    }

    public void addDefinitionList(Map<Text, Text[]> defData) throws HtmlReportToolException {
        if (defData != null) {
            Object[] defItem = defData.keySet().toArray();
            this.begin("dl");
            for (int i = 0; i < defItem.length; ++i) {
                this.begin("dt");
                this.addText((Text)defItem[i]);
                this.close("dt");
                for (Text txt : defData.get(defItem[i])) {
                    this.begin("dd");
                    this.addText(txt);
                    this.close("dd");
                }
            }
            this.close("dl");
        }
    }

    public static HtmlBuffer createHtmlBodyBegin(boolean indent, HtmlConstants.Colors backGroundColor) {
        HtmlBuffer htmlBodyBegin = new HtmlBuffer(indent);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (backGroundColor != null) {
            attributeMap.put("BGCOLOR", backGroundColor.getID());
        }
        if (attributeMap.size() > 0) {
            htmlBodyBegin.begin("body", attributeMap);
        } else {
            htmlBodyBegin.begin("body");
        }
        return htmlBodyBegin;
    }

    public static HtmlBuffer createHtmlHeadBegin(boolean indent, String author, String title) {
        HtmlBuffer htmlHeadBegin = new HtmlBuffer(indent);
        htmlHeadBegin.begin("head");
        if (VerificationUtil.isStringGood(author)) {
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            attributeMap.put("name", "Author");
            attributeMap.put("content", author);
            htmlHeadBegin.beginAndClose("meta", attributeMap);
        }
        htmlHeadBegin.begin("title");
        htmlHeadBegin.append(title);
        htmlHeadBegin.close("title");
        return htmlHeadBegin;
    }

    public static HtmlBuffer createClose(boolean indent, String tag) {
        HtmlBuffer htmlBodyClose = new HtmlBuffer(indent);
        htmlBodyClose.close(tag);
        return htmlBodyClose;
    }

    public static HtmlBuffer createHtmlBegin(boolean indent) {
        HtmlBuffer htmlBegin = new HtmlBuffer(indent);
        htmlBegin.begin("html");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("http-equiv", "Content-Type");
        attributeMap.put("content", "text/html; charset=iso-8859-1");
        if (attributeMap.size() > 0) {
            htmlBegin.begin("meta", attributeMap);
        } else {
            htmlBegin.begin("meta");
        }
        return htmlBegin;
    }

    public void addList(Text[] data, boolean isOrdered) throws HtmlReportToolException {
        if (data != null) {
            String tag = null;
            tag = isOrdered ? "ol" : "ul";
            this.begin(tag);
            for (Text txt : data) {
                this.begin("li");
                this.addText(txt);
                this.close("li");
            }
            this.close(tag);
        }
    }

    public void addTable(Table tab, HtmlConstants.HorizontalAlignment align) throws HtmlReportToolException {
        if (tab != null) {
            Vector<TableCell[]> rows;
            Vector<TableCell> headers;
            int borderValue = tab.getTableBorderWidth();
            int tableWidth = tab.getWidth();
            HtmlConstants.Colors tableBackGroundColor = tab.getBackGroudColor();
            HtmlConstants.Colors tableBorderColor = tab.getBorderColor();
            HashMap<String, String> tableAttributeMap = new HashMap<String, String>();
            if (align != null && align != HtmlConstants.HorizontalAlignment.none) {
                tableAttributeMap.put("align", align.name());
            }
            if (borderValue != 0) {
                tableAttributeMap.put("BORDER", Integer.toString(borderValue));
            }
            if (tableWidth != 0) {
                tableAttributeMap.put("width", Integer.toString(tableWidth) + "%");
            }
            if (tableBackGroundColor != null) {
                tableAttributeMap.put("BGCOLOR", tableBackGroundColor.getID());
            }
            if (tableBorderColor != null) {
                tableAttributeMap.put("BORDERCOLOR", tableBorderColor.getID());
            }
            if (tableAttributeMap.size() > 0) {
                this.begin("table", tableAttributeMap);
            } else {
                this.begin("table");
            }
            if (tab.hasCaption()) {
                this.begin("caption");
                this.addText(tab.getCaption());
                this.close("caption");
            }
            if ((headers = tab.getHeader()) != null && headers.size() > 0) {
                this.begin("tr");
                for (TableCell header : headers) {
                    HashMap<String, String> headerAttributeMap = new HashMap<String, String>();
                    if (header.getBackGroundColor() != null) {
                        headerAttributeMap.put("BGCOLOR", header.getBackGroundColor().getID());
                    }
                    if (header.isVerticallyAligned()) {
                        headerAttributeMap.put("valign", header.getVerticalAlignment().name());
                    }
                    if (header.isHorizontallyAligned()) {
                        headerAttributeMap.put("align", header.getHorizontalAlignment().name());
                    }
                    if (!header.isTextWrapped()) {
                        headerAttributeMap.put("nowrap", "nowrap");
                    }
                    if (header.getHeight() != 0) {
                        headerAttributeMap.put("height", Integer.toString(header.getHeight()) + "px");
                    }
                    if (header.getWidth() != 0) {
                        headerAttributeMap.put("width", Integer.toString(header.getWidth()) + "%");
                    }
                    if (header.getRowSpan() != 1) {
                        headerAttributeMap.put("rowspan", Integer.toString(header.getRowSpan()));
                    }
                    if (header.getColSpan() != 1) {
                        headerAttributeMap.put("colspan", Integer.toString(header.getColSpan()));
                    }
                    if (headerAttributeMap.size() > 0) {
                        this.begin("th", headerAttributeMap);
                    } else {
                        this.begin("th");
                    }
                    if (header.getType() == HtmlConstants.DataTypes.TEXT) {
                        this.addText((Text)header.getObject());
                    } else if (header.getType() == HtmlConstants.DataTypes.TEXT_ARRAY) {
                        Text[] textArray;
                        for (Text txt : textArray = (Text[])header.getObject()) {
                            this.addText(txt);
                            this.addLineBreak();
                        }
                    } else if (header.getType() == HtmlConstants.DataTypes.TABLE) {
                        this.addTable((Table)header.getObject(), header.getHorizontalAlignment());
                    }
                    this.close("th");
                }
                this.close("tr");
            }
            if ((rows = tab.getRows()) != null && rows.size() > 0) {
                for (TableCell[] row : rows) {
                    this.begin("tr");
                    for (int i = 0; i < row.length; ++i) {
                        TableCell rowElement = row[i];
                        HashMap<String, String> elementAttributeMap = new HashMap<String, String>();
                        if (rowElement.getBackGroundColor() != null) {
                            elementAttributeMap.put("BGCOLOR", rowElement.getBackGroundColor().getID());
                        }
                        if (rowElement.isVerticallyAligned()) {
                            elementAttributeMap.put("valign", rowElement.getVerticalAlignment().name());
                        }
                        if (rowElement.isHorizontallyAligned()) {
                            elementAttributeMap.put("align", rowElement.getHorizontalAlignment().name());
                        }
                        if (rowElement.getHeight() != 0) {
                            elementAttributeMap.put("height", Integer.toString(rowElement.getHeight()) + "px");
                        }
                        if (rowElement.getWidth() != 0) {
                            elementAttributeMap.put("width", Integer.toString(rowElement.getWidth()) + "%");
                        }
                        if (!rowElement.isTextWrapped()) {
                            elementAttributeMap.put("nowrap", "nowrap");
                        }
                        if (rowElement.getRowSpan() != 1) {
                            elementAttributeMap.put("rowspan", Integer.toString(rowElement.getRowSpan()));
                        }
                        if (rowElement.getColSpan() != 1) {
                            elementAttributeMap.put("colspan", Integer.toString(rowElement.getColSpan()));
                        }
                        if (elementAttributeMap.size() > 0) {
                            this.begin("td", elementAttributeMap);
                        } else {
                            this.begin("td");
                        }
                        if (rowElement.getType() == HtmlConstants.DataTypes.TEXT) {
                            this.addText((Text)rowElement.getObject());
                        } else if (rowElement.getType() == HtmlConstants.DataTypes.TEXT_ARRAY) {
                            Text[] textArray;
                            for (Text txt : textArray = (Text[])rowElement.getObject()) {
                                this.addText(txt);
                                this.addLineBreak();
                            }
                        } else if (rowElement.getType() == HtmlConstants.DataTypes.TABLE) {
                            this.addTable((Table)rowElement.getObject(), rowElement.getHorizontalAlignment());
                        }
                        this.close("td");
                    }
                    this.close("tr");
                }
            }
            this.close("table");
        }
    }

    public static HtmlBuffer createCloseButtonForPopupPage(String buttonText) {
        HtmlBuffer buttonBuffer = new HtmlBuffer(false);
        buttonBuffer.addLineBreak();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("type", "button");
        attrMap.put("value", buttonText);
        attrMap.put("onClick", "window.close()");
        buttonBuffer.beginAndClose("input", attrMap);
        return buttonBuffer;
    }

    public void addComment(String comment) {
        if (VerificationUtil.isStringGood(comment)) {
            String buffer = "<!-- BEGIN ";
            buffer = buffer + comment;
            buffer = buffer + " //END -->";
            this.append(buffer);
        }
    }

    public void addCSSStyle(String cssStyle) {
        if (VerificationUtil.isStringGood(cssStyle)) {
            String buffer = "<style type='text/css'> ";
            buffer = buffer + cssStyle;
            buffer = buffer + "</style>";
            this.append(buffer);
        }
    }

    public void addScript(String script) {
        if (VerificationUtil.isStringGood(script)) {
            String buffer = "<script> ";
            buffer = buffer + script;
            buffer = buffer + "</script>";
            this.append(buffer);
        }
    }

    public void addHTML(String htmlBlock) {
        if (VerificationUtil.isStringGood(htmlBlock)) {
            this.append(htmlBlock);
        }
    }

    protected void addText(Text text) throws HtmlReportToolException {
        if (text != null && VerificationUtil.isStringGood(text.getTextData())) {
            this.append(text.toHtmlString());
        }
    }
}

