/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportData;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.htmlreport.HtmlBuffer;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class HtmlPageData
extends ReportData
implements HtmlConstants {
    protected HtmlConstants.Colors m_backGroundColor;
    protected boolean m_isIndented;
    protected HtmlBuffer m_htmlBegin;
    protected HtmlBuffer m_htmlClose;
    protected HtmlBuffer m_htmlBodyBegin;
    protected HtmlBuffer m_htmlBodyClose;
    protected HtmlBuffer m_htmlHeadBegin;
    protected HtmlBuffer m_htmlHeadClose;
    protected List<HtmlObjectData> m_indexedDataList;
    private static long m_indexCount = 0L;

    protected HtmlPageData(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent) throws ReportToolException {
        super(ReportData.ReportTypes.HTML);
        this.m_backGroundColor = backGroundColor;
        this.m_isIndented = indent;
        this.init(title, author);
    }

    private void init(String title, String author) {
        this.m_indexedDataList = new ArrayList<HtmlObjectData>();
        this.m_htmlBegin = HtmlBuffer.createHtmlBegin(this.m_isIndented);
        this.m_htmlClose = HtmlBuffer.createClose(this.m_isIndented, "html");
        this.m_htmlBodyBegin = HtmlBuffer.createHtmlBodyBegin(this.m_isIndented, this.m_backGroundColor);
        this.m_htmlBodyClose = HtmlBuffer.createClose(this.m_isIndented, "body");
        this.m_htmlHeadBegin = HtmlBuffer.createHtmlHeadBegin(this.m_isIndented, author, title);
        this.m_htmlHeadClose = HtmlBuffer.createClose(this.m_isIndented, "head");
    }

    public boolean isBackGroundColorSet() {
        return this.m_backGroundColor != null;
    }

    public HtmlConstants.Colors getBackgroundColor() {
        return this.m_backGroundColor;
    }

    protected void add(HtmlBuffer content, HtmlConstants.HtmlDataTypes type, String marker) throws HtmlReportToolException {
        try {
            this.m_indexedDataList.add(new HtmlObjectData(content, type, marker));
        }
        catch (ReportToolException rte) {
            Trace.out((String)"Caught HtmlReportToolException while adding content to HTML data index");
            throw new HtmlReportToolException(rte.getMessage(), rte);
        }
    }

    protected void add(HtmlBuffer content) throws HtmlReportToolException {
        this.add(content, HtmlConstants.HtmlDataTypes.NONE, null);
    }

    public String saveToFile(String fullpath) throws HtmlReportToolException {
        String outputFilePath;
        try {
            FileOutputStream stream = new FileOutputStream(fullpath);
            stream.write(this.m_htmlBegin.toString().getBytes());
            stream.write(this.m_htmlHeadBegin.toString().getBytes());
            stream.write(this.m_htmlHeadClose.toString().getBytes());
            stream.write(this.m_htmlBodyBegin.toString().getBytes());
            for (HtmlObjectData idxData : this.m_indexedDataList) {
                String data = null;
                data = idxData.getDataStr();
                if (!VerificationUtil.isStringGood(data)) continue;
                stream.write(data.getBytes());
            }
            stream.write(this.m_htmlBodyClose.toString().getBytes());
            stream.write(this.m_htmlClose.toString().getBytes());
            stream.close();
            outputFilePath = new File(fullpath).getCanonicalPath();
        }
        catch (FileNotFoundException fne) {
            throw new HtmlReportToolException(fne.getMessage());
        }
        catch (IOException ioe) {
            throw new HtmlReportToolException(ioe.getMessage());
        }
        catch (ReportToolException rue) {
            throw new HtmlReportToolException(rue.getMessage(), rue);
        }
        return outputFilePath;
    }

    protected void finalize() {
        for (HtmlObjectData idxData : this.m_indexedDataList) {
            idxData.cleanData();
        }
    }

    protected class HtmlObjectData {
        private String m_data;
        private HtmlConstants.HtmlDataTypes m_markerType;
        private String m_marker;
        private long m_index;
        private boolean m_isObjectSaved;

        public HtmlObjectData(HtmlBuffer content, HtmlConstants.HtmlDataTypes type, String marker) throws ReportToolException {
            this.m_markerType = type;
            this.m_marker = marker;
            if (content.toString().getBytes().length > HtmlPageData.this.getCurrentObjectFileID().length() * 2) {
                this.m_data = HtmlPageData.this.save(content);
                this.m_isObjectSaved = true;
            } else {
                this.m_isObjectSaved = false;
                this.m_data = content.toString();
            }
            this.m_index = m_indexCount;
            m_indexCount++;
        }

        protected void cleanData() {
            if (this.m_isObjectSaved) {
                HtmlPageData.this.delete(this.m_data);
            }
            this.m_data = null;
        }

        public String getDataStr() throws ReportToolException {
            String data = "";
            data = this.m_isObjectSaved ? ((HtmlBuffer)HtmlPageData.this.load(this.m_data)).toString() : this.m_data;
            return data;
        }

        public HtmlConstants.HtmlDataTypes getType() {
            return this.m_markerType;
        }

        public String getMarker() {
            return this.m_marker;
        }

        public long getIndex() {
            return this.m_index;
        }
    }
}

