/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.htmlreport.HtmlBuffer;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlPageData;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HtmlPopupPage
extends HtmlPage {
    protected boolean m_inline = false;

    public HtmlPopupPage(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent) throws ReportToolException {
        this(title, author, backGroundColor, indent, false);
    }

    public HtmlPopupPage(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent, boolean inline) throws ReportToolException {
        super(title, author, backGroundColor, indent);
        this.m_inline = inline;
    }

    public String getHtmlContentsForPopUp() throws HtmlReportToolException {
        String buffer = this.toHtmlString();
        if (buffer.contains("&")) {
            buffer = buffer.replaceAll("&", "&amp;");
        }
        if (buffer.contains("<")) {
            buffer = buffer.replaceAll("<", "&lt;");
        }
        if (buffer.contains(">")) {
            buffer = buffer.replaceAll(">", "&gt;");
        }
        if (buffer.contains("\"")) {
            buffer = buffer.replaceAll("\"", "&quot;");
        }
        if (buffer.contains("'")) {
            buffer = buffer.replaceAll("'", "&quot;");
        }
        if (buffer.contains(VerificationConstants.LINE_SEPARATOR)) {
            buffer = buffer.replaceAll(VerificationConstants.LINE_SEPARATOR, "<br />");
        }
        return buffer;
    }

    private HtmlBuffer createCloseButtonAtPopUpPageBottom() throws HtmlReportToolException {
        this.addLineBreakToHtmlBody();
        HtmlBuffer buttonBuffer = HtmlBuffer.createCloseButtonForPopupPage(this.s_rptMsgBundle.getMessage("10000", false));
        return buttonBuffer;
    }

    private String toHtmlString() throws HtmlReportToolException {
        StringBuffer dataBuffer = new StringBuffer();
        try {
            dataBuffer.append(this.m_htmlBegin.toString());
            dataBuffer.append(this.m_htmlHeadBegin.toString());
            dataBuffer.append(this.m_htmlHeadClose.toString());
            dataBuffer.append(this.m_htmlBodyBegin.toString());
            for (HtmlPageData.HtmlObjectData idxData : this.m_indexedDataList) {
                String data = null;
                data = idxData.getDataStr();
                if (!VerificationUtil.isStringGood(data)) continue;
                dataBuffer.append(data);
            }
            if (!this.m_inline) {
                dataBuffer.append(this.createCloseButtonAtPopUpPageBottom().toString());
            }
            dataBuffer.append(this.m_htmlBodyClose.toString());
            dataBuffer.append(this.m_htmlClose.toString());
        }
        catch (ReportToolException rue) {
            throw new HtmlReportToolException(rue.getMessage(), rue);
        }
        return dataBuffer.toString();
    }
}

