/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.storage.HasFileSystem;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;

class StorageFilter {
    static final String FSEP = System.getProperty("file.separator");
    private String[] m_vendorNodeList = null;

    StorageFilter() {
    }

    Vector filterBySignature(Vector stList, String[] sigList) throws StorageException {
        Hashtable<String, String> cnTable = new Hashtable<String, String>();
        for (int i = 0; i < sigList.length; ++i) {
            cnTable.put(sigList[i], sigList[i]);
        }
        Vector<StorageInfo> remainderList = new Vector<StorageInfo>();
        Enumeration stEnum = stList.elements();
        while (stEnum.hasMoreElements()) {
            StorageInfo stInfo = (StorageInfo)stEnum.nextElement();
            if (null == cnTable.get(stInfo.getSignature())) continue;
            remainderList.add(stInfo);
        }
        return remainderList;
    }

    Vector filterBySignature(Vector stList, Vector refList) throws StorageException {
        String[] sigList = new String[refList.size()];
        Enumeration stEnum = refList.elements();
        int i = 0;
        while (stEnum.hasMoreElements()) {
            sigList[i] = ((StorageInfo)stEnum.nextElement()).getSignature();
            ++i;
        }
        return this.filterBySignature(stList, sigList);
    }

    Vector filterByNodeList(Vector stList, String[] nodeList) throws StorageException {
        Hashtable<String, String> cnTable = new Hashtable<String, String>();
        for (int i = 0; i < nodeList.length; ++i) {
            Trace.out((String)("_st_:adding node " + nodeList[i]));
            cnTable.put(nodeList[i], nodeList[i]);
        }
        Vector<StorageInfo> remainderList = new Vector<StorageInfo>();
        Enumeration stEnum = stList.elements();
        while (stEnum.hasMoreElements()) {
            StorageInfo stInfo = (StorageInfo)stEnum.nextElement();
            if (null != cnTable.get(stInfo.getNode())) {
                remainderList.add(stInfo);
                continue;
            }
            Trace.out((String)("_st_:no match for node " + stInfo.getNode()));
        }
        return remainderList;
    }

    public Vector filterByVendorNodeList(Vector stList) throws StorageException {
        String lsnodesHome = null;
        ParamManager pm = null;
        boolean isAPIMode = false;
        try {
            pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                isAPIMode = true;
            }
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((String)("UNINITIALIZEDPARAMMGREXCEPTION: " + e.getMessage()));
        }
        if (null == this.m_vendorNodeList) {
            try {
                lsnodesHome = CVUAutoUpdateManager.getLSNodesHome(isAPIMode);
                ClusterInfo clusterInfo = new ClusterInfo(lsnodesHome, Version.get92Version());
                this.m_vendorNodeList = clusterInfo.getNodeNames();
            }
            catch (ClusterInfoException e) {
                Trace.out((String)("Couldn't get the cluster nodes" + e.getMessage()));
                throw new StorageException("7011", e);
            }
        }
        return this.filterByNodeList(stList, this.m_vendorNodeList);
    }

    protected Vector filterByFileSystem(Collection stList, String[] fsList) {
        HasFileSystem hfs2 = null;
        Vector<HasFileSystem> remainderList = new Vector<HasFileSystem>();
        Hashtable<String, String> cnTable = new Hashtable<String, String>();
        for (int i = 0; i < fsList.length; ++i) {
            cnTable.put(fsList[i].toUpperCase(), fsList[i].toUpperCase());
        }
        for (HasFileSystem hfs2 : stList) {
            if (null == cnTable.get(hfs2.getFileSystem().toUpperCase())) continue;
            remainderList.add(hfs2);
        }
        return remainderList;
    }

    public Vector filterByASMDeviceString(Collection stList, List<String> m_discoveryASMPaths) {
        Vector<StorageInfo> remainderList = new Vector<StorageInfo>();
        block0: for (Object stInfoObj : stList) {
            StorageInfo stInfo = (StorageInfo)stInfoObj;
            for (String discoveryASMPath : m_discoveryASMPaths) {
                String regexp = discoveryASMPath.toLowerCase();
                regexp = regexp.replaceAll("\\\\", "\\\\\\\\");
                Pattern p = Pattern.compile(regexp = regexp.replaceAll("\\*", ".*"), 2);
                if (!p.matcher(stInfo.getName()).matches()) continue;
                remainderList.add(stInfo);
                continue block0;
            }
        }
        return remainderList;
    }
}

