/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TypeFinder
implements StorageConstants {
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();

    public StorageInfo getStorageInstance(String path) throws StorageException {
        String localNode = sStorageUtil.getLocalHost();
        return this.getStorageInstance(path, localNode);
    }

    public StorageInfo getStorageInstance(String path, String node) throws StorageException {
        String[] nodeArray = new String[]{node};
        List<StorageInfo> stList = this.getStorageInstance(path, nodeArray);
        return stList.get(0);
    }

    public List<StorageInfo> getStorageInstance(String path, String[] nodeArray) throws StorageException {
        Vector<StorageInfo> stList = new Vector<StorageInfo>();
        ClusterwareInfo cwInfo = new ClusterwareInfo();
        boolean asmRunning = false;
        boolean installException = false;
        boolean isCRSConfig = false;
        boolean isHAConfig = false;
        String crsHome = null;
        KFODUtil kfodUtil = null;
        Vector asmDGdata = null;
        String node = null;
        StorageInfo siASMPath = null;
        Trace.out((String)"ENTRY");
        Trace.out((String)("path: '" + path + "' nodeArray: '" + VerificationUtil.strArr2List(nodeArray) + "'"));
        if (path == null || path.length() == 0) {
            Trace.out((String)"path is NULL (or of size zero)");
            Trace.stackTrace();
        }
        if (nodeArray.length == 0) {
            Trace.out((String)"storage type for localnode");
            stList.add(this.getStorageInstance(path));
            return stList;
        }
        try {
            node = nodeArray[0];
            isCRSConfig = cwInfo.isCRSConfiguredOnNode(node);
            if (isCRSConfig || (isHAConfig = cwInfo.isHAConfiguredOnNode(node))) {
                crsHome = isHAConfig ? VerificationUtil.getHAHome() : VerificationUtil.getCRSHome(node, new Result(node));
            }
            Trace.out((String)("expecting kfod in: " + crsHome + "/bin"));
            if (crsHome != null) {
                Trace.out((String)("expecting kfod in: " + crsHome + "/bin"));
                kfodUtil = new KFODUtil(crsHome + "/bin");
                Trace.out((String)("calling isASMRunning for node: " + node));
                ArrayList<String> runningNodeList = new ArrayList<String>();
                ArrayList<String> failedNodeList = new ArrayList<String>();
                new ASMDiskGroupsUtil().checkASMRunning(new String[]{node}, runningNodeList, failedNodeList);
                asmRunning = runningNodeList.contains(node);
                Trace.out((String)("isASMRunning is: " + asmRunning));
                if (asmRunning && (asmDGdata = kfodUtil.getDiskGroupData(node)) != null && asmDGdata.size() > 0) {
                    for (String[] dgArray : asmDGdata) {
                        Trace.out((String)("CRSHOME ASM diskgroup data: " + VerificationUtil.strArr2List(dgArray)));
                    }
                }
            } else {
                Trace.out((String)"crsHome is NULL");
                VerificationLogData.logFine("crsHome is NULL");
            }
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION: for path: '" + path + "'" + " Msg: " + ie.getMessage()));
            installException = true;
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("CMDTOOLUTILEXCEPTION: \n" + e.getMessage()));
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((String)("ASMDiskGroupsUtilException: \n" + e.getMessage()));
        }
        if (installException) {
            try {
                String kfodLocation = VerificationUtil.getKFODLocation(node, true);
                Trace.out((String)("running kfod from: " + kfodLocation));
                VerificationLogData.logFine("running kfod from: " + kfodLocation);
                kfodUtil = new KFODUtil(kfodLocation);
                asmDGdata = kfodUtil.getDiskGroupData(node);
            }
            catch (CmdToolUtilException e) {
                Trace.out((String)("CMDTOOLUTILEXCEPTION: \n" + e.getMessage()));
            }
            catch (VerificationException ve) {
                Trace.out((String)("VERIFICATIONEXCEPTION: \n" + ve.getMessage()));
            }
        }
        if (asmDGdata != null) {
            for (String[] asmDGarray : asmDGdata) {
                Trace.out((String)("ASM diskgroup data: " + VerificationUtil.strArr2List(asmDGarray)));
                if (!path.equalsIgnoreCase("+" + asmDGarray[3]) && !path.equalsIgnoreCase(asmDGarray[3])) continue;
                siASMPath = new StorageInfo(path, node, path, 13);
                siASMPath.setSize(new StorageSize(Double.parseDouble(asmDGarray[0]), StorageUnit.MBYTE));
                siASMPath.setFree(new StorageSize(Double.parseDouble(asmDGarray[1]), StorageUnit.MBYTE));
            }
        }
        ArrayList<Command> cmdList = new ArrayList<Command>(Arrays.asList(new Command[0]));
        boolean i = false;
        VerificationLogData.logFine("TYPEFINDER:getStorageInstance: path[" + path + "] StorageInfo: " + siASMPath);
        for (String node1 : nodeArray) {
            Trace.out((String)("isCRSConfig[" + isCRSConfig + "] isHAConfig[" + isHAConfig + "] installException[" + installException + "]"));
            if ((isCRSConfig || isHAConfig) && !installException) {
                crsHome = isHAConfig ? VerificationUtil.getHAHome() : VerificationUtil.getCRSHome();
            }
            Trace.out((String)"Checking to see if ACFS, or FileSystem");
            if (asmDGdata != null && siASMPath != null) {
                VerificationLogData.logFine("path: '" + path + "' on ASM");
                Trace.out((String)("path is an ASM disk group: '" + path + "'"));
                int access = -1;
                siASMPath.setNode(node1);
                stList.add(siASMPath);
                continue;
            }
            VerificationLogData.logFine("path: '" + path + "' NOT on ASM");
            Trace.out((String)("NOT on ASM: '" + path + "'"));
            RemoteExecCommand typeCmd = s_commandHandler.genStorageInfoCmd(node1, path);
            cmdList.add((Command)typeCmd);
        }
        Command[] cmdArray = cmdList.toArray(new Command[cmdList.size()]);
        Trace.out((String)("stList.size(): " + stList.size() + " cmdList.size(): " + cmdList.size() + " nodeArray.length: " + nodeArray.length));
        if (cmdList.size() > 0) {
            boolean cmdSucc = false;
            try {
                cmdSucc = new ClusterCmd().submit(cmdArray);
            }
            catch (ClusterException e) {
                Trace.out((String)(">>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
                Trace.stackTrace((Throwable)e);
            }
            if (!cmdSucc) {
                Trace.out((String)"ClusterCmd.submit failed ");
                throw new StorageException("7009");
            }
            for (Command typeCmd : cmdArray) {
                Trace.out((String)("About to parse data from output: '" + typeCmd.getCommandResult().getStringResult() + "' for node: " + typeCmd.getNode()));
                stList.add(s_commandHandler.parseStorageInfoResult((VerificationCommand)typeCmd, path));
            }
        }
        Trace.out((String)("There are " + stList.size() + " storage instances in list"));
        return stList;
    }
}

