/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.ACFSInfo;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.LowCFSVersionException;
import oracle.ops.verification.framework.storage.NodeStorageInfo;
import oracle.ops.verification.framework.storage.NonSharedFileSystemException;
import oracle.ops.verification.framework.storage.NotFileSystemException;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.storage.sStrategyProvider;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class VerifyStorage
implements StorageConstants,
VerificationConstants {
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static final String s_ExecutableNotFoundException = "oracle.ops.verification.util.ExecutableNotFoundException";
    private static final String s_AccessDeniedException = "oracle.ops.verification.util.AccessDeniedException";
    private List<String> m_discoveryASMPaths = null;
    Vector m_exceptionList = new Vector();

    public void setDiscoveryASMPaths(List<String> discoveryASMPaths) {
        this.m_discoveryASMPaths = discoveryASMPaths;
    }

    public boolean isShared(String path, String[] nodeList, OracleFileType fileType, String release) throws StorageException, MultiNodeException {
        Trace.out((String)("path: '" + path + "' nodeList: '" + VerificationUtil.strArr2List(nodeList) + "' fileType: '" + fileType.name() + "' release:" + release));
        Vector<StorageInfo> stList = new Vector<StorageInfo>();
        return this.isShared(path, nodeList, stList, fileType, release);
    }

    public boolean isShared(Vector<StorageInfo> stInfoList, OracleFileType fileType) throws StorageException, MultiNodeException {
        Trace.out((String)("stInfoList.size()=" + stInfoList.size() + " fileType: '" + fileType.name() + "'"));
        Vector<StorageInfo> stList = new Vector<StorageInfo>();
        int type = -999;
        for (StorageInfo stInfo : stInfoList) {
            if (type != -999 && type != stInfo.getType()) {
                Trace.out((String)"not all st types are same");
                return false;
            }
            type = stInfo.getType();
        }
        ArrayList<String> succNodes = new ArrayList<String>();
        return this.isSharedInternal(stInfoList, stList, fileType, stInfoList.size(), succNodes, "12.1", false);
    }

    public boolean isShared(String path, String[] nodeList, Vector<StorageInfo> stList, OracleFileType fileType, String release) throws StorageException, MultiNodeException {
        Trace.out((String)("path: '" + path + "' nodeList: '" + VerificationUtil.strArr2List(nodeList) + "stList.size()=" + stList.size() + "' fileType: '" + fileType.name() + "' release:" + release));
        ArrayList<String> succNodes = new ArrayList<String>();
        return this.isShared(path, nodeList, stList, fileType, nodeList.length, succNodes, release, false);
    }

    public boolean isShared(String path, String[] nodeList, Vector<StorageInfo> stList, OracleFileType fileType, int targetCount, Collection<String> m_succNodeList, String release, boolean considerASMStorage) throws StorageException, MultiNodeException {
        boolean isShared = false;
        Object localNode = null;
        List<StorageInfo> stInfoList = null;
        Object stInfo = null;
        Object strategy = null;
        Trace.out((String)("path: '" + path + "' nodeList: '" + VerificationUtil.strArr2List(nodeList) + "' fileType: '" + fileType.name() + "' targetCount=" + targetCount));
        try {
            stInfoList = new TypeFinder().getStorageInstance(path, nodeList);
            isShared = this.isSharedInternal(stInfoList, stList, fileType, targetCount, m_succNodeList, release, considerASMStorage);
        }
        catch (MultiNodeException mne) {
            throw mne;
        }
        catch (NonSharedFileSystemException nsfs) {
            Trace.out((Exception)nsfs);
            isShared = false;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new StorageException(e2);
        }
        return isShared;
    }

    private boolean isSharedInternal(List<StorageInfo> stInfoList, Vector<StorageInfo> stList, OracleFileType fileType, int targetCount, Collection<String> succNodeList, String release, boolean considerASMStorage) throws StorageException, MultiNodeException {
        boolean isShared = false;
        StorageInfo stInfo = null;
        SharedVerifyStrategy strategy = null;
        ArrayList<String> nodeList = new ArrayList<String>();
        for (StorageInfo storageInfo : stInfoList) {
            nodeList.add(storageInfo.getNode());
        }
        HashMap stTypeStInfoMap = new HashMap();
        for (StorageInfo storageInfo : stInfoList) {
            Trace.out((String)(LSEP + storageInfo.toString()));
            VerificationLogData.logInfo(LSEP + storageInfo.toString());
            StorageUtil.isValidStorageType(nodeList.toArray(new String[0]), storageInfo, fileType, release, considerASMStorage);
            String type = storageInfo.getTypeStr();
            if (stTypeStInfoMap.get(type) == null) {
                stTypeStInfoMap.put(type, new ArrayList());
            }
            ((List)stTypeStInfoMap.get(type)).add(storageInfo);
        }
        if (stTypeStInfoMap.size() > 1) {
            Trace.out((String)("Found inconsistent storage types for path '" + stInfoList.get(0).getOrigPath()));
            VerificationLogData.logInfo("Found inconsistent storage types for path '" + stInfoList.get(0).getOrigPath());
            for (String sType : stTypeStInfoMap.keySet()) {
                List sInfoLst = (List)stTypeStInfoMap.get(sType);
                ArrayList<String> nodLst = new ArrayList<String>();
                for (StorageInfo si : sInfoLst) {
                    nodLst.add(si.getNode());
                }
                Trace.out((String)("Found storage type '" + sType + "' for nodes: " + VerificationUtil.strList2List(nodLst)));
                VerificationLogData.logInfo("Found storage type '" + sType + "' for nodes: " + VerificationUtil.strList2List(nodLst));
            }
        }
        Trace.out((String)"Checking for consistency of StorageInfo details");
        VerificationLogData.logInfo("Checking for consistency of StorageInfo details");
        try {
            stInfo = stInfoList.get(0);
            if (stInfoList.size() > 1 && !stInfo.isSharable(stInfoList)) {
                Trace.out((String)"StorageInfo.isSharable : Storage path on nodes not shared");
                VerificationLogData.logInfo("StorageInfo.isSharable : Storage path on nodes not shared");
                return false;
            }
            Trace.out((String)("_st_:after calling TypeFindergetStorageInstance" + stInfo));
            VerificationLogData.logInfo("_st_:after calling TypeFindergetStorageInstance" + stInfo);
            strategy = sStrategyProvider.getSharedVerifyStrategy(stInfo.getType());
            if (stInfo.getType() == 1) {
                strategy.setDiscoveryASMPaths(this.m_discoveryASMPaths);
            }
            strategy.setOracleFileType(fileType);
            Trace.out((String)"_st_:about to call strategy.isShared");
            VerificationLogData.logInfo("_st_:about to call strategy.isShared");
            HashMap<String, StorageInfo> nodeStorageInfo = new HashMap<String, StorageInfo>();
            for (StorageInfo storageInfo : stInfoList) {
                nodeStorageInfo.put(storageInfo.getNode(), storageInfo);
            }
            isShared = strategy.isShared(nodeStorageInfo, stList, targetCount, succNodeList);
        }
        catch (MultiNodeException mne) {
            throw mne;
        }
        catch (NonSharedFileSystemException nsfs) {
            Trace.out((Exception)nsfs);
            VerificationLogData.logError("NonSharedFileSystemException: " + nsfs.getMessage() + LSEP + Trace.getStackTrace((Throwable)nsfs));
            isShared = false;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new StorageException(e2);
        }
        return isShared;
    }

    public boolean hasReadAndWritePermissions(StorageInfo stInfo, String user) throws StorageException {
        boolean retVal = true;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem() || stInfo.getPermissions() == null) {
            return true;
        }
        String[] groups = null;
        groups = this.getGroups(user);
        Trace.out((String)("Storage: " + stInfo.getName() + " has permissions " + stInfo.getPermissions() + " on node " + stInfo.getNode()));
        int perms = Integer.parseInt(stInfo.getPermissions(), 8);
        int rMask = 0;
        int wMask = 0;
        rMask = 4;
        wMask = 2;
        if (stInfo.isInGroup(groups)) {
            rMask |= 0x20;
            wMask |= 0x10;
        }
        if (user.equals(stInfo.getOwner())) {
            rMask |= 0x100;
            wMask |= 0x80;
        }
        Trace.out((String)("rMask = " + Integer.toString(rMask, 8) + ". wMask = " + Integer.toString(wMask, 8)));
        if ((perms & rMask) == 0) {
            Trace.out((String)("Storage: " + stInfo.getName() + " did not have read access on node " + stInfo.getNode()));
            retVal = false;
        }
        if ((perms & wMask) == 0) {
            Trace.out((String)("Storage: " + stInfo.getName() + " did not have write access on node " + stInfo.getNode()));
            retVal = false;
        }
        return retVal;
    }

    private String[] getGroups(String user) throws StorageException {
        VerificationCommand cmd = s_commandHandler.genGetGroupsCmd(user);
        cmd.execute();
        return s_commandHandler.parseGetGroupsResult(cmd);
    }

    public boolean isSharedDevice(String refNode, String[] nodeList, String path) throws StorageException {
        boolean isShared = true;
        StorageInfo stInfo = null;
        String devSignature = null;
        VerificationCommand remCmd = null;
        int type = 0;
        try {
            stInfo = new TypeFinder().getStorageInstance(path, refNode);
            devSignature = stInfo.getSignature();
            type = stInfo.getType();
            for (String node : nodeList) {
                remCmd = (VerificationCommand)s_commandHandler.genInfoCmd(node, type, devSignature);
                boolean bResult = remCmd.execute();
                if (!bResult) {
                    Trace.out((String)("Getting device signature failed on node: " + node));
                    isShared = false;
                    continue;
                }
                if (0 == remCmd.getVfyCode()) continue;
                Trace.out((String)("Could not verify disk on node: " + node));
                isShared = false;
            }
        }
        catch (StorageException e) {
            Trace.out((String)("STORAGEEXCEPTION: " + e.getMessage() + e + "\nStorageException generating info cmd for location '" + path + "' of type " + type));
            throw e;
        }
        catch (Exception e2) {
            Trace.out((String)("EXCEPTION: " + e2.getMessage() + e2));
            throw new StorageException(e2);
        }
        return isShared;
    }

    public void findSharedStorage(NodeStorageInfo[] nodeInfoList, Vector allSets, String release, boolean considerASMStorage) throws StorageException {
        this.findSharedStorage(nodeInfoList, allSets, OracleFileType.RAC_DATA_FILES, release, considerASMStorage);
    }

    public void findSharedStorage(NodeStorageInfo[] nodeInfoList, Vector allSets, OracleFileType fileType, String release, boolean considerASMStorage) throws StorageException {
        Trace.out((String)"ENTRY");
        if (null == allSets) {
            Trace.out((String)"_st_:allsets is null!!");
            throw new StorageException();
        }
        if (null == nodeInfoList) {
            Trace.out((String)"_st_:nodeInfoList is null!!");
            throw new StorageException();
        }
        try {
            int numNodes = nodeInfoList.length;
            Trace.out((String)"_st_:>>About to call getStorageInfo");
            this.getStorageInfo(nodeInfoList, fileType, release, considerASMStorage);
            Trace.out((String)"_st_:>>findSharedSets.");
            this.findSharedSets(nodeInfoList, allSets, fileType, release, considerASMStorage);
        }
        catch (StorageException e) {
            Trace.out((String)("STORAGEEXCEPTON: " + e.getMessage()));
            throw e;
        }
        catch (Exception e2) {
            Trace.out((String)("EXCEPTON: " + e2.getMessage()));
            throw new StorageException(e2);
        }
    }

    void getStorageInfo(NodeStorageInfo[] nodeInfoList, OracleFileType fileType, String release, boolean considerASMStorage) throws StorageException {
        boolean getACFSStorage = false;
        boolean asmStorage = false;
        int[] typeList = sStorageUtil.getDiscoveryTypes(fileType, release, considerASMStorage);
        int numValidTypes = typeList.length;
        int numNodes = nodeInfoList.length;
        Trace.out((int)5, (String)("Number of valid types: " + numValidTypes));
        for (int typeVal : typeList) {
            if (typeVal == 14) {
                Trace.out((int)5, (String)"Removing TYPE_ACFS from numValidTypes");
                --numValidTypes;
                continue;
            }
            if (typeVal != 13) continue;
            Trace.out((int)5, (String)"Removing TYPE_ASMDISKGROUP from numValidTypes");
            --numValidTypes;
        }
        RemoteExecCommand[] cmdArray = new RemoteExecCommand[numValidTypes * numNodes];
        int cmdNum = 0;
        for (int type : typeList) {
            if (type == 14) {
                getACFSStorage = true;
                continue;
            }
            if (type == 13) {
                asmStorage = true;
                continue;
            }
            for (int j = 0; j < nodeInfoList.length; ++j) {
                if (type == 1) {
                    if (this.m_discoveryASMPaths != null && this.m_discoveryASMPaths.size() > 0 && new SystemFactory().CreateSystem().isUnixSystem()) {
                        String asmDiskArgument = VerificationUtil.strCollection2String(this.m_discoveryASMPaths);
                        asmDiskArgument = VerificationUtil.getShellEscapedString(nodeInfoList[j].getName(), asmDiskArgument);
                        cmdArray[cmdNum] = s_commandHandler.genInfoCmd(nodeInfoList[j].getName(), type, asmDiskArgument);
                    } else {
                        cmdArray[cmdNum] = s_commandHandler.genInfoCmd(nodeInfoList[j].getName(), type);
                    }
                } else {
                    cmdArray[cmdNum] = s_commandHandler.genInfoCmd(nodeInfoList[j].getName(), type);
                }
                ++cmdNum;
            }
        }
        boolean cmdSucc = false;
        try {
            cmdSucc = new ClusterCmd().submit((Command[])cmdArray);
        }
        catch (ClusterException e) {
            Trace.out((String)("_st_:>>ClusterException[Thread:" + Thread.currentThread().getName() + "]: " + (Object)((Object)e)));
            VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
        }
        if (!cmdSucc) {
            Trace.out((String)"_st_:ClusterCmd.submit failed ");
        }
        Vector stVector = null;
        Vector<String> failedNodeList = null;
        cmdNum = 0;
        for (int type : typeList) {
            if (type == 14 || type == 13) continue;
            for (int j = 0; j < nodeInfoList.length; ++j) {
                try {
                    RemoteExecCommand remCmd = cmdArray[cmdNum];
                    ++cmdNum;
                    if (!remCmd.getStatus()) {
                        Trace.out((String)("_st_:Failed getting Information from " + sStorageUtil.getTypeStr(type) + " on node: " + remCmd.getNode()));
                        VerificationLogData.logError("Failed getting storage information from " + sStorageUtil.getTypeStr(type) + " on node: " + remCmd.getNode());
                        String[] resLines = remCmd.getCommandResult().getResultString();
                        if (null != resLines) {
                            for (int line = 0; line < resLines.length; ++line) {
                                Trace.out((String)("_st_: result: " + resLines[line]));
                                VerificationLogData.logError("result: " + resLines[line]);
                            }
                        }
                        String errStr = remCmd.getCommandResult().getErrorString();
                        Trace.out((String)("_st_: error: " + errStr));
                        VerificationLogData.logError("error: " + errStr);
                        if (null == failedNodeList) {
                            failedNodeList = new Vector<String>();
                        }
                        failedNodeList.add(remCmd.getNode());
                        continue;
                    }
                    Trace.out((int)5, (String)("Parsing command: " + cmdNum));
                    stVector = s_commandHandler.parseInfoResult(remCmd, type);
                    if (null != stVector) {
                        Trace.out((String)("Adding storage: " + sStorageUtil.getTypeStr(type) + "\n"));
                        nodeInfoList[j].addStorage(stVector, type);
                        continue;
                    }
                    Trace.out((String)(nodeInfoList[j].getName() + " has no " + sStorageUtil.getTypeStr(type)));
                    continue;
                }
                catch (LowCFSVersionException e) {
                    Trace.out((String)e.getMessage());
                    nodeInfoList[j].getResult().addErrorInfo(e);
                    nodeInfoList[j].getResult().addTraceInfo(e);
                    continue;
                }
                catch (StorageException e) {
                    String className;
                    Trace.out((String)e.getMessage());
                    Throwable cause = e.getCause();
                    VerificationLogData.logError("STORAGEEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                    if (null != cause && (s_ExecutableNotFoundException.equals(className = cause.getClass().getName()) || s_AccessDeniedException.equals(className))) {
                        nodeInfoList[j].getResult().addErrorInfo(e);
                    }
                    nodeInfoList[j].getResult().addTraceInfo(e);
                }
            }
        }
        if (getACFSStorage) {
            Trace.out((int)5, (String)"Collecting ACFS information...");
            for (int k = 0; k < nodeInfoList.length; ++k) {
                stVector = this.getACFSStorage(nodeInfoList[k].getName());
                if (null != stVector) {
                    nodeInfoList[k].addStorage(stVector, 14);
                    continue;
                }
                Trace.out((String)(nodeInfoList[k].getName() + " has no " + sStorageUtil.getTypeStr(14)));
            }
        }
        if (asmStorage) {
            Trace.out((int)5, (String)"Collecting ASM Diskgroup information...");
            for (int k = 0; k < nodeInfoList.length; ++k) {
                stVector = this.getASMDiskGroups(nodeInfoList[k].getName());
                if (null != stVector) {
                    nodeInfoList[k].addStorage(stVector, 13);
                    continue;
                }
                Trace.out((String)(nodeInfoList[k].getName() + " has no " + sStorageUtil.getTypeStr(13)));
            }
        }
    }

    void findSharedSets(NodeStorageInfo[] nodeInfoList, Vector allSets, OracleFileType fileType, String release, boolean considerASMStorage) {
        boolean numSharedSets = false;
        int[] typeList = sStorageUtil.getDiscoveryTypes(fileType, release, considerASMStorage);
        SharedStrategy sharedStrategy = null;
        for (int i = 0; i < typeList.length; ++i) {
            int type = typeList[i];
            Trace.out((String)("Processing type: '" + sStorageUtil.getTypeStr(type) + "' " + (i + 1) + " of " + typeList.length));
            Vector stList = new Vector();
            for (int j = 0; j < nodeInfoList.length; ++j) {
                Vector tempList = nodeInfoList[j].getStorageByType(type);
                if (null != tempList) {
                    stList.addAll(tempList);
                    continue;
                }
                Trace.out((String)("NO " + sStorageUtil.getTypeStr(type) + " storage objects for node '" + nodeInfoList[j].getName() + "'!!!"));
            }
            if (stList.size() <= 0) continue;
            try {
                Trace.out((String)("Getting shared strategy for: " + sStorageUtil.getTypeStr(type) + "\n"));
                sharedStrategy = sStrategyProvider.getSharedStrategy(type);
            }
            catch (StorageException e) {
                VerificationLogData.logError("STORAGEEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                Trace.stackTrace((Throwable)e);
                continue;
            }
            Vector superSet = new Vector();
            try {
                if (type == 1) {
                    sharedStrategy.setDiscoveryASMPaths(this.m_discoveryASMPaths);
                }
                sharedStrategy.setOracleFileType(fileType);
                sharedStrategy.findShared(stList, superSet);
            }
            catch (StorageException e2) {
                VerificationLogData.logError("STORAGEEXCEPTION: " + e2.getMessage() + "\n" + Trace.getStackTrace((Throwable)e2));
                Trace.stackTrace((Throwable)e2);
                continue;
            }
            catch (MultiNodeException mne) {
                Trace.out((String)"MULTINODEEXCEPTION:");
                Trace.stackTrace((Throwable)mne);
                for (int k = 0; k < nodeInfoList.length; ++k) {
                    Collection ts = mne.getThrowables(nodeInfoList[k].getName());
                    if (null == ts) continue;
                    nodeInfoList[k].getResult().addErrorInfo(ts);
                }
            }
            allSets.addAll(superSet);
        }
    }

    public boolean isOCFS(String node, String path) throws StorageException {
        boolean isOCFS;
        try {
            int fsType = this.getFileSystem(node, path);
            isOCFS = fsType == 3 || fsType == 8;
        }
        catch (NotFileSystemException nfse) {
            isOCFS = false;
        }
        return isOCFS;
    }

    public boolean isACFS(String node, String path) throws StorageException {
        boolean isACFS = false;
        try {
            int fsType = this.getFileSystem(node, path);
            isACFS = fsType == 14;
        }
        catch (NotFileSystemException nfse) {
            isACFS = false;
        }
        return isACFS;
    }

    public boolean isNTFS(String node, String path) throws StorageException {
        boolean isNTFS = false;
        try {
            int fsType = this.getFileSystem(node, path);
            isNTFS = fsType == 6;
        }
        catch (NotFileSystemException nfse) {
            isNTFS = false;
        }
        return isNTFS;
    }

    public Vector getACFSStorage(String node) {
        Vector<ACFSInfo> acfsInfoLst = new Vector<ACFSInfo>();
        String diskGrpName = null;
        long size = 0L;
        long free = 0L;
        ACFSInfo acfsInfo = null;
        FSInfo fsInfo = null;
        ClusterwareInfo cwInfo = new ClusterwareInfo();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        try {
            String crsHome = null;
            if (cwInfo.isCRSConfiguredOnNode(node) || cwInfo.isHAConfiguredOnNode(node)) {
                if (cwInfo.isHAConfiguredOnNode(node)) {
                    Trace.out((String)"HA is configured");
                    crsHome = VerificationUtil.getHAHome();
                } else {
                    Trace.out((String)"CRS is configured");
                    crsHome = VerificationUtil.getCRSHome();
                }
            }
            if (crsHome == null) {
                Trace.out((String)"Failure in retrieving CRS home");
                return null;
            }
            if (nativeSystem.isUnixSystem()) {
                Trace.out((String)("Checking if ACFS is installed on unix node '" + node + "'"));
                if (!cwInfo.isOFSDriversConfiguredforNode(node)) {
                    Trace.out((String)("ACFS is not installed on unix node '" + node + "'"));
                    return null;
                }
            } else {
                Trace.out((String)("Checking if ACFS is installed on windows node '" + node + "'"));
                if (!cwInfo.isOFSDriversConfigured(crsHome + FSEP + "bin", node)) {
                    Trace.out((String)("ACFS is not installed on windows node '" + node + "'"));
                    return null;
                }
            }
            List acfsMntPnts = cwInfo.getOFSMountPointsforNode(node);
            for (String location : acfsMntPnts) {
                Trace.out((int)5, (String)("ACFS mount point: '" + location + "'"));
                String actVer = cwInfo.getOFSActiveVersionforNode(node);
                diskGrpName = cwInfo.getOFSDiskGroupNameforNode(location, node);
                size = cwInfo.getOFSTotalSizeforNode(location, node);
                free = cwInfo.getOFSFreeSpaceforNode(location, node);
                fsInfo = new FSInfo(node, location);
                acfsInfo = new ACFSInfo(node, location, actVer, free, size, diskGrpName, fsInfo);
                acfsInfoLst.add(acfsInfo);
            }
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION:\n" + (Object)((Object)ie)));
            VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
            return null;
        }
        Trace.out((int)5, (String)"EXIT");
        return acfsInfoLst;
    }

    public Vector getASMDiskGroups(String node) {
        ASMDiskGroupsUtil dgUtil = new ASMDiskGroupsUtil();
        try {
            ResultSet dgResultSet = new ResultSet();
            Hashtable<String, List<ASMDiskGroup>> htdg = new Hashtable<String, List<ASMDiskGroup>>();
            dgUtil.getDiskGroups(new String[]{node}, dgResultSet, htdg);
            List<ASMDiskGroup> dgList = htdg.get(node);
            Vector<ASMDiskGroup> dgVector = null;
            if (dgList != null) {
                dgVector = new Vector<ASMDiskGroup>();
                dgVector.addAll(dgList);
            }
            return dgVector;
        }
        catch (ASMDiskGroupsUtilException e2) {
            return null;
        }
    }

    int getFileSystem(String node, String path) throws StorageException {
        VerificationCommand[] cmdArray = new VerificationCommand[1];
        boolean cmdSucc = false;
        int fsType = 5;
        cmdArray[0] = s_commandHandler.genFSTypeCmd(node, path);
        try {
            cmdSucc = new ClusterCmd().submit((Command[])cmdArray);
        }
        catch (ClusterException e) {
            cmdSucc = false;
            Trace.out((String)"ClusterException in getFileSystem.");
            Trace.out((Exception)((Object)e));
            VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
        }
        if (!cmdSucc) {
            Trace.out((String)"_st_:ClusterCmd.submit failed for getFSType");
            VerificationLogData.logError("ClusterCmd.submit failed for genFSTypeCmd");
            throw new StorageException();
        }
        if (!cmdArray[0].getStatus()) {
            Trace.out((String)"getFsTypeCommand wasn't successfull.");
            throw new StorageException();
        }
        fsType = s_commandHandler.parseFSTypeResult(cmdArray[0], path);
        Trace.out((String)("FileSystem type of " + node + ":" + path + " is: " + fsType));
        return fsType;
    }

    public PathDiskInfo getDiskInfo(String node, String path) throws StorageException, InvalidPathException {
        VerificationCommand[] cmdArray = new VerificationCommand[1];
        boolean cmdSucc = false;
        PathDiskInfo pathInfo = null;
        if (!VerificationUtil.isStringGood(path)) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", true));
        }
        cmdArray[0] = s_commandHandler.genDiskDetailCmd(node, path);
        try {
            cmdSucc = new ClusterCmd().submit((Command[])cmdArray);
        }
        catch (ClusterException e) {
            cmdSucc = false;
            Trace.out((String)"ClusterException in getDiskInfo.");
            Trace.out((Exception)((Object)e));
            VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
        }
        if (!cmdSucc) {
            Trace.out((String)"_st_:ClusterCmd.submit failed for getDiskInfo");
            VerificationLogData.logError("ClusterCmd.submit failed for genDiskDetailCmd");
            throw new StorageException();
        }
        if (!cmdArray[0].getStatus()) {
            Trace.out((String)"getDiskInfo command wasn't successfull.");
            throw new StorageException();
        }
        pathInfo = s_commandHandler.parseDiskDetailResult(node, cmdArray[0], path);
        pathInfo.setOrigPath(path);
        return pathInfo;
    }

    public boolean isDiskNoFileSystem(String node, String path) throws StorageException {
        boolean isNoFS = false;
        try {
            int fsType = this.getFileSystem(node, path);
            if (fsType == 0) {
                isNoFS = true;
            }
        }
        catch (NotFileSystemException nfse) {
            isNoFS = false;
        }
        return isNoFS;
    }

    public boolean isDiskNFS(String node, String path) throws StorageException {
        boolean isNFS = false;
        try {
            int fsType = this.getFileSystem(node, path);
            if (fsType == 2) {
                isNFS = true;
            }
        }
        catch (NotFileSystemException nfse) {
            isNFS = false;
        }
        return isNFS;
    }

    static HashMap<String, String> getUnsuitableTypeMessage(OracleFileType fileType) {
        HashMap<String, String> h = new HashMap<String, String>();
        switch (fileType) {
            case RAC_SOFTWARE: {
                h.put("Prvg", "11501");
                break;
            }
            case RAC_DATA_FILES: {
                h.put("Prvg", "11502");
                break;
            }
            case RAC_OCR_VDISK: {
                h.put("Prvg", "11503");
                break;
            }
            case SI_SOFTWARE: {
                h.put("Prvg", "11504");
                break;
            }
            case SI_DATA_FILES: {
                h.put("Prvg", "11505");
                break;
            }
            case ASM: {
                h.put("Prvg", "11505");
                break;
            }
            default: {
                h.put("Prvf", "7000");
            }
        }
        return h;
    }
}

