/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.util.MultiNodeException;

public class sDiskSharedVerifyStrategy
extends SharedVerifyStrategy
implements StorageConstants {
    int m_type = 1;

    @Override
    protected boolean isShared(StorageInfo stInfo, String[] nodeList) throws StorageException, MultiNodeException {
        Vector stList = new Vector();
        return this.isShared(stInfo, nodeList, stList);
    }

    @Override
    protected boolean isShared(StorageInfo stInfo, String[] nodeList, Vector stList) throws StorageException, MultiNodeException {
        HashMap<String, StorageInfo> nodeStorageInfo = new HashMap<String, StorageInfo>(nodeList.length);
        for (String node : nodeList) {
            nodeStorageInfo.put(node, stInfo);
        }
        return this.isShared(nodeStorageInfo, stList);
    }

    protected boolean isShared(Map<String, StorageInfo> nodeStorageInfo, Vector stList) throws StorageException, MultiNodeException {
        String[] nodeList = nodeStorageInfo.keySet().toArray(new String[0]);
        boolean retVal = false;
        int numNodes = 0;
        int type = this.m_type;
        String[] signList = new String[nodeList.length];
        SharedStorageSet sharedSet = null;
        StorageInfo stinfo = null;
        for (int i = 0; i < nodeList.length; ++i) {
            stinfo = nodeStorageInfo.get(nodeList[i]);
            stList.add(stinfo);
        }
        Trace.out((String)("Number of storages : " + stList.size()));
        if (stList.size() > 0) {
            SharedStrategy strategy = new SharedStrategy();
            Vector superSet = new Vector();
            Enumeration ev = stList.elements();
            while (ev.hasMoreElements()) {
                StorageInfo stInfo = (StorageInfo)ev.nextElement();
                stInfo.setOrigPath(nodeStorageInfo.get(stInfo.getNode()).getOrigPath());
            }
            strategy.findShared(stList, superSet);
            Enumeration e = superSet.elements();
            if (e.hasMoreElements()) {
                sharedSet = (SharedStorageSet)e.nextElement();
                numNodes = sharedSet.getNumNodes();
            }
            boolean oneSharedSet = 1 == superSet.size();
            boolean allNodesIn = nodeList.length == numNodes;
            boolean bl = retVal = oneSharedSet && allNodesIn;
            if (!retVal) {
                Trace.out((String)("number of shared groups: " + superSet.size()));
            }
        } else {
            Trace.out((String)("No instances found, storage: " + nodeStorageInfo));
        }
        return retVal;
    }
}

