/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.net.UnknownHostException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sStorageUtil
implements StorageConstants {
    private static String m_localHost = null;

    public boolean isTypeValid(int type) {
        return type > 0;
    }

    public static int[] getDiscoveryTypes() {
        return sStorageUtil.getDiscoveryTypes(OracleFileType.RAC_DATA_FILES, "12.1", false);
    }

    public static int[] getDiscoveryTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        int[] discoveryTypes = fileType.equals((Object)OracleFileType.ASM) ? new int[]{1} : (fileType.equals((Object)OracleFileType.RAC_SOFTWARE) || fileType.equals((Object)OracleFileType.SI_SOFTWARE) || fileType.equals((Object)OracleFileType.RAC_DATA_FILES) || fileType.equals((Object)OracleFileType.SI_DATA_FILES) ? sStorageUtil.getSoftwareDataFilesDiscoveryTypes(release, considerASMStorage) : sStorageUtil.getOcrVdiskDiscoveryTypes(release, considerASMStorage));
        return discoveryTypes;
    }

    public static int[] getSupportedFileTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        if (OracleFileType.ASM.equals((Object)fileType)) {
            return new int[]{1};
        }
        int[] discoveryTypes = sStorageUtil.getDiscoveryTypes(fileType, release, considerASMStorage);
        int supportedTypesLen = discoveryTypes.length + 1;
        if (fileType.equals((Object)OracleFileType.RAC_SOFTWARE) || fileType.equals((Object)OracleFileType.SI_SOFTWARE)) {
            ++supportedTypesLen;
        }
        int[] supportedFileTypes = new int[supportedTypesLen];
        int i = 0;
        for (int discType : discoveryTypes) {
            supportedFileTypes[i++] = discType;
        }
        supportedFileTypes[i++] = 7;
        if (fileType.equals((Object)OracleFileType.RAC_SOFTWARE) || fileType.equals((Object)OracleFileType.SI_SOFTWARE)) {
            supportedFileTypes[i] = 5;
        }
        return supportedFileTypes;
    }

    private static int[] getSoftwareDataFilesDiscoveryTypes(String release, boolean considerASMStorage) {
        if (VerificationUtil.isVersionPre(release, "11.2")) {
            return new int[]{7, 1};
        }
        return new int[]{13, 14, 1};
    }

    private static int[] getOcrVdiskDiscoveryTypes(String release, boolean considerASMStorage) {
        if (VerificationUtil.isVersionPre(release, "11.2")) {
            return new int[]{7, 1};
        }
        if (VerificationUtil.isVersionPre(release, "12")) {
            return new int[]{7, 13, 14, 1};
        }
        boolean bc = false;
        try {
            bc = NodeManagerFactory.getInstance().getNodeManager().isBigCluster();
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((int)5, (String)"Ignored exception: %s: %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
        }
        if (bc) {
            if (considerASMStorage) {
                return new int[]{13, 14, 1};
            }
            return new int[]{13, 14};
        }
        if (considerASMStorage) {
            return new int[]{13, 14, 1};
        }
        return new int[]{13, 14};
    }

    public static String getTypeStr(int type) {
        return StorageUtil.getTypeStr(type);
    }

    public static StorageType getTypeEnum(int type) {
        return StorageUtil.getTypeEnum(type);
    }

    public static int getTypeByStr(String str) throws StorageException {
        return StorageUtil.getTypeByStr(str);
    }

    protected static String getLocalHost() throws StorageException {
        if (null == m_localHost) {
            try {
                m_localHost = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new StorageException("7007", e);
            }
        }
        return m_localHost;
    }

    public static int getNumDiskPartitions(StorageInfo stInfo) {
        if (stInfo.getType() == 1) {
            return ((sDisk)stInfo).getNumPartitions();
        }
        return -1;
    }
}

