/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.ACFSSharedStrategy;
import oracle.ops.verification.framework.storage.ASMSharedStrategy;
import oracle.ops.verification.framework.storage.ASMSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.FSSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.SharedVerifyStrategy;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.sDiskSharedStrategy;
import oracle.ops.verification.framework.storage.sDiskSharedVerifyStrategy;
import oracle.ops.verification.framework.storage.sStorageUtil;

class sStrategyProvider
implements StorageConstants {
    sStrategyProvider() {
    }

    static SharedStrategy getSharedStrategy(int type) throws StorageException {
        switch (type) {
            case 1: {
                return new sDiskSharedStrategy();
            }
            case 14: {
                return new ACFSSharedStrategy();
            }
            case 13: {
                return new ASMSharedStrategy();
            }
        }
        Trace.out((String)("genInfoCmd: Can't handle " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }

    static SharedVerifyStrategy getSharedVerifyStrategy(int type) throws StorageException {
        switch (type) {
            case 1: {
                return new sDiskSharedVerifyStrategy();
            }
            case 5: 
            case 7: {
                Trace.out((String)"FSSharedVerifyStrategy chosen.");
                return new FSSharedVerifyStrategy();
            }
            case 14: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"FSSharedVerifyStrategy chosen for TYPE_ACFS.");
                }
                return new FSSharedVerifyStrategy();
            }
            case 13: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"ASMSharedStrategy chosen for TYPE_ASMDISKGROUP.");
                }
                return new ASMSharedVerifyStrategy();
            }
        }
        Trace.out((String)("genInfoCmd: Can't handle " + sStorageUtil.getTypeStr(type)));
        throw new StorageException();
    }
}

