/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.List;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.fixup.CVUFixup;
import oracle.cluster.winsecurity.Credentials;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.util.VerificationUtil;

public class Assert
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public static void assertCredentials(Credentials credentials) throws VerificationException {
        if (credentials == null) {
            throw new VerificationException(s_gMsgBundle.getMessage("4500", true, (Object[])new String[]{"credentials"}));
        }
    }

    public static void assertNodes(String[] nodeList) throws VerificationException {
        if (nodeList == null || nodeList.length == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"node list"}));
        }
        for (String node : nodeList) {
            if (VerificationUtil.isStringGood(node)) continue;
            throw new VerificationException(s_gMsgBundle.getMessage("11321", true, (Object[])new String[]{"node list"}));
        }
    }

    public static String[] assertAndConvertNodesToLower(String[] nodeList) throws VerificationException {
        Assert.assertNodes(nodeList);
        return VerificationUtil.getNodenamesInLowerCase(nodeList);
    }

    public static void assertNodeVIPList(String[] nodeVIPList, boolean chkNullElm) throws VerificationException {
        if (nodeVIPList == null || nodeVIPList.length == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"node VIP list"}));
        }
        if (chkNullElm) {
            for (String node : nodeVIPList) {
                if (VerificationUtil.isStringGood(node)) continue;
                throw new VerificationException(s_gMsgBundle.getMessage("11321", true, (Object[])new String[]{"node VIP list"}));
            }
        }
    }

    public static void assertNodeRoleList(NodeRoleCapability[] nodeRoleList) throws VerificationException {
        if (nodeRoleList == null || nodeRoleList.length == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"node role list"}));
        }
        for (NodeRoleCapability nodeRole : nodeRoleList) {
            if (nodeRole == null) {
                throw new VerificationException(s_gMsgBundle.getMessage("11321", true, (Object[])new String[]{"node role list"}));
            }
            if (nodeRole == NodeRoleCapability.HUB || nodeRole == NodeRoleCapability.RIM || nodeRole == NodeRoleCapability.AUTO) continue;
            throw new VerificationException(s_gMsgBundle.getMessage("11400", true));
        }
    }

    public static void assertTargetHubSize(int targetHubSize) throws VerificationException {
        if (targetHubSize <= 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("0700", false));
        }
    }

    public static void assertPassword(String password) throws VerificationException {
        if (password == null) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"password"}));
        }
    }

    public static void assertNode(String node) throws VerificationException {
        if (node == null || node.length() == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"node name"}));
        }
    }

    public static String assertAndConvertNodeToLower(String node) throws VerificationException {
        Assert.assertNode(node);
        return node.toLowerCase();
    }

    public static void assertUser(String user) throws VerificationException {
        if (user == null || user.length() == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"user name"}));
        }
    }

    public static void assertLocation(String sudolocation) throws VerificationException {
        if (sudolocation == null || sudolocation.length() == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"sudo/pbrun location"}));
        }
    }

    public static void assertCommand(String command) throws VerificationException {
        if (command == null || command.length() == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"command"}));
        }
    }

    public static void assertPrimaryGroup(boolean primary) throws VerificationException {
        if (!new SystemFactory().CreateSystem().isUnixSystem() && primary) {
            throw new VerificationException(s_msgBundle.getMessage("4314", false));
        }
    }

    public static void assertGroup(String group) throws VerificationException {
        if (group == null || group.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7570", false));
        }
    }

    public static void assertProc(String proc) throws VerificationException {
        if (proc == null || proc.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7578", false));
        }
    }

    public static void assertName(String name) throws VerificationException {
        if (name == null || name.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7579", false));
        }
    }

    public static void assertVal(String val) throws VerificationException {
        if (val == null || val.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7580", false));
        }
    }

    public static void assertArch(String arch) throws VerificationException {
        if (arch == null || arch.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7581", false));
        }
    }

    public static void assertArchs(List<String> archs) throws VerificationException {
        if (archs == null || archs.size() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7585", false));
        }
        for (String arch : archs) {
            Assert.assertArch(arch);
        }
    }

    public static void assertOSPatch(String osPatch) throws VerificationException {
        if (osPatch == null || osPatch.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("9808", false));
        }
    }

    public static void assertVersion(String ver) throws VerificationException {
        if (ver == null || ver.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7582", false));
        }
    }

    public static void assertSize(long size) throws VerificationException {
        if (size < 0L) {
            throw new VerificationException(s_msgBundle.getMessage("7576", false));
        }
    }

    public static void assertSize(double size) throws VerificationException {
        if (size < 0.0) {
            throw new VerificationException(s_msgBundle.getMessage("7576", false));
        }
    }

    public static void assertRunlevels(List<Integer> runlevels) throws VerificationException {
        if (runlevels == null || runlevels.size() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7583", false));
        }
        for (int runLvl : runlevels) {
            Assert.assertRunlevel(runLvl);
        }
    }

    public static void assertRunlevel(int runlevel) throws VerificationException {
        if (runlevel < 0) {
            throw new VerificationException(s_msgBundle.getMessage("7577", false));
        }
    }

    public static void assertOracleHomeForCmdExec(String oracleHome) throws InvalidPathException {
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7556", false));
        }
        if (!new File(oracleHome).isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7557", false, (Object[])new String[]{oracleHome}));
        }
    }

    public static void assertOracleHome(String oracleHome, boolean checkExistence) throws VerificationException {
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7556", false));
        }
        if (!new File(oracleHome).isAbsolute()) {
            throw new VerificationException(s_msgBundle.getMessage("7557", false, (Object[])new String[]{oracleHome}));
        }
        if (checkExistence) {
            ClusterCmd clusterCmd = new ClusterCmd();
            try {
                clusterCmd.pathExists(new String[]{"localnode"}, oracleHome, 1);
            }
            catch (ClusterException ce) {
                throw new VerificationException(s_msgBundle.getMessage("7509", false, (Object[])new String[]{oracleHome}), ce);
            }
            catch (ClusterOperationException ce) {
                throw new VerificationException(ce);
            }
            try {
                if (!clusterCmd.isDirWritable(new String[]{"localnode"}, oracleHome)) {
                    throw new VerificationException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{oracleHome}));
                }
            }
            catch (ClusterException ce) {
                throw new VerificationException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{oracleHome}), ce);
            }
            catch (ClusterOperationException ce) {
                throw new VerificationException(ce);
            }
        }
    }

    public static void assertPath(String path) throws InvalidPathException {
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", false));
        }
        if (!new File(path).isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7518", false, (Object[])new String[]{path}));
        }
    }

    public static void assertCheckType(EnumSet<UserEquivCheckType> checkType) throws VerificationException {
        if (checkType == null || checkType.size() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7601", false));
        }
    }

    public static void assertUnixPlatform() throws UnsupportedOperationException {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            throw new UnsupportedOperationException(s_msgBundle.getMessage("7602", false));
        }
    }

    public static void assertWindowsPlatform() throws UnsupportedOperationException {
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            throw new UnsupportedOperationException(s_gMsgBundle.getMessage("1200", false));
        }
    }

    public static void assertStorageUnit(StorageUnit unit) throws VerificationException {
        if (unit == null) {
            throw new VerificationException(s_msgBundle.getMessage("7586", false));
        }
    }

    public static void assertASMDisk(String asmDisk, boolean checkForWildCard) throws VerificationException {
        if (asmDisk == null || asmDisk.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("9813", false));
        }
        if (checkForWildCard && VerificationUtil.containsWildCard(asmDisk)) {
            throw new VerificationException(s_msgBundle.getMessage("9814", false));
        }
    }

    public static void assertWorkDir(String workDir) throws VerificationException {
        if (workDir == null || workDir.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7519", false));
        }
        if (!new File(workDir).isAbsolute()) {
            throw new VerificationException(s_msgBundle.getMessage("7520", false, (Object[])new String[]{workDir}));
        }
    }

    public static void assertFrameworkHome(String frameworkHome) throws VerificationException {
        if (frameworkHome == null || frameworkHome.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7521", false));
        }
        if (!new File(frameworkHome).isAbsolute()) {
            throw new VerificationException(s_msgBundle.getMessage("7522", false, (Object[])new String[]{frameworkHome}));
        }
    }

    public static void assertInterface(String interfaceName) throws VerificationException {
        if (interfaceName == null || interfaceName.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("6010", false));
        }
    }

    public static void assertWritableDir(String path) throws InvalidPathException {
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", true));
        }
        File fileRef = new File(path);
        if (!fileRef.isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7518", true, (Object[])new String[]{path}));
        }
        if (!fileRef.isDirectory()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7509", true, (Object[])new String[]{path}));
        }
        if (!fileRef.canWrite()) {
            throw new InvalidPathException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{path}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void assertWritableOrCreatableDir(String path) throws InvalidPathException {
        if (path == null || path.length() == 0) throw new InvalidPathException(s_msgBundle.getMessage("7517", true));
        File fileRef = new File(path);
        if (!fileRef.isAbsolute()) throw new InvalidPathException(s_msgBundle.getMessage("7518", true, (Object[])new String[]{path}));
        if (!fileRef.exists()) {
            ClusterCmd clusterCmd = new ClusterCmd();
            try {
                String[] localNode = new String[]{VerificationUtil.getLocalHost()};
                clusterCmd.createDirWithPermissionsOnNodes(localNode, path, "755");
                return;
            }
            catch (UnknownHostException uhe) {
                throw new InvalidPathException(s_msgBundle.getMessage("7704", true, (Object[])new String[]{path}) + LSEP + uhe.getMessage());
            }
            catch (ClusterException ce) {
                throw new InvalidPathException(s_msgBundle.getMessage("7704", true, (Object[])new String[]{path}) + LSEP + ce.getMessage());
            }
        } else {
            if (!fileRef.isDirectory()) {
                throw new InvalidPathException(s_msgBundle.getMessage("7509", true, (Object[])new String[]{path}));
            }
            if (fileRef.canWrite()) return;
            throw new InvalidPathException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{path}));
        }
    }

    public static void assertInputParam(String input, String inputName) throws VerificationException {
        if (!VerificationUtil.isStringGood(input)) {
            throw new VerificationException(s_gMsgBundle.getMessage("0540", true, (Object[])new String[]{inputName}));
        }
    }

    public static void assertConfigMethodInput(String configMethodStr) throws VerificationException {
        if (!VerificationUtil.isStringGood(configMethodStr) || !configMethodStr.equalsIgnoreCase(ConfigurationSetup.ConfigMethod.ROOT.toString()) && !configMethodStr.equalsIgnoreCase(ConfigurationSetup.ConfigMethod.SUDO.toString()) && !configMethodStr.equalsIgnoreCase(ConfigurationSetup.ConfigMethod.PBRUN.toString())) {
            throw new VerificationException(s_gMsgBundle.getMessage("7091", true));
        }
    }

    public static void assertSubnet(String subnetNumber) throws VerificationException {
        if (subnetNumber == null || subnetNumber.length() == 0) {
            String msg = s_gMsgBundle.getMessage("4500", true, (Object[])new String[]{"subnetNumber"});
            throw new VerificationException(msg);
        }
    }

    public static void assertParamPreReq(ParamPreReq param) throws VerificationException {
        if (param == null) {
            throw new VerificationException(s_msgBundle.getMessage("7516", false));
        }
    }

    public static void assertFixupDriver(CVUFixup fixUpDriver) throws FixupException {
        if (fixUpDriver == null) {
            throw new FixupException(s_gMsgBundle.getMessage("9047", true));
        }
    }
}

