/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.client.CluvfyDriver;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CVUAutoUpdateManager {
    private static URL jarLocation = CluvfyDriver.class.getProtectionDomain().getCodeSource().getLocation();
    private static boolean s_unix = new SystemFactory().CreateSystem().isUnixSystem();
    private static String m_derivedCVUHome = CVUAutoUpdateManager.getDerivedCVUHome();
    private static String[] s_remExecServerFiles = null;
    private static String[] s_remExecFiles = null;
    private static String s_remExecFilesStr = null;

    public static String getCVUFileLocation(String cvuFileRelativePath) {
        String derivedPath = m_derivedCVUHome + File.separator + cvuFileRelativePath;
        String cvHome = VerificationUtil.getCVHome();
        if (CVUAutoUpdateManager.isAutoUpdate() && !m_derivedCVUHome.equals(cvHome) && new File(derivedPath).exists()) {
            return derivedPath;
        }
        return cvHome + File.separator + cvuFileRelativePath;
    }

    public static String getDerivedCVUHome() {
        if (m_derivedCVUHome != null) {
            return m_derivedCVUHome;
        }
        String cvuJarLocation = CVUAutoUpdateManager.getJarLocation();
        File jarFile = new File(cvuJarLocation);
        String cvuHome = jarFile.getParentFile().getParent();
        if (cvuHome.endsWith("ext")) {
            cvuHome = jarFile.getParentFile().getParentFile().getParent();
            cvuHome = cvuHome + VerificationUtil.FILE_SEPARATOR + "cvu";
        }
        m_derivedCVUHome = cvuHome;
        return m_derivedCVUHome;
    }

    public static String getJarLocation() {
        String path = jarLocation.getPath();
        if (!s_unix) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            path = path.replace("/", VerificationUtil.FILE_SEPARATOR);
        }
        return path;
    }

    public static String getLSNodesHome(boolean isAPIMode) {
        String cvHome;
        String lsnodesHome = cvHome = VerificationUtil.getCVHome();
        if (isAPIMode) {
            lsnodesHome = lsnodesHome + ".." + File.separator + "ext" + File.separator;
        }
        return lsnodesHome;
    }

    public static String getCRSCTLHome() {
        String cvHome = VerificationUtil.getCVHome();
        return cvHome;
    }

    public static String[] getCmdFiles4RemExec() {
        String[] remExecFiles = VDMUtil.getCmdFiles4RemExec();
        String remExecFilesStr = VerificationUtil.strArr2List(remExecFiles);
        if (s_remExecFiles != null && remExecFilesStr.equals(s_remExecFilesStr)) {
            return s_remExecFiles;
        }
        ArrayList<String> remExecFileList = new ArrayList<String>();
        String cvHome = VerificationUtil.getCVHome();
        String derivedCVHomeString = CVUAutoUpdateManager.getDerivedCVUHome();
        Trace.out((String)("cvHome=" + cvHome));
        Trace.out((String)("derivedCVHomeString=" + derivedCVHomeString));
        if (remExecFiles != null) {
            for (String file : remExecFiles) {
                if (CVUAutoUpdateManager.isAutoUpdate() && new File(derivedCVHomeString + File.separator + file).exists()) {
                    remExecFileList.add(derivedCVHomeString + File.separator + file);
                    continue;
                }
                remExecFileList.add(cvHome + File.separator + file);
            }
        }
        s_remExecFiles = remExecFileList.toArray(new String[0]);
        s_remExecFilesStr = remExecFilesStr;
        Trace.out((String)("s_remExecFiles=" + VerificationUtil.strArr2List(s_remExecFiles)));
        return s_remExecFiles;
    }

    public static String[] getFiles4RemExecServer() {
        if (s_remExecServerFiles != null) {
            return s_remExecServerFiles;
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String[] remExecFiles = nativeSystem.getRemoteExecServerFiles();
        ArrayList<String> remExecFileList = new ArrayList<String>();
        String cvHome = VerificationUtil.getCVHome();
        String derivedCVHomeString = CVUAutoUpdateManager.getDerivedCVUHome();
        if (remExecFiles != null) {
            for (String file : remExecFiles) {
                if (CVUAutoUpdateManager.isAutoUpdate()) {
                    if (new File(derivedCVHomeString + File.separator + file).exists()) {
                        remExecFileList.add(derivedCVHomeString + File.separator + file);
                        continue;
                    }
                    if (new File(derivedCVHomeString + File.separator + "bin" + File.separator + file).exists()) {
                        remExecFileList.add(derivedCVHomeString + File.separator + "bin" + File.separator + file);
                        continue;
                    }
                }
                if (new File(cvHome + File.separator + file).exists()) {
                    remExecFileList.add(cvHome + File.separator + file);
                    continue;
                }
                if (new File(cvHome + File.separator + "bin" + File.separator + file).exists()) {
                    remExecFileList.add(cvHome + File.separator + "bin" + File.separator + file);
                    continue;
                }
                remExecFileList.add(cvHome + File.separator + file);
            }
        }
        String[] msvcFilesArr = null;
        try {
            msvcFilesArr = nativeSystem.getMSVCRTFullPath(new String[]{derivedCVHomeString, cvHome});
        }
        catch (NativeException e) {
            Trace.out((String)("Native exception while getting full path for msvcrt files" + e.getMessage()));
            VerificationLogData.logError("Native exception while getting full path for msvcrt files" + e.getMessage());
        }
        if (msvcFilesArr != null) {
            for (String msvcFile : msvcFilesArr) {
                remExecFileList.add(msvcFile);
            }
        }
        s_remExecServerFiles = remExecFileList.toArray(new String[0]);
        Trace.out((String)("s_remExecServerFiles=" + VerificationUtil.strArr2List(s_remExecServerFiles)));
        VerificationLogData.logInfo("s_remExecServerFiles=" + VerificationUtil.strArr2List(s_remExecServerFiles));
        return s_remExecServerFiles;
    }

    public static boolean isAutoUpdate() {
        return true;
    }
}

